/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.ab;

import com.sun.addressbook.ABFilter;
import com.sun.addressbook.ABStore;
import com.sun.addressbook.AddressBook;
import com.sun.addressbook.Element;
import com.sun.addressbook.Entry;
import com.sun.addressbook.Group;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderAdapter;
import com.sun.portal.providers.ProviderEditUtility;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.ab.AddressBookApplicationHelper;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.SSOAdapterFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AddressBookProvider
extends ProfileProviderAdapter {
    private static final int defaultNum = 5;
    private static final int defaultMaxNum = 30;
    private static final String componentId = "iwtAddressBookProvider";
    private ProviderContext providerContext = null;
    private ResourceBundle bundle = null;
    protected SSOAdapterFactory adapterFactory = null;
    private String container = null;
    protected String editContainer = "";
    protected String targetProvider = "";
    protected String containerName = "";
    private static final String sortByAttributeName = "sunPortalABSortBy";
    private static final String sortOrderAttributeName = "sunPortalABSortOrder";
    private static final String sortOrderAscending = "Up";
    private static final String sortOrderDescending = "Down";
    private static final String sortOrderNone = "none";
    protected HashMap appHandlers = null;
    protected Boolean isPresentable = null;
    protected boolean isSSOConfigFound = true;

    public void init(String name, HttpServletRequest request) throws ProviderException {
        super.init(name, request);
        this.appHandlers = new HashMap();
        this.bundle = this.getResourceBundle();
        this.providerContext = this.getProviderContext();
        this.adapterFactory = SSOAdapterFactory.getInstance();
        try {
            SSOAdapter ssoAdapter = this.adapterFactory.getSSOAdapter(this.getStringProperty("ssoAdapter"), request, this.getProviderContext().getLocale(), this.getProviderContext().getUserID(), this.getName());
        }
        catch (SSOAdapterException ssoe) {
            this.isSSOConfigFound = false;
            this.warning(this.getName() + " not presentable, ssoAdapter not found: " + ssoe.getMessage());
        }
        if (!this.getProviderContext().isAuthless(request)) {
            this.isPresentable = this.isPresentable(request) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public boolean isPresentable(HttpServletRequest request) {
        boolean ip = false;
        boolean presentableVal = false;
        try {
            this.getTemplate("display.template");
        }
        catch (ProviderException pe) {
            this.getProviderContext().debugError((Object)(this.getName() + " Not presentable 'display.template' not found."));
            return false;
        }
        presentableVal = this.isPresentable != null ? (ip = this.isPresentable.booleanValue()) && this.isSSOConfigFound : this.isSSOConfigFound;
        this.message("AddressBookProvider.isPresentable():  returning " + presentableVal);
        return presentableVal;
    }

    public StringBuffer getContent(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        SSOAdapter ssoAdapter = null;
        Properties ssoProps = null;
        ABStore store = null;
        AddressBook ab = null;
        try {
            ssoAdapter = this.adapterFactory.getSSOAdapter(this.getStringProperty("ssoAdapter"), request, this.getProviderContext().getLocale(), this.getProviderContext().getUserID(), this.getName());
            ssoProps = ssoAdapter.getProperties();
            store = (ABStore)ssoAdapter.getConnection();
            ab = store.openAddressBook();
        }
        catch (Exception e) {
            boolean password_unavailable;
            this.message("AddressBookProvider.getContent(): Error connecting to address book", e);
            if (ssoAdapter == null) {
                this.message("AddressBookProvider.getContent(): ssoAdapter is null");
                return this.getErrorContent(this.bundle.getString("AddressBookProvider-ssoerror"));
            }
            if (ssoAdapter != null && !ssoAdapter.getName().endsWith("_" + this.getName())) {
                this.message("AddressBookProvider.getContent(): User configuration is not specified");
                return this.getErrorContent(this.bundle.getString("AddressBookProvider-specifyConfig"));
            }
            String user_id = ssoProps.getProperty("uid");
            String password = ssoProps.getProperty("password");
            boolean user_id_unavailable = user_id == null || user_id.equals("");
            boolean bl = password_unavailable = password == null || password.equals("");
            if (user_id_unavailable && password_unavailable) {
                this.message("AddressBookProvider.getContent(): Error with username and password");
                return this.getErrorContent(this.bundle.getString("AddressBookProvider-uid-password-err"));
            }
            if (user_id_unavailable) {
                this.message("AddressBookProvider.getContent(): Error with username");
                return this.getErrorContent(this.bundle.getString("AddressBookProvider-uid-err"));
            }
            if (password_unavailable) {
                this.message("AddressBookProvider.getContent(): Error with password");
                return this.getErrorContent(this.bundle.getString("AddressBookProvider-password-err"));
            }
            this.message("AddressBookProvider.getContent(): Error with LDAP server");
            return this.getErrorContent(this.bundle.getString("AddressBookProvider-ldaperr"));
        }
        ABFilter filter = new ABFilter();
        String sort_by = this.getStringProperty(sortByAttributeName);
        sort_by = sort_by.equals("Lastname") ? "ln" : (sort_by.equals("Firstname") ? "fn" : (sort_by.equals("Email") ? "em" : (sort_by.equals("Commonname") ? "cn" : "")));
        if (!(sort_by == null || sort_by.equals("") || sort_by.equals(sortOrderNone) || sort_by.equals("NoSort"))) {
            filter.setSortBy(sort_by);
        }
        String sort_order_string = this.getStringProperty(sortOrderAttributeName);
        int sort_order = 0;
        if (sortOrderAscending.equals(sort_order_string)) {
            sort_order = 1;
        } else if (sortOrderDescending.equals(sort_order_string)) {
            sort_order = 2;
        }
        filter.setSortOrder(sort_order);
        filter.setSearchTerm(ab.newABSearchTerm("any", "*", true));
        filter.setElementType(3);
        Element[] elements = null;
        try {
            elements = ab.fetch(filter);
        }
        catch (Exception abse) {
            this.error("getContent(): Error fetching elements from the address book store", abse);
            return this.getErrorContent(this.bundle.getString("AddressBookProvider-ldaperr"));
        }
        Hashtable<String, CharSequence> contentTags = new Hashtable<String, CharSequence>();
        try {
            ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), contentTags);
        }
        catch (ProviderContextException pce) {
            this.getProviderContext().debugError((Object)"AddressBookProvider.getContent():  Exception thrown:\n", (Throwable)pce);
        }
        if (this.getBooleanProperty("displayEntries", true) && elements != null) {
            contentTags.put("ab-display-entries", this.getEntriesContent(elements));
        } else {
            contentTags.put("ab-display-entries", new StringBuffer());
        }
        contentTags.put("ab-display-summary", this.getSummaryContent(elements));
        Vector pflist = new Vector();
        String applicationURL = "";
        AddressBookApplicationHelper appHelper = null;
        String appHelperClass = "";
        try {
            pflist.addAll(this.getProviderContext().getClientPropertiesFilters());
            appHelperClass = this.getStringProperty("applicationHelperURL", pflist);
        }
        catch (Exception e) {
            this.getProviderContext().debugWarning((Object)"Error retrieving aplicationHelperURL.  Will not display link");
        }
        if (appHelperClass != null) {
            appHelper = this.getABAppHelper(ssoAdapter, appHelperClass, true);
            applicationURL = appHelper != null ? this.getApplicationStartURL(appHelper, request) : null;
            if (applicationURL != null) {
                contentTags.put("ab-display-clientURL", this.getClientURLContent(applicationURL));
            } else {
                contentTags.put("ab-display-clientURL", " ");
            }
        } else {
            contentTags.put("ab-display-clientURL", " ");
        }
        String eprc = ssoProps.getProperty("enablePerRequestConnection", "false");
        if (eprc != null && eprc.equals("true")) {
            ssoAdapter.closeConnection();
        }
        return this.getTemplate("display.template", contentTags);
    }

    private StringBuffer getEntriesContent(Element[] elements) throws ProviderException {
        StringBuffer entryList = new StringBuffer();
        Hashtable<String, CharSequence> entryListTags = new Hashtable<String, CharSequence>();
        try {
            ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), entryListTags);
        }
        catch (ProviderContextException pce) {
            this.error("AddressBookProvider:getEntriesContent(): Exception thrown:\n", (Exception)((Object)pce));
        }
        String font = this.getStringProperty("fontFace1", "Sans-serif");
        if (elements != null && elements.length > 0) {
            if (this.providerContext.isDebugMessageEnabled()) {
                this.message("getEntriesContent(): Address Book Entries count = " + elements.length);
            }
            int max = this.getIntegerProperty("maxEntries", 30);
            int num = this.getIntegerProperty("numEntries", 5);
            if (num > max) {
                num = max;
            }
            String cbgc = "";
            String entryWithoutEmailMsg = "";
            try {
                cbgc = this.bundle.getString("AddressBookProvider-cbgc");
                if (cbgc == null) {
                    cbgc = "";
                }
                if (this.providerContext.isDebugMessageEnabled()) {
                    this.message("getEntriesContent(): cbgc = " + cbgc);
                }
                if ((entryWithoutEmailMsg = this.bundle.getString("AddressBookProvider-entryWithoutEmail")) == null) {
                    entryWithoutEmailMsg = "";
                }
            }
            catch (MissingResourceException mre) {
                this.message("getEntriesContent(): Exception - ", mre);
            }
            catch (Exception e) {
                this.message("getEntriesContent(): Exception - ", e);
            }
            Hashtable<String, String> entryTags = new Hashtable<String, String>();
            int numEntriesToDisplay = num < elements.length ? num : elements.length;
            int count = 0;
            while (count < numEntriesToDisplay) {
                Element element = elements[count];
                if (element != null) {
                    Entry entry = null;
                    Group group = null;
                    String firstName = null;
                    String lastName = null;
                    String commonName = null;
                    String email = null;
                    entryTags.put("ab-display-entry-cbgc", cbgc);
                    if (element.getElementType() == 1 || element.getElementType() == -1) {
                        entry = (Entry)element;
                        firstName = this.escape(entry.getFn());
                        lastName = this.escape(entry.getLn());
                        commonName = this.escape(entry.getCn());
                        email = this.escape(entry.getEm());
                        if (firstName != null) {
                            entryTags.put("ab-display-entry-firstname", firstName);
                        }
                        if (lastName != null) {
                            entryTags.put("ab-display-entry-lastname", lastName);
                        }
                        if (email != null) {
                            entryTags.put("ab-display-entry-email", email);
                            entryTags.put("ab-display-entry-email-link", email);
                        }
                    } else if ((element.getElementType() == 3 || element.getElementType() == 2) && (commonName = this.escape((group = (Group)element).getCn())) != null) {
                        entryTags.put("ab-display-entry-commonname", commonName);
                    }
                    entryTags.put("iwtDesktop-fontFace1", font);
                    try {
                        ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), entryTags);
                    }
                    catch (ProviderContextException pce) {
                        this.getProviderContext().debugError((Object)"AddressBookProvider.getEntriesContent(): Exception thrown: \n", (Throwable)pce);
                    }
                    entryList.append((Object)this.getTemplate("display-entry.template", entryTags));
                    entryTags.clear();
                }
                ++count;
            }
        }
        entryListTags.put("ab-display-entry-list", entryList);
        entryListTags.put("iwtDesktop-fontFace1", font);
        return this.getTemplate("display-entries.template", entryListTags);
    }

    private StringBuffer getSummaryContent(Element[] elements) throws ProviderException {
        int count = 0;
        if (elements != null) {
            count = elements.length;
        }
        if (this.providerContext.isDebugMessageEnabled()) {
            this.message("getSummaryContent(): Address Book Elements count = " + count);
        }
        Hashtable<String, String> summaryTags = new Hashtable<String, String>(1);
        try {
            ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), summaryTags);
        }
        catch (ProviderContextException pce) {
            this.getProviderContext().debugError((Object)"AddressBookProvider.getContent():  Exception thrown:\n", (Throwable)pce);
        }
        summaryTags.put("ab-display-summary-entries", Integer.toString(count));
        summaryTags.put("iwtDesktop-fontFace1", this.getStringProperty("fontFace1", "Sans-serif"));
        return this.getTemplate("display-summary.template", summaryTags);
    }

    private StringBuffer getClientURLContent(String applicationURL) throws ProviderException {
        if (this.providerContext.isDebugMessageEnabled()) {
            this.message("getClientURLContent(): Application access Url = " + applicationURL);
        }
        Hashtable<String, String> clientURLTags = new Hashtable<String, String>();
        clientURLTags.put("ab-display-clientURL-appURL", applicationURL);
        return this.getTemplate("display-clientURL.template", clientURLTags);
    }

    private StringBuffer getErrorContent(String msg) throws ProviderException {
        Hashtable<String, String> errorTags = new Hashtable<String, String>();
        errorTags.put("ab-display-error", msg);
        errorTags.put("iwtDesktop-fontFace1", this.getStringProperty("fontFace1", "Sans-serif"));
        return this.getTemplate("display-error.template", errorTags);
    }

    public StringBuffer getEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        String appPref;
        StringBuffer content = new StringBuffer();
        SSOAdapter ssoAdapter = null;
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        this.editContainer = request.getParameter("provider");
        this.targetProvider = request.getParameter("targetprovider");
        this.containerName = request.getParameter("containerName");
        this.getProviderContext().debugMessage((Object)("AddressBookProvider.getEdit(): editContainer=" + this.editContainer + "\n                               targetProvider=" + this.targetProvider + "\n                               containerName=" + this.containerName));
        try {
            ssoAdapter = this.adapterFactory.getSSOAdapter(this.getStringProperty("ssoAdapter"), request, this.getProviderContext().getLocale(), this.getProviderContext().getUserID(), this.getName());
            ProviderEditUtility.setDefaultPresentation((String)this.getName(), (ProviderContext)this.getProviderContext(), tagTable);
        }
        catch (Exception e) {
            this.getProviderContext().debugMessage((Object)"AddressBookProvider.processEdit(): No SSO Adapter Found for user", (Throwable)e);
        }
        if (ssoAdapter == null) {
            this.getProviderContext().debugMessage((Object)"AddressBookProvider.processEdit(): ssoAdapter is null");
        }
        if (!(appPref = ProviderEditUtility.getRequestParameter((String)"appPref", (HttpServletRequest)request)).equals("")) {
            AddressBookApplicationHelper abah = this.getABAppHelper(ssoAdapter, appPref, false);
            content = abah.getAppPrefsEdit(this, request, response);
        } else {
            String fontTag = this.getStringProperty("fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            content.append((Object)this.getTemplate("edit-start.template", tagTable));
            try {
                content.append((Object)ProviderEditUtility.getSSOAdapterPrefs((ProviderAdapter)this, (SSOAdapter)ssoAdapter));
            }
            catch (Exception e) {
                this.getProviderContext().debugMessage((Object)"AddressBookProvider.processEdit(): Failed to get SSOAdapter attributes ", (Throwable)e);
            }
            content.append((Object)this.getTemplate("edit-end.template", tagTable));
            AddressBookApplicationHelper abah = null;
            Map appHelperClasses = this.getAppHandlerMap();
            if (appHelperClasses == null) {
                this.getProviderContext().debugWarning((Object)"unable to retrieve app handler map");
            } else {
                Iterator iter = appHelperClasses.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry appClass = iter.next();
                    String appHelperClass = (String)appClass.getValue();
                    abah = this.getABAppHelper(ssoAdapter, appHelperClass, true);
                    String link = "";
                    if (abah == null) {
                        this.getProviderContext().debugWarning((Object)"AddressBookApplicationHelper is null");
                    } else {
                        link = abah.getAppHelperEditLink(request, this.getProviderContext());
                    }
                    if (link != null || !link.equals("")) {
                        content.append(link);
                        continue;
                    }
                    this.getProviderContext().debugWarning((Object)"CalendarApplicationHelper.getAppHelperEditLink()::  returned a null or empty string");
                }
            }
        }
        return content;
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        SSOAdapter ssoAdapter = null;
        URL returnURL = null;
        try {
            ssoAdapter = this.adapterFactory.getSSOAdapter(this.getStringProperty("ssoAdapter"), req, this.getProviderContext().getLocale(), this.getProviderContext().getUserID(), this.getName());
        }
        catch (SSOAdapterException ssoe) {
            this.getProviderContext().debugMessage((Object)"AddressBookProvider.processEdit(): No SSO Adapter Found for user", (Throwable)ssoe);
        }
        String appPref = ProviderEditUtility.getRequestParameter((String)"appPref", (HttpServletRequest)req);
        this.getProviderContext().debugMessage((Object)("Calendar.processEdit(): editContainer=" + this.editContainer + "\n                        targetProvider=" + this.targetProvider + "\n                        containerName=" + this.containerName + "\n                        appPref=" + appPref));
        AddressBookApplicationHelper abah = null;
        if (!appPref.equals("")) {
            abah = this.getABAppHelper(ssoAdapter, appPref, false);
            if (abah == null) {
                this.providerContext.debugError((Object)"AddressBookApplicationHandler is null");
                returnURL = null;
            } else {
                returnURL = abah.processAppPrefsEdit(this, req, res);
                this.providerContext.debugMessage((Object)("returnURL = " + returnURL));
            }
        } else {
            ProviderEditUtility.editContainer = this.editContainer;
            ProviderEditUtility.container = this.containerName;
            SSOAdapter newAdapter = null;
            try {
                newAdapter = ProviderEditUtility.setSSOAdapterPrefs((ProviderAdapter)this, (SSOAdapter)ssoAdapter, (SSOAdapterFactory)this.adapterFactory, (HttpServletRequest)req);
                returnURL = ProviderEditUtility.getErrorURL();
                if (returnURL == null && newAdapter != null) {
                    this.getProviderContext().debugMessage((Object)"AddressBookProvider::processEdit():  Resetting the app helpers ssoAdapter");
                    Vector pflist = new Vector();
                    pflist.addAll(this.getProviderContext().getClientPropertiesFilters());
                    appPref = this.getStringProperty("applicationHelperURL", pflist);
                    abah = this.getABAppHelper(ssoAdapter, appPref, false);
                    abah.init(this, newAdapter);
                }
            }
            catch (Exception e) {
                this.getProviderContext().debugError((Object)"Unable to save the users SSOAdapter preferences");
            }
        }
        return returnURL;
    }

    protected Map getAppHandlerMap() {
        Vector pflist = new Vector();
        try {
            pflist.addAll(this.providerContext.getClientPropertiesFilters());
        }
        catch (ProviderContextException pce) {
            this.providerContext.debugError((Object)"unable to save the Client Property Filter to the list.\n", (Throwable)pce);
        }
        Map appHelperClasses = null;
        try {
            appHelperClasses = this.providerContext.getCollectionProperty(this.getName(), "applicationHelperEdit", pflist);
        }
        catch (ProviderContextException pce) {
            this.providerContext.debugWarning((Object)"unable to retrieve the application helper list.\n", (Throwable)pce);
            return null;
        }
        return appHelperClasses;
    }

    private AddressBookApplicationHelper getABAppHelper(SSOAdapter ssoAdapter, String applicationHelperName, boolean safe) {
        AddressBookApplicationHelper abApplicationHelper = null;
        if (ssoAdapter == null) {
            this.getProviderContext().debugError((Object)"ssoAdapter is null");
            return null;
        }
        if (applicationHelperName == null) {
            this.getProviderContext().debugError((Object)"applicationHelperName is null");
            return null;
        }
        boolean validClass = safe;
        if (!safe) {
            Map validAppHelpers = this.getAppHandlerMap();
            if (validAppHelpers != null) {
                validClass = validAppHelpers.containsKey(applicationHelperName);
                this.getProviderContext().debugMessage((Object)("validClass ==" + validClass));
            } else {
                validClass = false;
            }
        }
        if (ProviderEditUtility.isAppHandlerSet((HashMap)this.appHandlers, (String)applicationHelperName)) {
            this.getProviderContext().debugMessage((Object)("App Handler " + applicationHelperName + " is being retrieved."));
            abApplicationHelper = (AddressBookApplicationHelper)this.appHandlers.get(applicationHelperName);
            return abApplicationHelper;
        }
        if (validClass) {
            try {
                Class<?> applicationHelperClass = Class.forName(applicationHelperName);
                Class[] argConst = new Class[]{};
                Constructor<?> applicationHelperConst = applicationHelperClass.getConstructor(argConst);
                Object[] argConstObj = new Object[]{};
                abApplicationHelper = (AddressBookApplicationHelper)applicationHelperConst.newInstance(argConstObj);
            }
            catch (ClassNotFoundException cnfe) {
                this.getProviderContext().debugError((Object)"AddressBookProvider.getABAppHelper(): ", (Throwable)cnfe);
            }
            catch (NoSuchMethodException nsme) {
                this.getProviderContext().debugError((Object)"AddressBookProvider.getABAppHelper(): ", (Throwable)nsme);
            }
            catch (InstantiationException ine) {
                this.getProviderContext().debugError((Object)"AddressBookProvider.getABAppHelper(): ", (Throwable)ine);
            }
            catch (IllegalAccessException iae) {
                this.getProviderContext().debugError((Object)"AddressBookProvider.getABAppHelper(): ", (Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                this.getProviderContext().debugError((Object)"AddressBookProvider.getABAppHelper(): ", (Throwable)ite);
            }
            try {
                abApplicationHelper.init(this, ssoAdapter);
            }
            catch (Exception e) {
                this.getProviderContext().debugWarning((Object)("AddressBookProvider:getABAppHelper(): Unable to call init() for " + applicationHelperName), (Throwable)e);
                return null;
            }
            if (abApplicationHelper != null) {
                this.getProviderContext().debugMessage((Object)("AddressBookProvider:getABAppHelper:  Saving app helper" + applicationHelperName + "to the internal map"));
                this.appHandlers.put(applicationHelperName, abApplicationHelper);
                abApplicationHelper.setName(applicationHelperName);
                return abApplicationHelper;
            }
            return null;
        }
        return null;
    }

    protected String getApplicationStartURL(AddressBookApplicationHelper abApplicationHelper, HttpServletRequest request) {
        String applicationURLString = null;
        if (abApplicationHelper != null) {
            applicationURLString = abApplicationHelper.getStartURL(this, request);
        }
        return applicationURLString;
    }

    private URL getEditReturnURL(HttpServletRequest request, String errMsg) {
        StringBuffer urlBuffer = new StringBuffer(512);
        errMsg = this.getProviderContext().encodeURLParameter(errMsg);
        urlBuffer.append(this.getProviderContext().getDesktopURL(request));
        urlBuffer.append("?action=edit");
        urlBuffer.append("&provider=" + URLEncoder.encode(this.editContainer));
        urlBuffer.append("&targetprovider=" + this.getName());
        urlBuffer.append("&containerName=" + URLEncoder.encode(this.container));
        urlBuffer.append("&error=" + errMsg);
        String desktopURL = urlBuffer.toString();
        URL url = null;
        try {
            url = new URL(desktopURL);
        }
        catch (MalformedURLException e) {
            this.error("getEditReturnURL(): Failed to construct the edit URL " + e);
        }
        return url;
    }

    private String escape(String inContent) {
        if (inContent == null) {
            return null;
        }
        try {
            return this.getProviderContext().escape(inContent);
        }
        catch (ProviderContextException e) {
            this.getProviderContext().debugError((Object)"AddressBookProvider.escapeContent():", (Throwable)e);
            return inContent;
        }
    }

    private void message(String x) {
        if (this.providerContext.isDebugMessageEnabled()) {
            this.providerContext.debugMessage((Object)("AddressBookProvider." + x));
        }
    }

    private void message(String x, Exception e) {
        if (this.providerContext.isDebugMessageEnabled()) {
            this.providerContext.debugMessage((Object)("AddressBookProvider." + x), (Throwable)e);
        }
    }

    private void warning(String x) {
        if (this.providerContext.isDebugWarningEnabled()) {
            this.providerContext.debugWarning((Object)("AddressBookProvider." + x));
        }
    }

    private void warning(String x, Exception e) {
        if (this.providerContext.isDebugWarningEnabled()) {
            this.providerContext.debugWarning((Object)("AddressBookProvider." + x), (Throwable)e);
        }
    }

    private void error(String x) {
        if (this.providerContext.isDebugErrorEnabled()) {
            this.providerContext.debugError((Object)("AddressBookProvider." + x));
        }
    }

    private void error(String x, Exception e) {
        if (this.providerContext.isDebugErrorEnabled()) {
            this.providerContext.debugError((Object)("AddressBookProvider." + x), (Throwable)e);
        }
    }
}

