/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netmail.protocol;

import com.sun.portal.netmail.protocol.Account;
import com.sun.portal.netmail.protocol.Controller;
import com.sun.portal.netmail.protocol.Message;
import com.sun.portal.netmail.protocol.Preferences;
import com.sun.portal.netmail.protocol.Requestor;
import com.sun.portal.netmail.protocol.SearchCriteria;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Folder
implements Serializable,
Requestor {
    public static final int NOEXIST = 2;
    public static final int NEWMESSAGES = 3;
    public int exists = 0;
    public Hashtable messageTable = new Hashtable();
    public static final int DELETE = 5;
    public boolean isParent = false;
    public Account account;
    public boolean isDeleted = false;
    public static final int EXPUNGE = 1;
    public String name;
    public boolean isPrimordial = false;
    public static final int CREATE = 2;
    public static final int READONLY = 1;
    public boolean isReadOnly = false;
    public long UID = -1L;
    String IMAPname = "";
    public int nextCloneUID = -1;
    public static final int OK = 0;
    public static final int OTHER = 0;
    public static final int RENAME = 4;

    public String getName() {
        return this.name;
    }

    public void search(Controller controller, SearchCriteria searchCriteria) {
        Serializable[] serializableArray;
        Enumeration enumeration = this.messageTable.elements();
        while (enumeration.hasMoreElements()) {
            serializableArray = (Serializable[])enumeration.nextElement();
            serializableArray.found = false;
        }
        serializableArray = new Serializable[]{this.getRef(), searchCriteria, this.makeMsgBitmap()};
        controller.getRequest().startOp((Requestor)this, 6, serializableArray);
    }

    public Message getMsg(Long l) {
        return (Message)this.messageTable.get(l);
    }

    public boolean isCreated() {
        return !this.isPrimordial;
    }

    public int lastMissingMsg() {
        int n;
        boolean[] blArray = new boolean[this.exists + 1];
        Enumeration enumeration = this.messageTable.elements();
        while (enumeration.hasMoreElements()) {
            n = ((Message)enumeration.nextElement()).IMAPnumber();
            if (n <= 0 || n > this.exists) continue;
            blArray[n] = true;
        }
        n = this.exists;
        while (n > 0) {
            if (!blArray[n]) {
                return n;
            }
            --n;
        }
        return 0;
    }

    public void removeMessage(Message message) {
        this.messageTable.remove(new Long(message.UID));
    }

    public void delete(Controller controller) {
        this.isDeleted = true;
        controller.getRequest().startOp((Requestor)this, 12, this.getRef());
    }

    public Enumeration getIMAPuids() {
        return this.messageTable.keys();
    }

    public void open(Controller controller, int n) {
        long l = 0L;
        Enumeration enumeration = this.messageTable.elements();
        while (enumeration.hasMoreElements()) {
            Message message = (Message)enumeration.nextElement();
            if (message.UID() <= l) continue;
            l = message.UID();
        }
        controller.getRequest().startOp((Requestor)this, 9, new Serializable[]{this.getRef(), new Long(l), new Integer(n)});
    }

    public void rename(Controller controller, String string) {
        this.account.removeFolder(this);
        this.name = string;
        this.account.addFolder(this);
        Serializable[] serializableArray = new Serializable[]{this.getRef(), string};
        controller.getRequest().startOp((Requestor)this, 11, serializableArray);
    }

    public void addMessage(Message message) {
        int n = message.IMAPnumber();
        if (n > this.exists) {
            this.exists = n;
        }
        this.messageTable.put(new Long(message.UID), message);
        message.folder = this;
    }

    public void fetchHeaders(Controller controller, int n, int n2) {
        Serializable[] serializableArray = new Serializable[]{this.getRef(), new Integer(n), new Integer(n2)};
        controller.getRequest().startOp((Requestor)this, 5, serializableArray);
    }

    public void resync(Controller controller) {
        if (this.isParent) {
            return;
        }
        long[] lArray = new long[this.messageTable.size()];
        int n = 0;
        Enumeration enumeration = this.messageTable.elements();
        while (enumeration.hasMoreElements()) {
            Message message = (Message)enumeration.nextElement();
            lArray[n++] = message.UID();
            message.resync(controller);
        }
        if (lArray.length > 0) {
            controller.getRequest().startOp((Requestor)this, 21, new Serializable[]{this.getRef(), lArray});
        }
    }

    public void create(Controller controller) {
        controller.getRequest().startOp((Requestor)this, 10, this.getRef());
    }

    public String getOriginalName() {
        return this.IMAPname;
    }

    public Folder(Account account, String string, boolean bl) {
        this.isPrimordial = !bl;
        this.account = account;
        if (string.equalsIgnoreCase("INBOX")) {
            string = string.toUpperCase();
        }
        this.name = string;
        this.IMAPname = string;
        if (this.account != null) {
            this.account.addFolder(this);
        }
    }

    private int[] makeMsgBitmap() {
        int[] nArray = new int[this.exists / 32 + 1];
        Enumeration enumeration = this.messageTable.elements();
        while (enumeration.hasMoreElements()) {
            Message message = (Message)enumeration.nextElement();
            int n = message.IMAPnumber();
            int n2 = n / 32;
            int n3 = n % 32;
            int n4 = n2;
            nArray[n4] = nArray[n4] | 1 << n3;
        }
        return nArray;
    }

    public String setName(String string) {
        this.name = string;
        return this.IMAPname;
    }

    public void opCompleted(Controller controller, int n, Serializable[] serializableArray, Serializable[] serializableArray2) {
        switch (n) {
            case 10: {
                boolean bl = (Boolean)serializableArray2[0];
                if (bl) {
                    this.isPrimordial = false;
                } else {
                    if (this.account != null) {
                        this.account.removeFolder(this);
                    }
                    this.account = null;
                }
                controller.folderUpdated(this, 2, -1);
                break;
            }
            case 12: {
                this.account.removeFolder(this);
                Account account = this.account;
                this.account = null;
                controller.folderUpdated(this, 5, -1);
                controller.accountUpdated(account);
                break;
            }
            case 11: {
                this.IMAPname = (String)((Object)serializableArray[1]);
                controller.folderUpdated(this, 4, -1);
                break;
            }
            case 6: {
                Message[] messageArray;
                long[] lArray = (long[])serializableArray2[0];
                Vector vector = (Vector)serializableArray2[1];
                int n2 = 0;
                while (n2 < vector.size()) {
                    messageArray = (Message)vector.elementAt(n2);
                    this.addMessage((Message)messageArray);
                    ++n2;
                }
                messageArray = new Message[lArray.length];
                n2 = 0;
                while (n2 < lArray.length) {
                    messageArray[n2] = (Message)this.messageTable.get(new Long(lArray[n2]));
                    if (messageArray[n2] != null) {
                        messageArray[n2].found = true;
                    }
                    ++n2;
                }
                controller.foundMessages(messageArray);
                break;
            }
            case 5: {
                int n3 = 0;
                while (n3 < serializableArray2.length) {
                    this.addMessage((Message)serializableArray2[n3]);
                    ++n3;
                }
                controller.folderUpdated(this, 3, serializableArray2.length);
                break;
            }
            case 9: {
                int n4 = (Integer)serializableArray2[0];
                long l = (Long)serializableArray2[1];
                int n5 = (Integer)serializableArray2[2];
                Vector vector = (Vector)serializableArray2[3];
                if (n4 == 2) {
                    if (this.account != null) {
                        this.account.removeFolder(this);
                    }
                    this.account = null;
                } else {
                    if (l != this.UID) {
                        this.messageTable = new Hashtable();
                        this.nextCloneUID = 0;
                        this.exists = 0;
                        this.UID = l;
                    }
                    this.isReadOnly = n4 == 1;
                    this.isPrimordial = false;
                    int n6 = 0;
                    while (n6 < vector.size()) {
                        this.addMessage((Message)vector.elementAt(n6));
                        ++n6;
                    }
                    this.exists = n5;
                }
                controller.folderUpdated(this, 3, vector.size());
                break;
            }
            case 4: {
                int[] nArray = (int[])serializableArray2[0];
                Message[] messageArray = new Message[this.exists + 1];
                Enumeration enumeration = this.messageTable.elements();
                while (enumeration.hasMoreElements()) {
                    Message message = (Message)enumeration.nextElement();
                    int n7 = message.IMAPnumber();
                    if (n7 <= 0 || n7 > this.exists) continue;
                    messageArray[n7] = message;
                }
                int n8 = 0;
                int n9 = 0;
                while (n9 < nArray.length) {
                    Message message = messageArray[nArray[n9]];
                    if (message != null) {
                        this.messageTable.remove(new Long(message.UID));
                        message.folder = null;
                    }
                    ++n8;
                    int n10 = n9 + 1 < nArray.length ? nArray[n9 + 1] : this.exists + 1;
                    int n11 = nArray[n9] + 1;
                    while (n11 < n10) {
                        Message message2 = messageArray[n11];
                        if (message2 != null) {
                            message2.setIMAPnumber(message2.IMAPnumber() - n8);
                        }
                        ++n11;
                    }
                    if (message != null) {
                        controller.messageUpdated(message);
                    }
                    ++n9;
                }
                this.exists -= n8;
                controller.folderUpdated(this, 1, -1);
                break;
            }
            case 21: {
                long[] lArray = (long[])serializableArray[1];
                int[] nArray = (int[])serializableArray2[0];
                byte[] byArray = (byte[])serializableArray2[1];
                Hashtable<Long, Message> hashtable = new Hashtable<Long, Message>();
                this.exists = 0;
                int n12 = 0;
                while (n12 < lArray.length) {
                    Long l = new Long(lArray[n12]);
                    Message message = (Message)this.messageTable.get(l);
                    if (message != null && n12 < nArray.length && nArray[n12] != 0) {
                        message.resyncFlags = message.serverFlags = byArray[n12];
                        message.flags = message.serverFlags;
                        message.markStatus();
                        message.setIMAPnumber(nArray[n12]);
                        hashtable.put(l, message);
                        if (nArray[n12] > this.exists) {
                            this.exists = nArray[n12];
                        }
                    }
                    ++n12;
                }
                this.messageTable = hashtable;
                controller.folderUpdated(this, 0, -1);
            }
        }
    }

    public void expunge(Controller controller) {
        controller.getRequest().startOp((Requestor)this, 4, this.getRef());
    }

    public int firstMsgBefore(int n) {
        int n2 = 0;
        Enumeration enumeration = this.messageTable.elements();
        while (enumeration.hasMoreElements()) {
            int n3 = ((Message)enumeration.nextElement()).IMAPnumber();
            if (n3 <= n2 || n3 >= n) continue;
            n2 = n3;
        }
        return n2;
    }

    public Enumeration getMessages() {
        return this.messageTable.elements();
    }

    public Ref getRef() {
        return new Ref(this);
    }

    public int size() {
        return this.messageTable.size();
    }

    public boolean isSentMessagesFolder(Preferences preferences) {
        return this.getName().equals(preferences.sentMessagesFolder);
    }

    public static class Ref
    implements Serializable {
        public Account.Ref account;
        public String name;
        public long UID;

        public Ref(Folder folder) {
            if (folder.account != null) {
                this.account = folder.account.getRef();
            }
            this.name = folder.IMAPname;
            this.UID = folder.UID;
        }

        public String toArgString() {
            return this.account.toArgString() + "&folder=" + URLEncoder.encode(this.name) + "&fUID=" + this.UID;
        }
    }
}

