/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netmail.protocol;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Address
implements Cloneable,
Serializable {
    private String email = "";
    private String comment = "";

    public Address(String string) {
        if (string != null) {
            this.email = string;
        }
    }

    private static int indexOfAny(String string, String string2) {
        return Address.indexOfAny(string, string2, 0);
    }

    public String getAddress(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && this.comment.length() > 0) {
            boolean bl2 = this.comment.startsWith("(");
            if (bl2 && this.comment.endsWith(")")) {
                stringBuffer.append(this.comment);
            } else {
                if (!this.comment.startsWith("\"")) {
                    stringBuffer.append("\"");
                }
                stringBuffer.append(this.comment);
            }
            if (!(this.comment.endsWith(")") && bl2 || this.comment.endsWith("\""))) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(" ");
        }
        stringBuffer.append("<" + this.email + ">");
        return stringBuffer.toString();
    }

    public String getComment() {
        return this.comment;
    }

    public Address(String string, String string2) {
        if (string != null) {
            this.comment = string;
        }
        if (string2 != null) {
            this.email = string2;
        }
    }

    public String getEmail() {
        return this.email;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        Address address = (Address)object;
        return this.email.equalsIgnoreCase(address.email);
    }

    private static int indexOfAny(String string, String string2, int n) {
        try {
            int n2 = string.length();
            int n3 = n;
            while (n3 < n2) {
                if (string2.indexOf(string.charAt(n3)) >= 0) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return -1;
        }
    }

    public static Address[] parse(String string) throws IllegalArgumentException {
        return Address.parse(string, true);
    }

    public static Address[] parse(String string, boolean bl) throws IllegalArgumentException {
        Object object;
        int n = -1;
        int n2 = -1;
        int n3 = string.length();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Vector<Object> vector = new Vector<Object>();
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        while (n6 < n3) {
            char c = string.charAt(n6);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '(': {
                    bl4 = true;
                    if (n5 >= 0 && n4 == -1) {
                        n4 = n6;
                    }
                    if (n == -1) {
                        n = n6 + 1;
                    }
                    ++n6;
                    int n7 = 1;
                    while (n6 < n3 && n7 > 0) {
                        char c2 = string.charAt(n6);
                        switch (c2) {
                            case '\\': {
                                ++n6;
                                break;
                            }
                            case '(': {
                                ++n7;
                                break;
                            }
                            case ')': {
                                --n7;
                            }
                        }
                        ++n6;
                    }
                    if (n7 > 0) {
                        throw new IllegalArgumentException("Missing ')' in " + string);
                    }
                    --n6;
                    if (n2 != -1) break;
                    n2 = n6;
                    break;
                }
                case ')': {
                    throw new IllegalArgumentException("Missing '(' in " + string);
                }
                case '<': {
                    bl4 = true;
                    if (bl3) {
                        throw new IllegalArgumentException("Extra route-addr in " + string);
                    }
                    if (!bl2) {
                        n = n5;
                        n2 = n6;
                        n5 = n6 + 1;
                    }
                    ++n6;
                    block31: while (n6 < n3) {
                        char c3 = string.charAt(n6);
                        switch (c3) {
                            case '>': {
                                break block31;
                            }
                            default: {
                                ++n6;
                                break;
                            }
                            case '\\': {
                                ++n6;
                            }
                        }
                    }
                    if (n6 >= n3) {
                        throw new IllegalArgumentException("Missing '>' in " + string);
                    }
                    bl3 = true;
                    n4 = n6;
                    break;
                }
                case '>': {
                    throw new IllegalArgumentException("Missing '<' in " + string);
                }
                case '\"': {
                    bl4 = true;
                    if (n5 == -1) {
                        n5 = n6;
                    }
                    ++n6;
                    block32: while (n6 < n3) {
                        char c4 = string.charAt(n6);
                        switch (c4) {
                            case '\"': {
                                break block32;
                            }
                            default: {
                                ++n6;
                                break;
                            }
                            case '\\': {
                                ++n6;
                            }
                        }
                    }
                    if (n6 < n3) break;
                    throw new IllegalArgumentException("Missing '\"' in " + string);
                }
                case '[': {
                    bl4 = true;
                    ++n6;
                    block33: while (n6 < n3) {
                        char c5 = string.charAt(n6);
                        switch (c5) {
                            case ']': {
                                break block33;
                            }
                            case '\\': {
                                ++n6;
                            }
                            default: {
                                ++n6;
                            }
                        }
                    }
                    if (n6 < n3) break;
                    throw new IllegalArgumentException("Missing ']' in " + string);
                }
                case ',': {
                    Object object2;
                    if (n5 == -1) {
                        bl3 = false;
                        bl4 = false;
                        n4 = -1;
                        n5 = -1;
                        break;
                    }
                    if (bl2) break;
                    if (n4 == -1) {
                        n4 = n6;
                    }
                    String string2 = string.substring(n5, n4).trim();
                    if (bl4) {
                        Address.checkAddress(string2, bl3, bl);
                        object = new Address(string2);
                        if (n >= 0) {
                            object2 = string.substring(n, n2).trim();
                            if (((String)object2).startsWith("\"") && ((String)object2).endsWith("\"")) {
                                object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                            }
                            ((Address)object).comment = object2;
                            n2 = -1;
                            n = -1;
                        }
                        vector.addElement(object);
                    } else {
                        object2 = new StringTokenizer(string2);
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            String string3 = ((StringTokenizer)object2).nextToken();
                            Address.checkAddress(string3, false, bl);
                            object = new Address(string3);
                            vector.addElement(object);
                        }
                    }
                    bl3 = false;
                    bl4 = false;
                    n4 = -1;
                    n5 = -1;
                    break;
                }
                case ':': {
                    bl4 = true;
                    if (bl2) {
                        throw new IllegalArgumentException("Nested group in " + string);
                    }
                    bl2 = true;
                    break;
                }
                case ';': {
                    if (!bl2) {
                        throw new IllegalArgumentException("Illegal semicolon, not in group in " + string);
                    }
                    bl2 = false;
                    n4 = n6 + 1;
                    object = new Address(string.substring(n5, n4).trim());
                    vector.addElement(object);
                    bl3 = false;
                    n4 = -1;
                    n5 = -1;
                    break;
                }
                default: {
                    if (n5 != -1) break;
                    n5 = n6;
                }
            }
            ++n6;
        }
        if (n5 >= 0) {
            if (n4 == -1) {
                n4 = n6;
            }
            String string4 = string.substring(n5, n4).trim();
            if (bl4) {
                Address.checkAddress(string4, bl3, bl);
                Address address = new Address(string4);
                if (n >= 0) {
                    String string5 = string.substring(n, n2).trim();
                    if (string5.startsWith("\"") && string5.endsWith("\"")) {
                        string5 = string5.substring(1, string5.length() - 1);
                    }
                    address.comment = string5;
                }
                vector.addElement(address);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    Address.checkAddress((String)object, false, bl);
                    Address address = new Address((String)object);
                    vector.addElement(address);
                }
            }
        }
        Object[] objectArray = new Address[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static void checkAddress(String string, boolean bl, boolean bl2) throws IllegalArgumentException {
        String string2;
        String string3;
        int n;
        int n2 = 0;
        if (string.indexOf(34) >= 0) {
            return;
        }
        if (!bl2 || bl) {
            n2 = 0;
            while ((n = Address.indexOfAny(string, ",:", n2)) >= 0) {
                if (string.charAt(n2) != '@') {
                    throw new IllegalArgumentException("Illegal route-addr in " + string);
                }
                if (string.charAt(n) == ':') {
                    n2 = n + 1;
                    break;
                }
                n2 = n + 1;
            }
        }
        if ((n = string.indexOf(64, n2)) >= 0) {
            if (n == n2) {
                throw new IllegalArgumentException("Missing local name  in " + string);
            }
            if (n == string.length() - 1) {
                throw new IllegalArgumentException("Missing domain in " + string);
            }
            string3 = string.substring(n2, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = string;
            string2 = null;
        }
        if (Address.indexOfAny(string, " \t\n\r") >= 0) {
            throw new IllegalArgumentException("Illegal whitespace in address: " + string);
        }
        if (Address.indexOfAny(string3, "()<>,;:\\\"[]@") >= 0) {
            throw new IllegalArgumentException("Illegal character in local name: " + string);
        }
        if (string2 != null && string2.indexOf(91) < 0 && Address.indexOfAny(string2, "()<>,;:\\\"[]@") >= 0) {
            throw new IllegalArgumentException("Illegal character in domain: " + string);
        }
    }

    public String getAddress() {
        return this.getAddress(false);
    }
}

