/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.impl;

import com.sun.portal.portlet.impl.PortletResourceBundle;
import com.sun.portal.portletcontainercommon.descriptor.InitParamDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletInfoDescriptor;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;

public class PortletConfigImpl
implements PortletConfig {
    private String _portletName;
    private PortletContext _portletContext;
    private PortletDescriptor _pd;
    private Map _paramsMap = new HashMap();

    public PortletConfigImpl(PortletDescriptor portletDescriptor, String portletName, PortletContext portletContext) {
        this._portletName = portletName;
        this._portletContext = portletContext;
        this._pd = portletDescriptor;
        this.initParamsMap();
    }

    private void initParamsMap() {
        if (this._pd != null) {
            Iterator i = this._pd.getInitParamDescriptors().iterator();
            while (i.hasNext()) {
                InitParamDescriptor ipd = (InitParamDescriptor)i.next();
                this._paramsMap.put(ipd.getParamName(), ipd.getParamValue());
            }
        }
    }

    public String getInitParameter(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return (String)this._paramsMap.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._paramsMap.keySet());
    }

    public PortletContext getPortletContext() {
        return this._portletContext;
    }

    public String getPortletName() {
        return this._portletName;
    }

    public ResourceBundle getResourceBundle(Locale locale) throws MissingResourceException {
        ResourceBundle rb = null;
        if (this._pd == null) {
            throw new MissingResourceException("PortletConfigImpl.getResourceBundle: missing portlet descriptor", null, null);
        }
        String rbName = this._pd.getResourceBundle();
        PortletInfoDescriptor pid = this._pd.getPortletInfoDescriptor();
        Object[] values = new Object[]{"", "", ""};
        boolean[] valuesDefinedInline = new boolean[]{false, false, false};
        if (pid != null) {
            if (pid.getTitle() != null) {
                values[0] = pid.getTitle();
                valuesDefinedInline[0] = true;
            }
            if (pid.getShortTitle() != null) {
                values[1] = pid.getShortTitle();
                valuesDefinedInline[1] = true;
            }
            if (pid.getKeywords() != null) {
                List keywords = pid.getKeywords();
                String[] strArray = new String[keywords.size()];
                values[2] = keywords.toArray(strArray);
                valuesDefinedInline[2] = true;
            }
        }
        try {
            if (rbName != null) {
                rb = ResourceBundle.getBundle(rbName, locale);
            }
        }
        catch (MissingResourceException me) {
            // empty catch block
        }
        rb = new PortletResourceBundle(rb, rbName, values, valuesDefinedInline);
        return rb;
    }
}

