/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.yahoo;

import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.collections.ListMap;
import com.sun.portal.rewriter.util.uri.DecoratedURI;
import com.sun.portal.rproxy.rewriter.SRAPTranslatorHelper;
import com.sun.portal.rproxy.rewriter.util.uri.SRAPGatewayURI;
import com.sun.portal.rproxy.rewriter.yahoo.QueryParser;
import com.sun.portal.rproxy.rewriter.yahoo.YahooConfigManager;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import sun.misc.BASE64Encoder;

public final class YahooTranslatorHelper {
    private static final String YPB_URL = "ypburl";
    private static final String MD5_SIGN = "sign";
    private static final String DOT_DONE = ".done";

    public static String doTranslate(SRAPGatewayURI sRAPGatewayURI, DecoratedURI decoratedURI) {
        String string = decoratedURI.toExternalForm();
        String string2 = StringHelper.normalize((String)decoratedURI.getDecoratee().getQuery());
        String string3 = YahooTranslatorHelper.translateQuery(string2, sRAPGatewayURI);
        if (string3 == string2) {
            return string;
        }
        string = decoratedURI.getFullFileURI() + "?" + string3 + decoratedURI.getReference();
        return string;
    }

    private static String translateQuery(String string, SRAPGatewayURI sRAPGatewayURI) {
        try {
            ListMap listMap = null;
            String string2 = YPB_URL;
            if (YahooTranslatorHelper.isYahooAuthURL(string)) {
                listMap = YahooTranslatorHelper.rewriteParam(string2, string, sRAPGatewayURI);
                String string3 = YahooTranslatorHelper.computeYahooSign((Map)listMap);
                listMap.put((Object)string2, (Object)URLEncoder.encode(listMap.get((Object)string2).toString()));
                listMap.put((Object)MD5_SIGN, (Object)string3);
            } else if (YahooTranslatorHelper.isYahooLogoutURL(string)) {
                listMap = YahooTranslatorHelper.rewriteParam(string2, string, sRAPGatewayURI);
            } else if (YahooTranslatorHelper.isYahooEditURL(string)) {
                string2 = DOT_DONE;
                listMap = YahooTranslatorHelper.rewriteParam(string2, string, sRAPGatewayURI);
            } else {
                return string;
            }
            return YahooTranslatorHelper.toQueryForm(listMap);
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    private static String toQueryForm(ListMap listMap) {
        List list = listMap.keyList();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < list.size()) {
            String string = list.get(n).toString();
            String string2 = listMap.get((Object)string).toString();
            if (n != 0) {
                stringBuffer.append("&");
            }
            if (string2 == null) {
                stringBuffer.append(string).append("=");
            } else {
                stringBuffer.append(string).append("=").append(string2);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static boolean isYahooEditURL(String string) {
        return string.indexOf(DOT_DONE) != -1;
    }

    private static boolean isYahooLogoutURL(String string) {
        return string.indexOf(YPB_URL) != -1;
    }

    private static boolean isYahooAuthURL(String string) {
        return string.indexOf("&ypburl") != -1 && string.indexOf("&sign") != -1;
    }

    private static String computeYahooSign(Map map) {
        String[] stringArray = new String[]{YahooConfigManager.getCorporateID(), map.get("login").toString(), map.get("usernum").toString(), map.get(YPB_URL).toString(), map.get("ma").toString(), YahooConfigManager.getCorporatePassword()};
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    messageDigest.update(stringArray[n].getBytes());
                }
                ++n;
            }
            StringBuffer stringBuffer = new StringBuffer(new BASE64Encoder().encodeBuffer(messageDigest.digest()));
            stringBuffer = new StringBuffer(stringBuffer.substring(0, 24));
            int n2 = stringBuffer.length();
            int n3 = 0;
            while (n3 < n2) {
                switch (stringBuffer.charAt(n3)) {
                    case '+': {
                        stringBuffer.setCharAt(n3, '.');
                        break;
                    }
                    case '/': {
                        stringBuffer.setCharAt(n3, '_');
                        break;
                    }
                    case '=': {
                        stringBuffer.setCharAt(n3, '-');
                        break;
                    }
                }
                ++n3;
            }
            return stringBuffer.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Debug.error((String)"MD5 Algorithm Not Found", (Throwable)noSuchAlgorithmException);
            return "MD5AlgorithmNotFound";
        }
    }

    private static ListMap rewriteParam(String string, String string2, SRAPGatewayURI sRAPGatewayURI) throws MalformedURLException {
        ListMap listMap = QueryParser.parseQueryString(string2);
        String string3 = listMap.get((Object)string).toString();
        DecoratedURI decoratedURI = new DecoratedURI(URLDecoder.decode(string3));
        String string4 = SRAPTranslatorHelper.prefixGateway(sRAPGatewayURI, decoratedURI);
        listMap.put((Object)string, (Object)string4);
        return listMap;
    }
}

