/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.util.http;

import com.sun.portal.rproxy.rewriter.util.http.HTTPData;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class CharsetDetector {
    private static boolean charsetDetect = true;
    private String languageHint = System.getProperty("file.encoding");
    private boolean found = false;
    private String encoding = "ASCII";
    private static ArrayList chinese = new ArrayList();
    private static ArrayList japanese = new ArrayList();
    private static ArrayList korean = new ArrayList();

    public static boolean charsetDetectEnabled() {
        return charsetDetect;
    }

    public int getLanguageHint() {
        return this.getLanguageHint(this.languageHint);
    }

    public int getLanguageHint(String string) {
        int n = 0;
        if (chinese.contains(string)) {
            n = 2;
        } else if (korean.contains(string)) {
            n = 5;
        } else if (japanese.contains(string)) {
            n = 1;
        }
        return n;
    }

    public String detectCharset(HTTPData hTTPData) {
        int n = this.getLanguageHint();
        nsDetector nsDetector2 = new nsDetector(n);
        nsDetector2.Init(new nsICharsetDetectionObserver(){

            public void Notify(String string) {
                CharsetDetector.this.found = true;
                CharsetDetector.this.encoding = string;
            }
        });
        try {
            int n2;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(hTTPData.getContentBytes()));
            byte[] byArray = new byte[1024];
            boolean bl = false;
            boolean bl2 = true;
            while ((n2 = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                if (bl2) {
                    bl2 = nsDetector2.isAscii(byArray, n2);
                }
                if (bl2 || bl) continue;
                bl = nsDetector2.DoIt(byArray, n2, false);
            }
            nsDetector2.DataEnd();
            if (bl2) {
                this.found = true;
                this.encoding = "ASCII";
            }
            if (!this.found) {
                nsDetector2.getProbableCharsets();
                String[] stringArray = nsDetector2.getProbableCharsets();
                if (stringArray.length > 0 && !this.encoding.equalsIgnoreCase(stringArray[0])) {
                    this.encoding = new String(stringArray[0]);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.encoding;
    }

    static {
        chinese.add("GB2312");
        chinese.add("GB18030");
        chinese.add("Big5");
        chinese.add("ISO-2022-CN");
        chinese.add("HZ-GB-2312");
        chinese.add("x-euc-tw");
        korean.add("EUC-KR");
        korean.add("ISO-2022-KR");
        japanese.add("Shift_JIS");
        japanese.add("EUC-JP");
        japanese.add("ISO-2022-JP");
    }
}

