/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.connectionhandler.Base64;
import java.util.StringTokenizer;

class InternalCookie {
    private long timestamp = -1L;
    private String host = null;
    private String encodedForm = null;
    private String name = null;
    private String domain = null;
    private String path = null;
    private String nameValue = null;
    private String setCookie = null;
    private int max_age = -1;

    InternalCookie(String string) {
        this.encodedForm = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "^");
        this.setCookie = stringTokenizer.nextToken().trim();
        try {
            this.timestamp = Integer.parseInt(stringTokenizer.nextToken().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.timestamp = 0L;
        }
        this.host = stringTokenizer.nextToken();
        this.setCookie = new String(Base64.decode(this.setCookie.getBytes()));
        this.setCookie = this.setCookie.trim();
        this.parseSetCookie();
    }

    InternalCookie(String string, String string2, long l) {
        this.host = string2;
        this.timestamp = l;
        this.setCookie = string = string.substring(string.indexOf(58) + 1).trim();
        this.parseSetCookie();
    }

    private void parseSetCookie() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.setCookie, ";");
        this.nameValue = stringTokenizer.nextToken();
        int n = this.nameValue.indexOf(61);
        this.name = this.setCookie.substring(0, n);
        while (stringTokenizer.hasMoreTokens()) {
            String string;
            String string2;
            String string3 = stringTokenizer.nextToken();
            n = string3.indexOf(61);
            if (n == -1) {
                string2 = string3;
                string = null;
            } else {
                string2 = string3.substring(0, n).trim();
                string = string3.substring(n + 1).trim();
            }
            if (string2.equalsIgnoreCase("domain")) {
                this.domain = string;
                continue;
            }
            if (string2.equalsIgnoreCase("path")) {
                this.path = string;
                continue;
            }
            if (!string2.equalsIgnoreCase("max-age")) continue;
            try {
                this.max_age = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.max_age = 0;
            }
        }
    }

    public int getMaxAge() {
        return this.max_age;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public boolean shouldRemove() {
        return this.max_age >= 0 ? System.currentTimeMillis() / 1000L - this.timestamp <= (long)this.max_age : false;
    }

    public String getName() {
        return this.name;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getHost() {
        return this.host;
    }

    public String getNameValue() {
        return this.nameValue;
    }

    public String getPath() {
        return this.path;
    }

    public String getEncodedValue() {
        if (this.encodedForm != null) {
            return this.encodedForm;
        }
        this.encodedForm = Base64.encode(this.setCookie) + " ^ " + this.timestamp + " ^ " + this.host;
        return this.encodedForm;
    }
}

