/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.Base64;
import com.sun.portal.rproxy.connectionhandler.BasicAuthentication;
import com.sun.portal.rproxy.connectionhandler.CSBufferedInputStream;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.CachedSocketFactory;
import com.sun.portal.rproxy.connectionhandler.CookieParser;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.connectionhandler.Retriever;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.ServiceIdentifier;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.HashMap;

public class HTTPRetriever
implements Retriever {
    private static final String SET_COOKIE = "Set-Cookie";
    private static final byte[] crlf = new byte[]{13, 10};
    protected static final String scrlf = new String(crlf);
    private static String gateway_ip;
    private static boolean cookie_management;
    private static boolean doBasicAuthentication;
    public static int numBytesRead;
    private static final int defaultBufferSize = 2048;
    protected static HashMap proxyPasswdList;
    protected static final String PROXY_PASSWD_LIST = "ProxyPasswdList";

    public static String getProxyPassword(String string) {
        Object v = proxyPasswdList.get(string.trim().toLowerCase());
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    public Response getResponse2(Request request, String string, Integer n, byte[] byArray) {
        Object object;
        CachedSocket cachedSocket;
        block26: {
            String string2;
            cachedSocket = null;
            CSBufferedInputStream cSBufferedInputStream = null;
            String string3 = null;
            boolean bl = false;
            if (doBasicAuthentication) {
                string3 = request.getRequestHeader("Authorization");
                if (string3 == null) {
                    bl = BasicAuthentication.getPassword(request, string);
                } else {
                    object = string3.substring(string3.indexOf(58) + 1).trim();
                    if (!((String)object).regionMatches(true, 0, "basic ", 0, 5)) {
                        string3 = null;
                    }
                }
            }
            if (request.getUseProxy()) {
                String string4;
                object = request.getProxyHost();
                string2 = request.getRequestHeader("Proxy-Authorization");
                if (string2 == null && (string4 = HTTPRetriever.getProxyPassword((String)object)) != null) {
                    request.setRequestHeader("Proxy-Authorization", "Proxy-Authorization: Basic " + string4);
                }
            }
            object = null;
            try {
                object = new HTTPResponse();
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("HTTPRetriever retrieving " + request);
                }
                if (request.getUseProxy()) {
                    cachedSocket = CachedSocketFactory.getCachedSocket(request.getProxyHost(), request.getProxyPort(), "plain", n);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRetriever getProxyHost connecting to: " + request.getProxyHost());
                    }
                } else {
                    cachedSocket = CachedSocketFactory.getCachedSocket(request.getHost(), Integer.parseInt(request.getPort()), "plain", n);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRetriever: Connecting to: " + request.getHost());
                    }
                }
                if (cachedSocket == null) {
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("HTTPRetriever: Null socket returned. Probably couldn't resolve host.");
                    }
                    return null;
                }
                try {
                    this.sendRequest2(request, cachedSocket, byArray);
                    cSBufferedInputStream = cachedSocket.getInputStream();
                    this.getResponseHeader((HTTPResponse)object, cSBufferedInputStream, request);
                }
                catch (Exception exception) {
                    if (request.getUseProxy()) {
                        cachedSocket = CachedSocketFactory.getNewCachedSocket(request.getProxyHost(), request.getProxyPort(), "plain", n);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPRetriever: Connecting to: " + request.getProxyHost());
                        }
                    } else {
                        cachedSocket = CachedSocketFactory.getNewCachedSocket(request.getHost(), Integer.parseInt(request.getPort()), "plain", n);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPRetriever: Connecting to: " + request.getHost());
                        }
                    }
                    this.sendRequest2(request, cachedSocket, byArray);
                    cSBufferedInputStream = cachedSocket.getInputStream();
                    this.getResponseHeader((HTTPResponse)object, cSBufferedInputStream, request);
                }
                if (doBasicAuthentication && object.getStatusCode().compareTo("401") != 0 && object.getStatusCode().compareTo("403") != 0 && string3 != null) {
                    BasicAuthentication.storePassword(request, string);
                }
                string2 = object.getResponseHeader("content-length");
                int n2 = 0;
                n2 = string2 != null ? Integer.parseInt(string2.substring(string2.indexOf(58) + 1).trim()) : -1;
                cSBufferedInputStream.setClosed();
                cSBufferedInputStream.setLength(n2);
                ((HTTPResponse)object).setContentStream(cSBufferedInputStream);
                object.setSocket(cachedSocket);
            }
            catch (Exception exception) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("HTTPRetriever failed", exception);
                }
                object = null;
                if (cachedSocket == null) break block26;
                try {
                    cachedSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (object != null) {
            object.setSocket(cachedSocket);
        }
        return object;
    }

    public void sendRequest(Request request, CachedSocket cachedSocket) throws IOException, EOFException {
        if (cookie_management && !request.getHost().equals(gateway_ip)) {
            CookieParser.restoreCookieHeader(request);
        }
        OutputStream outputStream = cachedSocket.getOutputStream();
        outputStream.write(request.getRequestHeaderBytes());
        outputStream.flush();
        String string = request.getRequestHeader("Content-length");
        if (string != null) {
            int n = Integer.parseInt(string.substring(string.indexOf(58) + 1).trim());
            byte[] byArray = new byte[2048];
            int n2 = 0;
            int n3 = 0;
            BufferedInputStream bufferedInputStream = request.getContentStream();
            while (n3 + 2048 < n) {
                n2 = bufferedInputStream.read(byArray, 0, 2048);
                if (n2 == -1 && n3 < n) {
                    throw new EOFException();
                }
                if (n2 == 0) break;
                outputStream.write(byArray, 0, n2);
                n3 += n2;
            }
            int n4 = 0;
            while (n3 < n) {
                n2 = bufferedInputStream.read(byArray, n4, n - n3);
                if (n2 == -1 && n3 < n) {
                    throw new EOFException();
                }
                if (n2 == 0) break;
                n3 += n2;
                n4 += n2;
            }
            outputStream.write(byArray, 0, n4);
            request.addSize(n3);
        }
        outputStream.flush();
    }

    public void sendRequest2(Request request, CachedSocket cachedSocket, byte[] byArray) throws IOException, EOFException {
        if (cookie_management && !request.getHost().equals(gateway_ip)) {
            CookieParser.restoreCookieHeader(request);
        }
        OutputStream outputStream = cachedSocket.getOutputStream();
        outputStream.write(request.getRequestHeaderBytes());
        outputStream.flush();
        String string = request.getRequestHeader("Content-length");
        if (string != null) {
            int n = Integer.parseInt(string.substring(string.indexOf(58) + 1).trim());
            outputStream.write(byArray);
        }
        outputStream.flush();
    }

    public void getResponseHeader(HTTPResponse hTTPResponse, CSBufferedInputStream cSBufferedInputStream, Request request) throws IOException, EOFException {
        boolean bl = cookie_management && !request.getHost().equals(gateway_ip);
        boolean bl2 = true;
        cSBufferedInputStream.setLength(4000);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (bl2) {
            int n = cSBufferedInputStream.read();
            if (n == -1) {
                bl2 = false;
                throw new EOFException();
            }
            byteArrayOutputStream.write(n);
            if (n != 10) continue;
            String string = byteArrayOutputStream.toString();
            if (string.regionMatches(true, 0, SET_COOKIE, 0, SET_COOKIE.length()) && bl) {
                String string2 = CookieParser.modifyCookieHeader(hTTPResponse, request, string);
                if (string2 != null) {
                    hTTPResponse.addHeaderLine(string2);
                }
            } else if (string.toLowerCase().startsWith("content-length")) {
                String string3 = hTTPResponse.getResponseHeader("Content-Length");
                if (string3 == null) {
                    hTTPResponse.addHeaderLine(string);
                }
            } else if (string.toLowerCase().startsWith("content-disposition")) {
                string = byteArrayOutputStream.toString("ISO-8859-1");
                hTTPResponse.addHeaderLine(string);
            } else {
                hTTPResponse.addHeaderLine(string);
            }
            bl2 = !hTTPResponse.isHeaderComplete();
            byteArrayOutputStream.reset();
        }
    }

    public Response getResponse(Request request, String string, Integer n) {
        Object object;
        CachedSocket cachedSocket;
        block31: {
            String string2;
            cachedSocket = null;
            CSBufferedInputStream cSBufferedInputStream = null;
            String string3 = null;
            boolean bl = false;
            if (doBasicAuthentication) {
                string3 = request.getRequestHeader("Authorization");
                if (string3 == null) {
                    bl = BasicAuthentication.getPassword(request, string);
                } else {
                    object = string3.substring(string3.indexOf(58) + 1).trim();
                    if (!((String)object).regionMatches(true, 0, "basic ", 0, 5)) {
                        string3 = null;
                    }
                }
            }
            if (request.getUseProxy()) {
                String string4;
                object = request.getProxyHost();
                string2 = request.getRequestHeader("Proxy-Authorization");
                if (string2 == null && (string4 = HTTPRetriever.getProxyPassword((String)object)) != null) {
                    request.setRequestHeader("Proxy-Authorization", "Proxy-Authorization: Basic " + string4);
                }
            }
            object = null;
            try {
                object = new HTTPResponse();
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("HTTPRetriever retrieving " + request);
                }
                if (request.getUseProxy()) {
                    cachedSocket = CachedSocketFactory.getCachedSocket(request.getProxyHost(), request.getProxyPort(), "plain", n);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRetriever getProxyHost connecting to: " + request.getProxyHost());
                    }
                } else {
                    cachedSocket = CachedSocketFactory.getCachedSocket(request.getHost(), Integer.parseInt(request.getPort()), "plain", n);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRetriever: Connecting to: " + request.getHost());
                    }
                }
                if (cachedSocket == null) {
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("HTTPRetriever: Null socket returned. Probably couldn't resolve host.");
                    }
                    return null;
                }
                try {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRetriever before sendRequest(): req == " + request);
                    }
                    if (request.getContentStream() != null) {
                        request.getContentStream().mark(Integer.MAX_VALUE);
                    }
                    this.sendRequest(request, cachedSocket);
                    cSBufferedInputStream = cachedSocket.getInputStream();
                    this.getResponseHeader((HTTPResponse)object, cSBufferedInputStream, request);
                }
                catch (Exception exception) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("HTTPRetriever: Caught exception ", exception);
                    }
                    if (request.getUseProxy()) {
                        cachedSocket = CachedSocketFactory.getNewCachedSocket(request.getProxyHost(), request.getProxyPort(), "plain", n);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPRetriever: Connecting to: " + request.getProxyHost());
                        }
                    } else {
                        cachedSocket = CachedSocketFactory.getNewCachedSocket(request.getHost(), Integer.parseInt(request.getPort()), "plain", n);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPRetriever: Connecting to: " + request.getHost());
                        }
                    }
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRetriever: inside catch before sendRequest req.getObject() == " + request.getObject());
                    }
                    if (request.getContentStream() != null) {
                        request.getContentStream().reset();
                    }
                    this.sendRequest(request, cachedSocket);
                    cSBufferedInputStream = cachedSocket.getInputStream();
                    this.getResponseHeader((HTTPResponse)object, cSBufferedInputStream, request);
                }
                if (doBasicAuthentication && object.getStatusCode().compareTo("401") != 0 && object.getStatusCode().compareTo("403") != 0 && string3 != null) {
                    BasicAuthentication.storePassword(request, string);
                }
                string2 = object.getResponseHeader("content-length");
                int n2 = 0;
                n2 = string2 != null ? Integer.parseInt(string2.substring(string2.indexOf(58) + 1).trim()) : -1;
                cSBufferedInputStream.setClosed();
                cSBufferedInputStream.setLength(n2);
                ((HTTPResponse)object).setContentStream(cSBufferedInputStream);
                object.setSocket(cachedSocket);
            }
            catch (Exception exception) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("HTTPRetriever failed", exception);
                }
                object = null;
                if (cachedSocket == null) break block31;
                try {
                    cachedSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (object != null) {
            object.setSocket(cachedSocket);
        }
        return object;
    }

    static {
        doBasicAuthentication = false;
        numBytesRead = 0;
        Object object = GatewayProfile.getStringList(PROXY_PASSWD_LIST);
        int n = object.size();
        proxyPasswdList = new HashMap();
        if (object != null) {
            int n2 = 0;
            while (n2 < n) {
                String string = object.get(n2).toString().trim();
                int n3 = string.indexOf(124);
                if (n3 != -1) {
                    String string2 = string.substring(n3 + 1);
                    string = string.substring(0, n3).trim().toLowerCase();
                    n3 = string2.indexOf(124);
                    string2 = n3 != -1 ? string2.substring(0, n3).trim() + ":" + string2.substring(n3 + 1).trim() : string2.trim();
                    proxyPasswdList.put(string, Base64.encode(string2) + scrlf);
                } else {
                    proxyPasswdList.put(string.toLowerCase(), null);
                }
                ++n2;
            }
        }
        try {
            object = InetAddress.getLocalHost().getAddress();
            gateway_ip = Integer.toString(object[0] & 0xFF) + "." + Integer.toString(object[1] & 0xFF) + "." + Integer.toString(object[2] & 0xFF) + "." + Integer.toString(object[3] & 0xFF);
        }
        catch (Exception exception) {
            gateway_ip = null;
        }
        cookie_management = GatewayProfile.getBoolean("CookieManagement", false) && ServiceIdentifier.isGateway();
        doBasicAuthentication = GatewayProfile.getBoolean("DoBasicAuthentication", false) && ServiceIdentifier.isGateway();
    }
}

