/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.urlscraper;

import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.urlscraper.Header;
import com.sun.portal.providers.urlscraper.URLScraperProvider;
import com.sun.portal.rewriter.AbsoluteTranslator;
import com.sun.portal.rewriter.RewriterModule;
import com.sun.portal.rewriter.RewriterPool;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.util.uri.PageSpec;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class Fetcher
extends Thread {
    private final int CONTENT_BUFFER_SIZE = 2048;
    private StringBuffer content = null;
    private String data = null;
    private URL url = null;
    private URL requestURL = null;
    private URLScraperProvider provider = null;
    private boolean terminated = false;
    private boolean finished = false;
    private boolean allCookies = false;
    private List cookiesToForwardList = null;
    private ProviderContext context = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ResourceBundle bundle = null;
    private String rulesetID = null;
    private String contentType = null;
    private static List ignoreHeaders = new ArrayList();
    private static boolean rewriteCookieNames = true;

    public Fetcher(String string, URLScraperProvider uRLScraperProvider, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceBundle resourceBundle, String string2) throws MalformedURLException, ProviderException {
        this.provider = uRLScraperProvider;
        this.context = this.provider.getProviderContext();
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.requestURL = new URL(this.context.getRequestServer(this.request).toString());
        this.url = new URL(this.getAbsURL(string));
        this.bundle = resourceBundle;
        this.rulesetID = string2;
        this.allCookies = this.provider.getBooleanProperty("cookiesToForwardAll");
        this.cookiesToForwardList = this.provider.getListProperty("cookiesToForwardList");
        this.setDaemon(true);
        String string3 = this.context.getConfigProperty("rewriteURLScraperCookieNames");
        if (string3 != null) {
            rewriteCookieNames = !string3.equalsIgnoreCase("false");
        }
    }

    public StringBuffer getContent() {
        return this.content;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void terminate() {
        this.terminated = true;
        this.interrupt();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block50: {
            block49: {
                if (this.isTerminated()) {
                    return;
                }
                var1_1 = null;
                var2_2 = null;
                var3_3 = null;
                try {
                    try {
                        try {
                            var3_3 = (HttpURLConnection)this.url.openConnection();
                        }
                        catch (ClassCastException var4_4) {
                            throw new ProviderException("URLScraperProvider doesn't support ftp, file urls. URL:" + this.url, var4_4);
                        }
                        if (var3_3 == null) {
                            throw new ProviderException("Fetcher.run(): URLConnection object is null");
                        }
                        var3_3.setDoInput(true);
                        var3_3.setUseCaches(false);
                        if (this.request != null) {
                            var4_5 = this.request.getCookies();
                            var5_8 = null;
                            if (var4_5 != null) {
                                var5_8 = new Vector<Cookie>(var4_5.length);
                                var6_11 = 0;
                                while (var6_11 < var4_5.length) {
                                    if (this.provider.forward(var4_5[var6_11].getName(), this.allCookies, this.cookiesToForwardList)) {
                                        var5_8.add(var4_5[var6_11]);
                                    }
                                    ++var6_11;
                                }
                            }
                            if (var5_8 != null && var5_8.size() > 0) {
                                var6_12 = new StringBuffer();
                                if (this.context.isDebugMessageEnabled()) {
                                    this.context.debugMessage("cookieTable=" + this.provider.cookieTable);
                                }
                                var7_17 = var5_8.iterator();
                                while (true) {
                                    if (!var7_17.hasNext()) {
                                        if (this.context.isDebugMessageEnabled()) {
                                            this.context.debugMessage("Fetcher.run(): Forwarded cookie header: " + var6_12.toString());
                                            this.context.debugMessage("Fetcher.run(): cookieMap=" + this.provider.cookieTable);
                                        }
                                        var3_3.setRequestProperty("Cookie", var6_12.toString());
                                        break;
                                    }
                                    var8_19 = (Cookie)var7_17.next();
                                    var9_20 /* !! */  = null;
                                    var10_22 = null;
                                    var11_24 = var8_19.getName();
                                    if (this.provider.cookieTable != null && this.provider.cookieTable.containsKey(var11_24)) {
                                        var12_25 = (domainPathEntry)this.provider.cookieTable.get(var11_24);
                                        var9_20 /* !! */  = (byte[])var12_25.getPath();
                                        var10_22 = var12_25.getDomain();
                                        if (Fetcher.rewriteCookieNames && var11_24.startsWith("PSUSP_")) {
                                            var11_24 = var11_24.substring(6);
                                            var13_26 = var11_24.substring(0, var11_24.indexOf("_"));
                                            var14_27 = var13_26.length() + Integer.parseInt(var13_26);
                                            var11_24 = var11_24.substring(var14_27);
                                        }
                                    }
                                    if (var11_24.startsWith("PSUSP_")) continue;
                                    var6_12.append(var11_24).append("=").append(URLEncoder.encode(var8_19.getValue()));
                                    if (var9_20 /* !! */  != null) {
                                        var6_12.append("; ").append("$Path=" + (String)var9_20 /* !! */ );
                                    }
                                    if (var10_22 != null) {
                                        var6_12.append("; ").append("$Domain=" + var10_22);
                                    }
                                    if (!var7_17.hasNext()) continue;
                                    var6_12.append("; ");
                                }
                            }
                        }
                        this.setHeaders(var3_3, this.request);
                        var4_6 = var3_3.getContentLength();
                        var5_9 = var3_3.getResponseCode();
                        if (this.context.isDebugMessageEnabled()) {
                            this.context.debugMessage("Fetcher.run(): got response, code=" + var5_9);
                        }
                        if (var5_9 == -1) {
                            this.context.debugError("Fetcher.run(): response code was -1!");
                            try {
                                var3_3.disconnect();
                            }
                            catch (Exception var6_13) {
                            }
                            var16_28 = null;
                            break block49;
                        }
                        if (var5_9 == 301 || var5_9 == 302) {
                            var6_14 = var3_3.getHeaderField("Location");
                            var7_17 = new Header(var6_14);
                            if (this.context.isDebugMessageEnabled()) {
                                this.context.debugMessage("Fetcher.run(): got redirect, location=" + var7_17.getValue());
                            }
                            this.url = new URL(this.getAbsURL(var7_17.getValue()));
                            var9_21 = 1;
                            while (true) {
                                if ((var8_19 = var3_3.getHeaderFieldKey(var9_21)) == null) {
                                    this.run();
                                    ** try [egrp 4[TRYBLOCK] [2 : 865->872)] { 
lbl92:
                                    // 1 sources

                                    break;
                                }
                                if (var8_19.equalsIgnoreCase("Set-cookie")) {
                                    var10_22 = var3_3.getHeaderField(var9_21);
                                    this.processSetCookieHeader(var10_22);
                                }
                                ++var9_21;
                            }
                            {
                                var3_3.disconnect();
                            }
lbl100:
                            // 1 sources

                            catch (Exception var10_23) {
                            }
                            var16_29 = null;
                            try {
                                var3_3.disconnect();
                                return;
                            }
                            catch (Exception var17_36) {
                                // empty catch block
                            }
                            return;
                        }
                        var7_18 = 1;
                        while (true) {
                            if ((var6_15 = var3_3.getHeaderFieldKey(var7_18)) == null) {
                                this.contentType = var3_3.getContentType();
                                var8_19 = new PageSpec(var3_3.getURL().toString(), this.contentType);
                                var1_1 = var3_3.getInputStream();
                                var9_20 /* !! */  = this.provider.readContent(var1_1, var4_6);
                                var2_2 = this.provider.getContentEncoding(this.contentType, var9_20 /* !! */ , var8_19.getMIME());
                                this.data = var2_2 != null && var2_2.length() != 0 ? new String(var9_20 /* !! */ , var2_2) : new String(var9_20 /* !! */ );
                            }
                            if (var6_15.equalsIgnoreCase("Set-cookie")) {
                                var8_19 = var3_3.getHeaderField(var7_18);
                                this.processSetCookieHeader((String)var8_19);
                            }
                            ++var7_18;
                        }
                        var10_22 = RewriterPool.getDefault().getRewriter(this.rulesetID, (PageSpec)var8_19);
                        if (var10_22 != null) {
                            var11_24 = new AbsoluteTranslator((PageSpec)var8_19);
                            this.content = new StringBuffer(var10_22.rewrite(this.data, (Translator)var11_24));
                        } else {
                            this.content = new StringBuffer(this.data);
                        }
                        if (this.context.isDebugMessageEnabled()) {
                            this.context.debugMessage("Fetcher.run(): got content=\n" + this.content.toString());
                        }
                        this.finished = true;
                        break block50;
                    }
                    catch (InvalidXMLException var4_7) {
                        this.context.debugError("Fetcher.run(): ", var4_7);
                        this.content = new StringBuffer(this.bundle.getString("invalidruleset"));
                        this.finished = true;
                        var16_31 = null;
                        try {}
                        catch (Exception var17_38) {
                            return;
                        }
                        var3_3.disconnect();
                        return;
                    }
                    catch (UnsupportedEncodingException var5_10) {
                        this.context.debugError("Fetcher.run():Invalid charset " + var2_2);
                        this.context.debugError("Fetcher.run():Unsupported Encoding.", var5_10);
                        this.content = new StringBuffer(this.bundle.getString("unsupportedencoding"));
                        this.finished = true;
                        var16_32 = null;
                        try {}
                        catch (Exception var17_39) {
                            return;
                        }
                        var3_3.disconnect();
                        return;
                    }
                    catch (Exception var6_16) {
                        this.context.debugError("Exception in Fetcher:run()", var6_16);
                        this.content = null;
                        this.finished = true;
                        var16_33 = null;
                        try {}
                        catch (Exception var17_40) {
                            return;
                        }
                        var3_3.disconnect();
                        return;
                    }
                }
                catch (Throwable var15_42) {
                    var16_34 = null;
                    ** try [egrp 5[TRYBLOCK] [7 : 1321->1328)] { 
lbl171:
                    // 1 sources

                    var3_3.disconnect();
                    throw var15_42;
lbl173:
                    // 1 sources

                    catch (Exception var17_41) {
                        // empty catch block
                    }
                    throw var15_42;
                }
            }
            ** try [egrp 5[TRYBLOCK] [7 : 1321->1328)] { 
lbl178:
            // 1 sources

            var3_3.disconnect();
            return;
lbl180:
            // 1 sources

            catch (Exception var17_35) {
                // empty catch block
            }
            return;
        }
        var16_30 = null;
        try {}
        catch (Exception var17_37) {}
        var3_3.disconnect();
        return;
    }

    private String getCookieName(String string) {
        String string2 = null;
        int n = string.indexOf("=");
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private void processSetCookieHeader(String string) {
        block7: {
            String string2 = this.modifyCookieHeader(string);
            if (this.context.isDebugMessageEnabled()) {
                this.context.debugMessage("Fetcher.processSetCookieHeader(): Original set-cookie=" + string + "Modified set-cookie=" + string2);
            }
            if (string2 != null) {
                string = string2;
            }
            try {
                String string3;
                if (string == null || this.response == null || (string3 = this.getCookieName(string)) == null || !this.provider.forward(string3, this.allCookies, this.cookiesToForwardList)) break block7;
                HttpServletResponse httpServletResponse = this.response;
                synchronized (httpServletResponse) {
                    this.response.addHeader("Set-Cookie", string);
                }
            }
            catch (Exception exception) {
                this.context.debugError("Fetcher.processSetCookieHeader(): invalid cookie: " + string, exception);
            }
        }
    }

    private String getAbsURL(String string) throws MalformedURLException {
        if (!string.regionMatches(true, 0, "http://", 0, 7) && !string.regionMatches(true, 0, "https://", 0, 8)) {
            String string2 = this.requestURL.getProtocol();
            StringBuffer stringBuffer = new StringBuffer().append(string2).append("://").append(this.requestURL.getHost()).append(":");
            int n = this.requestURL.getPort();
            if (string2.equals("http") && n <= 0) {
                n = 80;
            } else if (string2.equals("https") && n <= 0) {
                n = 443;
            }
            stringBuffer.append(n).append(string);
            return stringBuffer.toString();
        }
        return string;
    }

    private String modifyCookieHeader(String string) {
        String string2;
        String string3;
        String string4;
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (!stringTokenizer.hasMoreTokens()) {
            return string;
        }
        String string5 = null;
        String string6 = stringTokenizer.nextToken().trim();
        String string7 = this.getCookieName(string);
        String string8 = this.url.getHost();
        String string9 = this.requestURL.getHost();
        StringBuffer stringBuffer = new StringBuffer();
        if (rewriteCookieNames) {
            string4 = string8 + ":" + this.url.getPort() + ":" + this.url.getPath();
            int n = string4.length() + 2;
            string3 = "PSUSP_" + n + "_" + string4 + "_" + string7;
            string2 = string6.substring(string7.length() + 1);
            stringBuffer.append(string3).append("=").append(string2);
            string5 = string3;
        } else {
            stringBuffer.append(string6);
            string5 = string7;
        }
        string2 = null;
        String string10 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string11;
            string4 = stringTokenizer.nextToken().trim();
            if (string4.length() == 0) continue;
            int n = string4.indexOf(61);
            if (n < 0) {
                string11 = string4;
                string3 = null;
            } else {
                string11 = string4.substring(0, n).trim();
                string3 = n + 1 == string4.length() ? null : string4.substring(n + 1).trim();
            }
            if (string11.equalsIgnoreCase("path")) {
                string2 = string3;
                if (string2 == null || string2.startsWith("/")) continue;
                return null;
            }
            if (string11.equalsIgnoreCase("domain")) {
                string10 = string3;
                if (string10 == null) continue;
                if (string10.charAt(0) != '.' || string10.length() < 4) {
                    return null;
                }
                if (string10.charAt(string10.length() - 1) == '.') {
                    return null;
                }
                if (string8.toLowerCase().endsWith(string10.toLowerCase())) continue;
                return null;
            }
            stringBuffer.append(";" + string4);
        }
        this.provider.cookieTable.put(string5, new domainPathEntry(string10, string2));
        String string12 = null;
        if (string9 != null && string10 != null && string9.toLowerCase().endsWith(string10.toLowerCase())) {
            string12 = string10;
        }
        if (string12 == null) {
            string12 = this.getDomain(string9);
        }
        stringBuffer.append(";domain=").append(string12).append(";path=/");
        return stringBuffer.toString();
    }

    private String getPath() {
        return this.request.getContextPath() + this.request.getServletPath();
    }

    private String getDomain(String string) {
        if (this.context.isDebugMessageEnabled()) {
            this.context.debugMessage("HOSTNAME in getDomain() : " + string);
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.lastIndexOf(46);
        while (n3 != -1) {
            n = n3;
            n3 = string.substring(0, n).lastIndexOf(46);
            ++n2;
        }
        if (this.context.isDebugMessageEnabled()) {
            this.context.debugMessage("DomainName returned from getDomain() : " + string.substring(n));
        }
        if (n2 >= 2) {
            return string.substring(n);
        }
        return string;
    }

    protected void setHeaders(URLConnection uRLConnection, HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null) continue;
                String string2 = string.toLowerCase();
                String string3 = httpServletRequest.getHeader(string);
                if (this.context.isDebugMessageEnabled()) {
                    this.context.debugMessage("Fetcher.setHeader():  header:" + string + " = " + string3);
                }
                if (ignoreHeaders.contains(string2) || string3 == null) continue;
                uRLConnection.setRequestProperty(string, string3);
                if (!this.context.isDebugMessageEnabled()) continue;
                this.context.debugMessage("URLScraperProvider's Fetcher.setHeader(): added header: " + string + " = " + string3);
            }
        }
    }

    String getContentType() {
        return this.contentType;
    }

    static {
        ignoreHeaders.add("host");
        ignoreHeaders.add("cookie");
        ignoreHeaders.add("connection");
        ignoreHeaders.add("content-length");
        ignoreHeaders.add("accept-encoding");
        ignoreHeaders.add("location");
        RewriterModule.initIDSAME();
    }

    static class domainPathEntry {
        String domain = null;
        String path = null;

        domainPathEntry(String string, String string2) {
            this.domain = string;
            this.path = string2;
        }

        String getPath() {
            return this.path;
        }

        String getDomain() {
            return this.domain;
        }
    }
}

