/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.personalnote;

import com.sun.portal.providers.InvalidEditFormDataException;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PersonalNoteProvider
extends ProfileProviderAdapter {
    private static final String sccsID = "$Id: PersonalNoteProvider.java,v 1.8 2003/08/14 01:05:27 madan Exp $";
    private ResourceBundle bundle = null;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
        this.bundle = this.getResourceBundle();
    }

    private List setNotes(List notes) throws ProviderException {
        this.setListProperty("notes", notes);
        return notes;
    }

    private List getNotes() throws ProviderException {
        return this.getListProperty("notes");
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        StringBuffer content;
        block6: {
            content = new StringBuffer();
            List pnotes = this.getNotes();
            if (!pnotes.isEmpty()) {
                int num_notes = pnotes.size();
                String text_color = this.bundle.getString("textColor");
                String dark_color = this.bundle.getString("darkColor");
                String light_color = this.bundle.getString("lightColor");
                String font_face = this.getStringProperty("fontFace1");
                String linebreak = this.getTemplate("linebreak.template").toString();
                String msgSuffix = this.getTemplate("msgSuffix.template").toString();
                Hashtable<String, String> tagTable = new Hashtable<String, String>();
                tagTable.put("textColor", text_color);
                tagTable.put("fontFace1", font_face);
                int i = 0;
                while (i < num_notes) {
                    String pnote = pnotes.get(i).toString();
                    tagTable.put("bgColor", i % 2 == 0 ? light_color : dark_color);
                    StringBuffer msgPrefix = this.getTemplate("msgPrefix.template", tagTable);
                    content.append((Object)msgPrefix).append(this.encode(pnote)).append(msgSuffix);
                    if (i < num_notes - 1) {
                        content.append(linebreak);
                    }
                    ++i;
                }
                tagTable.clear();
                tagTable.put("note", content.toString());
                tagTable.put("count", Integer.toString(num_notes));
                content = this.getTemplate("content.template", tagTable);
            } else {
                try {
                    content = this.getTemplate("noContent.template");
                }
                catch (ProviderException e) {
                    if (!this.getProviderContext().isDebugMessageEnabled()) break block6;
                    this.getProviderContext().debugMessage("PersonalNoteProvider.getContent(): noContent.template not found");
                }
            }
        }
        return content;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String editContainer = req.getParameter("provider");
        String container = req.getParameter("containerName");
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        tagTable.put("fontFace1", this.getStringProperty("fontFace1"));
        StringBuffer pnoteList = new StringBuffer("");
        List pnotes = this.getNotes();
        int num_notes = pnotes.size();
        int i = 0;
        while (i < num_notes) {
            String pnote = pnotes.get(i).toString();
            String string_i = String.valueOf(i);
            tagTable.put("removeId", string_i);
            tagTable.put("nameId", string_i);
            tagTable.put("note", pnote);
            pnoteList.append((Object)this.getTemplate("editNoteListWrapper.template", tagTable));
            tagTable.remove("note");
            ++i;
        }
        tagTable.put("noteCount", Integer.toString(num_notes));
        tagTable.put("noteList", pnoteList.toString());
        tagTable.put("container", container);
        tagTable.put("editContainer", editContainer);
        return this.getTemplate("edit.template", tagTable);
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        this.getProviderContext().contentChanged(this.getName());
        URL next = null;
        int count = 0;
        String noteCount = req.getParameter("noteCount");
        if (noteCount != null) {
            try {
                count = Integer.parseInt(noteCount);
            }
            catch (NumberFormatException e) {
                String err = this.bundle.getString("linesNAN");
                throw new InvalidEditFormDataException(err);
            }
        }
        ArrayList<String> pnotes = new ArrayList<String>();
        int i = 0;
        while (i < count) {
            boolean remove_i = false;
            String param = req.getParameter("remove" + i);
            if (param != null) {
                try {
                    remove_i = Integer.parseInt(param) == 1;
                }
                catch (NumberFormatException ne) {
                    if (this.getProviderContext().isDebugWarningEnabled()) {
                        this.getProviderContext().debugWarning("PersonalNoteProvider.processEdit(): Non numeric values cannot be removed ", ne);
                    }
                    throw new ProviderException("PersonalNoteProvider.processEdit(): Non numeric value cannot be removed", ne);
                }
            }
            if (!remove_i) {
                pnotes.add(req.getParameter("name" + i));
            }
            ++i;
        }
        String newNoteValue = req.getParameter("noteTextbox");
        if (newNoteValue != null && !newNoteValue.equals("")) {
            pnotes.add(newNoteValue);
            String addMore = req.getParameter("add_more");
            if (addMore != null && addMore.length() > 0) {
                StringBuffer urlString = new StringBuffer();
                urlString.append(this.getProviderContext().getDesktopURL(req)).append("?action=edit&provider=").append(URLEncoder.encode(req.getParameter("editContainer"))).append("&targetprovider=").append(URLEncoder.encode(this.getName())).append("&containerName=").append(URLEncoder.encode(req.getParameter("container")));
                try {
                    next = new URL(urlString.toString());
                }
                catch (MalformedURLException me) {
                    throw new ProviderException(this.getName() + ".processEdit()", me);
                }
            }
        }
        pnotes.trimToSize();
        this.setNotes(pnotes);
        String windowPref = req.getParameter("windowPref");
        if (windowPref != null) {
            this.setStringProperty("windowPref", windowPref);
        }
        return next;
    }

    public boolean isEditable() throws ProviderException {
        boolean editable = false;
        if (this.getTemplatePath("edit.template") != null && this.getBooleanProperty("isEditable")) {
            editable = true;
        }
        return editable;
    }

    public boolean isPresentable() {
        if (this.getProviderContext().isDebugWarningEnabled()) {
            this.getProviderContext().debugWarning("PersonalNoteProvider.isPresentable() is deprecated please call the method isPresentable(req)");
        }
        return false;
    }

    public boolean isPresentable(HttpServletRequest req) {
        boolean isPresentable;
        block3: {
            isPresentable = false;
            ProviderContext pc = this.getProviderContext();
            try {
                if (this.getTemplatePath("content.template") != null) {
                    isPresentable = true;
                }
            }
            catch (ProviderException pe) {
                if (!pc.isDebugWarningEnabled()) break block3;
                pc.debugWarning("PersonalNoteProvider.isPresentable() : ", pe);
            }
        }
        return isPresentable;
    }

    private String encode(String raw_data) throws ProviderException {
        String encoded_data = null;
        try {
            encoded_data = this.getProviderContext().escape(raw_data);
        }
        catch (ProviderContextException e) {
            this.getProviderContext().debugError("PersonalNoteProvider.encode(): ", e);
            throw new ProviderException("Error escaping data", e);
        }
        return encoded_data;
    }
}

