/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.jsp.jasper3.jasper.compiler;

import com.sun.portal.providers.jsp.jasper3.jasper.compiler.Mangler;
import java.io.File;

public class JspMangler
implements Mangler {
    String pkgName;
    String className;
    String javaFileName;
    String classFileName;
    String prefix;
    File jsp;
    String outputDir;

    public JspMangler(String jspFile, String outputDir) {
        this.jsp = new File(jspFile);
        this.outputDir = outputDir;
    }

    public final String getClassName() {
        if (this.className != null) {
            return this.className;
        }
        this.className = this.jsp.getName().endsWith(".jsp") ? this.jsp.getName().substring(0, this.jsp.getName().length() - 4) : this.jsp.getName();
        StringBuffer modifiedClassName = new StringBuffer();
        this.className = "_" + this.mangleString(this.className, this.className.length() - 1, modifiedClassName) + "_jsp";
        return this.className;
    }

    public final String getJavaFileName() {
        if (this.javaFileName != null) {
            return this.javaFileName;
        }
        String prefix = this.getPrefix(this.jsp.getPath());
        this.javaFileName = prefix + File.separatorChar + this.getClassName() + ".java";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.javaFileName = this.outputDir + File.separatorChar + this.javaFileName;
        }
        return this.javaFileName;
    }

    public final String getClassFileName() {
        if (this.classFileName != null) {
            return this.classFileName;
        }
        String prefix = this.getPrefix(this.jsp.getPath());
        this.classFileName = prefix + File.separatorChar + this.getClassName() + ".class";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.classFileName = this.outputDir + File.separatorChar + this.classFileName;
        }
        return this.classFileName;
    }

    public final String getPackageName() {
        if (this.pkgName != null) {
            return this.pkgName;
        }
        String pathName = this.jsp.getPath();
        String pkgName = this.getPrefix(pathName);
        pkgName = pkgName.replace(File.separatorChar, '.');
        return pkgName;
    }

    public final void setPrefix(String pfx) {
        if (pfx != null) {
            this.prefix = pfx;
        }
    }

    private final String getPrefix(String pathName) {
        if (this.prefix != null) {
            return this.prefix;
        }
        if (pathName == null) {
            return "_jsps";
        }
        int maxIndex = pathName.lastIndexOf(File.separatorChar);
        if (maxIndex == -1 || maxIndex == 0) {
            return "_jsps";
        }
        StringBuffer modifiedName = new StringBuffer();
        modifiedName.append("_jsps");
        return this.mangleString(pathName, maxIndex - 1, modifiedName);
    }

    private final String mangleString(String pathName, int maxIndex, StringBuffer sb) {
        int i = 0;
        while (i <= maxIndex) {
            if (Character.isLetterOrDigit(pathName.charAt(i)) || pathName.charAt(i) == '_') {
                sb.append(pathName.substring(i, i + 1));
            } else if (pathName.charAt(i) == File.separatorChar) {
                sb.append(File.separatorChar);
                if (i != maxIndex) {
                    sb.append("_");
                }
            } else if (pathName.charAt(i) == '-' || pathName.charAt(i) == '.') {
                sb.append("_");
            } else {
                sb.append(JspMangler.mangleChar(pathName.charAt(i)));
            }
            ++i;
        }
        return sb.toString();
    }

    private static final String mangleChar(char ch) {
        if (ch == File.separatorChar) {
            ch = (char)47;
        }
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        int i = 1;
        while (i <= nzeros) {
            result[i] = 48;
            ++i;
        }
        int i2 = nzeros + 1;
        int j = 0;
        while (i2 < 6) {
            result[i2] = s.charAt(j);
            ++i2;
            ++j;
        }
        return new String(result);
    }
}

