/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.error;

import com.sun.portal.desktop.DesktopException;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.UnknownEditTypeException;
import com.sun.portal.providers.util.ProviderProperties;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ErrorProvider
implements ProviderProperties,
Provider {
    protected static Map templates = null;
    private String exceptionType = null;

    public void init(String name, HttpServletRequest req) throws ProviderException {
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        Throwable e = (Throwable)req.getAttribute(this.getName() + ".exception");
        DesktopContext dc = (DesktopContext)req.getAttribute(this.getName() + ".desktopContext");
        DesktopAppContext dac = (DesktopAppContext)req.getAttribute(this.getName() + ".desktopAppContext");
        if (e instanceof DesktopException) {
            String redirectURL = this.getRedirectURL(req, (DesktopException)e);
            this.redirect(req, redirectURL);
        }
        StringBuffer ob = null;
        String app = this.getName();
        String provider = "error";
        if (dc != null) {
            String locale = dc.getLocaleString();
            String staticContent = dc.getStaticContentPath();
            Hashtable<String, CharSequence> tags = new Hashtable<String, CharSequence>();
            tags.put("localeString", locale);
            tags.put("staticContent", staticContent);
            String logoutUrl = dc.getLogoutURL();
            if (logoutUrl != null) {
                tags.put("logoutUrl", logoutUrl);
            }
            tags.put("banner", dc.getTemplate(app, provider, "banner.template", tags));
            tags.put("bulletColor", dc.getTemplate(app, provider, "bulletColor.js", tags));
            StringWriter swriter = new StringWriter(160);
            PrintWriter buf = new PrintWriter((Writer)swriter, true);
            if (e != null) {
                e.printStackTrace(buf);
                buf.flush();
            }
            tags.put("stackTrace", swriter.toString());
            ob = dc.getTemplate(app, provider, this.getTemplateName(e), tags);
        } else if (dac != null && dc == null) {
            dac.debugError((Object)("dac ErrorProvider.getContent type = " + this.getTemplateName(e)));
            String type = dac.getDefaultDesktopType();
            String locale = Locale.getDefault().toString();
            String clientPath = dac.getClientPath(dac.getDefaultClientType());
            Hashtable<String, CharSequence> tags = new Hashtable<String, CharSequence>();
            tags.put("banner", dac.getTemplate(type, locale, app, provider, clientPath, "banner_nocontext.template", tags, dac.getTemplateBaseDir(), null));
            tags.put("bulletColor", dac.getTemplate(type, locale, app, provider, clientPath, "bulletColor.js", tags, dac.getTemplateBaseDir(), null));
            StringWriter swriter = new StringWriter(160);
            PrintWriter buf = new PrintWriter((Writer)swriter, true);
            if (e != null) {
                e.printStackTrace(buf);
                buf.flush();
            }
            tags.put("stackTrace", swriter.toString());
            ob = dac.getTemplate(type, locale, app, provider, clientPath, this.getTemplateName(e), tags, dac.getTemplateBaseDir(), null);
        } else {
            try {
                res.sendError(500);
            }
            catch (IOException i) {
                throw new ProviderException("ErrorProvider:getContent", i);
            }
            return null;
        }
        return ob;
    }

    protected void redirect(HttpServletRequest req, String redirectURL) {
        if (redirectURL != null && !redirectURL.trim().equals("")) {
            HttpServletResponse httpRes = (HttpServletResponse)req.getAttribute(this.getName() + ".response");
            try {
                httpRes.sendRedirect(redirectURL);
            }
            catch (Exception i) {
                // empty catch block
            }
        }
    }

    protected String getRedirectURL(HttpServletRequest req, DesktopException de) {
        String redirectURL = null;
        String propertiesFile = (String)req.getAttribute(this.getName() + ".propertiesFile");
        if (propertiesFile != null && !propertiesFile.trim().equals("")) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(propertiesFile));
            }
            catch (Exception e) {
                // empty catch block
            }
            redirectURL = properties.getProperty(de.getExceptionType());
        }
        return redirectURL;
    }

    protected String getTemplateName(Throwable e) {
        String template = null;
        String exceptionType = null;
        if (e instanceof DesktopException) {
            exceptionType = ((DesktopException)e).getExceptionType();
            template = (String)templates.get(exceptionType);
        }
        if (template == null) {
            template = "error.template";
        }
        return template;
    }

    public StringBuffer getContent(Map m) throws ProviderException {
        return null;
    }

    public StringBuffer getEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        return null;
    }

    public StringBuffer getEdit(Map m) throws ProviderException {
        return null;
    }

    public int getEditType() throws UnknownEditTypeException {
        return 0;
    }

    public URL processEdit(Map m) throws ProviderException {
        return null;
    }

    public URL processEdit(HttpServletRequest request, HttpServletResponse response) throws ProviderException {
        return null;
    }

    public boolean isEditable() throws ProviderException {
        return true;
    }

    public boolean isPresentable() {
        return true;
    }

    public boolean isPresentable(HttpServletRequest req) {
        return true;
    }

    public String getTitle() throws ProviderException {
        return null;
    }

    public String getName() {
        return "Error";
    }

    public String getDescription() throws ProviderException {
        return null;
    }

    public URL getHelp(HttpServletRequest req) throws ProviderException {
        return null;
    }

    public long getRefreshTime() throws ProviderException {
        return 0L;
    }

    public int getWidth() throws ProviderException {
        return 0;
    }

    static {
        templates = new HashMap();
        templates.put("nonEditableChannel", "noneditablechannel.template");
        templates.put("noPrivilege", "noprivilege.template");
        templates.put("unknownChannel", "unknownchannel.template");
    }
}

