/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.bookmark;

import com.sun.portal.desktop.encode.Encoder;
import com.sun.portal.desktop.util.I18n;
import com.sun.portal.desktop.util.Integers;
import com.sun.portal.desktop.util.Target;
import com.sun.portal.providers.AsciiFormInputExpectedException;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.util.ProviderProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BookmarkProvider
extends ProfileProviderAdapter
implements ProviderProperties {
    private ResourceBundle bundle = null;
    private String editContainer = null;
    private String container = null;
    private static final String contentTemplate = "display.template";
    private static final String urlWrapTemplate = "urlWrapper.template";
    private static final String EDIT_URL_WRAPPER_TEMPLATE = "editUrlWrapper.template";
    private static final String EDIT_WINDOW_OPTION_TEMPLATE = "editWindowOption.template";

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
    }

    private List setTargets(List targets) throws ProviderException {
        block2: {
            try {
                List clientAndLocaleFilters = this.getProviderContext().getClientAndLocalePropertiesFilters();
                this.getProviderContext().setCollectionProperty(this.getName(), "targets", targets, clientAndLocaleFilters);
            }
            catch (ProviderContextException pce) {
                if (!this.getProviderContext().isDebugWarningEnabled()) break block2;
                this.getProviderContext().debugWarning("BookmarkProvider.getTargets():couldn't get the PropertiesFilters List", pce);
            }
        }
        return targets;
    }

    private List getTargets() throws ProviderException {
        ArrayList targets;
        block3: {
            targets = null;
            try {
                List clientAndLocaleFilters = this.getProviderContext().getClientAndLocalePropertiesFilters();
                targets = new ArrayList(this.getProviderContext().getCollectionProperty(this.getName(), "targets", clientAndLocaleFilters).values());
            }
            catch (ProviderContextException pce) {
                if (!this.getProviderContext().isDebugWarningEnabled()) break block3;
                this.getProviderContext().debugWarning("BookmarkProvider.getTargets():couldn't get the PropertiesFilters List", pce);
            }
        }
        if (targets == null) {
            targets = this.getListProperty("targets");
        }
        return targets;
    }

    public boolean isPresentable(HttpServletRequest request) {
        boolean isPresentable;
        block3: {
            isPresentable = false;
            ProviderContext pc = this.getProviderContext();
            try {
                if (this.getTemplatePath(contentTemplate) != null && this.getTemplatePath(urlWrapTemplate) != null) {
                    isPresentable = true;
                }
            }
            catch (ProviderException pe) {
                if (!pc.isDebugWarningEnabled()) break block3;
                pc.debugWarning("BookmarkProvider.isPresentable(): ", pe);
            }
        }
        return isPresentable;
    }

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        Hashtable<String, CharSequence> tagTable = new Hashtable<String, CharSequence>();
        StringBuffer content = new StringBuffer();
        StringBuffer ob = new StringBuffer();
        List clientAndLocaleFilters = null;
        List targets = this.getTargets();
        int x = 0;
        while (x < targets.size()) {
            String targ = (String)targets.get(x);
            Target target = new Target(targ);
            String name = target.getName();
            String link = target.getValue();
            try {
                name = this.getProviderContext().escape(name);
                link = this.getProviderContext().escape(link);
                clientAndLocaleFilters = this.getProviderContext().getClientAndLocalePropertiesFilters();
            }
            catch (ProviderContextException pce) {
                this.getProviderContext().debugError("BookmarkProvider.getContent()", pce);
            }
            StringBuffer windowName = new StringBuffer();
            StringTokenizer tokens = new StringTokenizer(target.getName(), " (),=+#[]@<>$%./!");
            while (tokens.hasMoreTokens()) {
                windowName.append(tokens.nextToken());
                if (!tokens.hasMoreElements()) continue;
                windowName.append("_");
            }
            tagTable.put("fontFace1", this.getStringProperty("fontFace1", clientAndLocaleFilters));
            tagTable.put("channelName", Encoder.FORMNAME_ENCODER.encode(this.getName()));
            tagTable.put("windowName", windowName);
            tagTable.put("link", link);
            tagTable.put("name", name);
            content.append((Object)this.getTemplate(urlWrapTemplate, tagTable));
            tagTable.clear();
            ++x;
        }
        String windowPref = this.getStringProperty("windowPref", clientAndLocaleFilters);
        tagTable.put("windowOption", windowPref);
        tagTable.put("bookmarks", content.toString());
        tagTable.put("channelName", Encoder.FORMNAME_ENCODER.encode(this.getName()));
        tagTable.put("fontFace1", this.getStringProperty("fontFace1", clientAndLocaleFilters));
        ob = this.getTemplate(contentTemplate, tagTable);
        return ob;
    }

    public boolean isEditable() throws ProviderException {
        boolean isEditable = false;
        if (this.getTemplatePath("edit.template") != null && this.getBooleanProperty("isEditable")) {
            isEditable = true;
        }
        return isEditable;
    }

    public StringBuffer getEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        List clientAndLocaleFilters;
        List targets;
        Hashtable<String, String> windowOptions;
        StringBuffer resourceList;
        StringBuffer content;
        block13: {
            content = new StringBuffer();
            resourceList = new StringBuffer("");
            windowOptions = new Hashtable<String, String>();
            this.editContainer = req.getParameter("provider");
            this.container = req.getParameter("containerName");
            targets = this.getTargets();
            clientAndLocaleFilters = null;
            try {
                clientAndLocaleFilters = this.getProviderContext().getClientAndLocalePropertiesFilters();
            }
            catch (ProviderContextException pce) {
                if (!this.getProviderContext().isDebugWarningEnabled()) break block13;
                this.getProviderContext().debugWarning("BookmarkProvider.getEdit():couldn't get the PropertiesFilters List", pce);
            }
        }
        int i = 0;
        while (i < targets.size()) {
            String targ = (String)targets.get(i);
            Target target = new Target(targ);
            Hashtable<String, String> existingBM = new Hashtable<String, String>();
            existingBM.put("targetName", Encoder.HTML_ENCODER.encode(target.getName()));
            existingBM.put("targetValue", Encoder.HTML_ENCODER.encode(target.getValue()));
            existingBM.put("fontFace1", this.getStringProperty("fontFace1", clientAndLocaleFilters));
            existingBM.put("index", String.valueOf(i));
            resourceList.append((Object)this.getTemplate(EDIT_URL_WRAPPER_TEMPLATE, existingBM));
            ++i;
        }
        Hashtable<String, CharSequence> tagTable = new Hashtable<String, CharSequence>();
        String all_new_checked = new String("");
        String one_new_checked = new String("");
        String same_checked = new String("");
        String wp = this.getStringProperty("windowPref", clientAndLocaleFilters);
        if (wp.equals("all_new")) {
            all_new_checked = "CHECKED";
        }
        if (wp.equals("one_new")) {
            one_new_checked = "CHECKED";
        }
        if (wp.equals("same")) {
            same_checked = "CHECKED";
        }
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle();
        }
        windowOptions.put("all_new_checked", all_new_checked);
        windowOptions.put("one_new_checked", one_new_checked);
        windowOptions.put("same_checked", same_checked);
        windowOptions.put("ownWindow", this.bundle.getString("ownWindow"));
        windowOptions.put("singleWindow", this.bundle.getString("singleWindow"));
        windowOptions.put("mainWindow", this.bundle.getString("mainWindow"));
        String resourceCountString = Integer.toString(targets.size());
        String err = I18n.IURLDecode((String)req.getParameter("error"));
        if (err != null) {
            tagTable.put("errMessage", err);
            tagTable.put("inlineError", this.getTemplate("inlineError.template"));
        } else {
            tagTable.put("errMessage", "");
            tagTable.put("inlineError", "");
        }
        String resourceName = req.getParameter("resourceName");
        if (resourceName != null) {
            tagTable.put("resourceName", resourceName);
        } else {
            tagTable.put("resourceName", "");
        }
        String resourceURL = req.getParameter("resourceURL");
        if (resourceURL != null) {
            tagTable.put("resourceURL", resourceURL);
        } else {
            tagTable.put("resourceURL", "");
        }
        tagTable.put("resourceCount", resourceCountString);
        tagTable.put("resourceList", resourceList.toString());
        tagTable.put("windowOptions", this.getTemplate(EDIT_WINDOW_OPTION_TEMPLATE, windowOptions));
        tagTable.put("fontFace1", this.getStringProperty("fontFace1", clientAndLocaleFilters));
        content = this.getTemplate("edit.template", tagTable);
        return content;
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        URL next;
        block34: {
            List clientAndLocaleFilters = null;
            this.getProviderContext().contentChanged(this.getName());
            String error = null;
            Vector<String> targets = new Vector<String>();
            StringBuffer nextURLString = new StringBuffer();
            if (this.editContainer != null && this.container != null) {
                nextURLString.append(this.getProviderContext().getDesktopURL(req)).append("?action=edit&provider=").append(URLEncoder.encode(this.editContainer)).append("&targetprovider=").append(URLEncoder.encode(this.getName())).append("&containerName=").append(URLEncoder.encode(this.container));
            } else {
                nextURLString = null;
            }
            String rc = req.getParameter("resourceCount");
            int resourceCount = Integer.parseInt(rc);
            if (this.bundle == null) {
                this.bundle = this.getResourceBundle();
            }
            next = null;
            int i = 0;
            while (i < resourceCount) {
                Integer removeFlag;
                String checkBoxValue = req.getParameter("remove" + i);
                Integer n = removeFlag = checkBoxValue == null ? Integers.get((int)0) : Integer.valueOf(checkBoxValue);
                if (removeFlag != 1) {
                    String nameString = "name" + i;
                    String urlString = "url" + i;
                    String name = req.getParameter(nameString);
                    String url = req.getParameter(urlString);
                    boolean errorFlag = false;
                    if ((name == null || name.trim().equals("")) && (url == null || url.trim().equals(""))) {
                        if (nextURLString != null) {
                            nextURLString.append("&error=").append(URLEncoder.encode(this.bundle.getString("removeError")));
                            errorFlag = true;
                        }
                    } else if (name == null || name.trim().equals("")) {
                        if (nextURLString != null) {
                            nextURLString.append("&error=").append(URLEncoder.encode(this.bundle.getString("emptyName") + " : " + url));
                            errorFlag = true;
                        }
                    } else if ((url == null || url.trim().equals("")) && nextURLString != null) {
                        nextURLString.append("&error=").append(URLEncoder.encode(this.bundle.getString("emptyURL") + " : " + name));
                        errorFlag = true;
                    }
                    if (errorFlag) {
                        try {
                            if (nextURLString != null) {
                                next = new URL(nextURLString.toString());
                            }
                        }
                        catch (MalformedURLException e) {
                            throw new ProviderException("BookmarkProvider.processEdit()", e);
                        }
                        return next;
                    }
                    if (!I18n.isAscii((String)url)) {
                        String err = this.bundle.getString("nonAsciiURL");
                        throw new AsciiFormInputExpectedException(err);
                    }
                    Target target = new Target(name, url);
                    if (target.getValue().indexOf("://") == -1 && !target.getValue().startsWith("/")) {
                        target.setValue("http://" + target.getValue());
                    }
                    targets.add(target.toString());
                }
                ++i;
            }
            String newName = req.getParameter("resourceName");
            String newURL = req.getParameter("resourceURL");
            String addMore = req.getParameter("add_more");
            if (newName != null && newURL != null && !newName.trim().equals("") && !newURL.trim().equals("")) {
                if (!I18n.isAscii((String)newURL)) {
                    String err = this.bundle.getString("nonAsciiURL");
                    throw new AsciiFormInputExpectedException(err);
                }
                Target target = new Target(newName, newURL);
                if (target.getValue().indexOf("://") == -1 && !target.getValue().startsWith("/")) {
                    target.setValue("http://" + target.getValue());
                }
                targets.add(target.toString());
            } else if ((newName == null || newName.trim().equals("")) && (newURL == null || newURL.trim().equals(""))) {
                if (addMore != null && !addMore.trim().equals("")) {
                    error = this.bundle.getString("emptyNameURL");
                }
            } else {
                error = newName == null || newName.trim().equals("") ? this.bundle.getString("emptyName") : this.bundle.getString("emptyURL");
            }
            if (error != null && nextURLString != null && newName != null && newURL != null) {
                nextURLString.append("&resourceName=").append(URLEncoder.encode(newName)).append("&resourceURL=").append(URLEncoder.encode(newURL)).append("&error=").append(URLEncoder.encode(error));
            }
            if (error == null && (addMore == null || addMore.trim().equals(""))) {
                next = null;
            } else {
                try {
                    if (nextURLString != null) {
                        next = new URL(nextURLString.toString());
                    }
                }
                catch (MalformedURLException e) {
                    throw new ProviderException("BookmarkProvider.processEdit()", e);
                }
            }
            this.setTargets(targets);
            String windowPref = req.getParameter("windowPref");
            try {
                clientAndLocaleFilters = this.getProviderContext().getClientAndLocalePropertiesFilters();
                if (windowPref != null && !windowPref.equals(this.getStringProperty("windowPref", clientAndLocaleFilters))) {
                    this.getProviderContext().setStringProperty(this.getName(), "windowPref", windowPref, clientAndLocaleFilters);
                }
            }
            catch (ProviderContextException pce) {
                if (!this.getProviderContext().isDebugWarningEnabled()) break block34;
                this.getProviderContext().debugWarning("BookmarkProvider.processEdit():couldn't get the PropertiesFilters List", pce);
            }
        }
        return next;
    }
}

