/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon.descriptor;

import com.sun.portal.common.logging.Level;
import com.sun.portal.common.logging.Logger;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentExtensionDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;

public class PortletsDescriptor {
    public static final String PORTLET = "portlet";
    private List _portletDescriptors = new ArrayList();
    private List _portletNames = new ArrayList();
    private Logger _logger;
    private DeploymentExtensionDescriptor _depExtDescriptor;

    public PortletsDescriptor(Logger logger, DeploymentExtensionDescriptor depExtDescriptor) {
        this._logger = logger;
        this._depExtDescriptor = depExtDescriptor;
    }

    public void load(Element element, Namespace namespace) throws DeploymentDescriptorException {
        List portletElements = element.getChildren(PORTLET, namespace);
        if (portletElements.isEmpty() && this._logger.isLoggable(Level.WARNING)) {
            this._logger.logp(Level.WARNING, "PortletsDescriptor", "load()", "porltes element is missing in the deployment descriptor.");
        }
        Iterator iterator = portletElements.iterator();
        while (iterator.hasNext()) {
            Element portletElement = (Element)iterator.next();
            PortletDescriptor portletDescriptor = new PortletDescriptor(this._logger, this._depExtDescriptor);
            portletDescriptor.load(portletElement, namespace);
            this._portletDescriptors.add(portletDescriptor);
            this._portletNames.add(portletDescriptor.getPortletName());
        }
    }

    public List getPortletNames() {
        return this._portletNames;
    }

    public List getPortletDescriptors() {
        return this._portletDescriptors;
    }

    public PortletDescriptor getPortletDescriptor(String portletName) {
        PortletDescriptor portlet = null;
        boolean stop = false;
        Iterator iterator = this._portletDescriptors.iterator();
        while (iterator.hasNext() && !stop) {
            PortletDescriptor portletDescriptor = (PortletDescriptor)iterator.next();
            if (!portletDescriptor.getPortletName().equals(portletName)) continue;
            portlet = portletDescriptor;
            stop = true;
        }
        return portlet;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PortletsDescriptor [");
        Iterator iterator = this._portletDescriptors.iterator();
        while (iterator.hasNext()) {
            PortletDescriptor portletDescriptor = (PortletDescriptor)iterator.next();
            sb.append(portletDescriptor.toString());
            sb.append("\n");
        }
        sb.append("]");
        sb.append("\n");
        return sb.toString();
    }
}

