/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainercommon.descriptor;

import com.sun.portal.common.logging.Logger;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;

public class DeploymentExtensionDescriptor {
    public static final String SAVE_PREFERENCES_IN_RENDER_PERMISSION = "save-preferences-in-render-permission";
    public static final String EXTENSION_ELEMENT = "extension-element";
    public static final String DEPLOYMENT_EXTENSION = "deployment-extension";
    public static final String SESSION_ENABLED = "session-enabled";
    private Logger _logger;
    private List _sessionDisabledList = new ArrayList();
    private boolean _savePerferencesPermission = false;

    public DeploymentExtensionDescriptor(Logger logger) {
        this._logger = logger;
    }

    public void load(Element element, Namespace namespace) throws DeploymentDescriptorException {
        String permission = element.getChildTextTrim(SAVE_PREFERENCES_IN_RENDER_PERMISSION, namespace);
        if (permission != null && permission.equals("1")) {
            this._savePerferencesPermission = true;
        }
        List portletElements = element.getChildren("portlet", namespace);
        Iterator iterator = portletElements.iterator();
        while (iterator.hasNext()) {
            Element portletElement = (Element)iterator.next();
            String portletName = portletElement.getChildTextTrim("portlet-name", namespace);
            List depExtElements = portletElement.getChildren(DEPLOYMENT_EXTENSION, namespace);
            if (depExtElements.isEmpty()) continue;
            Iterator iterator1 = depExtElements.iterator();
            while (iterator1.hasNext()) {
                Element depExtElement = (Element)iterator1.next();
                List extensionElements = depExtElement.getChildren(EXTENSION_ELEMENT, namespace);
                String sessionEnabled = null;
                boolean stop = false;
                Iterator itor = extensionElements.iterator();
                while (itor.hasNext() && !stop) {
                    Element extensionElement = (Element)itor.next();
                    sessionEnabled = extensionElement.getChildTextTrim(SESSION_ENABLED, namespace);
                    if (sessionEnabled == null) continue;
                    stop = true;
                }
                if (sessionEnabled == null || !sessionEnabled.equals("0")) continue;
                this._sessionDisabledList.add(portletName);
            }
        }
    }

    public boolean sessionEnabled(String portletName) {
        boolean sessionEnabled = true;
        if (this._sessionDisabledList.contains(portletName)) {
            sessionEnabled = false;
        }
        return sessionEnabled;
    }

    public boolean isSavePreferencesAllowed() {
        return this._savePerferencesPermission;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DeploymentExtensionDescriptor ");
        Iterator iterator = this._sessionDisabledList.iterator();
        sb.append("[ portlets without session: ");
        while (iterator.hasNext()) {
            sb.append((String)iterator.next()).append(", ");
        }
        sb.append("]");
        sb.append("[ save preferences is allowed: ");
        sb.append(this._savePerferencesPermission);
        sb.append(" ]");
        return sb.toString();
    }
}

