/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.services;

import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.collections.ListMap;
import com.sun.portal.rewriter.util.re.Pattern;
import com.sun.portal.rproxy.rewriter.services.SRAPContext;
import com.sun.portal.rproxy.rewriter.services.URI2RuleSetMap;
import java.util.HashMap;
import java.util.List;

public final class SRAPProcessedProfile {
    private static SRAPContext srapContext;
    private static URI2RuleSetMap uri2RulesetMAP;
    private static ListMap mime2ParserMAP;
    private static ListMap uri2ParserMAP;
    private static Pattern[] not2RewriteURIPatterns;
    private static Pattern[] not2ObscureURIPatterns;
    private static String httpsPort;
    private static String httpPort;

    public static void init(SRAPContext sRAPContext) {
        srapContext = sRAPContext;
        uri2RulesetMAP = SRAPProcessedProfile.initURI2RuleSetMap(sRAPContext.readURI2RuleSetMappings());
        mime2ParserMAP = SRAPProcessedProfile.initMIME2ParserMap(sRAPContext.readMIME2ParserMappings());
        uri2ParserMAP = SRAPProcessedProfile.initURI2ParserMap(sRAPContext.readURI2ParserMappings());
        not2RewriteURIPatterns = SRAPProcessedProfile.initNot2RewriteURIPatterns(sRAPContext.readNot2RewriteURIList());
        not2ObscureURIPatterns = SRAPProcessedProfile.initNot2ObscureURIPatterns(sRAPContext.readNot2ObscureURIList());
        httpPort = sRAPContext.getHTTPPort() == 80 ? "" : ":" + sRAPContext.getHTTPPort();
        httpsPort = sRAPContext.getHTTPSPort() == 443 ? "" : ":" + sRAPContext.getHTTPSPort();
    }

    public static String getInstanceName() {
        return srapContext.getProfileName();
    }

    public static URI2RuleSetMap getURI2RuleSetMap() {
        return uri2RulesetMAP;
    }

    public static ListMap getMIME2ParserMap() {
        return mime2ParserMAP;
    }

    public static boolean isMIMEGuessingEnabled() {
        return srapContext.isMIMEGuessingEnabled();
    }

    public static ListMap getURI2ParserMAP() {
        return uri2ParserMAP;
    }

    public static Pattern[] getNot2RewriteURIPatterns() {
        return not2RewriteURIPatterns;
    }

    public static boolean isObscureURIs() {
        return srapContext.isURLObfuscationEnabled();
    }

    public static String getObfuscatorSeed() {
        return srapContext.readObfuscatorSeed();
    }

    public static Pattern[] getNot2ObscureURIPatterns() {
        return not2ObscureURIPatterns;
    }

    public static boolean isUseConsistantProtocol4Gateway() {
        return srapContext.isUseConsistantProtocol4Gateway();
    }

    private static URI2RuleSetMap initURI2RuleSetMap(List list) {
        return new URI2RuleSetMap(list);
    }

    private static ListMap initMIME2ParserMap(List list) {
        return SRAPProcessedProfile.parserMapHelper(list, new CustomProcess(){

            public Object processKey(Object object) {
                return object.toString().toLowerCase();
            }
        });
    }

    private static ListMap initURI2ParserMap(List list) {
        return SRAPProcessedProfile.parserMapHelper(list, new CustomProcess(){

            public Object processKey(Object object) {
                return new Pattern(object.toString(), true);
            }
        });
    }

    private static Pattern[] initNot2RewriteURIPatterns(List list) {
        return Pattern.convert2Patterns((String[])list.toArray(Constants.EMPTY_STRING_ARRAY), (boolean)true);
    }

    private static Pattern[] initNot2ObscureURIPatterns(List list) {
        return Pattern.convert2Patterns((String[])list.toArray(Constants.EMPTY_STRING_ARRAY), (boolean)true);
    }

    private static ListMap parserMapHelper(List list, CustomProcess customProcess) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("html", "text/html");
        hashMap.put("javascript", "application/x-javascript");
        hashMap.put("java_script", "application/x-javascript");
        hashMap.put("xml", "text/xml");
        hashMap.put("css", "text/css");
        ListMap listMap = new ListMap();
        int n = 0;
        while (n < list.size()) {
            String string = StringHelper.normalize((String)((String)list.get(n))).toString();
            String[] stringArray = StringHelper.tokenize((String)string, (String)"=");
            if (stringArray.length == 2) {
                String string2 = stringArray[0].trim();
                Object v = hashMap.get(string2.toLowerCase());
                if (v != null) {
                    String[] stringArray2 = StringHelper.tokenize((String)stringArray[1], (String)";:|");
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        String string3 = stringArray2[n2].trim();
                        if (string3.length() != 0) {
                            listMap.put(customProcess.processKey(string3), v);
                        }
                        ++n2;
                    }
                } else {
                    System.out.println("No Rewriter Available for key:" + string2);
                }
            } else {
                System.out.println("Illegal List Content:" + string);
            }
            ++n;
        }
        return listMap;
    }

    public static String getHTTPPort() {
        return httpPort;
    }

    public static String getHTTPSPort() {
        return httpsPort;
    }

    static {
        not2RewriteURIPatterns = Pattern.EMPTY_PATTERN_ARRAY;
        not2ObscureURIPatterns = Pattern.EMPTY_PATTERN_ARRAY;
    }

    private static interface CustomProcess {
        public Object processKey(Object var1);
    }
}

