/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.connectionhandler.InternalCookie;
import com.sun.portal.util.GWDebug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class CookieList {
    private Hashtable existingCookies = new Hashtable();
    private long time = System.currentTimeMillis() / 1000L;
    private String encodedValue = "";
    private boolean hasBeenModified = false;

    public CookieList() {
    }

    public CookieList(String string) {
        this();
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("encodedCookieList : " + string);
        }
        this.encodedValue = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            InternalCookie internalCookie;
            String string2 = stringTokenizer.nextToken();
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("CookieList : cookie " + string2);
            }
            if ((internalCookie = new InternalCookie(string2)).shouldRemove()) {
                this.hasBeenModified = true;
                this.encodedValue = null;
                continue;
            }
            this.existingCookies.put(internalCookie.getName(), internalCookie);
        }
    }

    public void processCookie(String string, String string2) {
        InternalCookie internalCookie = new InternalCookie(string, string2, this.time);
        String string3 = internalCookie.getName();
        InternalCookie internalCookie2 = (InternalCookie)this.existingCookies.get(string3);
        if (internalCookie2 == null) {
            if (internalCookie.shouldRemove()) {
                return;
            }
        } else if (internalCookie.shouldRemove()) {
            this.existingCookies.remove(string3);
            this.hasBeenModified = true;
            this.encodedValue = null;
            return;
        }
        this.hasBeenModified = true;
        this.encodedValue = null;
        this.existingCookies.put(string3, internalCookie);
    }

    public boolean isModified() {
        return this.hasBeenModified;
    }

    public int length() {
        return this.existingCookies.size();
    }

    public Enumeration enumerate() {
        return this.existingCookies.elements();
    }

    public String getEncodedValue() {
        if (this.encodedValue != null) {
            return this.encodedValue;
        }
        Set set = this.existingCookies.keySet();
        Iterator iterator = set.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            InternalCookie internalCookie = (InternalCookie)this.existingCookies.get(string);
            if (bl) {
                stringBuffer.append(internalCookie.getEncodedValue());
                bl = false;
                continue;
            }
            stringBuffer.append(" | ").append(internalCookie.getEncodedValue());
        }
        this.encodedValue = stringBuffer.toString();
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("encodedValue : " + this.encodedValue);
        }
        return this.encodedValue;
    }
}

