/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.perf.rproxy;

import com.sun.portal.perf.rproxy.DataFormater;
import com.sun.portal.perf.rproxy.PerfContext;
import com.sun.portal.perf.rproxy.PerfContextController;
import com.sun.portal.perf.rproxy.PerfData;
import com.sun.portal.perf.rproxy.PerfDataRecorderFactory;
import com.sun.portal.perf.rproxy.SimpleDataFormater;
import com.sun.portal.perf.util.PerfProperties;
import java.util.LinkedList;
import java.util.List;

public class PerfContextObject
implements PerfContext,
PerfContextController {
    public static final boolean ENABLE_PERF = PerfProperties.get("gateway.perf.enable", "false").trim().equalsIgnoreCase("true");
    private static DataFormater dataFormater = null;
    private static ThreadLocal thrLocal;
    private LinkedList checkpoints = new LinkedList();

    private PerfContextObject() {
        this.reset();
    }

    public static PerfContext getPerfContext() {
        return (PerfContext)thrLocal.get();
    }

    public static PerfContextController createPerfContext() {
        if (thrLocal.get() == null) {
            PerfContextObject perfContextObject = new PerfContextObject();
            thrLocal.set(perfContextObject);
            return perfContextObject;
        }
        return null;
    }

    public void reset() {
        this.checkpoints.clear();
    }

    public void record(PerfData perfData) {
        this.checkpoints.add(perfData);
    }

    public List getData() {
        return this.checkpoints;
    }

    public void saveData() {
        PerfDataRecorderFactory.getRecorder().writeData(this.checkpoints, dataFormater);
    }

    public static boolean isPerfEnabled() {
        return ENABLE_PERF;
    }

    static {
        String string = PerfProperties.get("gateway.perf.dataformater", "com.sun.portal.perf.rproxy.SimpleDataFormater");
        try {
            dataFormater = (DataFormater)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            dataFormater = new SimpleDataFormater();
        }
        thrLocal = new ThreadLocal();
    }
}

