/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.eproxy.GW;
import com.sun.portal.netlet.eproxy.RProxyConnection;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.PlatformProfile;
import com.sun.portal.rproxy.rewriter.SRAPRewriterModule;
import com.sun.portal.rproxy.server.GatewayContext;
import com.sun.portal.rproxy.server.GatewayContextFactory;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.GWNSSInit;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.NetletLogMgr;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class EProxy {
    public static boolean isNetletEnabled = true;
    static final String watchdogInfoFileBase = "/var/opt/SUNWps/.gw.";

    private static void init() {
        CharSequence charSequence;
        GWDebug.createDefault("srapGateway");
        if (!GWNSSInit.initialize()) {
            System.exit(1);
        }
        ServiceIdentifier.createDefault("srapGateway");
        try {
            charSequence = System.getProperty("gateway.profilename", "default");
            GatewayProfile.init("this-should-be-sid", (String)charSequence);
            PlatformProfile.init("this-should-be-sid");
            SRAPRewriterModule.initIDSAME();
        }
        catch (Exception exception) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("Unable to initialize GatewayProfile/PlatformProfile", exception);
            }
            System.exit(1);
        }
        GatewayContextFactory.init(1);
        GWLogManager.initialise();
        if (GWLogManager.loggingEnabled) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("srapGateway_").append(SystemProperties.get("gateway.host").replace('-', '_')).append('_').append(System.getProperty("gateway.profilename", "default").replace('-', '_'));
            GWLogManager.createDefault(((StringBuffer)charSequence).toString());
        }
        if (NetletLogMgr.loggingEnabled) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("srapNetlet_").append(SystemProperties.get("gateway.host").replace('-', '_')).append('_').append(System.getProperty("gateway.profilename", "default").replace('-', '_'));
            NetletLogMgr.createDefault(((StringBuffer)charSequence).toString());
        }
        GWLocale.createDefault();
        GWThreadPool.init();
    }

    public static void main(String[] stringArray) {
        EProxy.init();
        if (GWLogManager.loggingEnabled) {
            GWLogManager.write("EProxy", GWLocale.getPFString("StartEProxy"));
        }
        GatewayContext gatewayContext = GatewayContextFactory.getGatewayContext();
        boolean bl = gatewayContext.isHttpEnabled();
        boolean bl2 = gatewayContext.isHttpsEnabled();
        if (!bl && !bl2) {
            return;
        }
        int n = gatewayContext.getHttpPort();
        int n2 = gatewayContext.getHttpsPort();
        EProxy.writePortInfoForWatchdog(bl, n, bl2, n2);
        isNetletEnabled = gatewayContext.isEProxyEnabled();
        EProxy.startRProxy(bl, n, bl2, n2);
    }

    private static void startRProxy(boolean bl, int n, boolean bl2, int n2) {
        int n3 = bl && bl2 ? 2 : 1;
        GW.setNumberOfInstances(n3);
        if (bl) {
            RProxyConnection.startHttp(n);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Http is being initialised at port:" + n);
            }
        }
        if (bl2) {
            RProxyConnection.startHttps(n2);
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("Https is being initialised at port:" + n2);
            }
        }
    }

    private static void writePortInfoForWatchdog(boolean bl, int n, boolean bl2, int n2) {
        block5: {
            File file = new File(watchdogInfoFileBase + System.getProperty("conf.suffix"));
            if (file.exists()) {
                file.delete();
            }
            try {
                FileWriter fileWriter = new FileWriter(file);
                if (bl) {
                    fileWriter.write(n + "\n");
                }
                if (bl2) {
                    fileWriter.write(n2 + "\n");
                }
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                if (!GWDebug.debug.errorEnabled()) break block5;
                GWDebug.debug.error("Unable to enter information for watchdog information");
            }
        }
    }
}

