/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.econnection;

import com.sun.portal.netlet.econnection.MessageConstants;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;

public abstract class HeaderMsg
implements MessageConstants {
    protected byte version;
    protected short opCode;
    protected int msgLen;
    protected int seq = 0;
    protected final int HEADER_LEN = 11;
    protected final int MAX_MSG_LEN = 100000;

    public HeaderMsg() {
    }

    public HeaderMsg(byte by, short s) {
        this.version = by;
        this.opCode = s;
    }

    public int readHeader(DataInputStream dataInputStream) {
        this.msgLen = 0;
        try {
            int n;
            do {
                this.version = dataInputStream.readByte();
                this.opCode = dataInputStream.readShort();
                n = dataInputStream.readInt();
                this.msgLen = dataInputStream.readInt();
            } while (this.opCode == 4);
            if (n != this.seq) {
                System.out.println("Netlet HeaderMsg: Unexpected sequence number");
                return -1;
            }
            ++this.seq;
        }
        catch (EOFException eOFException) {
            return -1;
        }
        catch (SocketException socketException) {
            return -1;
        }
        catch (IOException iOException) {
            System.out.println("HeaderMsg: readHeader IOException:" + iOException);
            return -1;
        }
        return 0;
    }

    public void writeHeaderToByteArray(ByteArrayOutputStream byteArrayOutputStream) {
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(this.version);
            dataOutputStream.writeShort(this.opCode);
            dataOutputStream.writeInt(this.seq);
            dataOutputStream.writeInt(this.msgLen);
            ++this.seq;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract int readMsg(DataInputStream var1);

    public abstract int writeMsg(DataOutputStream var1);

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = (byte)n;
    }

    public short getOpCode() {
        return this.opCode;
    }

    public void setOpCode(short s) {
        this.opCode = s;
    }

    public int getMsgLen() {
        return this.msgLen;
    }

    public void setMsgLen(int n) {
        this.msgLen = n;
    }
}

