/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.impl;

import com.sun.portal.common.util.URLEncodeUtils;
import com.sun.portal.portletcontainercommon.PortletContainerRequest;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class PortletURLImpl
implements PortletURL {
    private Map _params;
    private String _action;
    private PortletMode _portletMode;
    private WindowState _windowState;
    private PortletRequest _pReq;
    private PortletContainerRequest _pContReq;

    public PortletURLImpl(PortletRequest pReq, PortletContainerRequest pContReq, String action) {
        this._pReq = pReq;
        this._pContReq = pContReq;
        this._action = action;
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (!this._pReq.isWindowStateAllowed(windowState)) {
            throw new WindowStateException("Invalid setting window state", windowState);
        }
        this._windowState = windowState;
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (!this._pReq.isPortletModeAllowed(portletMode)) {
            throw new PortletModeException("Invalid setting portlet mode", portletMode);
        }
        this._portletMode = portletMode;
    }

    public void setParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("Can not set parameter with null name or value.");
        }
        if (this._params == null) {
            this._params = new HashMap();
        }
        this._params.put(name, value);
    }

    public void setParameter(String name, String[] values) {
        if (name == null || values == null) {
            throw new IllegalArgumentException("Can not set parameter with null name or value.");
        }
        if (this._params == null) {
            this._params = new HashMap();
        }
        this._params.put(name, values);
    }

    public void setParameters(Map parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Can not set parameter with null map object.");
        }
        Iterator i = parameters.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object val = parameters.get(key);
            if (key instanceof String && val instanceof String[]) continue;
            throw new IllegalArgumentException("Parameter keys should be type String and values should be type String[].");
        }
        this._params = parameters;
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        if (secure && !this._pReq.isSecure()) {
            throw new PortletSecurityException("PortletURLImpl.setSecure: the Portal Server is not running on secure mode");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String entityID = this._pContReq.getEntityID();
        String desktopURL = this._pContReq.getDesktopURL();
        buf.append(desktopURL);
        buf.append("&");
        buf.append("javax.portlet.portletc.");
        buf.append("entityID=").append(URLEncoder.encode(entityID));
        buf.append("&");
        buf.append("javax.portlet.portletc.");
        buf.append("portletAction=").append(this._action);
        if (this._windowState != null) {
            buf.append("&");
            buf.append("javax.portlet.portletc.");
            buf.append("windowState=").append(this._windowState);
        }
        if (this._portletMode != null) {
            buf.append("&");
            buf.append("javax.portlet.portletc.");
            buf.append("portletMode=").append(this._portletMode);
        }
        if (this._params != null) {
            Iterator i = this._params.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Object val = this._params.get(key);
                if (URLEncodeUtils.isEncodingNeeded((String)key)) {
                    key = URLEncoder.encode(key);
                }
                if (val instanceof String) {
                    if (URLEncodeUtils.isEncodingNeeded((String)((String)val))) {
                        val = URLEncoder.encode((String)val);
                    }
                    buf.append("&").append(key);
                    buf.append("=").append((String)val);
                    continue;
                }
                if (!(val instanceof String[])) continue;
                String[] vals = (String[])val;
                int j = 0;
                while (j < vals.length) {
                    if (URLEncodeUtils.isEncodingNeeded((String)vals[j])) {
                        vals[j] = URLEncoder.encode(vals[j]);
                    }
                    buf.append("&").append(key);
                    buf.append("=").append(vals[j]);
                    ++j;
                }
            }
        }
        return buf.toString();
    }
}

