/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.cli;

import com.sun.portal.portlet.cli.PortletDeployerLocalizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class PDWarUpdater {
    private File warFile = null;
    private JarFile jar = null;
    private Properties configProps = null;
    private static final String PAE_LOCATION = "PAEJarLocation";
    private static final String TLD_LOCATION = "tldLocation";
    private static final String WEB_INF_PREFIX = "WEB-INF/";
    private static final String WEB_XML = "web.xml";
    private static final String WEB_XML_NAME = "WEB-INF/web.xml";
    private static final String PAE_PREFIX = "WEB-INF/lib/";
    private static final String DD_LOCATION = "DDFileLocation";

    public PDWarUpdater(File warFile, Properties props) throws IOException {
        this.warFile = warFile;
        this.jar = new JarFile(warFile);
        this.configProps = props;
    }

    public JarFile getJarFile() {
        return this.jar;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File getUpdatedWarFile(File webXMLFile) throws IOException {
        String PAEFilename = this.configProps.getProperty(PAE_LOCATION);
        File paeFile = new File(PAEFilename);
        String tldFileName = this.configProps.getProperty(TLD_LOCATION);
        File tldFile = new File(tldFileName);
        String ddLocation = this.configProps.getProperty(DD_LOCATION);
        File tempJarFile = new File(ddLocation, this.warFile.getName() + ".tmp");
        tempJarFile.deleteOnExit();
        boolean jarUpdated = false;
        try {
            Manifest jarManifest = this.jar.getManifest();
            JarOutputStream tempJar = new JarOutputStream(new FileOutputStream(tempJarFile));
            byte[] buffer = new byte[1024];
            try {
                try {
                    int bytesRead;
                    FileInputStream file = new FileInputStream(paeFile);
                    try {
                        JarEntry entry = new JarEntry(PAE_PREFIX + paeFile.getName());
                        tempJar.putNextEntry(entry);
                        while ((bytesRead = file.read(buffer)) != -1) {
                            void var12_15;
                            tempJar.write(buffer, 0, (int)var12_15);
                        }
                        Object var16_16 = null;
                        file.close();
                    }
                    catch (Throwable throwable) {
                        Object var16_17 = null;
                        file.close();
                        throw throwable;
                    }
                    FileInputStream webXMLin = new FileInputStream(webXMLFile);
                    try {
                        JarEntry entry = new JarEntry(WEB_XML_NAME);
                        tempJar.putNextEntry(entry);
                        while ((bytesRead = webXMLin.read(buffer)) != -1) {
                            tempJar.write(buffer, 0, bytesRead);
                        }
                        Object var18_20 = null;
                        webXMLin.close();
                    }
                    catch (Throwable throwable) {
                        Object var18_21 = null;
                        webXMLin.close();
                        throw throwable;
                    }
                    FileInputStream tldin = new FileInputStream(tldFile);
                    try {
                        JarEntry entry = new JarEntry(WEB_INF_PREFIX + tldFile.getName());
                        tempJar.putNextEntry(entry);
                        while ((bytesRead = tldin.read(buffer)) != -1) {
                            tempJar.write(buffer, 0, bytesRead);
                        }
                        Object var20_24 = null;
                        tldin.close();
                    }
                    catch (Throwable throwable) {
                        Object var20_25 = null;
                        tldin.close();
                        throw throwable;
                    }
                    Enumeration<JarEntry> entries = this.jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (entry.getName().equals(WEB_XML_NAME) || entry.getName().equals(PAE_PREFIX + paeFile.getName()) || entry.getName().equals(WEB_INF_PREFIX + tldFile.getName())) continue;
                        InputStream entryStream = this.jar.getInputStream(entry);
                        tempJar.putNextEntry(entry);
                        while ((bytesRead = entryStream.read(buffer)) != -1) {
                            tempJar.write(buffer, 0, bytesRead);
                        }
                    }
                    jarUpdated = true;
                }
                catch (Exception ex) {
                    PortletDeployerLocalizer.error(ex.toString());
                    tempJar.putNextEntry(new JarEntry("stub"));
                    Object var22_28 = null;
                    tempJar.close();
                }
                Object var22_27 = null;
                tempJar.close();
            }
            catch (Throwable throwable) {
                Object var22_29 = null;
                tempJar.close();
                throw throwable;
            }
            Object var24_31 = null;
            this.jar.close();
            if (!jarUpdated) {
                tempJarFile.delete();
            }
        }
        catch (Throwable throwable) {
            Object var24_32 = null;
            this.jar.close();
            if (!jarUpdated) {
                tempJarFile.delete();
            }
            throw throwable;
        }
        if (jarUpdated) {
            return tempJarFile;
        }
        return null;
    }
}

