/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.client;

import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.client.CDCacheEntry;
import com.sun.portal.rproxy.configservlet.client.SrapClient;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.SystemProperties;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ClientDetector
implements Runnable {
    private static ClientDetector cd = new ClientDetector();
    private HashMap table = new HashMap();
    private static final String CDM_GET_CLIENT_PROPERTY = "CDM_GET_CLIENT_PROPERTY";
    private static int CACHE_SLEEP_TIME;
    private static int CLEANUP_TIME;

    private ClientDetector() {
    }

    public static String isCookieSupported(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("User-Agent");
        if (string == null) {
            return "autodetect";
        }
        string = string.substring(string.indexOf(":") + 1).trim();
        return cd.isCookieSupportedImpl(string);
    }

    private String isCookieSupportedImpl(String string) {
        CDCacheEntry cDCacheEntry = this.retrieveValue(string);
        if (cDCacheEntry == null) {
            cDCacheEntry = this.fetchCookieSupport(string);
        }
        return cDCacheEntry.toString();
    }

    private CDCacheEntry fetchCookieSupport(String string) {
        String string2;
        Response response;
        CDCacheEntry cDCacheEntry = null;
        Request request = new Request(null, null, CDM_GET_CLIENT_PROPERTY, string);
        try {
            response = SrapClient.execute(request);
        }
        catch (Exception exception) {
            response = null;
        }
        if (response != null && (string2 = response.getReturnedObject().toString()) != null) {
            cDCacheEntry = new CDCacheEntry(string2);
            this.storeValue(string, cDCacheEntry);
        }
        return cDCacheEntry;
    }

    private synchronized void storeValue(Object object, Object object2) {
        this.table.put(object, object2);
    }

    private synchronized CDCacheEntry retrieveValue(Object object) {
        return (CDCacheEntry)this.table.get(object);
    }

    public void run() {
        boolean bl = false;
        while (!bl) {
            try {
                block5: {
                    try {
                        Thread.currentThread();
                        Thread.sleep(CACHE_SLEEP_TIME);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!GWDebug.debug.messageEnabled()) break block5;
                        GWDebug.debug.message("Exception in ClientDetector cache cleaner thread ", interruptedException);
                    }
                }
                this.cleanupCache();
            }
            catch (Throwable throwable) {
                if (!GWDebug.debug.messageEnabled()) continue;
                GWDebug.debug.message("Throwable thrown in ClientDetector cache cleaner thread ", throwable);
            }
        }
    }

    private synchronized void cleanupCache() {
        Set set = this.table.keySet();
        Iterator iterator = set.iterator();
        long l = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            CDCacheEntry cDCacheEntry = (CDCacheEntry)this.table.get(k);
            if (l - cDCacheEntry.getTimestamp() <= (long)CLEANUP_TIME) continue;
            iterator.remove();
        }
    }

    static {
        new Thread(cd).start();
        try {
            CACHE_SLEEP_TIME = Integer.parseInt(SystemProperties.get("gateway.cdm.cacheSleepTime", "60000"));
        }
        catch (Exception exception) {
            CACHE_SLEEP_TIME = 60000;
        }
        try {
            CLEANUP_TIME = Integer.parseInt(SystemProperties.get("gateway.cdm.cacheCleanupTime", "300000"));
        }
        catch (Exception exception) {
            CLEANUP_TIME = 300000;
        }
    }
}

