/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.AddRootCA;
import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminException;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.CertContext;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.CreateSelfSignedCertificate;
import com.sun.portal.cli.cert.DeleteCertificate;
import com.sun.portal.cli.cert.Exit;
import com.sun.portal.cli.cert.GenerateCSR;
import com.sun.portal.cli.cert.InstallCertificate;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSContextImpl;
import com.sun.portal.cli.cert.ListCACertificates;
import com.sun.portal.cli.cert.ListCertificates;
import com.sun.portal.cli.cert.ModifyTrustAttributes;
import com.sun.portal.cli.cert.PasswordContext;
import com.sun.portal.cli.cert.PasswordContextImpl;
import com.sun.portal.cli.cert.PrintCertificate;
import com.sun.portal.cli.cert.SystemProperties;

public class CertAdminFactory {
    public static PasswordContext CreatePasswordContext() {
        return new PasswordContextImpl();
    }

    public static JSSContext CreateJSSContext(String string, String string2, String string3) throws CertAdminException {
        String string4 = string2 + CertAdminConstants.SEPERATOR + "platform.conf" + "." + string;
        if (!CertAdminUtil.fileExist(string4)) {
            throw new CertAdminException(CertAdminLocale.getPFString("m2", "Error!, Cannot locate Platform file"));
        }
        SystemProperties.init(string4);
        String string5 = SystemProperties.get("gateway.certdir");
        String string6 = SystemProperties.get("gateway.host");
        String string7 = string3 + CertAdminConstants.SEPERATOR + "AMConfig.properties";
        if (!CertAdminUtil.fileExist(string7)) {
            throw new CertAdminException(CertAdminLocale.getPFString("m51", "Error!, Cannot locate the idsame property file"));
        }
        SystemProperties.init(string7);
        String string8 = SystemProperties.get("com.iplanet.am.locale", "en_US");
        JSSContextImpl jSSContextImpl = new JSSContextImpl(string5, string6, string8);
        jSSContextImpl.setPasswordContext(CertAdminFactory.CreatePasswordContext());
        if (!jSSContextImpl.init()) {
            throw new CertAdminException(CertAdminLocale.getPFString("m1", "Error!, Initialization failed"));
        }
        return jSSContextImpl;
    }

    public static CertContext CreateCertificateContext(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n) {
        CertContext certContext = new CertContext();
        certContext.fqdn = string;
        certContext.o = string2;
        certContext.ou = string3;
        certContext.l = string4;
        certContext.s = string5;
        certContext.c = string6;
        certContext.token = string7;
        certContext.nick = string8;
        certContext.val = n;
        return certContext;
    }

    public static Command CreateCommand(int n) {
        switch (n) {
            case 1: {
                return new CreateSelfSignedCertificate();
            }
            case 2: {
                return new GenerateCSR();
            }
            case 3: {
                return new AddRootCA();
            }
            case 4: {
                return new InstallCertificate();
            }
            case 5: {
                return new DeleteCertificate();
            }
            case 6: {
                return new ModifyTrustAttributes();
            }
            case 7: {
                return new ListCACertificates();
            }
            case 8: {
                return new ListCertificates();
            }
            case 9: {
                return new PrintCertificate();
            }
        }
        return new Exit();
    }
}

