/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminHelpText;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import java.io.File;
import org.mozilla.jss.crypto.X509Certificate;

public class AddRootCA
implements Command {
    private JSSContext cntx;

    public boolean execute(JSSContext jSSContext) {
        this.cntx = jSSContext;
        CertAdminUtil.println(CertAdminHelpText.getDNHelpText());
        String string = CertAdminUtil.question(CertAdminLocale.getPFString("q14", "What is the name (including path) of file that contains the root") + CertAdminConstants.newline + CertAdminLocale.getPFString("q141", "certificate that you would like to add to your database ?"));
        File file = new File(string);
        if (!file.exists()) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m23", "Certificate file") + " " + string + " " + CertAdminLocale.getPFString("m231", "doesn't exist!"));
            return false;
        }
        try {
            X509Certificate x509Certificate = this.addCACertificate(file);
            String string2 = x509Certificate.getNickname();
            X509Certificate x509Certificate2 = JSSUtil.changeCertificateTrust(x509Certificate, "CT", "CT", "c");
            jSSContext.getCryptoManager().importCertToPerm(x509Certificate2, string2);
            CertAdminUtil.println(CertAdminConstants.newline);
            CertAdminUtil.println(CertAdminLocale.getPFString("m24", "Certificate file"));
            return true;
        }
        catch (Exception exception) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m25", "Added the Root CA certificate successfully"));
            exception.printStackTrace();
            return false;
        }
    }

    private X509Certificate addCACertificate(File file) throws Exception {
        return JSSUtil.addCertificate(this.cntx, file, null, true);
    }
}

