/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPObject;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class XMLDPProperty
extends XMLDPObject
implements DPProperty,
XMLDPTags,
Map.Entry {
    static long ccount = 0L;
    private Element propertiesElement = null;

    XMLDPProperty(DPContext dpc, DPRoot r, Element e) {
        super(dpc, r, e);
        if (this.isPerfMessageEnabled()) {
            this.perfMessage("XMLDPProperty.XMLDPProperty(): ccount=" + ++ccount);
        }
    }

    public void setPropagate(boolean state) {
        XMLDPProperty.setPropagateElement(this.getElement(), state);
    }

    Element getPropertiesElement() {
        if (this.propertiesElement == null) {
            this.propertiesElement = XMLDPProperty.getPropertiesElement(this.getElement());
        }
        return this.propertiesElement;
    }

    static Element getPropertiesElement(Element e) {
        if (e.getTagName().equals("Properties")) {
            return e;
        }
        Node n = e.getParentNode();
        if (n == null) {
            throw new DPError("XMLDPProperty.getPropertiesElement(): parent node was null");
        }
        e = (Element)n;
        return XMLDPProperty.getPropertiesElement(e);
    }

    protected DPProperties getPropertiesFromThis() {
        Element e = this.getPropertiesElement();
        DPProperties dpp = (DPProperties)this.getObject(e);
        if (dpp == null) {
            dpp = XMLDPFactory.getInstance().getProperties(this.getContext(), this.getRoot(), e);
            this.putObject(dpp);
        }
        return dpp;
    }

    public DPProperties getProperties() {
        DPProperties dpProperties = this.getPropertiesFromThis();
        if (dpProperties == null || !dpProperties.isMerged()) {
            Iterator i = this.getMergers().iterator();
            while (i.hasNext()) {
                DPProperty dpp = (DPProperty)i.next();
                DPProperties dppp = ((XMLDPProperty)dpp).getPropertiesFromThis();
                dpProperties.addMerger(dppp);
            }
        }
        return dpProperties;
    }

    static void setPropagateElement(Element e, boolean state) {
        String s = null;
        s = state ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        e.setAttribute("propagate", s);
    }

    public boolean isPropagate() {
        if (!this.isDummy() && this.isThisPropagate()) {
            return true;
        }
        Iterator i = this.getMergers().iterator();
        while (i.hasNext()) {
            DPProperty mergerDPP = (DPProperty)i.next();
            if (!((XMLDPProperty)mergerDPP).isThisPropagate()) continue;
            return true;
        }
        return false;
    }

    public boolean isThisPropagate() {
        Element e = this.getElement();
        if (!XMLDPProperty.isPropagateElement(e)) {
            return false;
        }
        if (e.getTagName().equals("Properties")) {
            return true;
        }
        Node parentNode = e.getParentNode();
        if (parentNode.getNodeType() != 1) {
            throw new DPError("XMLDPProperty.isPropagate(): property's parent was not an element");
        }
        Element parentElement = (Element)parentNode;
        return XMLDPProperty.isPropagateElement(parentElement);
    }

    public static boolean isPropagateElement(Element e) {
        String p = e.getAttribute("propagate");
        if (p == null || p.length() == 0) {
            return XMLDPObject.staticGetDefaultPropagateValue();
        }
        boolean propagate = Boolean.valueOf(p);
        return propagate;
    }

    public DPProperty copy(DPRoot dpr, boolean deep) {
        Element elementCopy = this.copyElement(dpr, deep);
        return XMLDPFactory.getInstance().getProperty(this.getContext(), dpr, elementCopy);
    }

    Element copyElement(DPRoot dpr, boolean deep) {
        XMLDPRoot xmldpr = (XMLDPRoot)dpr;
        Document ownerDocument = xmldpr.getElement().getOwnerDocument();
        Element elementCopy = (Element)ownerDocument.importNode(this.getElement(), deep);
        return elementCopy;
    }

    public DPProperty createDummy(DPRoot dpr) {
        DPProperty dpp = this.copy(dpr, false);
        dpp.setDummy(true);
        dpp.setDefaults();
        return dpp;
    }

    public boolean isNamed() {
        return this.getElement().hasAttribute("name");
    }

    public Object getKey() {
        return this.getName();
    }

    public void appendPropagateAttr(StringBuffer b) {
        if (XMLDPProperty.isPropagateElement(this.getElement()) != this.getDefaultPropagateValue()) {
            b.append(" propagate=\"").append(this.isThisPropagate()).append("\"");
        }
    }

    public abstract Object setValue(Object var1);

    public abstract Object getValue();
}

