/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.InputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;

public class PluginProxyInfo
implements ActionListener,
ItemListener {
    public static final int UNSUPPORTED = 0;
    public static final int VER2 = 2;
    public static final int VER3 = 3;
    public static final int VER4 = 4;
    private int pluginVersion = 0;
    public static final int DIRECT = 0;
    public static final int MANUAL = 1;
    public static final int AUTO = 2;
    public static final int BROWSER = 3;
    private int proxyType = 0;
    private String proxySSL = "";
    private int proxySSLPort = 0;
    private Vector noProxiesFor = new Vector();
    private static ProxyInfoDialog pid = null;
    private static ProxyInfoHelpDialog pihd = null;
    private String destHost = null;
    private int destPort = 0;

    public PluginProxyInfo(SServer sServer, SClientMgr sClientMgr) {
        this.readGWHostAndPort(sServer);
        this.readVMVersion();
        this.readProxyType();
        if (this.proxyType == 3) {
            this.useNetletProfile(sServer, sClientMgr);
        } else if (this.proxyType == 2) {
            this.parsePACFileURL(System.getProperty("javaplugin.proxy.auto.url"));
            if (!this.isProxySettingsValid(sClientMgr)) {
                this.useNetletProfile(sServer, sClientMgr);
            }
        } else if (this.proxyType == 1) {
            this.extractSSLProxyHostAndPort(System.getProperty("javaplugin.proxy.config.list"));
            this.parseProxyOverrideList(System.getProperty("javaplugin.proxy.config.bypass"));
            System.out.println("Proxy override - " + this.noProxiesFor.toString());
        }
    }

    private void readGWHostAndPort(SServer sServer) {
        this.destHost = sServer.getGWHost();
        this.destPort = sServer.getGWPort();
    }

    private void readVMVersion() {
        String string = System.getProperty("java.version");
        System.out.println("Java version : " + string);
        this.pluginVersion = string == null || string.trim().length() == 0 ? 0 : (string.startsWith("1.4") ? 4 : (string.startsWith("1.3") ? 3 : (string.startsWith("1.2") ? 2 : 0)));
    }

    private void readProxyType() {
        String string = System.getProperty("javaplugin.proxy.config.type");
        System.out.println("Proxy type : " + string);
        this.proxyType = string.equalsIgnoreCase("direct") ? 0 : (string.equalsIgnoreCase("manual") ? 1 : (string.equalsIgnoreCase("browser") ? 3 : 2));
    }

    private void readNetletProfile(SServer sServer) {
        String string = sServer.getParameter("proxytype");
        this.proxyType = string != null && string.equalsIgnoreCase("DIRECT") ? 0 : 1;
        string = sServer.getParameter("proxyhost");
        if (string != null && string.trim().length() != 0) {
            this.proxySSL = string;
        }
        if ((string = sServer.getParameter("proxyport")) != null && string.trim().length() != 0) {
            try {
                this.proxySSLPort = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.proxySSLPort = 0;
            }
        }
    }

    private void storeProxySettings(SServer sServer) {
        String string = "&proxytype=";
        string = this.proxyType == 0 ? string + "DIRECT" : string + "MANUAL";
        string = string + "&proxyhost=" + this.proxySSL;
        string = string + "&proxyport=" + this.proxySSLPort;
        String string2 = this.noProxiesFor.toString();
        string2 = string2.substring(string2.indexOf("[") + 1, string2.indexOf("]")).trim();
        string = string + "&proxyoverride=" + string2;
        InputStream inputStream = sServer.sendByPost("storeProxySettings", string);
    }

    private void useNetletProfile(SServer sServer, SClientMgr sClientMgr) {
        this.readNetletProfile(sServer);
        boolean bl = this.isProxySettingsValid(sClientMgr);
        if (!bl) {
            pid = new ProxyInfoDialog(new JFrame(), this, this);
            pid.showWarning();
            pid.waitForAction();
            bl = this.isProxySettingsValid(sClientMgr);
            if (bl) {
                this.storeProxySettings(sServer);
            }
        } else {
            this.parseProxyOverrideList(sServer.getParameter("proxyoverride"));
        }
    }

    private void extractSSLProxyHostAndPort(String string) {
        if (this.proxyType == 0 || string == null || string.trim().length() == 0) {
            return;
        }
        String string2 = null;
        try {
            if (string.indexOf("https") == -1) {
                this.proxySSL = string.substring(0, string.indexOf(58)).trim();
                string2 = string.substring(string.indexOf(58) + 1).trim();
                this.proxySSLPort = Integer.parseInt(string2);
            } else {
                String string3 = string.substring(string.indexOf("https") + 6).trim();
                if (string3.indexOf(",") != -1) {
                    string3 = string3.substring(0, string3.indexOf(","));
                }
                this.proxySSL = string3.substring(0, string3.indexOf(58)).trim();
                string2 = string3.substring(string3.indexOf(58) + 1).trim();
                this.proxySSLPort = Integer.parseInt(string2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println("Exception when reading proxy information from plugin - " + indexOutOfBoundsException);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Exception when reading proxy information from plugin - " + numberFormatException);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Exception when reading proxy information from plugin - " + nullPointerException);
        }
    }

    private void parseProxyOverrideList(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase().trim();
            if (string2.trim().length() == 0) continue;
            this.noProxiesFor.addElement(string2);
        }
    }

    public String getProxySSL() {
        return this.proxySSL;
    }

    public int getProxySSLPort() {
        return this.proxySSLPort;
    }

    public boolean getProxyMode() {
        return this.proxyType != 0;
    }

    private boolean isProxySettingsValid(SClientMgr sClientMgr) {
        Connection connection = null;
        if (this.proxyType == 1) {
            try {
                connection = new ProxySConn(this.proxySSLPort, this.proxySSL, this.destPort, this.destHost, sClientMgr, null);
            }
            catch (ProxyAuthNeededException proxyAuthNeededException) {
                try {
                    connection = new ProxySConn(this.proxySSLPort, this.proxySSL, this.destPort, this.destHost, sClientMgr, true, null);
                }
                catch (ProxyAuthNeededException proxyAuthNeededException2) {
                    System.out.println("Invalid proxy information");
                }
                catch (ProxyAuthFailedException proxyAuthFailedException) {
                    System.out.println("Invalid proxy information");
                }
            }
            catch (ProxyAuthFailedException proxyAuthFailedException) {
                System.out.println("Invalid proxy information");
            }
        } else if (this.proxyType == 0) {
            connection = new ProxySConn(this.destPort, this.destHost, null);
        } else {
            return false;
        }
        Socket socket = connection.getconn();
        return socket != null;
    }

    private void parsePACFileURL(String string) {
        if (string == null || string.trim().length() == 0) {
            this.proxyType = 0;
            return;
        }
        String string2 = BrowserProxyInfo.parsePACFile(string);
        if (string2 == null || string2.trim().length() == 0 || string2.equals("null")) {
            this.proxyType = 0;
            return;
        }
        if (string2.equalsIgnoreCase("DIRECT")) {
            this.proxyType = 0;
            return;
        }
        if (string2.startsWith("PROXY")) {
            this.proxyType = 1;
            if (string2.length() > 5) {
                String string3 = string2.substring(5);
                int n = string3.indexOf(";");
                if (n < 0) {
                    n = string3.length();
                }
                String string4 = string3.substring(0, n);
                int n2 = string4.lastIndexOf(":");
                String string5 = string4.substring(n2 + 1);
                String string6 = string4.substring(0, n2);
                this.proxySSL = string6.trim();
                try {
                    this.proxySSLPort = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid SSL Proxy port");
                    this.proxySSLPort = 0;
                }
            }
        }
    }

    public boolean inNoProxiesFor(String string) {
        Enumeration enumeration = this.noProxiesFor.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.toLowerCase().endsWith(string2.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if ("OK".equals(actionEvent.getActionCommand())) {
            if (object == PluginProxyInfo.pid.ok) {
                ((Component)pid).setVisible(false);
                if (PluginProxyInfo.pid.direct.isSelected()) {
                    this.proxyType = 0;
                } else if (PluginProxyInfo.pid.manual.isSelected()) {
                    this.proxyType = 1;
                    this.proxySSL = PluginProxyInfo.pid.proxyHost.getText();
                    try {
                        this.proxySSLPort = Integer.parseInt(PluginProxyInfo.pid.proxyPort.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.proxySSLPort = 0;
                        System.out.println("Invalid SSL proxy host: " + numberFormatException);
                    }
                    this.parseProxyOverrideList(PluginProxyInfo.pid.noProxy.getText());
                } else if (PluginProxyInfo.pid.auto.isSelected()) {
                    this.parsePACFileURL(PluginProxyInfo.pid.autoURL.getText());
                }
                if (pihd != null) {
                    ((Component)pihd).setVisible(false);
                    pihd = null;
                }
                pid.notifyAction();
            }
        } else if ("Cancel".equals(actionEvent.getActionCommand())) {
            if (object == PluginProxyInfo.pid.cancel) {
                ((Component)pid).setVisible(false);
                if (pihd != null) {
                    ((Component)pihd).setVisible(false);
                    pihd = null;
                }
                pid.notifyAction();
            }
        } else if ("Help".equals(actionEvent.getActionCommand()) && object == PluginProxyInfo.pid.help) {
            if (pihd == null) {
                pihd = new ProxyInfoHelpDialog(new JFrame());
            }
            pihd.show();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (PluginProxyInfo.pid.direct.isSelected()) {
            pid.setState(0);
        } else if (PluginProxyInfo.pid.manual.isSelected()) {
            pid.setState(1);
        } else if (PluginProxyInfo.pid.auto.isSelected()) {
            pid.setState(2);
        }
    }
}

