/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchangewebdav.util.xml;

import com.aligo.pim.exchangewebdav.util.xml.AmlDefaultStringTokenizer;
import com.aligo.pim.exchangewebdav.util.xml.HtmlNode;
import java.io.File;
import java.io.FileInputStream;

public class HtmlParser {
    public String parse(String html) {
        HtmlNode parentNode = new HtmlNode();
        boolean done = false;
        String str = html;
        while (!done) {
            parentNode = new HtmlNode();
            int index = this.parse(parentNode, str, 0);
            int length = str.length();
            if (++index < length) {
                int seekIndex = this.seek(str, index);
                if (index != seekIndex) {
                    String firstPart = str.substring(0, index);
                    String secondPart = str.substring(seekIndex);
                    str = firstPart + secondPart;
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        return parentNode.print();
    }

    private int parse(HtmlNode parentNode, String htmlSegment, int sIndex) {
        int index;
        StringBuffer name = new StringBuffer("");
        StringBuffer cname = new StringBuffer("");
        StringBuffer text = new StringBuffer("");
        StringBuffer attrName = new StringBuffer("");
        StringBuffer attrValue = new StringBuffer("");
        HtmlNode node = new HtmlNode();
        boolean end = false;
        boolean beginTag = false;
        boolean beginTagName = false;
        boolean beginTagDesc = false;
        boolean closeTag = false;
        boolean beginAttrName = false;
        boolean beginAttrValue = false;
        boolean comment = false;
        boolean preBeginAttr = false;
        boolean quoteAttr = false;
        boolean beginContents = false;
        int rindex = index = sIndex;
        int cindex = index - 1;
        int length = htmlSegment.length();
        int beginIndex = -1;
        char quoteChar = '\uffff';
        while (index < length && !end) {
            int startIndex;
            int commentIndex;
            char c = htmlSegment.charAt(index);
            int nc = 65535;
            int nextIndex = index + 1;
            if (nextIndex < length) {
                nc = htmlSegment.charAt(nextIndex);
            }
            boolean handled = false;
            if (c == '<') {
                if (nc == 47) {
                    closeTag = true;
                    cindex = index - 1;
                }
                if (!beginTag) {
                    beginIndex = index;
                    beginTagName = true;
                    beginTagDesc = true;
                    beginTag = true;
                } else {
                    HtmlNode textNode = new HtmlNode();
                    textNode.setText(text.toString());
                    node.addNode(textNode);
                    text = new StringBuffer("");
                    if (!closeTag) {
                        index = this.parse(node, htmlSegment, index);
                    }
                }
                handled = true;
            }
            if (beginTagName && !handled && c == '!' && (commentIndex = htmlSegment.indexOf("<!", startIndex = index - 1)) != -1 && commentIndex == startIndex) {
                comment = true;
                handled = true;
            }
            if (beginTagName && !comment && !handled && this.isCloser(c) && !beginAttrValue) {
                beginTagName = false;
                beginAttrName = true;
                node.setName(name.toString().toLowerCase());
                if (this.invisibleTag(name.toString())) {
                    node.setVisible(false);
                    parentNode.addNode(node);
                } else if (!this.ignoreTag(name.toString())) {
                    parentNode.addNode(node);
                }
                if (c != '/') {
                    handled = true;
                }
            }
            if (beginTagDesc && !comment && !handled && this.isAttrNameDelimiter(c) && beginAttrName && !beginAttrValue) {
                beginAttrName = false;
                if (c == '=') {
                    preBeginAttr = true;
                    handled = true;
                }
            }
            if (beginTagDesc && !comment && !handled) {
                boolean closeAttr = false;
                if (beginAttrValue && this.isCloser(c) && !quoteAttr) {
                    if (c == '/') {
                        if (!this.isUrl(name.toString(), attrName.toString(), attrValue.toString()) && nc == 62) {
                            closeAttr = true;
                        }
                    } else {
                        closeAttr = true;
                    }
                }
                boolean attrDelimiter = false;
                if (this.isAttrValueDelimiter(c)) {
                    if (!quoteAttr) {
                        attrDelimiter = true;
                    } else if (c == quoteChar) {
                        attrDelimiter = true;
                    }
                }
                if (attrDelimiter || preBeginAttr || closeAttr) {
                    if (!beginAttrValue) {
                        beginAttrValue = true;
                        if (attrDelimiter) {
                            quoteAttr = true;
                            quoteChar = c;
                            handled = true;
                        }
                    } else {
                        beginAttrValue = false;
                        quoteAttr = false;
                        quoteChar = '\uffff';
                        this.addAttribute(node, attrName.toString().toLowerCase(), attrValue.toString().toLowerCase());
                        attrValue = new StringBuffer("");
                        attrName = new StringBuffer("");
                        if (!this.isCloser(c)) {
                            handled = true;
                        }
                    }
                    preBeginAttr = false;
                }
            }
            if (c == '>') {
                boolean closeComment = false;
                if (comment) {
                    int startIndex2 = index - 1;
                    int commentIndex2 = htmlSegment.indexOf("!>", startIndex2);
                    if (commentIndex2 != -1 && commentIndex2 == startIndex2) {
                        closeComment = true;
                    }
                    if (!closeComment && this.matchBraces(htmlSegment, beginIndex, index)) {
                        closeComment = true;
                    }
                }
                if (beginTagDesc || closeComment) {
                    beginAttrName = false;
                    beginAttrValue = false;
                    beginTagName = false;
                    beginTagDesc = false;
                    beginContents = true;
                    handled = true;
                }
                if (closeComment) {
                    beginTag = false;
                    comment = false;
                }
                if (closeTag) {
                    closeTag = false;
                    beginIndex = -1;
                    beginTag = false;
                    beginContents = false;
                    if (name.toString().toLowerCase().equals(cname.toString().toLowerCase())) {
                        node.setEnd(true);
                        rindex = index;
                        end = true;
                    } else {
                        if (this.shouldEnd(name.toString(), cname.toString())) {
                            node.setEnd(true);
                        }
                        rindex = cindex;
                        end = true;
                    }
                    handled = true;
                }
            }
            if (closeTag && !comment && !handled) {
                if (c != '/') {
                    cname.append(c);
                }
                handled = true;
            }
            if (beginTagDesc && !comment && !handled && c == '/' && !beginAttrValue) {
                cname = name;
                comment = true;
                closeTag = true;
                handled = true;
            }
            if (beginTagDesc && !comment && !handled && this.isAttrNameOpener(c) && !beginAttrValue) {
                beginAttrName = true;
                handled = true;
            }
            if (beginTagDesc && !comment && !handled) {
                if (beginTagName) {
                    name.append(c);
                } else if (beginAttrName) {
                    attrName.append(c);
                } else if (beginAttrValue) {
                    attrValue.append(this.encodeAttr(htmlSegment, index));
                }
                handled = true;
            }
            if (beginContents && !comment && !handled) {
                text.append(this.encodeText(htmlSegment, index));
            }
            ++index;
        }
        if (!end) {
            beginTag = false;
            rindex = index;
        }
        return rindex;
    }

    private boolean isCloser(char c) {
        boolean closer = false;
        if (c == ' ' || c == '/' || c == '>' || c == '\r' || c == '\n') {
            closer = true;
        }
        return closer;
    }

    private boolean isAttrNameOpener(char c) {
        boolean opener = false;
        if (c == ' ' || c == '\r' || c == '\n') {
            opener = true;
        }
        return opener;
    }

    private boolean isAttrNameDelimiter(char c) {
        boolean delimiter = false;
        if (c == '=' || c == '\"') {
            delimiter = true;
        }
        return delimiter;
    }

    private boolean isAttrValueDelimiter(char c) {
        boolean delimiter = false;
        if (c == '\"' || c == '\'') {
            delimiter = true;
        }
        return delimiter;
    }

    private int seek(String html, int index) {
        int rIndex = index;
        int length = html.length();
        boolean done = false;
        boolean wrong = false;
        boolean first = true;
        boolean second = false;
        boolean inQuotes = false;
        while (!done && !wrong && index < length) {
            char c = html.charAt(index);
            if (second) {
                if (c != '/') {
                    wrong = true;
                }
                second = false;
            } else if (first) {
                if (c != '<') {
                    wrong = true;
                }
                first = false;
                second = true;
            }
            if (!inQuotes && c == '>') {
                done = true;
            }
            if (c == '\"') {
                inQuotes = !inQuotes;
            }
            ++index;
        }
        if (!wrong) {
            rIndex = index;
        }
        return rIndex;
    }

    private String encodeAttr(String stream, int index) {
        char c = stream.charAt(index);
        StringBuffer str = new StringBuffer("");
        if (c == '&') {
            str.append("&amp;");
        } else {
            str.append(c);
        }
        return str.toString();
    }

    private String encodeText(String stream, int index) {
        char c = stream.charAt(index);
        StringBuffer str = new StringBuffer("");
        if (c == '&') {
            boolean encode = true;
            int seindex = stream.indexOf(59, index);
            if (seindex != -1) {
                int sindex = stream.indexOf(32, index);
                if (sindex != -1) {
                    if (seindex < sindex) {
                        encode = false;
                    }
                } else {
                    encode = false;
                }
            }
            if (encode) {
                str.append("&amp;");
            } else {
                str.append(c);
            }
        } else {
            str.append(c);
        }
        return str.toString();
    }

    private boolean invisibleTag(String name) {
        boolean invisible = false;
        String uname = name.toUpperCase();
        if (uname.equals("META")) {
            invisible = true;
        }
        return invisible;
    }

    private boolean ignoreTag(String name) {
        boolean ignore = false;
        String uname = name.toUpperCase();
        if (uname.equals("SCRIPT") || uname.equals("STYLE")) {
            ignore = true;
        }
        return ignore;
    }

    private String replace(String source, String oldStr, String newStr) {
        StringBuffer result = null;
        if (source != null) {
            result = new StringBuffer("");
            AmlDefaultStringTokenizer st = new AmlDefaultStringTokenizer(source, oldStr);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                result.append(token);
                if (!st.hasMoreTokens()) continue;
                result.append(newStr);
            }
        }
        return result != null ? result.toString() : null;
    }

    private boolean isUrl(String name, String attrName, String attrValue) {
        boolean url = false;
        if (attrValue.indexOf("://") != -1) {
            url = true;
        } else {
            String lname = name.toLowerCase();
            String lAttrName = attrName.toLowerCase();
            if (lname.equals("a") && lAttrName.equals("href")) {
                url = true;
            } else if (lname.equals("img") && lAttrName.equals("src")) {
                url = true;
            } else if (lname.equals("form") && lAttrName.equals("action")) {
                url = true;
            }
        }
        return url;
    }

    private boolean shouldEnd(String name, String cname) {
        boolean end = false;
        String lName = name.toLowerCase();
        String lcName = cname.toLowerCase();
        if (lName.equals("td")) {
            if (lcName.equals("tr") || lcName.equals("tbody") || lcName.equals("table")) {
                end = true;
            }
        } else if (lName.equals("tr")) {
            if (lcName.equals("tbody") || lcName.equals("table")) {
                end = true;
            }
        } else if (lName.equals("tbody") && lcName.equals("table")) {
            end = true;
        }
        return end;
    }

    private void addAttribute(HtmlNode node, String attrName, String attrValue) {
        if (!attrName.startsWith("on")) {
            node.addAttribute(attrName, attrValue);
        }
    }

    private char getChar(String stream, int index) {
        char c = '\uffff';
        int length = stream.length();
        if (index >= 0 && index < length) {
            c = stream.charAt(index);
        }
        return c;
    }

    private boolean matchBraces(String stream, int startIndex, int endIndex) {
        boolean match = true;
        if (startIndex != -1) {
            int count = 0;
            int length = stream.length();
            int maxIndex = length - 1;
            if (endIndex > maxIndex) {
                endIndex = maxIndex;
            }
            int i = startIndex;
            while (i <= endIndex) {
                char c = this.getChar(stream, i);
                if (c == '<') {
                    ++count;
                } else if (c == '>') {
                    --count;
                }
                ++i;
            }
            if (count != 0) {
                match = false;
            }
        }
        return match;
    }

    public static void main(String[] args) {
        try {
            File f = new File("test.html");
            long length = f.length();
            FileInputStream fi = new FileInputStream(f);
            byte[] b = new byte[(int)length];
            fi.read(b);
            System.out.println(new HtmlParser().parse(new String(b)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

