/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange.outlook;

import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.outlook.OutlookPimAppointmentItem;
import com.aligo.pim.exchange.outlook.OutlookPimItem;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimReminderItem;
import outlook._AppointmentItem;

public class OutlookPimReminderItem
extends OutlookPimItem
implements PimReminderItem {
    long lNoOfMinutesBeforeStart = 0L;
    OutlookPimAppointmentItem m_oPimAppointmentItem;

    public OutlookPimReminderItem(OutlookPimAppointmentItem pimAppointmentItem) throws ExchangePimException {
        try {
            this.m_oPimAppointmentItem = pimAppointmentItem;
            _AppointmentItem _oAppointmentItem = pimAppointmentItem.getOutlookAppointmentItem();
            if (_oAppointmentItem.isReminderSet()) {
                this.lNoOfMinutesBeforeStart = _oAppointmentItem.getReminderMinutesBeforeStart();
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    private _AppointmentItem getOutlookAppointmentItem() {
        return this.m_oPimAppointmentItem.getOutlookAppointmentItem();
    }

    public void setNoOfMinutesBeforeStart(long noOfMinutes) throws ExchangePimException {
        try {
            if (noOfMinutes < 0L) {
                return;
            }
            this.lNoOfMinutesBeforeStart = noOfMinutes;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public long getNoOfMinutesBeforeStart() throws ExchangePimException {
        try {
            if (this.lNoOfMinutesBeforeStart < 0L) {
                this.lNoOfMinutesBeforeStart = 0L;
            }
            return this.lNoOfMinutesBeforeStart;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void update() throws ExchangePimException {
        try {
            this.getOutlookAppointmentItem().setReminderMinutesBeforeStart((int)this.getNoOfMinutesBeforeStart());
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete() throws ExchangePimException {
        try {
            this.lNoOfMinutesBeforeStart = 0L;
            this.getOutlookAppointmentItem().setReminderMinutesBeforeStart(0);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete(boolean flag) throws PimException {
        this.delete();
    }

    public String getID() throws ExchangePimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws ExchangePimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public String getName() throws ExchangePimException {
        try {
            return "Reminder Item: ";
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }
}

