/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange.outlook;

import com.aligo.pim.PimRecurrencePatternDayType;
import com.aligo.pim.PimRecurrencePatternNthType;
import com.aligo.pim.PimRecurrencePatternType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimRecurrencePatternDayTypeMapper;
import com.aligo.pim.exchange.ExchangePimRecurrencePatternTypeMapper;
import com.aligo.pim.exchange.outlook.OutlookPimAppointmentItem;
import com.aligo.pim.exchange.outlook.OutlookPimItem;
import com.aligo.pim.exchange.outlook.OutlookPimMonthlyRecurParameter;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import outlook.AppointmentItem;
import outlook.RecurrencePattern;

public class OutlookPimRecurrencePatternItem
extends OutlookPimItem
implements PimRecurrencePatternItem {
    private RecurrencePattern m_oRecurrencePattern;
    private OutlookPimAppointmentItem m_oPimAppointmentItem;
    private PimRecurrencePatternType m_oPimRecurrencePatternType;
    private int m_iInterval;
    private int oDaysOfWeekMask;
    private int weekSize = 1;
    private Vector oDaysOfMonth;
    private int oNoOfOccurrences;
    private Date oRecurrenceEndDate;
    private Date oStartTime;
    private Date oEndTime;
    private boolean isUpdateCalled;
    int m_iTalOccurences;
    int m_iTalMonthInstance;
    int m_iTalDayInstance;
    int m_iTalInterval;
    Date m_oTalRecurrenceEndDate;
    boolean m_bTalSpecialMonthlyRecurrence = false;
    Vector m_vExceptionDates = new Vector();

    public OutlookPimRecurrencePatternItem() {
    }

    public Vector getMonthsOfYear() throws PimException {
        return null;
    }

    public PimRecurrencePatternNthType getNthType() throws PimException {
        return null;
    }

    public OutlookPimRecurrencePatternItem(RecurrencePattern _oRecurrencePattern) {
        this.m_oRecurrencePattern = _oRecurrencePattern;
    }

    public OutlookPimRecurrencePatternItem(RecurrencePattern _oRecurrencePattern, OutlookPimAppointmentItem _oPimAppointmentItem) {
        this.m_oRecurrencePattern = _oRecurrencePattern;
        this.m_oPimAppointmentItem = _oPimAppointmentItem;
    }

    public void setOutlookRecurrencePattern(RecurrencePattern _oRecurrencePattern) {
        this.m_oRecurrencePattern = _oRecurrencePattern;
    }

    public RecurrencePattern getOutlookRecurrencePattern() throws ExchangePimException {
        return this.m_oRecurrencePattern;
    }

    public Date getEndDate() throws ExchangePimException {
        try {
            return this.getOutlookRecurrencePattern().getPatternEndDate();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public Date getEndTime() throws ExchangePimException {
        try {
            return this.getOutlookRecurrencePattern().getEndTime();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setType(PimRecurrencePatternType pimRecurrencePatternType) throws PimException {
        try {
            if (pimRecurrencePatternType != null) {
                this.m_oPimRecurrencePatternType = pimRecurrencePatternType;
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setInterval(int interval) throws PimException {
        try {
            if (interval > 0) {
                this.m_iInterval = interval;
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setDaysOfWeek(Vector daysOfWeek) throws PimException {
        this.weekSize = daysOfWeek.size();
        int dayOfWeekMask = 0;
        try {
            if (daysOfWeek == null) {
                throw new ExchangePimException(55L);
            }
            if (daysOfWeek.size() > 0) {
                Vector tempVector = new Vector();
                int i = 0;
                while (i < daysOfWeek.size()) {
                    Object obj = daysOfWeek.elementAt(i);
                    if (!(obj instanceof PimRecurrencePatternDayType)) {
                        throw new ExchangePimException(55L);
                    }
                    int repeatIndex = daysOfWeek.lastIndexOf(obj);
                    if (i == repeatIndex) {
                        dayOfWeekMask += ExchangePimRecurrencePatternDayTypeMapper.getType((PimRecurrencePatternDayType)obj);
                    }
                    ++i;
                }
                this.oDaysOfWeekMask = dayOfWeekMask;
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(55L);
        }
    }

    public void setExceptionDates(Vector exceptionDates) throws PimException {
        try {
            this.m_vExceptionDates = exceptionDates;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void doExceptionDatesDeletion() {
        if (!this.isUpdateCalled) {
            return;
        }
        if (this.m_vExceptionDates != null && this.m_vExceptionDates.size() > 0) {
            int size = this.m_vExceptionDates.size();
            int i = 0;
            while (i < size) {
                Date date = null;
                try {
                    date = (Date)this.m_vExceptionDates.elementAt(i);
                    AppointmentItem apptItem = this.getOutlookRecurrencePattern().getOccurrence(date);
                    if (apptItem != null) {
                        apptItem.delete();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public void setDaysOfMonth(Vector daysOfMonth) throws PimException {
        try {
            if (daysOfMonth == null) {
                throw new ExchangePimException(56L);
            }
            if (daysOfMonth.size() > 0) {
                Vector<Integer> tempVector = new Vector<Integer>();
                int i = 0;
                while (i < daysOfMonth.size()) {
                    int dayOfMonth = (Integer)daysOfMonth.elementAt(i);
                    if (dayOfMonth <= 0 || dayOfMonth > 31) {
                        throw new ExchangePimException(56L);
                    }
                    int repeatIndex = daysOfMonth.lastIndexOf(new Integer(dayOfMonth));
                    if (i == repeatIndex) {
                        tempVector.add(new Integer(dayOfMonth));
                    }
                    ++i;
                }
                this.oDaysOfMonth = tempVector;
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(56L);
        }
    }

    public void setNoOfOccurrences(int noOfOccurrences) throws PimException {
        try {
            if (noOfOccurrences > 0) {
                this.oNoOfOccurrences = noOfOccurrences;
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void setNoOfInstances(int noOfInstances) throws PimException {
        this.setNoOfOccurrences(noOfInstances);
    }

    public void setRecurrenceEndDate(Date endDate) throws PimException {
        try {
            if (endDate != null) {
                this.oRecurrenceEndDate = endDate;
            }
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createDailyEveryNDays(Date recurrenceEndDate, int nDays) throws PimException {
        try {
            this.setType(PimRecurrencePatternType.DAILY);
            this.setInterval(nDays);
            this.setRecurrenceEndDate(recurrenceEndDate);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createDailyEveryNDays(int noOfOccurrences, int nDays) throws PimException {
        try {
            this.setType(PimRecurrencePatternType.DAILY);
            this.setNoOfOccurrences(noOfOccurrences);
            this.setInterval(nDays);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createWeeklyEveryNWeeks(Date recurrenceEndDate, int nWeeks, Vector daysOfWeek) throws PimException {
        try {
            this.setType(PimRecurrencePatternType.WEEKLY);
            this.setInterval(nWeeks);
            this.setDaysOfWeek(daysOfWeek);
            this.setRecurrenceEndDate(recurrenceEndDate);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createWeeklyEveryNWeeks(int noOfOccurrences, int nWeeks, Vector daysOfWeek) throws PimException {
        try {
            this.setType(PimRecurrencePatternType.WEEKLY);
            this.setNoOfOccurrences(noOfOccurrences);
            this.setInterval(nWeeks);
            this.setDaysOfWeek(daysOfWeek);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createWeeklyNoOfInstances(int noOfOccurrences, int nWeeks, Vector daysOfWeek) throws PimException {
        this.createWeeklyEveryNWeeks(noOfOccurrences, nWeeks, daysOfWeek);
    }

    public void createMonthlyEveryNMonths(Date recurrenceEndDate, int nMonths, Vector daysOfMonth) throws PimException {
        try {
            this.setType(PimRecurrencePatternType.MONTHLY);
            this.setInterval(nMonths);
            this.setDaysOfMonth(daysOfMonth);
            this.setRecurrenceEndDate(recurrenceEndDate);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createMonthlyEveryNMonths(int noOfOccurrences, int nMonths, Vector daysOfMonth) throws PimException {
        try {
            this.setType(PimRecurrencePatternType.MONTHLY);
            this.setNoOfOccurrences(noOfOccurrences);
            this.setInterval(nMonths);
            this.setDaysOfMonth(daysOfMonth);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createYearlyEveryNYears(Date recurrenceEndDate, int nYears) throws PimException {
        try {
            this.setType(PimRecurrencePatternType.YEARLY);
            this.setInterval(nYears);
            this.setRecurrenceEndDate(recurrenceEndDate);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void createYearlyEveryNYears(int noOfOccurrences, int nYears) throws PimException {
        try {
            this.setType(PimRecurrencePatternType.YEARLY);
            this.setNoOfOccurrences(noOfOccurrences);
            this.setInterval(nYears);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public boolean isItRecurringItem() throws ExchangePimException {
        return this.isUpdateCalled;
    }

    private void doValidityCheck() throws ExchangePimException {
        try {
            this.oStartTime = this.m_oPimAppointmentItem.oStartTime;
            if (this.oStartTime == null) {
                throw new ExchangePimException(59L);
            }
            this.oEndTime = this.m_oPimAppointmentItem.oEndTime;
            if (this.oEndTime == null) {
                throw new ExchangePimException(59L);
            }
            if (this.oEndTime.compareTo(this.oStartTime) < 0) {
                throw new ExchangePimException(13L);
            }
            if (this.oRecurrenceEndDate != null && this.oRecurrenceEndDate.compareTo(this.oEndTime) < 0) {
                throw new ExchangePimException(61L);
            }
            if (this.m_bTalSpecialMonthlyRecurrence) {
                return;
            }
            if (this.m_oPimRecurrencePatternType == null) {
                throw new ExchangePimException(60L);
            }
            if (this.oDaysOfMonth == null) {
                this.oDaysOfMonth = new Vector();
            }
            if (this.oDaysOfWeekMask < 1) {
                this.oDaysOfWeekMask = 2;
            }
            if (this.m_iInterval < 1) {
                this.m_iInterval = 1;
            }
            if (this.oNoOfOccurrences < 1) {
                this.oNoOfOccurrences = 1;
            }
            if (this.weekSize > 1 && this.oNoOfOccurrences > 0) {
                this.oNoOfOccurrences *= this.weekSize;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExchangePimException(e);
        }
    }

    public void createMonthlyEveryNMonths(int noOfOccurences, OutlookPimMonthlyRecurParameter monthInstance, PimRecurrencePatternDayType dayInstance, int interval) {
        this.m_iTalOccurences = noOfOccurences;
        this.m_iTalMonthInstance = monthInstance.getType();
        this.m_iTalDayInstance = ExchangePimRecurrencePatternDayTypeMapper.getType(dayInstance);
        this.m_iTalInterval = interval;
        this.m_bTalSpecialMonthlyRecurrence = true;
    }

    public void createMonthlyEveryNMonths(Date recurrenceEndDate, OutlookPimMonthlyRecurParameter monthInstance, PimRecurrencePatternDayType dayInstance, int interval) {
        this.m_oTalRecurrenceEndDate = recurrenceEndDate;
        this.m_iTalMonthInstance = monthInstance.getType();
        this.m_iTalDayInstance = ExchangePimRecurrencePatternDayTypeMapper.getType(dayInstance);
        this.m_iTalInterval = interval;
        this.m_bTalSpecialMonthlyRecurrence = true;
    }

    public void update() throws PimException {
        try {
            this.doValidityCheck();
            if (this.m_bTalSpecialMonthlyRecurrence) {
                if (this.m_iTalMonthInstance < 0 || this.m_iTalDayInstance < 0 || this.m_iTalInterval < 0) {
                    throw new Exception("The parmeters set are invalid[MonthInsance=" + this.m_iTalMonthInstance + "] [DayInstance=" + this.m_iTalDayInstance + "] [Interval=" + this.m_iTalInterval + "]");
                }
                this.getOutlookRecurrencePattern().setRecurrenceType(3);
                this.getOutlookRecurrencePattern().setInstance(this.m_iTalMonthInstance);
                this.getOutlookRecurrencePattern().setDayOfWeekMask(this.m_iTalDayInstance);
                this.getOutlookRecurrencePattern().setInterval(this.m_iTalInterval);
                if (this.m_oTalRecurrenceEndDate != null) {
                    this.getOutlookRecurrencePattern().setPatternEndDate(this.m_oTalRecurrenceEndDate);
                } else if (this.m_iTalOccurences > 0) {
                    this.getOutlookRecurrencePattern().setOccurrences(this.m_iTalOccurences);
                }
                this.isUpdateCalled = true;
                return;
            }
            if (this.m_oPimRecurrencePatternType == PimRecurrencePatternType.DAILY) {
                this.getOutlookRecurrencePattern().setRecurrenceType(0);
            } else if (this.m_oPimRecurrencePatternType == PimRecurrencePatternType.WEEKLY) {
                this.getOutlookRecurrencePattern().setRecurrenceType(1);
                this.getOutlookRecurrencePattern().setDayOfWeekMask(this.oDaysOfWeekMask);
                Calendar startCal = Calendar.getInstance();
                startCal.setTime(this.oStartTime);
                int week = startCal.get(7);
                int startWeek = -1;
                String binaryString = Integer.toBinaryString(this.oDaysOfWeekMask);
                int i = 0;
                while (i < binaryString.length()) {
                    char c = binaryString.charAt(i);
                    if (c == '1') {
                        startWeek = binaryString.length() - i;
                    }
                    ++i;
                }
                startCal.add(7, startWeek);
            } else if (this.m_oPimRecurrencePatternType == PimRecurrencePatternType.MONTHLY) {
                this.getOutlookRecurrencePattern().setRecurrenceType(2);
                int day = (Integer)this.oDaysOfMonth.elementAt(0);
                Calendar startCal = Calendar.getInstance();
                startCal.setTime(this.oStartTime);
                int startDay = startCal.get(5);
                if (startDay < day) {
                    startCal.set(5, day);
                } else if (startDay > day) {
                    startCal.set(5, day);
                    int startMonth = startCal.get(2);
                    startCal.roll(2, 1);
                    if (startMonth == 11) {
                        startCal.roll(1, 1);
                    }
                }
                this.getOutlookRecurrencePattern().setDayOfMonth(day);
            } else if (this.m_oPimRecurrencePatternType == PimRecurrencePatternType.YEARLY) {
                this.getOutlookRecurrencePattern().setRecurrenceType(5);
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.oStartTime);
                this.getOutlookRecurrencePattern().setDayOfMonth(cal.get(5));
                this.getOutlookRecurrencePattern().setMonthOfYear(cal.get(2) + 1);
            }
            this.getOutlookRecurrencePattern().setInterval(this.m_iInterval);
            if (this.oRecurrenceEndDate != null) {
                this.getOutlookRecurrencePattern().setPatternEndDate(this.oRecurrenceEndDate);
            } else if (this.oNoOfOccurrences > 0) {
                this.getOutlookRecurrencePattern().setOccurrences(this.oNoOfOccurrences);
            }
            this.isUpdateCalled = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExchangePimException(e);
        }
    }

    public void delete() throws PimException {
        try {
            this.isUpdateCalled = false;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete(boolean flag) throws PimException {
        this.delete();
    }

    public String getID() throws PimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws PimException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public String getName() throws ExchangePimException {
        try {
            return "Recurrence Pattern Item";
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecurrencePatternType getType() throws PimException {
        try {
            int type = this.getOutlookRecurrencePattern().getRecurrenceType();
            if (type == 3) {
                type = 2;
            }
            if (type == 6) {
                type = 5;
            }
            return ExchangePimRecurrencePatternTypeMapper.getRecurrenceType(type);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public int getInterval() throws PimException {
        try {
            return this.getOutlookRecurrencePattern().getInterval();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public Vector getDaysOfWeek() throws PimException {
        try {
            int days = this.getOutlookRecurrencePattern().getDayOfWeekMask();
            Vector<PimRecurrencePatternDayType> daysOfWeek = new Vector<PimRecurrencePatternDayType>();
            String binaryString = Integer.toBinaryString(days);
            int i = 0;
            while (i < binaryString.length()) {
                char c = binaryString.charAt(i);
                if (c == '1') {
                    daysOfWeek.add(ExchangePimRecurrencePatternDayTypeMapper.getRecurrenceType(binaryString.length() - i));
                }
                ++i;
            }
            return daysOfWeek;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public Vector getDaysOfMonth() throws PimException {
        try {
            int day = this.getOutlookRecurrencePattern().getDayOfMonth();
            Vector<Integer> daysOfMonth = new Vector<Integer>();
            daysOfMonth.add(new Integer(day));
            return daysOfMonth;
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public int getNoOfOccurrences() throws PimException {
        try {
            return this.getOutlookRecurrencePattern().getOccurrences();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public Date getRecurrenceEndDate() throws PimException {
        try {
            return this.getOutlookRecurrencePattern().getPatternEndDate();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }
}

