/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeAddressEntry;
import com.aligo.messaging.exchange.ExchangeRecipient;
import com.aligo.pim.PimRecipientType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchange.ExchangePimAddressEntryItem;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimItem;
import com.aligo.pim.exchange.ExchangePimRecipientTypeMapper;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimFieldItems;
import com.aligo.pim.interfaces.PimRecipientItem;

public class ExchangePimRecipientItem
extends ExchangePimItem
implements PimRecipientItem {
    private ExchangeRecipient _oRecipient;

    public ExchangePimRecipientItem(ExchangeRecipient _oRecipient, ExchangePimSession pimSession) {
        super(pimSession);
        this._oRecipient = _oRecipient;
    }

    public void setExchangeRecipient(ExchangeRecipient _oRecipient) {
        this._oRecipient = _oRecipient;
    }

    public ExchangeRecipient getExchangeRecipient() {
        return this._oRecipient;
    }

    public void setEmailAddress(String address) throws ExchangePimException {
        try {
            this.getExchangeRecipient().setAddress("SMTP:" + address);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void setRecipientType(PimRecipientType recipientType) throws ExchangePimException {
        try {
            this.getExchangeRecipient().setType(ExchangePimRecipientTypeMapper.getType(recipientType));
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void resolve() throws ExchangePimException {
        try {
            this.getExchangeRecipient().resolve();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getEmailAddress() throws ExchangePimException {
        try {
            return this.getExchangeRecipient().getAddress();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getName() throws ExchangePimException {
        try {
            return this.getExchangeRecipient().getName();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientType getRecipientType() throws ExchangePimException {
        try {
            int recipientType = this.getExchangeRecipient().getType();
            return ExchangePimRecipientTypeMapper.getType(recipientType);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAddressEntryItem getAddressEntryItem() throws ExchangePimException {
        try {
            ExchangeAddressEntry _oAddressEntry = this.getExchangeRecipient().getAddressEntry();
            if (_oAddressEntry == null) {
                return null;
            }
            return new ExchangePimAddressEntryItem(_oAddressEntry, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void update() throws ExchangePimException {
    }

    public void setAddressEntryItem(PimAddressEntryItem pimAddressEntryItem) throws ExchangePimException {
        try {
            if (pimAddressEntryItem instanceof ExchangePimAddressEntryItem) {
                this.getExchangeRecipient().setAddressEntry(((ExchangePimAddressEntryItem)pimAddressEntryItem).getExchangeAddressEntry());
            }
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete() throws ExchangePimException {
        try {
            this.getExchangeRecipient().delete();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete(boolean flag) throws PimException {
        this.delete();
    }

    public String getID() throws ExchangePimException {
        try {
            return this.getExchangeRecipient().getId();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimFieldItems getFieldItems() throws ExchangePimException {
        return null;
    }

    public void setID(String id) throws ExchangePimException {
        try {
            this.getExchangeRecipient().setId(id);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }
}

