/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeMessage;
import com.aligo.messaging.exchange.ExchangeRecipients;
import com.aligo.pim.PimImportanceType;
import com.aligo.pim.exceptions.PimException;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimImportanceTypeMapper;
import com.aligo.pim.exchange.ExchangePimMailAttachmentItems;
import com.aligo.pim.exchange.ExchangePimMailMessageItem;
import com.aligo.pim.exchange.ExchangePimRecipientItems;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.interfaces.PimMailAttachmentItems;
import com.aligo.pim.interfaces.PimMailItem;
import com.aligo.pim.interfaces.PimMailMessageItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecipientItems;

public class ExchangePimMailItem
extends ExchangePimMailMessageItem
implements PimMailItem {
    private ExchangePimMailAttachmentItems m_oPimMailAttachmentItems;
    private ExchangePimRecipientItems m_oPimRecipientItems;

    public ExchangePimMailItem(ExchangeMessage _oMessage, ExchangePimSession pimSession) {
        super(_oMessage, pimSession);
    }

    private ExchangeMessage getExchangeMailItem() {
        return this.getExchangeMailMessage();
    }

    public PimMailAttachmentItems getAttachmentItems() throws ExchangePimException {
        try {
            if (this.m_oPimMailAttachmentItems == null) {
                this.m_oPimMailAttachmentItems = new ExchangePimMailAttachmentItems(this.getExchangeMailItem().getAttachments(), this.getPimSession());
            } else {
                this.m_oPimMailAttachmentItems.setExchangeMailAttachmentItems(this.getExchangeMailItem().getAttachments());
            }
            return this.m_oPimMailAttachmentItems;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void setBody(String body) throws ExchangePimException {
        try {
            this.getExchangeMailItem().setText(body);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void setSubject(String subject) throws ExchangePimException {
        try {
            this.getExchangeMailItem().setSubject(subject);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void setImportance(PimImportanceType type) throws ExchangePimException {
        try {
            this.getExchangeMailMessage().setImportance(ExchangePimImportanceTypeMapper.getType(type));
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getText() throws ExchangePimException {
        try {
            return this.getExchangeMailItem().getText();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimRecipientItems getRecipients() throws ExchangePimException {
        try {
            ExchangeRecipients _oRecipients = this.getExchangeMailItem().getRecipients();
            if (_oRecipients == null) {
                return null;
            }
            if (this.m_oPimRecipientItems == null) {
                this.m_oPimRecipientItems = new ExchangePimRecipientItems(_oRecipients, this.getPimSession());
            } else {
                this.m_oPimRecipientItems.setExchangeRecipients(_oRecipients);
            }
            return this.m_oPimRecipientItems;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void send() throws ExchangePimException {
        try {
            this.getExchangeMailItem().send();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMailMessageItem reply() throws ExchangePimException {
        try {
            ExchangeMessage _oMessage = this.getExchangeMailItem().reply();
            _oMessage.setSubject("Re:" + _oMessage.getSubject());
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimMailItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMailMessageItem replyAll() throws ExchangePimException {
        try {
            ExchangeMessage _oMessage = this.getExchangeMailItem().replyAll();
            _oMessage.setSubject("Re:" + _oMessage.getSubject());
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimMailItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public boolean hasAttachment() throws PimException {
        try {
            return this.getExchangeMailItem().getAttachments().getCount() > 0;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMessageItem forward() throws ExchangePimException {
        try {
            ExchangeMessage _oMessage = this.getExchangeMailItem().forward();
            _oMessage.setSubject("Fw:" + _oMessage.getSubject());
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimMailItem(_oMessage, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void update() throws ExchangePimException {
        try {
            this.getExchangeMailItem().update();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void update(boolean makeItPermanent, boolean refreshObject) throws ExchangePimException {
        try {
            this.getExchangeMailItem().update(makeItPermanent, refreshObject);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public String getName() throws ExchangePimException {
        try {
            return "Mail Item with subject: " + this.getExchangeMailItem().getSubject();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }
}

