/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.lotus;

import com.aligo.pim.PimImportanceType;
import com.aligo.pim.PimTaskStatusType;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimRecurrencePatternItem;
import com.aligo.pim.interfaces.PimReminderItem;
import com.aligo.pim.interfaces.PimTaskItem;
import com.aligo.pim.lotus.LotusPimCommonTaskItem;
import com.aligo.pim.lotus.LotusPimException;
import com.aligo.pim.lotus.LotusPimMessageItem;
import com.aligo.pim.lotus.LotusPimNewApptNewReminderItem;
import com.aligo.pim.lotus.LotusPimNewRecurrencePatternItem;
import com.aligo.pim.lotus.LotusPimSession;
import com.aligo.pim.lotus.LotusPimTaskItem;
import com.aligo.pim.lotus.recycle.Recycle;
import java.util.Date;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.RichTextStyle;
import lotus.domino.Session;
import lotus.domino.ViewEntryCollection;

public class LotusPimNewTaskItem
extends LotusPimMessageItem
implements PimTaskItem,
LotusPimCommonTaskItem {
    private DateTime m_oStartDateTime = null;
    private DateTime m_oDueDateTime = null;
    private String m_szSubject = "";
    private String m_szText = "";
    private LotusPimNewRecurrencePatternItem m_oPimRecurrencePatternItem;
    private LotusPimNewApptNewReminderItem m_oPimReminderItem;
    private boolean m_bHasHeSetStatus;

    public LotusPimNewTaskItem(ViewEntryCollection viewEntryCollection, LotusPimSession lotusPimSession, Recycle recycle) {
        super(viewEntryCollection, lotusPimSession, recycle);
    }

    private DateTime getStartDateTime() throws LotusPimException {
        try {
            return this.m_oStartDateTime;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Date getStartTime() throws LotusPimException {
        return this.getStartDate();
    }

    public Date getEndTime() throws LotusPimException {
        return this.getDueDate();
    }

    private DateTime getDueDateTime() throws LotusPimException {
        try {
            return this.m_oDueDateTime;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimRecurrencePatternItem getRecurrencePatternItem() throws LotusPimException {
        try {
            if (this.m_oPimRecurrencePatternItem == null) {
                this.m_oPimRecurrencePatternItem = new LotusPimNewRecurrencePatternItem(this, this.getLotusPimSession(), this.getRecycle());
            }
            return this.m_oPimRecurrencePatternItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Date getDueDate() throws LotusPimException {
        try {
            DateTime dateTime = this.getDueDateTime();
            if (dateTime != null) {
                return dateTime.toJavaDate();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public PimImportanceType getImportance() throws LotusPimException {
        return PimImportanceType.NORMAL;
    }

    public PimReminderItem getReminderItem() throws LotusPimException {
        try {
            if (this.m_oPimReminderItem == null) {
                this.m_oPimReminderItem = new LotusPimNewApptNewReminderItem(this.getLotusPimSession(), this.getRecycle());
            }
            return this.m_oPimReminderItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimReminderItem addReminderItem() throws LotusPimException {
        try {
            return this.getReminderItem();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public Date getStartDate() throws LotusPimException {
        try {
            DateTime dateTime = this.getStartDateTime();
            if (dateTime != null) {
                return dateTime.toJavaDate();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
        return null;
    }

    public String getSubject() throws LotusPimException {
        try {
            return this.m_szSubject;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getName() throws LotusPimException {
        try {
            return "Task Item: " + this.getSubject();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public String getText() throws LotusPimException {
        try {
            return this.m_szText;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setDueDate(Date date) throws LotusPimException {
        try {
            DateTime dateTime;
            this.m_oDueDateTime = dateTime = this.getLotusSession().createDateTime(date);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setImportance(PimImportanceType pimImportanceType) throws LotusPimException {
    }

    public void setStartDate(Date date) throws LotusPimException {
        try {
            DateTime dateTime;
            this.m_oStartDateTime = dateTime = this.getLotusSession().createDateTime(date);
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setSubject(String string) throws LotusPimException {
        try {
            this.m_szSubject = string;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void setText(String string) throws LotusPimException {
        try {
            this.m_szText = string;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimMessageItem forward() throws LotusPimException {
        try {
            Document document = this.returnForwardDocument();
            if (document == null) {
                return null;
            }
            document.replaceItemValue("Subject", (Object)"FW: Task Item forwarded ");
            LotusPimTaskItem lotusPimTaskItem = new LotusPimTaskItem(document, this.getLotusPimSession(), this.getRecycle());
            return lotusPimTaskItem;
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void send() throws LotusPimException {
        super.send();
    }

    private void writeCommonStuff(Document document) throws LotusPimException {
        try {
            Date date = this.getStartDate();
            Date date2 = this.getDueDate();
            if (date != null && date2 != null && this.getDueDateTime().timeDifference(this.getStartDateTime()) < 0) {
                throw new LotusPimException(13L);
            }
            this.writeReminderValues(document);
            document.replaceItemValue("$AltPrincipal", (Object)this.getLotusSession().getUserName());
            document.replaceItemValue("$CSVersion", (Object)new String("2"));
            document.replaceItemValue("$ExpandGroups", (Object)new String("3"));
            document.replaceItemValue("$PublicAccess", (Object)new String("1"));
            document.replaceItemValue("$SMTPKeepNotesItems", (Object)new String("1"));
            document.replaceItemValue("$UpdatedBy", (Object)this.getLotusSession().getUserName());
            document.replaceItemValue("$WebFlags", (Object)new String("J"));
            document.replaceItemValue("AltChair", (Object)this.getLotusSession().getUserName());
            date = this.getLotusSession().createDateTime(new Date());
            try {
                date2 = document.createRichTextItem("Body");
                RichTextStyle richTextStyle = this.getLotusSession().createRichTextStyle();
                richTextStyle.setFontSize(9);
                date2.appendStyle(richTextStyle);
                date2.appendText(this.getText());
            }
            catch (Exception exception) {
                document.replaceItemValue("Body", (Object)this.getText());
            }
            document.replaceItemValue("Chair", (Object)this.getLotusSession().getUserName());
            document.replaceItemValue("DefaultMailSaveOptions", (Object)new String("1"));
            document.replaceItemValue("DueDate", (Object)this.getDueDateTime());
            document.replaceItemValue("DueDateTime", (Object)this.getDueDateTime());
            if (!this.m_bHasHeSetStatus && this.getDueDateTime() != null) {
                double d = this.getDueDateTime().timeDifferenceDouble((DateTime)date);
                if (d > 86400.0) {
                    document.replaceItemValue("DueState", (Object)new Integer(2));
                } else if (d < 0.0) {
                    document.replaceItemValue("DueState", (Object)new Integer(0));
                } else {
                    document.replaceItemValue("DueState", (Object)new Integer(1));
                }
            }
            document.replaceItemValue("Encrypt", (Object)new String("0"));
            document.replaceItemValue("ExcludeFromView", (Object)new String("D"));
            document.replaceItemValue("Form", (Object)"Task");
            document.replaceItemValue("From", (Object)this.getLotusSession().getUserName());
            document.replaceItemValue("Importance", (Object)new String("2"));
            document.replaceItemValue("MailFirstPass", (Object)new String("1"));
            document.replaceItemValue("OrgTable", (Object)new String("T0"));
            document.replaceItemValue("Principal", (Object)this.getLotusSession().getUserName());
            document.replaceItemValue("SequenceNum", (Object)new Integer(1));
            document.replaceItemValue("Sign", (Object)new String("0"));
            document.replaceItemValue("SMTPKeepNotesItems", (Object)new String("1"));
            document.replaceItemValue("StartDate", (Object)this.getStartDateTime());
            document.replaceItemValue("StartDateTime", (Object)this.getStartDateTime());
            document.replaceItemValue("subject", (Object)this.getSubject());
            document.replaceItemValue("TaskType", (Object)new String("1"));
            document.replaceItemValue("tmpOwnerHW", (Object)new String("1"));
            document.replaceItemValue("WebDateTimeInit", (Object)new String("1"));
            if (!this.m_bHasHeSetStatus) {
                document.replaceItemValue("_ViewIcon", (Object)new Integer(168));
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void updateAsNormalItem() throws LotusPimException {
        try {
            this.writeCommonStuff(this.getLotusDocument());
            this.getLotusDocument().replaceItemValue("ApptUNID", (Object)this.getID());
            this.getLotusDocument().replaceItemValue("CalendarDateTime", (Object)this.getStartDateTime());
            super.update();
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void updateAsRecurringItem() throws LotusPimException {
        try {
            if (this.m_oPimRecurrencePatternItem != null) {
                if (!this.m_oPimRecurrencePatternItem.isItRecurringItem()) {
                    this.m_oPimRecurrencePatternItem.update();
                }
                this.writeTaskParentDocument();
                this.writeTaskChildDocument();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void writeTaskParentDocument() throws LotusPimException {
        try {
            if (this.m_oPimRecurrencePatternItem != null) {
                Session session = this.getLotusSession();
                this.writeCommonStuff(this.getLotusDocument());
                this.getLotusDocument().replaceItemValue("$CSFlags", (Object)new String("c"));
                this.getLotusDocument().replaceItemValue("ApptUNID", (Object)this.getID());
                this.getLotusDocument().replaceItemValue("OrgRepeat", (Object)"1");
                this.getLotusDocument().replaceItemValue("RepeatAdjust", (Object)this.m_oPimRecurrencePatternItem.getRepeatAdjust());
                this.getLotusDocument().replaceItemValue("RepeatCustom", (Object)this.m_oPimRecurrencePatternItem.getRepeatCustom());
                this.getLotusDocument().replaceItemValue("RepeatDates", (Object)this.m_oPimRecurrencePatternItem.getRepeatDates());
                this.getLotusDocument().replaceItemValue("RepeatFor", (Object)this.m_oPimRecurrencePatternItem.getRepeatFor());
                this.getLotusDocument().replaceItemValue("RepeatForUnit", (Object)this.m_oPimRecurrencePatternItem.getRepeatForUnit());
                this.getLotusDocument().replaceItemValue("RepeatFromEnd", (Object)this.m_oPimRecurrencePatternItem.getRepeatFromEnd());
                this.getLotusDocument().replaceItemValue("RepeatHow", (Object)this.m_oPimRecurrencePatternItem.getRepeatHow());
                this.getLotusDocument().replaceItemValue("RepeatInstanceDates", (Object)this.m_oPimRecurrencePatternItem.getRepeatOccurrenceDates());
                this.getLotusDocument().replaceItemValue("RepeatInterval", (Object)this.m_oPimRecurrencePatternItem.getRepeatInterval());
                this.getLotusDocument().replaceItemValue("Repeats", (Object)"1");
                this.getLotusDocument().replaceItemValue("RepeatStartDate", (Object)this.m_oPimRecurrencePatternItem.getRepeatStartDate());
                this.getLotusDocument().replaceItemValue("RepeatUnit", (Object)this.m_oPimRecurrencePatternItem.getRepeatUnit());
                this.getLotusDocument().replaceItemValue("RepeatUntil", (Object)this.m_oPimRecurrencePatternItem.getRepeatUntil());
                this.getLotusDocument().replaceItemValue("RepeatWeekends", (Object)this.m_oPimRecurrencePatternItem.getRepeatWeekends());
                this.getLotusDocument().replaceItemValue("StartDate", (Object)this.m_oPimRecurrencePatternItem.getStartDate());
                this.getLotusDocument().replaceItemValue("StartDateTime", (Object)this.m_oPimRecurrencePatternItem.getStartDateTime());
                this.getLotusDocument().replaceItemValue("DueDate", (Object)this.m_oPimRecurrencePatternItem.getEndDate());
                this.getLotusDocument().replaceItemValue("DueDateTime", (Object)this.m_oPimRecurrencePatternItem.getEndDateTime());
                super.update();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void writeTaskChildDocument() throws LotusPimException {
        try {
            if (this.m_oPimRecurrencePatternItem != null) {
                Session session = this.getLotusSession();
                Document document = this.getLotusDatabase().createDocument();
                this.getRecycle().add(document);
                this.writeCommonStuff(document);
                document.replaceItemValue("$CSFlags", (Object)"i");
                document.replaceItemValue("$RefOptions", (Object)"1");
                document.replaceItemValue("CalendarDateTime", (Object)this.m_oPimRecurrencePatternItem.getChildCalendarDateTime());
                document.replaceItemValue("DueDate", (Object)this.m_oPimRecurrencePatternItem.getChildEndDate());
                document.replaceItemValue("DueDateTime", (Object)this.m_oPimRecurrencePatternItem.getChildEndDateTime());
                document.replaceItemValue("OrgRepeat", (Object)"1");
                document.replaceItemValue("RepeatFromEnd", (Object)this.m_oPimRecurrencePatternItem.getChildRepeatFromEnd());
                document.replaceItemValue("RepeatInstanceDates", (Object)this.m_oPimRecurrencePatternItem.getChildRepeatOccurrenceDates());
                document.replaceItemValue("Repeats", (Object)"1");
                document.replaceItemValue("StartDate", (Object)this.m_oPimRecurrencePatternItem.getChildStartDate());
                document.replaceItemValue("StartDateTime", (Object)this.m_oPimRecurrencePatternItem.getChildStartDateTime());
                document.makeResponse(this.getLotusDocument());
                document.save(true, true);
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    private void writeReminderValues(Document document) throws LotusPimException {
        try {
            if (this.m_oPimReminderItem != null && this.m_oPimReminderItem.isReminderSet()) {
                document.replaceItemValue("$Alarm", (Object)new Integer(1));
                document.replaceItemValue("$AlarmDescription", (Object)this.getSubject());
                document.replaceItemValue("$AlarmMemoOptions", (Object)"");
                document.replaceItemValue("Alarms", (Object)"1");
                document.replaceItemValue("$AlarmUnit", (Object)this.m_oPimReminderItem.getAlarmUnit());
                document.replaceItemValue("$AlarmOffset", (Object)new Integer(-1L * this.m_oPimReminderItem.getNoOfMinutesBeforeStart() + ""));
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public void update() throws LotusPimException {
        try {
            if (this.m_oPimRecurrencePatternItem != null && this.m_oPimRecurrencePatternItem.isItRecurringItem()) {
                this.updateAsRecurringItem();
            } else {
                this.updateAsNormalItem();
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }

    public PimTaskStatusType getStatus() throws LotusPimException {
        try {
            int n;
            Document document = this.getLotusDocument();
            if (document.hasItem("DueState") && (n = document.getItemValueInteger("DueState")) == 9) {
                return PimTaskStatusType.COMPLETE;
            }
            return PimTaskStatusType.NOT_COMPLETE;
        }
        catch (Exception exception) {
            return PimTaskStatusType.NOT_COMPLETE;
        }
    }

    public void setStatus(PimTaskStatusType pimTaskStatusType) throws LotusPimException {
        try {
            if (pimTaskStatusType != null) {
                Document document = this.getLotusDocument();
                if (pimTaskStatusType.equals(PimTaskStatusType.COMPLETE)) {
                    if (this.getStatus().equals(PimTaskStatusType.NOT_COMPLETE)) {
                        document.replaceItemValue("ASSIGNSTATE", (Object)new Integer(9));
                        DateTime dateTime = this.getLotusSession().createDateTime(new Date());
                        document.replaceItemValue("CompletedDateTime", (Object)dateTime);
                        document.replaceItemValue("DueState", (Object)new Integer(9));
                        document.replaceItemValue("NoticeType", (Object)"F");
                        document.replaceItemValue("_ViewIcon", (Object)new Integer(82));
                    }
                } else if (this.getStatus().equals(PimTaskStatusType.COMPLETE)) {
                    document.removeItem("ASSIGNSTATE");
                    document.removeItem("CompletedDateTime");
                    document.removeItem("NoticeType");
                    document.replaceItemValue("_ViewIcon", (Object)new Integer(168));
                    document.replaceItemValue("DueState", (Object)new Integer(1));
                }
                this.m_bHasHeSetStatus = true;
            }
        }
        catch (Exception exception) {
            throw new LotusPimException(exception);
        }
    }
}

