/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.cli.cert;

import com.sun.portal.cli.cert.CertAdminConstants;
import com.sun.portal.cli.cert.CertAdminHelpText;
import com.sun.portal.cli.cert.CertAdminLocale;
import com.sun.portal.cli.cert.CertAdminPasswordCallback;
import com.sun.portal.cli.cert.CertAdminUtil;
import com.sun.portal.cli.cert.Command;
import com.sun.portal.cli.cert.JSSContext;
import com.sun.portal.cli.cert.JSSUtil;
import com.sun.portal.cli.cert.SystemProperties;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.util.ConsolePasswordCallback;
import org.mozilla.jss.util.NullPasswordCallback;
import org.mozilla.jss.util.PasswordCallback;

public class GenerateCSR
implements Command {
    public boolean execute(JSSContext jSSContext) {
        CertAdminUtil.println(CertAdminHelpText.getDNHelpText());
        String string = jSSContext.getHost();
        String string2 = CertAdminUtil.question(CertAdminLocale.getPFString("q2", "What is the fully-qualified DNS name of this host? [") + string + CertAdminLocale.getPFString("q1", "]"));
        if (string2.equals("")) {
            string2 = string;
        }
        String string3 = "MyOrganization";
        String string4 = CertAdminUtil.question(CertAdminLocale.getPFString("q3", "What is the name of your organization (ex: Company)? [") + string3 + CertAdminLocale.getPFString("q1", "]"));
        if (string4.equals("")) {
            string4 = string3;
        }
        String string5 = "MyOrganizationUnit";
        String string6 = CertAdminUtil.question(CertAdminLocale.getPFString("q4", "What is the name of your organizational unit (ex: division)? [") + string5 + CertAdminLocale.getPFString("q1", "]"));
        if (string6.equals("")) {
            string6 = string5;
        }
        String string7 = "MyLocality";
        String string8 = CertAdminUtil.question(CertAdminLocale.getPFString("q5", "What is the name of your City or Locality? [") + string7 + CertAdminLocale.getPFString("q1", "]"));
        if (string8.equals("")) {
            string8 = string7;
        }
        String string9 = "MyState";
        String string10 = CertAdminUtil.question(CertAdminLocale.getPFString("q6", "What is the name (no abbreviation please) of your State or Province? [") + string9 + CertAdminLocale.getPFString("q1", "]"));
        if (string10.equals("")) {
            string10 = string9;
        }
        String string11 = CertAdminUtil.question(CertAdminLocale.getPFString("q7", "What is the two-letter country code for this unit? []"));
        while (string11.trim().length() != 2) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m19", "Email/Phone values should not be empty!"));
            string11 = CertAdminUtil.question(CertAdminLocale.getPFString("q7", "What is the two-letter country code for this unit? []"));
        }
        CertAdminUtil.println(CertAdminHelpText.getTokenHelpText());
        String string12 = CertAdminUtil.question(CertAdminLocale.getPFString("q8", "Enter the token name []"));
        CertAdminUtil.println(CertAdminHelpText.getCSRAdminHelpText());
        CertAdminUtil.println(CertAdminConstants.newline);
        String string13 = CertAdminUtil.question(CertAdminLocale.getPFString("q11", "What is the email address of the admin/webmaster for this server ?"));
        String string14 = CertAdminUtil.question(CertAdminLocale.getPFString("q12", "What is the phone number of the admin/webmaster for this server ?"));
        while (string13.trim().equals("") || string14.trim().equals("")) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m19", "Email/Phone values should not be empty!"));
            string13 = CertAdminUtil.question(CertAdminLocale.getPFString("q11", "What is the email address of the admin/webmaster for this server ?"));
            string14 = CertAdminUtil.question(CertAdminLocale.getPFString("q12", "What is the phone number of the admin/webmaster for this server ?"));
        }
        CertAdminUtil.println(CertAdminConstants.newline);
        CertAdminUtil.println(CertAdminLocale.getPFString("m16", "You have entered the following values:"));
        CertAdminUtil.println(CertAdminLocale.getPFString("m17", "Webmaster Email :") + string13);
        CertAdminUtil.println(CertAdminLocale.getPFString("m18", "Webmaster Phone : ") + string14);
        CertAdminUtil.println(CertAdminConstants.newline);
        String string15 = CertAdminUtil.question(CertAdminLocale.getPFString("q13", "Are these values correct (y/n) ? [n]"));
        while (!string15.equals("y")) {
            CertAdminUtil.println(CertAdminConstants.newline);
            string13 = CertAdminUtil.question(CertAdminLocale.getPFString("q11", "What is the email address of the admin/webmaster for this server ?"));
            string14 = CertAdminUtil.question(CertAdminLocale.getPFString("q12", "What is the phone number of the admin/webmaster for this server ?"));
            while (string13.trim().equals("") || string14.trim().equals("")) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m19", "Email/Phone values should not be empty!"));
                string13 = CertAdminUtil.question(CertAdminLocale.getPFString("q11", "What is the email address of the admin/webmaster for this server ?"));
                string14 = CertAdminUtil.question(CertAdminLocale.getPFString("q12", "What is the phone number of the admin/webmaster for this server ?"));
            }
            CertAdminUtil.println(CertAdminConstants.newline);
            CertAdminUtil.println(CertAdminLocale.getPFString("m16", "You have entered the following values:"));
            CertAdminUtil.println(CertAdminLocale.getPFString("m17", "Webmaster Email :") + string13);
            CertAdminUtil.println(CertAdminLocale.getPFString("m18", "Webmaster Phone : ") + string14);
            CertAdminUtil.println(CertAdminConstants.newline);
            string15 = CertAdminUtil.question(CertAdminLocale.getPFString("q13", "Are these values correct (y/n) ? [n]"));
        }
        try {
            String string16;
            CertAdminPasswordCallback certAdminPasswordCallback;
            String string17 = jSSContext.getPasswordContext().generatePassphrase(jSSContext);
            CryptoToken cryptoToken = null;
            if (string12.trim().equals("")) {
                cryptoToken = jSSContext.getCryptoManager().getInternalKeyStorageToken();
                certAdminPasswordCallback = new CertAdminPasswordCallback(string17);
                if (!cryptoToken.passwordIsInitialized()) {
                    cryptoToken.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)certAdminPasswordCallback);
                }
            } else {
                cryptoToken = jSSContext.getCryptoManager().getTokenByName(string12);
                certAdminPasswordCallback = new ConsolePasswordCallback();
                if (!cryptoToken.passwordIsInitialized()) {
                    cryptoToken.initPassword((PasswordCallback)new NullPasswordCallback(), (PasswordCallback)certAdminPasswordCallback);
                }
            }
            cryptoToken.login((PasswordCallback)certAdminPasswordCallback);
            String string18 = "OU=" + string6 + "," + "O=" + string4 + "," + "CN=" + string2 + "," + "C=" + string11 + "," + "ST=" + string10 + "," + "L=" + string8;
            Name name = new Name();
            if (!string2.equals("")) {
                name.addCommonName(string2);
            }
            if (!string8.equals("")) {
                name.addLocalityName(string8);
            }
            if (!string10.equals("")) {
                name.addStateOrProvinceName(string10);
            }
            name.addCountryName(string11);
            if (!string4.equals("")) {
                name.addOrganizationName(string4);
            }
            if (!string6.equals("")) {
                name.addOrganizationalUnitName(string6);
            }
            if ((string16 = JSSUtil.getCertWithSubject(cryptoToken, name)) != null) {
                CertAdminUtil.println();
                CertAdminUtil.println(CertAdminLocale.getPFString("m63", "Certificate with the specified Subject DN already exist!"));
                CertAdminUtil.println(CertAdminLocale.getPFString("m64", "Certificate Nickname:") + " " + string16);
                CertAdminUtil.println(CertAdminLocale.getPFString("m65", "Certificate Subject DN:") + " " + name.getRFC1485());
                CertAdminUtil.println(CertAdminLocale.getPFString("m66", "Retry deleting the certificate or change the Subject DN for the new certificate"));
                CertAdminUtil.question(CertAdminLocale.getPFString("m67", "Hit Return to continue!!"));
                CertAdminUtil.println(CertAdminConstants.newline);
                return false;
            }
            CertAdminUtil.println(CertAdminLocale.getPFString("m20", "Generating CSR..."));
            CertAdminUtil.println(CertAdminLocale.getPFString("m12", "Generating key.  This may take a few moments..."));
            CertAdminUtil.println(CertAdminConstants.newline);
            String string19 = cryptoToken.generateCertRequest(string18, 1024, "rsa", (byte[])null, (byte[])null, (byte[])null);
            CertAdminUtil.println(CertAdminHelpText.getCSRHelpText());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("The CSR is also show below:");
            stringBuffer.append(CertAdminConstants.newline);
            stringBuffer.append(CertAdminConstants.newline);
            stringBuffer.append("Certificate request generated by Netscape certutil");
            stringBuffer.append(CertAdminConstants.newline);
            stringBuffer.append(CertAdminConstants.newline);
            stringBuffer.append("Phone: " + string14);
            stringBuffer.append(CertAdminConstants.newline);
            stringBuffer.append("Common Name: " + string2);
            stringBuffer.append(CertAdminConstants.newline);
            stringBuffer.append("Email: " + string13);
            stringBuffer.append(CertAdminConstants.newline);
            stringBuffer.append("Organization: " + string4);
            stringBuffer.append(CertAdminConstants.newline);
            stringBuffer.append("State: " + string10);
            stringBuffer.append(CertAdminConstants.newline);
            stringBuffer.append("Country: " + string11);
            stringBuffer.append(CertAdminConstants.newline);
            stringBuffer.append(CertAdminConstants.newline);
            stringBuffer.append(string19);
            CertAdminUtil.println(stringBuffer.toString());
            if (!CertAdminUtil.writeLine(stringBuffer.toString(), "csr." + SystemProperties.get("gateway.host") + "." + CertAdminUtil.getCurrentDateTime())) {
                CertAdminUtil.println(CertAdminLocale.getPFString("m21", "Could not write the csr to the file!"));
            }
        }
        catch (Exception exception) {
            CertAdminUtil.println(CertAdminLocale.getPFString("m22", "Could not generate the csr!"));
            exception.printStackTrace();
            return false;
        }
        return true;
    }
}

