/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines;

import com.sun.portal.rewriter.Rewriter;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.engines.LanguageConstants;
import com.sun.portal.rewriter.engines.PageContent;
import com.sun.portal.rewriter.engines.RewriterBroker;
import com.sun.portal.rewriter.rom.RuleSet;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.uri.PageSpec;
import java.io.Reader;
import java.io.StringReader;

public abstract class AbstractRewriter
implements Rewriter,
LanguageConstants {
    private final RewriterBroker rewriterBroker;
    private final String mime;

    protected AbstractRewriter(RewriterBroker aRewriterBroker, String aMIME) {
        this.rewriterBroker = aRewriterBroker;
        this.mime = aMIME;
    }

    public RuleSet getRuleSet() {
        return this.rewriterBroker.getRuleSet();
    }

    public String getMIME() {
        return this.mime;
    }

    public Reader rewrite(Reader aReader, Translator aTranslator) {
        return new StringReader(this.rewrite(Resource.read(aReader), aTranslator));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String rewrite(String aContent, Translator aTranslator) {
        boolean root = aTranslator.getLookAheadInfo().isRootRewriter();
        String lRewrittenConent = aContent;
        try {
            try {
                if (StringHelper.normalize(aContent).length() < 1) {
                    String string = aContent;
                    Object var7_8 = null;
                    if (!root) return string;
                    this.recordPage(aTranslator.getPageSpec(), lRewrittenConent, aContent);
                    return string;
                }
                PageContent lPageContent = new PageContent(aContent);
                this.plugableRewriter(lPageContent, aTranslator);
                if (root) {
                    this.endRewriting(lPageContent, aTranslator);
                }
                lRewrittenConent = lPageContent.getResult();
            }
            catch (Exception e) {
                Debug.recordOriginalPageWarning("", e);
                Object var7_10 = null;
                if (!root) return lRewrittenConent;
                this.recordPage(aTranslator.getPageSpec(), lRewrittenConent, aContent);
                return lRewrittenConent;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!root) throw throwable;
            this.recordPage(aTranslator.getPageSpec(), lRewrittenConent, aContent);
            throw throwable;
        }
        Object var7_9 = null;
        if (!root) return lRewrittenConent;
        this.recordPage(aTranslator.getPageSpec(), lRewrittenConent, aContent);
        return lRewrittenConent;
    }

    public abstract void plugableRewriter(PageContent var1, Translator var2);

    public void endRewriting(PageContent aPageContent, Translator aTranslator) {
    }

    protected final RewriterBroker getRewriterBroker() {
        return this.rewriterBroker;
    }

    private void recordPage(PageSpec aPageSpec, String aRewrittenConent, String aContent) {
        if (Debug.isMessageEnabled()) {
            String bRewrittenConent = aRewrittenConent;
            boolean unaffected = false;
            if (aRewrittenConent.trim().equals(aContent.trim())) {
                bRewrittenConent = "This Page remains same as the Original Page even after rewritting";
                unaffected = true;
            }
            String bHeadder = "\n{\n" + (unaffected ? "(IDENTICAL)" : "") + aPageSpec + "RuleSet ID: " + this.getRuleSet().getID() + ",\n" + "Parser MIME: " + this.mime + ",\n";
            if (unaffected) {
                Debug.recordUnaffectedPageMessage(bHeadder + "Rewritten Content:\n" + bRewrittenConent + "\n}\n");
            } else {
                Debug.recordRewrittenPageMessage(bHeadder + "Rewritten Content:\n" + bRewrittenConent + "\n}\n");
            }
            Debug.recordOriginalPageMessage(bHeadder + "Original Content:\n" + aContent + "\n}\n");
        }
    }
}

