/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter;

import com.sun.portal.rewriter.AbsoluteTranslator;
import com.sun.portal.rewriter.AbstractTranslator;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.re.Pattern;
import com.sun.portal.rewriter.util.re.RegExp;
import com.sun.portal.rewriter.util.uri.DecoratedURI;
import com.sun.portal.rewriter.util.uri.PageSpec;
import java.net.MalformedURLException;

public final class TranslatorHelper {
    public static final String convert2Absolute(PageSpec aPageSpec, String aOrgURL) {
        return AbstractTranslator.doTranslate(aOrgURL, aPageSpec, null);
    }

    public static final String translateSubStrings(Pattern[] aRuleList, String aSourceString, Translator aTranslator) {
        String result = aSourceString;
        boolean translateZeroPosition = false;
        int vpSize = aRuleList.length;
        int j = vpSize - 1;
        while (j >= 0) {
            Pattern rule = aRuleList[j];
            if (rule.getInput().equals("**")) {
                translateZeroPosition = true;
            } else if (rule.getInput().length() == 0) {
                result = TranslatorHelper.translateString(result, aTranslator);
            } else {
                int index = RegExp.indexOf(rule, result);
                if (index != -1 && index < result.length()) {
                    result = result.substring(0, index) + TranslatorHelper.translateString(result.substring(index), aTranslator);
                }
            }
            --j;
        }
        if (translateZeroPosition && !aSourceString.equals(result)) {
            result = TranslatorHelper.translateString(result, aTranslator);
        }
        return result;
    }

    public static final String translateString(String aString, Translator aTranslator) {
        int i = TranslatorHelper.findLastValidURICharIndex(aString);
        if (i == 0) {
            return aString;
        }
        StringBuffer sb = new StringBuffer(aString.length());
        sb.append(aTranslator.translate(aString.substring(0, i)));
        sb.append(aString.substring(i));
        return sb.toString();
    }

    private static final int findLastValidURICharIndex(String aString) {
        String lScheme = StringHelper.normalize(aString);
        int strLen = lScheme.length();
        int i = 0;
        while (i < strLen) {
            char c = lScheme.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '.' && c != '/' && c != ' ' && c != ':' && c != '\'' && c != '\"') {
                return i;
            }
            ++i;
        }
        return i;
    }

    public static final DecoratedURI handleScriptSRC(PageSpec aPageSpec, DecoratedURI aURI) throws MalformedURLException {
        String bScriptReferrerBase;
        DecoratedURI lResult = aURI;
        String bScriptSRCBase = aURI.getBaseHREF();
        if (!bScriptSRCBase.equalsIgnoreCase(bScriptReferrerBase = aPageSpec.getBaseURI().getBaseHREF())) {
            String bURIString = lResult.toExternalForm();
            if (aURI.hasQuery()) {
                if (aURI.getQuery().indexOf("psScriptReferrer") != -1) {
                    return lResult;
                }
                if (!bURIString.endsWith("&")) {
                    bURIString = bURIString + "&";
                }
            } else {
                bURIString = bURIString + "?";
            }
            bURIString = bURIString + "psScriptReferrer=" + bScriptReferrerBase;
            lResult = new DecoratedURI(bURIString);
        }
        return lResult;
    }

    public static void main(String[] args) throws Exception {
        PageSpec samplePageSpec = new PageSpec("http://rajanagendra.sun.com/Base/Raja/raja.html?name=raja", "");
        AbsoluteTranslator defaultTranslator = new AbsoluteTranslator(samplePageSpec);
        String result = defaultTranslator.translate("..");
        System.out.println(result);
    }
}

