/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.userinfo;

import com.sun.portal.desktop.util.I18n;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.userinfo.tag.ReadTag;
import com.sun.portal.providers.userinfo.tag.TagException;
import com.sun.portal.providers.userinfo.tag.UnhandledTagException;
import com.sun.portal.providers.userinfo.tag.WriteTag;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;

public class TimezoneTag
implements ReadTag,
WriteTag {
    private ProviderContext context = null;
    private String channel = null;
    private ResourceBundle bundle = null;
    private Locale locale = null;

    public void init(String string, ProviderContext providerContext, HttpServletRequest httpServletRequest) throws TagException {
        this.channel = string;
        if (providerContext == null) {
            throw new TagException("TimezoneTag.init(): provider context was null");
        }
        this.context = providerContext;
        this.locale = providerContext.getLocale();
        try {
            this.bundle = ResourceBundle.getBundle(providerContext.getProviderName(string), this.locale);
        }
        catch (ProviderContextException providerContextException) {
            throw new TagException("TimezoneTag.init(): Failed to get resource bundle for " + string + " with locale " + this.locale);
        }
    }

    public void set(String string, String string2) throws TagException {
        if (!string.equals("preferredtimezone")) {
            throw new UnhandledTagException("unhandled tag=" + string);
        }
        this.context.setStringAttribute(string, string2);
    }

    public String get(String string) throws TagException {
        if (string.equals("timezoneList")) {
            String string2 = this.bundle.getString("timezoneFormat");
            String[] stringArray = TimeZone.getAvailableIDs();
            String string3 = "";
            StringBuffer stringBuffer = new StringBuffer("<SELECT NAME=\"preferredtimezone\">");
            String string4 = this.context.getStringAttribute("preferredtimezone");
            if (string4 == null || string4.length() == 0) {
                string4 = TimeZone.getDefault().getID();
            }
            int n = 0;
            while (n < stringArray.length) {
                TimeZone timeZone = TimeZone.getTimeZone(stringArray[n]);
                string3 = stringArray[n].equals(string4) ? "SELECTED" : "";
                stringBuffer.append("<OPTION ").append(string3).append(" VALUE=\"").append(stringArray[n]).append("\">");
                if (timeZone.useDaylightTime()) {
                    stringBuffer.append('*');
                }
                stringBuffer.append(I18n.format((String)string2, (TimeZone)timeZone, (Locale)this.locale)).append("</OPTION>");
                ++n;
            }
            stringBuffer.append("</SELECT>");
            return stringBuffer.toString();
        }
        throw new UnhandledTagException("unknown key=" + string);
    }
}

