/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.js.parser;

import com.sun.portal.rewriter.engines.js.parser.JavaScriptException;
import java.io.IOException;
import java.io.Reader;

final class LineBuffer {
    private char[] otherBuffer = null;
    private char[] buffer = null;
    private int lineNo = 0;
    private int lineOffset = 0;
    private int end = 0;
    private int otherEnd;
    private int bufferNo = -1;
    private int lineBufferNo = 0;
    private int myLineStart = 0;
    private int myPrevStart = 0;
    private int lineStart = 0;
    private int otherStart = 0;
    private int prevStart = 0;
    private boolean lastWasCR = false;
    private boolean hitEOF = false;
    private int stringStart = -1;
    private StringBuffer stringSoFar = null;
    private static final int BUFLEN = 256;
    private final Reader in;
    private final String sourceURI;

    LineBuffer(Reader aIN, String aSourceURI) {
        this.in = aIN;
        this.sourceURI = aSourceURI;
    }

    int read() throws IOException, JavaScriptException {
        if (this.end == this.lineOffset && !this.fill()) {
            return -1;
        }
        if ((this.buffer[this.lineOffset] & 0xFFF0) == 0) {
            if (this.buffer[this.lineOffset] == '\r') {
                if (this.lineOffset + 1 < this.end) {
                    if (this.buffer[this.lineOffset + 1] == '\n') {
                        ++this.lineOffset;
                    }
                } else {
                    this.lastWasCR = true;
                }
            } else if (this.buffer[this.lineOffset] != '\n') {
                return this.buffer[this.lineOffset++];
            }
            ++this.lineOffset;
            this.prevStart = this.lineStart;
            this.myPrevStart = this.myLineStart;
            this.lineStart = this.lineOffset;
            this.myLineStart = this.lineOffset;
            ++this.lineNo;
            this.lineBufferNo = this.bufferNo;
            return 10;
        }
        return this.buffer[this.lineOffset++];
    }

    void unread() {
        if (this.lineOffset == 0) {
            return;
        }
        --this.lineOffset;
        if ((this.buffer[this.lineOffset] & 0xFFF0) == 0 && (this.buffer[this.lineOffset] == '\r' || this.buffer[this.lineOffset] == '\n')) {
            this.lineStart = this.prevStart;
            this.myLineStart = this.myPrevStart;
            --this.lineNo;
        }
    }

    int peek() throws IOException, JavaScriptException {
        if (this.end == this.lineOffset && !this.fill()) {
            return -1;
        }
        if (this.buffer[this.lineOffset] == '\r') {
            return 10;
        }
        return this.buffer[this.lineOffset];
    }

    boolean match(char c) throws IOException, JavaScriptException {
        if (this.end == this.lineOffset && !this.fill()) {
            return false;
        }
        if (this.buffer[this.lineOffset] == c) {
            ++this.lineOffset;
            return true;
        }
        return false;
    }

    String getLine() {
        StringBuffer result = new StringBuffer();
        int start = this.lineStart;
        if (start >= this.lineOffset) {
            if (this.otherStart < this.otherEnd) {
                result.append(this.otherBuffer, this.otherStart, this.otherEnd - this.otherStart);
            }
            start = 0;
        }
        result.append(this.buffer, start, this.lineOffset - start);
        int i = this.lineOffset;
        while (true) {
            if (i == this.buffer.length) {
                char[] newBuffer = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                this.buffer = newBuffer;
                int charsRead = 0;
                try {
                    charsRead = this.in.read(this.buffer, this.end, this.buffer.length - this.end);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                if (charsRead < 0) break;
                this.end += charsRead;
            }
            if (this.buffer[i] == '\r' || this.buffer[i] == '\n') break;
            ++i;
        }
        result.append(this.buffer, this.lineOffset, i - this.lineOffset);
        return result.toString();
    }

    int getLineOffset() {
        if (this.lineStart >= this.lineOffset) {
            int buffNoDiff = this.bufferNo - this.lineBufferNo;
            if (buffNoDiff > 1) {
                int swap_offset = (buffNoDiff - 1) * 256;
                return 256 - this.myLineStart + this.lineOffset + swap_offset;
            }
            return this.lineOffset + (this.otherEnd - this.otherStart);
        }
        return this.lineOffset - this.lineStart;
    }

    void startString() throws JavaScriptException {
        if (this.lineOffset == 0) {
            if (this.buffer == null || this.otherBuffer == null) {
                throw new JavaScriptException("startString() called before any read", this.sourceURI, this);
            }
            this.stringSoFar = new StringBuffer();
            this.stringSoFar.append(this.otherBuffer, this.otherEnd - 1, 1);
            this.stringStart = -1;
        } else {
            this.stringSoFar = null;
            this.stringStart = this.lineOffset - 1;
        }
    }

    String getString() throws JavaScriptException {
        String result;
        int loseCR;
        if (this.buffer == null) {
            throw new JavaScriptException("very confused", this.sourceURI, this);
        }
        int n = loseCR = this.lineOffset > 0 && this.buffer[this.lineOffset] == '\n' && this.buffer[this.lineOffset - 1] == '\r' ? 1 : 0;
        if (this.stringStart != -1) {
            if (this.stringSoFar != null) {
                throw new JavaScriptException("getString() called inconsistently", this.sourceURI, this);
            }
            result = new String(this.buffer, this.stringStart, this.lineOffset - this.stringStart - loseCR);
        } else {
            if (this.stringSoFar == null) {
                throw new JavaScriptException("getString() called at a funny time", this.sourceURI, this);
            }
            result = this.stringSoFar.append(this.buffer, 0, this.lineOffset - loseCR).toString();
        }
        this.stringStart = -1;
        this.stringSoFar = null;
        return result;
    }

    boolean fill() throws IOException, JavaScriptException {
        int loseCR;
        if (this.end - this.lineOffset != 0) {
            throw new IOException("fill of non-empty buffer");
        }
        int n = loseCR = this.lineOffset > 0 && this.lastWasCR ? 1 : 0;
        if (this.stringStart != -1) {
            if (this.stringSoFar != null || this.buffer == null) {
                throw new JavaScriptException("as usual, I'm confused", this.sourceURI, this);
            }
            this.stringSoFar = new StringBuffer();
            this.stringSoFar.append(this.buffer, this.stringStart, this.end - this.stringStart - loseCR);
            this.stringStart = -1;
        } else if (this.stringSoFar != null) {
            this.stringSoFar.append(this.buffer, 0, this.end - loseCR);
        }
        char[] tempBuffer = this.buffer;
        this.buffer = this.otherBuffer;
        this.otherBuffer = tempBuffer;
        ++this.bufferNo;
        if (this.buffer == null) {
            this.buffer = new char[256];
        }
        this.otherStart = this.lineStart;
        this.otherEnd = this.end;
        this.lineStart = this.otherBuffer == null ? 0 : this.buffer.length + 1;
        this.prevStart = this.lineStart;
        this.lineOffset = 0;
        this.end = this.in.read(this.buffer, 0, this.buffer.length);
        if (this.end < 0) {
            this.end = 0;
            this.hitEOF = true;
            return false;
        }
        if (this.lastWasCR) {
            if (this.buffer[0] == '\n') {
                ++this.lineOffset;
                if (this.end == 1) {
                    return this.fill();
                }
            }
            this.lineStart = this.lineOffset;
            this.myLineStart = this.lineOffset;
            this.lastWasCR = false;
        }
        return true;
    }

    int getLineNo() {
        return this.lineNo;
    }

    boolean eof() {
        return this.hitEOF;
    }
}

