/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter;

import com.sun.portal.rewriter.Rewriter;
import com.sun.portal.rewriter.RewriterPool;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.rom.InvalidXMLException;
import com.sun.portal.rewriter.services.DataServiceException;
import com.sun.portal.rewriter.util.Constants;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.uri.PageSpec;
import com.sun.portal.rewriter.util.xml.Document;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.UserProfile;
import com.sun.portal.rproxy.connectionhandler.ErrorResponse;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.rewriter.SRAPAdapterHelper;
import com.sun.portal.rproxy.rewriter.SRAPTranslatorBuilder;
import com.sun.portal.rproxy.rewriter.util.SRAPConfigManager;
import com.sun.portal.rproxy.rewriter.util.http.ContentInfo;
import com.sun.portal.rproxy.rewriter.util.http.HTTPData;
import com.sun.portal.util.GWLocale;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class SRAPAdapter {
    private static final String UN_SUPPORTED_ENCODING_EXCEPTION_LOCALE_KEY = "UnSupportedEncodingWarningMessage";
    private static final String INVALID_XML_EXCEPTION_LOCALE_KEY = "InvalidRuleSetWarningMessage";
    private static final String DATASERVICE_EXCEPTION_LOCALE_KEY = "DataServiceErrorMessage";
    public static final RewriterPool rewriterPool = RewriterPool.getDefault();
    private static final String[] messages = new String[]{"No Parser available for this MIME", "No Ruleset Mapped for this URI", "Invalid Encoding"};

    public static InputStream rewrite(Request request, Response response) throws IOException {
        HTTPData hTTPData = null;
        String string = null;
        try {
            PageSpec pageSpec = new PageSpec(request.getURL());
            hTTPData = new HTTPData(pageSpec, response);
            ContentInfo contentInfo = hTTPData.getContentInfo();
            SRAPAdapterHelper.updateMIME(pageSpec, contentInfo);
            String string2 = SRAPConfigManager.selectParser4MIME(contentInfo.getMIME());
            if (string2 == null || (string = SRAPConfigManager.selectRuleSet4URI(pageSpec)) == null) {
                SRAPAdapter.recordUnTouchedPage(hTTPData, string2 == null ? messages[0] : messages[1]);
                if (hTTPData.isStreamRead()) {
                    return new ByteArrayInputStream(hTTPData.getContentBytes());
                }
                return null;
            }
            if (contentInfo.isInvalidEncoding() && string2.equalsIgnoreCase("text/xml")) {
                contentInfo.setEncoding(Document.parseEncoding((String)hTTPData.getRawEncodedString()));
            }
            return SRAPAdapter.rewriteContent(hTTPData, string2, string, contentInfo, request);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SRAPAdapter.recordUnTouchedPage(hTTPData, messages[2]);
            return SRAPAdapter.handleException(response, request, UN_SUPPORTED_ENCODING_EXCEPTION_LOCALE_KEY, new Object[]{hTTPData.getContentInfo().getEncoding()}, unsupportedEncodingException);
        }
        catch (InvalidXMLException invalidXMLException) {
            return SRAPAdapter.handleException(response, request, INVALID_XML_EXCEPTION_LOCALE_KEY, new Object[]{string}, (Exception)((Object)invalidXMLException));
        }
        catch (DataServiceException dataServiceException) {
            return SRAPAdapter.handleException(response, request, DATASERVICE_EXCEPTION_LOCALE_KEY, new Object[]{""}, (Exception)((Object)dataServiceException));
        }
    }

    private static InputStream rewriteContent(HTTPData hTTPData, String string, String string2, ContentInfo contentInfo, Request request) throws InvalidXMLException, IOException {
        PageSpec pageSpec = new PageSpec(request.getURL(), contentInfo.getMIME(), contentInfo.getEncoding());
        Translator translator = SRAPTranslatorBuilder.create(request, pageSpec);
        Rewriter rewriter = rewriterPool.getRewriter(string2, string);
        String string3 = rewriter.rewrite(hTTPData.getPageContent(), translator);
        if (Constants.SYSTEM_ENCODING == contentInfo.getEncoding()) {
            return new ByteArrayInputStream(string3.getBytes());
        }
        return new ByteArrayInputStream(string3.getBytes(contentInfo.getEncoding()));
    }

    private static void recordUnTouchedPage(HTTPData hTTPData, String string) {
        if (Debug.isWarningEnabled() && hTTPData != null) {
            String string2 = "\n(WARNING)" + hTTPData.getPageSpec() + "\n\t\tIS NOT BEING REWRITTEN..\n\n" + hTTPData.getContentInfo() + "Cause: " + string + "\n";
            Debug.recordUnaffectedPageWarning((String)string2);
        }
    }

    private static final InputStream handleException(Response response, Request request, String string, Object[] objectArray, Exception exception) {
        if (Debug.isWarningEnabled()) {
            Debug.recordOriginalPageWarning((String)string, (Exception)exception);
        }
        String string2 = request.getSessionID();
        String string3 = SRAPAdapter.getUserLocale(string2);
        String string4 = GWLocale.getPFString(string, objectArray, string3);
        return new ErrorResponse(string4, null, request.getRequestHeader("Accept-Language")).getContentStream();
    }

    private static final String getUserLocale(String string) {
        try {
            UserProfile userProfile = new UserProfile(string);
            return userProfile.getString("preferredlocale", "en_US");
        }
        catch (Exception exception) {
            return GatewayProfile.getString("locale", "en_US");
        }
    }
}

