/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.econnection.ESessionMsg;
import com.sun.portal.netlet.eproxy.EProxy;
import com.sun.portal.netlet.eproxy.ESession;
import com.sun.portal.netlet.eproxy.ProxyConnection;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.server.RequestProcessor;
import com.sun.portal.rproxy.server.ServerSocketFactory;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.LogInfoContainer;
import com.sun.portal.util.ServiceIdentifier;
import com.sun.portal.util.SystemProperties;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class RProxyConnection
extends ProxyConnection {
    private boolean secureConnection;
    private int port = 0;
    private RequestProcessor requestProcessor;
    static boolean useAcceleratorSupport = false;
    private static final String TIMEOUT = "RProxyPortTimeout";
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final int timeout;

    public static void startHttps(final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                RProxyConnection rProxyConnection = new RProxyConnection(true, n);
                rProxyConnection.start();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public static void startHttps(final int n, final int n2) {
        Runnable runnable = new Runnable(){

            public void run() {
                RProxyConnection rProxyConnection = new RProxyConnection(true, n, n2);
                rProxyConnection.start();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public static void startHttp(final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                RProxyConnection rProxyConnection = new RProxyConnection(false, n);
                rProxyConnection.start();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private RProxyConnection(boolean bl, int n) {
        super("RProxyHTTPSThread", "epc1");
        this.secureConnection = bl;
        this.port = n;
        this.requestProcessor = this.secureConnection ? new RequestProcessor("https", n) : new RequestProcessor("http", n);
    }

    private RProxyConnection(boolean bl, int n, int n2) {
        super("RProxyHTTPSThread", "epc1");
        this.secureConnection = bl;
        this.port = n2;
        this.requestProcessor = this.secureConnection ? new RequestProcessor("https", n) : new RequestProcessor("http", n);
    }

    protected ServerSocket makeServerSocket() {
        if (this.secureConnection && useAcceleratorSupport && ServiceIdentifier.isGateway()) {
            return ServerSocketFactory.createSRAPServerSocket(this.port);
        }
        return this.secureConnection ? ServerSocketFactory.createSSLSocketServer(this.port) : ServerSocketFactory.createSRAPServerSocket(this.port);
    }

    private boolean isNetletTraffic(Socket socket) {
        ESessionMsg eSessionMsg;
        block15: {
            InputStream inputStream = null;
            try {
                inputStream = socket.getInputStream();
            }
            catch (IOException iOException) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("RProxyConnection cannot open input stream on " + socket, iOException);
                }
                try {
                    socket.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementPlainSockets();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
            eSessionMsg = new ESessionMsg();
            try {
                inputStream.mark(512);
            }
            catch (Exception exception) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("Cannot mark " + socket, exception);
                }
                try {
                    socket.close();
                    if (PerfContextObject.ENABLE_PERF) {
                        SocketCount.decrementPlainSockets();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                eSessionMsg = null;
                return false;
            }
            if (eSessionMsg.readMsg(new DataInputStream(inputStream)) == 0) {
                eSessionMsg = null;
                return true;
            }
            try {
                inputStream.reset();
            }
            catch (Exception exception) {
                if (!GWDebug.debug.errorEnabled()) break block15;
                GWDebug.debug.error("Cannot reset " + socket, exception);
            }
        }
        eSessionMsg = null;
        return false;
    }

    protected void process(Socket socket, Integer n) {
        try {
            GWThreadPool.run(new RProxyThread(socket, n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        String string = SystemProperties.get("gateway.enable.accelerator", "false");
        if (string != null) {
            useAcceleratorSupport = string.trim().equalsIgnoreCase("true");
        }
        timeout = GatewayProfile.getInt(TIMEOUT, 60000);
    }

    class RProxyThread
    implements Runnable {
        private Socket connection;
        private Integer logId;

        public RProxyThread(Socket socket, Integer n) {
            this.connection = socket;
            this.logId = n;
        }

        public void run() {
            int n;
            boolean bl;
            block20: {
                block19: {
                    bl = false;
                    if (ServiceIdentifier.isRewriterProxy() || ServiceIdentifier.isGateway() && EProxy.isNetletEnabled) {
                        GWLogManager.logIdMap.put(new Integer(this.connection.getPort()), new LogInfoContainer(this.logId, this.connection));
                    }
                    n = 0;
                    try {
                        n = this.connection.getSoTimeout();
                    }
                    catch (Exception exception) {
                        if (!GWDebug.debug.errorEnabled()) break block19;
                        GWDebug.debug.error("RProxy caught exception while setting getSoTimeout() : ", exception);
                    }
                }
                try {
                    this.connection.setSoTimeout(timeout);
                }
                catch (Exception exception) {
                    if (!GWDebug.debug.errorEnabled()) break block20;
                    GWDebug.debug.error("RProxy caught exception while setting setSoTimeout() : ", exception);
                }
            }
            if (ServiceIdentifier.isGateway()) {
                bl = EProxy.isNetletEnabled;
            } else if (ServiceIdentifier.isNetletProxy()) {
                bl = true;
            }
            if (bl && RProxyConnection.this.isNetletTraffic(this.connection)) {
                block21: {
                    GWDebug.debug.message("RPRoxy received netlet request. Starting netlet session...");
                    try {
                        this.connection.setSoTimeout(n);
                    }
                    catch (Exception exception) {
                        if (!GWDebug.debug.errorEnabled()) break block21;
                        GWDebug.debug.error("isNetletTraffic caught exception while setting setSoTimeout() : ", exception);
                    }
                }
                ESession eSession = new ESession(this.connection, this.logId);
                try {
                    GWThreadPool.run(eSession);
                }
                catch (InterruptedException interruptedException) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("Cannot run ESession", interruptedException);
                    }
                    try {
                        this.connection.close();
                        if (PerfContextObject.ENABLE_PERF) {
                            SocketCount.decrementPlainSockets();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
            }
            if (!ServiceIdentifier.isNetletProxy()) {
                RProxyConnection.this.requestProcessor.processRequestInGWTheadPool(this.connection, this.logId);
            } else {
                RProxyConnection.this.closeSocket(this.connection);
            }
        }
    }
}

