/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.rewriter.util.http;

import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.xml.Tag;
import com.sun.portal.rewriter.util.xml.TagParser;
import com.sun.portal.rproxy.rewriter.util.http.ContentInfo;
import com.sun.portal.rproxy.rewriter.util.http.HTTPData;
import java.io.IOException;

public final class MIMEAndEncodingParser {
    private static final String CONTENT_TYPE_PATTERN = "Content-type:";
    private static final String CONTENT_PATTERN = "Content";
    private static final String CHARSET_PATTERN = "charset";
    private static final String CHARSET_EQUALS_PATTERN = "charset=";

    private static String parseMIME(String string, String string2) {
        int n = string2.indexOf(59);
        if (n == -1) {
            return StringHelper.trimQuotes((String)string);
        }
        return StringHelper.trimQuotes((String)string.substring(0, n));
    }

    private static final String parseEncoding(String string, String string2) {
        String string3 = null;
        int n = string2.indexOf(CHARSET_EQUALS_PATTERN);
        if (n != -1) {
            int n2 = string2.indexOf(59, n);
            if (n2 == -1) {
                n2 = string2.length();
            }
            if (n2 - n > CHARSET_EQUALS_PATTERN.length()) {
                string3 = string.substring(n + CHARSET_EQUALS_PATTERN.length(), n2);
            }
        }
        return MIMEAndEncodingParser.validateEncoding(string3);
    }

    private static String validateEncoding(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() > 0) {
            string = StringHelper.trimQuotes((String)string);
            int n = -1;
            while (++n < string.length()) {
                char c = string.charAt(n);
                if (!Character.isLetterOrDigit(c) && c != '-' && c != '_') break;
            }
            if (n > 0 && n <= string.length()) {
                return string.substring(0, n);
            }
        }
        return null;
    }

    private static void parseMIMEAndEncoding(ContentInfo contentInfo, String string) {
        String string2 = StringHelper.trimQuotes((String)string);
        String string3 = string2.toLowerCase();
        contentInfo.setMIME(MIMEAndEncodingParser.parseMIME(string2, string3));
        contentInfo.setEncoding(MIMEAndEncodingParser.parseEncoding(string2, string3));
    }

    public static final ContentInfo parse(HTTPData hTTPData) throws IOException {
        int n;
        int n2;
        int n3;
        MIMEAndEncodingParser.parseHeadder(hTTPData);
        if (!MIMEAndEncodingParser.isNeeds2ScanBody(hTTPData)) {
            return hTTPData.getContentInfo();
        }
        String string = hTTPData.getRawEncodedString();
        String string2 = hTTPData.getRawEncodedStringLowerCase();
        int n4 = 0;
        while ((n3 = string2.indexOf("<meta", n4)) != -1 && (n2 = string2.indexOf(">", n3)) != -1 && (n = string2.indexOf(CHARSET_EQUALS_PATTERN, n3)) != -1) {
            if (n2 < n) {
                n4 = n2;
                continue;
            }
            String string3 = string.substring(n3, n2 - 1);
            Tag tag = TagParser.parse((String)string3);
            String string4 = tag.get(CONTENT_PATTERN);
            MIMEAndEncodingParser.parseMIMEAndEncoding(hTTPData.getContentInfo(), string4);
            if (!hTTPData.getContentInfo().isInvalidEncoding()) break;
            hTTPData.getContentInfo().setEncoding(MIMEAndEncodingParser.validateEncoding(tag.get(CHARSET_PATTERN)));
            break;
        }
        return hTTPData.getContentInfo();
    }

    public static void parseHeadder(HTTPData hTTPData) {
        String string = hTTPData.getContentType();
        if (string != null && string.length() > 0) {
            int n = string.indexOf(CONTENT_TYPE_PATTERN);
            String string2 = n == -1 ? string : string.substring(n + CONTENT_TYPE_PATTERN.length());
            MIMEAndEncodingParser.parseMIMEAndEncoding(hTTPData.getContentInfo(), string2);
        }
    }

    private static boolean isNeeds2ScanBody(HTTPData hTTPData) throws IOException {
        ContentInfo contentInfo = hTTPData.getContentInfo();
        if (contentInfo.isInvalidMIME() || contentInfo.isInvalidEncoding() && (contentInfo.getMIME().equalsIgnoreCase("text/html") || contentInfo.getMIME().equalsIgnoreCase("text/htm"))) {
            return hTTPData.getContentBytes() != null && hTTPData.getContentBytes().length != 0;
        }
        return false;
    }
}

