/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.util.GWDebug;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImplFactory;
import org.mozilla.jss.ssl.SSLSocket;

public class SRAPSocket
extends Socket {
    private Socket sock = null;
    private BufferedInputStream in = null;
    private BufferedOutputStream out = null;
    private boolean isHTTPS;

    public SRAPSocket(Socket socket) throws IOException {
        this.sock = socket;
        this.isHTTPS = socket instanceof SSLSocket;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new BufferedInputStream(this.sock.getInputStream());
        }
        return this.in;
    }

    public void close() throws IOException {
        if (PerfContextObject.ENABLE_PERF) {
            if (this.isHTTPS) {
                SocketCount.decrementSSLSockets();
            } else {
                SocketCount.decrementPlainSockets();
            }
        }
        this.sock.close();
    }

    public InetAddress getInetAddress() {
        return this.sock.getInetAddress();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.sock.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.sock.getLocalAddress();
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
        }
        return this.out;
    }

    public int getPort() {
        return this.sock.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.sock.getReceiveBufferSize();
    }

    public int getSendBufferSize() throws SocketException {
        return this.sock.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.sock.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.sock.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.sock.getTcpNoDelay();
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        this.sock.setKeepAlive(bl);
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.sock.setReceiveBufferSize(n);
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.sock.setSendBufferSize(n);
    }

    public static void setSocketImplFactory(SocketImplFactory socketImplFactory) throws UnsupportedOperationException {
        if (GWDebug.debug.messageEnabled()) {
            GWDebug.debug.message("setSocketImplFactory(SocketImplFactory fac) called in SRAPSocket");
        }
        throw new UnsupportedOperationException("Not supported");
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.sock.setSoLinger(bl, n);
    }

    public void setSoTimeout(int n) throws SocketException {
        this.sock.setSoTimeout(n);
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.sock.setTcpNoDelay(bl);
    }

    public void shutdownInput() throws IOException {
        this.in.skip(this.in.available());
        this.sock.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.out.flush();
        this.sock.shutdownOutput();
    }

    public String toString() {
        try {
            return this.sock.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isSSLSocket() {
        return this.isHTTPS;
    }

    public Socket getActualSocket() {
        return this.sock;
    }
}

