/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.econnection;

import com.sun.portal.netlet.econnection.CipherMsg;
import com.sun.portal.netlet.econnection.MessageConstants;
import com.sun.portal.netlet.econnection.SizeConstants;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DataCipherMsg
extends CipherMsg
implements MessageConstants,
SizeConstants {
    protected static final int MAX_DATA_LEN = 8192;
    protected byte[] data = null;

    public DataCipherMsg() {
        super((byte)1, (short)3);
    }

    public DataCipherMsg(byte[] byArray, int n) {
        super((byte)1, (short)3);
        if (n <= 8192) {
            this.data = new byte[n];
            this.msgLen = n;
            System.arraycopy(byArray, 0, this.data, 0, n);
        }
        this.msgLen = 0;
    }

    public int readMsg(DataInputStream dataInputStream) {
        int n = 0;
        n = this.readHeader(dataInputStream);
        if (n == 0 && this.msgLen >= 0 && this.msgLen <= 8192) {
            if (this.data == null) {
                this.data = new byte[this.msgLen];
            } else if (this.msgLen > this.data.length) {
                this.data = null;
                this.data = new byte[this.msgLen];
            }
            try {
                dataInputStream.readFully(this.data, 0, this.msgLen);
            }
            catch (IOException iOException) {
                System.out.println("DataMsg: readMsg IOE:" + iOException);
                n = -1;
            }
        }
        return n;
    }

    public int writeMsg(DataOutputStream dataOutputStream) {
        int n = 0;
        if (this.msgLen >= 0 && this.msgLen < 8192) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8203);
                int n2 = this.msgLen;
                this.writeHeaderToByteArray(byteArrayOutputStream);
                byteArrayOutputStream.write(this.data, 0, this.msgLen);
                byteArrayOutputStream.writeTo(dataOutputStream);
                dataOutputStream.flush();
                this.msgLen = n2;
            }
            catch (IOException iOException) {
                System.out.println("DataMsg: writeMsg IOException");
                n = -1;
            }
        } else {
            n = -1;
        }
        return n;
    }

    public byte[] getData() {
        byte[] byArray = null;
        if (this.msgLen >= 0 && this.msgLen <= 8192) {
            byArray = new byte[this.msgLen];
            System.arraycopy(this.data, 0, byArray, 0, this.msgLen);
        }
        return byArray;
    }

    public void setData(byte[] byArray, int n) {
        if (n > 0 && n <= 8192) {
            this.msgLen = n;
            this.data = new byte[n];
            System.arraycopy(byArray, 0, this.data, 0, n);
        } else {
            this.data = null;
            this.msgLen = 0;
        }
    }

    public byte[] getDataByRef() {
        return this.data;
    }

    public void setDataByRef(byte[] byArray, int n) {
        this.data = byArray;
        this.msgLen = n;
    }

    public void writeCloseConnectionMsg(DataOutputStream dataOutputStream) {
        if (dataOutputStream != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(11);
                this.msgLen = -1;
                this.writeHeaderToByteArray(byteArrayOutputStream);
                byteArrayOutputStream.writeTo(dataOutputStream);
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

