/*
 * Decompiled with CFR 0.152.
 */
import com.sun.portal.netlet.econnection.Base64;
import java.io.InputStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;

public class NetletUtil {
    private static PropertyResourceBundle resources = null;
    private static Locale locale;

    public NetletUtil(SServer sServer) {
        try {
            InputStream inputStream = sServer.netletConfig("loadResources", true);
            resources = new PropertyResourceBundle(inputStream);
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            locale = new Locale(NetletUtil.getString("lang"), NetletUtil.getString("country"), NetletUtil.getString("variant"));
        }
        catch (Exception exception) {
            resources = null;
            System.out.println("Netlet cannot read resources URL: " + exception);
        }
    }

    public static String getString(String string) {
        try {
            return resources == null ? "" : resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new MissingResourceException(missingResourceException.getMessage() + ": " + string, "Netlet", string);
        }
    }

    public static String format(String string, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat(NetletUtil.getString(string));
        messageFormat.setLocale(locale);
        return messageFormat.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
    }

    public static String format(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return NetletUtil.format(string, objectArray);
    }

    public static String rfc1522(String string) {
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c > '\u007f') {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            return string;
        }
        return "=?UTF-8?B?" + Base64.encode(string) + "?=";
    }
}

