/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.econnection;

import com.sun.portal.netlet.econnection.DataCipherMsg;
import com.sun.portal.netlet.econnection.MessageConstants;
import com.sun.portal.netlet.econnection.ReaderWriterCrypt;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.util.GWDebug;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class ReaderWriterEncrypt
extends ReaderWriterCrypt
implements MessageConstants {
    private long activityTime = System.currentTimeMillis();
    private int netletKeepAliveInterval = 0;

    public ReaderWriterEncrypt(ReaderWriterLock readerWriterLock, InputStream inputStream, OutputStream outputStream, int n) {
        super(readerWriterLock, inputStream, outputStream);
        this.netletKeepAliveInterval = n;
    }

    public void run() {
        DataCipherMsg dataCipherMsg = new DataCipherMsg();
        try {
            int n = 0;
            byte[] byArray = new byte[8192];
            while (this.go) {
                try {
                    n = this.in.read(byArray, 0, 4096);
                    if (n > 0) {
                        dataCipherMsg.setDataByRef(byArray, n);
                        if (dataCipherMsg.writeMsg(this.out) != 0) continue;
                        this.sent = true;
                        this.activityTime = System.currentTimeMillis();
                        continue;
                    }
                    if (n == 0) {
                        System.out.println("ReaderWriterEncrypt received 0 bytes");
                        continue;
                    }
                    this.go = false;
                    Object var7_7 = null;
                    dataCipherMsg.writeCloseConnectionMsg(this.out);
                    this.stop();
                    this.rwLock.notifyFinished(this);
                    this.rwLock = null;
                    return;
                }
                catch (InterruptedIOException interruptedIOException) {
                    int n2 = this.writeDummyMsg(this.out);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("DEBUG: Writing dummy message: " + n2);
                    }
                    if (n2 != -1) continue;
                    this.go = false;
                    Object var7_8 = null;
                    dataCipherMsg.writeCloseConnectionMsg(this.out);
                    this.stop();
                    this.rwLock.notifyFinished(this);
                    this.rwLock = null;
                    return;
                }
                catch (Exception exception) {
                    System.out.println("ReaderWriterEncrypt caught exception:");
                    exception.printStackTrace();
                    this.go = false;
                    Object var7_9 = null;
                    dataCipherMsg.writeCloseConnectionMsg(this.out);
                    this.stop();
                    this.rwLock.notifyFinished(this);
                    this.rwLock = null;
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            dataCipherMsg.writeCloseConnectionMsg(this.out);
            this.stop();
            this.rwLock.notifyFinished(this);
            this.rwLock = null;
            throw throwable;
        }
        Object var7_10 = null;
        dataCipherMsg.writeCloseConnectionMsg(this.out);
        this.stop();
        this.rwLock.notifyFinished(this);
        this.rwLock = null;
    }

    protected int writeDummyMsg(DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeShort(4);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
        }
        catch (IOException iOException) {
            System.out.println("ReaderWriterEncrypt caught exception while sending dummy msg:");
            iOException.printStackTrace();
            return -1;
        }
        return 0;
    }

    public long getLastActivityTime() {
        return this.activityTime;
    }
}

