# Copyright 11/20/00 Sun Microsystems, Inc. All Rights Reserved.
#pragma ident  "@(#)serengeti-platadmin-d.prc	1.25 00/11/20 Sun Microsystems"
#

proc dprint { channel message } {
    ddl print $channel "serengeti-platadmin, $message"
}

#
#This function reads the configuration file and returns a list of
#community strings. The configuration file contains the community
#name. This functions prepends a view identifier and a - to that name.
#This way the public in configuration file becomes P-public for platform
#view. This is required by the serengeti security.
#This function is used to refresh the node communitystrings.
#

proc getCommunityStrings { } {
    global env
    set componentname [ lookup value component ]
    set configfile "$env(ESDIR)/cfg/serengeti-platadmincfg-$componentname-d.dat"
    if [ catch { open $configfile r } fileId ] {
        dprint error "Could not open file $configfile for reading"
        return [list P-public P-private A-private B-private C-private D-private ]
    } else {
        set listtoreturn ""
        foreach line [ split [read $fileId] \n ] {
            set varname  [lindex [split $line :] 0]
            set varvalue [lindex [split $line :] 1]
            switch -exact -- $varname {
                platformRComm {
		    set pltrcomm "$varvalue"
                }
                platformWComm {
		    set pltwcomm "$varvalue"
                }
                domainAWComm {
		    set dawcomm "$varvalue"
                }
                domainBWComm {
		    set dbwcomm "$varvalue"
                }
                domainCWComm {
		    set dcwcomm "$varvalue"
                }
                domainDWComm {
		    #set ddwcomm "D-$varvalue"
		    set ddwcomm "$varvalue"
                }
            } 
        }
        close $fileId
        lappend listtoreturn "$pltrcomm" "$pltwcomm" "$dawcomm" "$dbwcomm" "$dcwcomm" "$ddwcomm"
        return $listtoreturn
    }
        
}

#
#This function reads the configuration file and returns the IP
#address of the system controller. If in the configuration file
#the host name of SC is stored then this function will convert
#the hostname to IP address.
#

proc getRemoteIPAddress { } {
    global env
    set componentname [ lookup value component ]
    set configfile "$env(ESDIR)/cfg/serengeti-platadmincfg-$componentname-d.dat"
    if [ catch { open $configfile r } fileId ] {
        dprint error "Could not open file $configfile : $fileId"
        return 
    } else {
        foreach line [ split [read $fileId] \n ] {
            set varname  [lindex [split $line :] 0]
            set varvalue [lindex [split $line :] 1]
            switch -exact -- $varname {
                SCIPAddress {
                    if { [isIpAddress $varvalue ] } {
                        lappend remoteip $varvalue
                    } else {
			lappend remoteip [resolveHostName $varvalue]
                    }
                    close $fileId
                    return $remoteip
                }
            }
        }
        close $fileId
        return 
    }
}

#
#This function returns the number of passive columns in the tabel 
#specified by the tablename. The tables in this module use walk
#SNMP command to refresh themselves. Local tables may contain more
#number of columns then the source table which these tables are 
#refreshed from. The walk command of SNMP returns values of columns 
#together. But for refreshing the tables in this module we need 
#data for rows together. Using the number of passive columns returne
#by this function, the refreshcommand will format the data returned
#by walk into the list of data containig all data for one row together.
#NOTE: Any change in number of columns in the tables may require a 
#change here.
#

proc getNumberOfPassiveColumns { tablename } {
    switch -exact -- $tablename {
	chassisTable {
	    return 23
	}
	slotTable {
	    return 10
	}
	fruTable {
	    return 22
	}
	cpuBoardTable {
	    return 9
	}
	ioBoardTable {
	    return 8
	}
	l2BoardTable {
	    return 5
	}
	cpuModTable {
	    return 14
	}
	dimmTable {
	    return 5
	}
	ecacheTable {
	    return 5
	}
	fanTable {
	    return 5
	}
	psTable {
	    return 8
	}
	scTable {
	    return 17
	}
	wciModTable {
	    return 13
	}
	wciPortTable {
	    return 8
	}
	domainTable {
	    return 12
	}
    } 
}

#NOTE: Gives the number of columns before treenode info

proc getNumberColumnsBeforeTreeNode { tablename } {
    switch -exact -- $tablename {
	slotTable {
	    return 2
	}
	cpuBoardTable {
	    return 2
	}
	ioBoardTable {
	    return 2
	}
	l2BoardTable {
	    return 1
	}
	cpuModTable {
	    return 3
	}
	dimmTable {
	    return 3
	}
	ecacheTable {
	    return 3
	}
	wciModTable {
	    return 3
	}
	wciPortTable {
	    return 3
	}
    } 
    return 0
}


#
#This is the function used by all the original tables while refreshing.
#This gets the walk result and converts that into a list of data to refresh
#the table. The result of walk is in column major format while for refreshing
#the table in agent we need data in row major format. This function does that
#conversion.
#

proc mainTableFilter { res } {
    dprint debug "mainTableFilter called for node [getNodeName 0] with result = $res"
    set domainview 0
    set tablename [getNodeName 0]
    set tablenamelength [string length $tablename]
    set domname [string range $tablename [expr $tablenamelength - 1] $tablenamelength]
    
    #
    #All the tables in domain views end with the letter indicating the view. So remove
    #that letter before looking for the number of columns in that table.
    #

    if { $domname == "A" || $domname == "B" || $domname == "C" || $domname == "D" } {
        set commontablename [string range $tablename 0 [expr $tablenamelength - 2] ]
        set domainview 1
        dprint debug "This call is for one of the node in domain views"
    } else {
        set commontablename $tablename
        dprint debug "This call is for one of the node in platform view"
    }
    set numofcolumns [getNumberOfPassiveColumns $commontablename]
    if { $domainview == 1 && $commontablename == "domainTable" } {
        #
        #Adjust the keyswitch column for domain view.
        #This field is not accessible in platform view.
        #
        set numofcolumns [expr $numofcolumns + 1 ]
    }
    dprint debug "Total number of passive columns are $numofcolumns"
    set totaldatalength [llength $res]
    if { $totaldatalength == 0 } {
        define private refresh 1
        dprint debug "Total length of result data from refreshCommand is 0"
	dprint debug "mainTableFilter ended for node [getNodeName 0] "
        return $res
    }

    #
    #Find out total number of rows in the walk result.
    #

    set numberofrows [expr $totaldatalength / $numofcolumns ]
    if { $numberofrows == 0 } {
        set numberofrows 1
    } else {
        set requireddatalength [expr $numofcolumns * $numberofrows ]
        if {$requireddatalength < $totaldatalength} {
            set numberofrows [expr $numberofrows + 1]
        }
    }
    dprint debug "Total number of rows = $numberofrows"
    set indexinmainlist 0
    set localindex 0
    set listtoreturn ""
    for {set i 0} {$i < $numberofrows} {incr i 1} {
        set localindex $i
        for {set j 0} {$j < $numofcolumns} {incr j 1} {
            if { $localindex >= [llength $res] } {
                lappend  listtoreturn  " "
            } else {
                lappend  listtoreturn  [lindex $res $localindex]
            }
            #lappend  listtoreturn  [lindex $res $localindex]
            set localindex [expr $localindex + $numberofrows]
        }
    }

    #
    #Check to see if the table has got treeNodeInfo node in it. If
    #yes then call the handler for that.
    #

    set entrylist [toe_send [locate [ls]] ls]
    set treenodeinfoindex [ lsearch -regexp $entrylist TreeNodeInfo]
    if { $treenodeinfoindex >= 0 && $domainview == 0 } {
        dprint debug "starting the treenode info handling function"
	handleTreeNodeInfo $listtoreturn $numofcolumns $numberofrows
        dprint debug "finished the treenode info handling function"
    }
   
    #
    #define this variable to indicate the first time refresh.
    #

    define private refresh 1
    dprint debug "Final list returning is = $listtoreturn"

    setTrapInfo refreshOID
    
    dprint debug "mainTableFilter ended for node [getNodeName 0] "
    return $listtoreturn
}

#proc mainTableFilter { res } {
#    dprint debug "mainTableFilter called for node [getNodeName 0] with result = $res"
#    set domainview 0
#    set tablename [getNodeName 0]
#    set tablenamelength [string length $tablename]
#    set domname [string range $tablename [expr $tablenamelength - 1] $tablenamelength]
#
#    #
#    #All the tables in domain views end with the letter indicating the view. So remove
#    #that letter before looking for the number of columns in that table.
#    #
#
#    if { $domname == "A" || $domname == "B" || $domname == "C" || $domname == "D" } {
#        set commontablename [string range $tablename 0 [expr $tablenamelength - 2] ]
#        set domainview 1
#        dprint debug "This call is for one of the node in domain views"
#    } else {
#        set commontablename $tablename
#        dprint debug "This call is for one of the node in platform view"
#    }
#    set numofcolumns [getNumberOfPassiveColumns $commontablename]
#    if { $domainview == 1 && $commontablename == "domainTable" } {
#        #
#        #Adjust the keyswitch column for domain view.
#        #This field is not accessible in platform view.
#        #
#        set numofcolumns [expr $numofcolumns + 1 ]
#    }
#    dprint debug "Total number of passive columns are $numofcolumns"
#    set totaldatalength [llength $res]
#    if { $totaldatalength == 0 } {
#        define private refresh 1
#        dprint debug "Total length of result data from refreshCommand is 0"
#        return $res
#    }
#
#
#    set numberofrows [expr $totaldatalength / $numofcolumns ]
#    if { $numberofrows == 0 } {
#        set numberofrows 1
#    } else {
#        set requireddatalength [expr $numofcolumns * $numberofrows ]
#
#        if {$requireddatalength < $totaldatalength} {
#            set numberofrows [expr $numberofrows + 1]
#        }
#    }
#    dprint debug "Total number of rows = $numberofrows"
#
#    #
#    #Check to see if the table has got treeNodeInfo node in it. If
#    #yes then call the handler for that.
#    #
#
#    set entrylist [toe_send [locate [ls]] ls]
#    set treenodeinfoindex [ lsearch -regexp $entrylist TreeNodeInfo]
#    if { $treenodeinfoindex >= 0 && $domainview == 0 } {
#        dprint debug "starting the treenode info handling function"
#        handleTreeNodeInfo $res $numofcolumns $numberofrows
#        dprint debug "finished the treenode info handling function"
#    }
#
#    #
#    #define this variable to indicate the first time refresh.
#    #
#
#    define private refresh 1
#    dprint debug "Final list returning is = $res"
#
#    return $res
#}


#proc mainTableFilter { res } {
#    dprint debug "mainTableFilter called for node [getNodeName 0] with result = $res"
#    set domainview 0
#    set tablename [getNodeName 0]
#    set tablenamelength [string length $tablename]
#    set domname [string range $tablename [expr $tablenamelength - 1] $tablenamelength]
#    
#    #
#    #All the tables in domain views end with the letter indicating the view. So remove
#    #that letter before looking for the number of columns in that table.
#    #
#
#    if { $domname == "A" || $domname == "B" || $domname == "C" || $domname == "D" } {
#        set commontablename [string range $tablename 0 [expr $tablenamelength - 2] ]
#        set domainview 1
#        dprint debug "This call is for one of the node in domain views"
#    } else {
#        set commontablename $tablename
#        dprint debug "This call is for one of the node in platform view"
#    }
#    set numofcolumns [getNumberOfPassiveColumns $commontablename]
#    if { $domainview == 1 && $commontablename == "domainTable" } {
#        #
#        #Adjust the keyswitch column for domain view.
#        #This field is not accessible in platform view.
#        #
#        set numofcolumns [expr $numofcolumns + 1 ]
#    }
#    dprint debug "Total number of passive columns are $numofcolumns"
#    set totaldatalength [llength $res]
#    if { $totaldatalength == 0 } {
#        define private refresh 1
#        dprint debug "Total length of result data from refreshCommand is 0"
#        return $res
#    }
#
#    #
#    #Find out total number of rows in the walk result.
#    #
#
#    #New code to handle treenode. For domains we get all treenode
#    # information, we get it for rows which are not visible to domain.
#    # So we have to filter out the ones not needed. Thats more work.
#    # And as treenode info is not used for domain views, I just
#    # ignore them
#    if { $domainview == 1 } {
#      set numcol [ getNumberColumnsBeforeTreeNode $commontablename]
#      if { $numcol == 0 } {
#	dprint debug "No need to worry as table has no treenode info"
#      } else {
#	#Domain view remove, extra treenode info rows...
#	dprint debug "Domain table, so change datalength and result"
#	set newres ""
#	set numrows 0
#	set treenodefirstrow 0
#	set treenodelast 0
#	for {set i 0} {$i < $totaldatalength} {incr i 1} {
#	    set val [ lindex $res $i ] 
#	    set treenode [ llength [ split $val : ] ]
#	    if { $treenode == 1 } {
#		#Not treenode information
#		dprint debug "Not tree node, index is $i and value is [lindex $res $i]"
#		lappend  newres  [lindex $res $i]
#	    } else {
#		#Got treenode information
#		if { $treenodefirstrow == 0 } {
#		    #This is first treenode information
#		    dprint debug "tree node, index is $i and value is [lindex $res $i]"
#		    set treenodefirstrow 1
#		    set treenodelast $i
#		    #Get number of rows, 2 is hardcoded as there are 2 
#		    #columns before treenodeinfo
#		    set numrows [expr $i/$numcol ] 
#		    dprint debug "tree node, number of rows is $numrows" 
#		    for {set j 0} {$j < $numrows} {incr j 1} {
#			lappend  newres "null:null"
#		    }
#		} else {
#		    set nexttreerow [ incr treenodelast 1 ]
#		    if { $nexttreerow == $i } {
#			dprint debug "Not first treenode, Ignoring treenode info"
#		    } else {
#			dprint debug "Not treenode, something else"
#			lappend  newres  [lindex $res $i]
#		    }
#		}
#	    }
#	}
#	set res $newres
#	set totaldatalength [llength $res]
#	dprint debug "Treenode confusion ends: res is $res and totaldatalength is $totaldatalength"
#      }
#    }
#    #End of treenode  code .
#
#
#
#    set numberofrows [expr $totaldatalength / $numofcolumns ]
#    if { $numberofrows == 0 } {
#        set numberofrows 1
#    } else {
#        set requireddatalength [expr $numofcolumns * $numberofrows ]
#        if {$requireddatalength < $totaldatalength} {
#            set numberofrows [expr $numberofrows + 1]
#        }
#    }
#    dprint debug "Total number of rows = $numberofrows"
#    set indexinmainlist 0
#    set localindex 0
#    set listtoreturn ""
#    for {set i 0} {$i < $numberofrows} {incr i 1} {
#        set localindex $i
#        for {set j 0} {$j < $numofcolumns} {incr j 1} {
#            if { $localindex >= [llength $res] } {
#                lappend  listtoreturn  " "
#            } else {
#                lappend  listtoreturn  [lindex $res $localindex]
#            }
#            #lappend  listtoreturn  [lindex $res $localindex]
#            set localindex [expr $localindex + $numberofrows]
#        }
#    }
#
#    #
#    #Check to see if the table has got treeNodeInfo node in it. If
#    #yes then call the handler for that.
#    #
#
#    set entrylist [toe_send [locate [ls]] ls]
#    set treenodeinfoindex [ lsearch -regexp $entrylist TreeNodeInfo]
#    if { $treenodeinfoindex >= 0 && $domainview == 0 } {
#        dprint debug "starting the treenode info handling function"
#	handleTreeNodeInfo $listtoreturn $numofcolumns $numberofrows
#        dprint debug "finished the treenode info handling function"
#    }
#   
#    #
#    #define this variable to indicate the first time refresh.
#    #
#
#    define private refresh 1
#    dprint debug "Final list returning is = $listtoreturn"
#    
#    return $listtoreturn
#}

#
#For every table name in platform view, this function returns 
#the treeNodeInfo node path from the module root.
#

proc getSymOidByName { name } {
    switch -exact -- $name {
	chassisTable {
	    return "serengeti-platadmin.platform.chassis.chassisTable.chassisEntry.chassisTreeNodeInfo"
	}
	slotTable {
	    return "serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry.slotTreeNodeInfo"
	}
	cpuBoardTable {
	    return "serengeti-platadmin.platform.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardTreeNodeInfo"
	}
	ioBoardTable {
	    return "serengeti-platadmin.platform.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardTreeNodeInfo"
	}
	l2BoardTable {
	    return "serengeti-platadmin.platform.slots.originalTables.l2BoardTable.l2BoardEntry.l2BoardTreeNodeInfo"
	}
	cpuModTable {
	    return "serengeti-platadmin.platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModTreeNodeInfo"
	}
	dimmTable {
	    return "serengeti-platadmin.platform.components.dimm.dimmTable.dimmEntry.dimmTreeNodeInfo"
	}
	ecacheTable {
	    return "serengeti-platadmin.platform.components.ecache.ecacheTable.ecacheEntry.ecacheTreeNodeInfo"
	}
	fanTable {
	    return "serengeti-platadmin.platform.slots.originalTables.fanTable.fanEntry.fanTreeNodeInfo"
	}
	psTable {
	    return "serengeti-platadmin.platform.slots.originalTables.psTable.psEntry.psTreeNodeInfo"
	}
	scTable {
	    return "serengeti-platadmin.platform.slots.originalTables.scTable.scEntry.scTreeNodeInfo"
	}
	wciModTable {
	    return "serengeti-platadmin.platform.components.wci.wciModTable.wciModEntry.wciModTreeNodeInfo"
	}
	wciPortTable {
	    return "serengeti-platadmin.platform.components.wciPort.wciPortTable.wciPortEntry.wciPortTreeNodeInfo"
	}
	domainTable {
	    return "serengeti-platadmin.platform.domains.domainTable.domainEntry.domainTreeNodeInfo"
	}
    } 
}

#
#For table name in platform view, this function returns 
#the sunSmTreeProp node path from the module root.
#

proc getSmTreePropOidByName { name } {
    switch -exact -- $name {
	chassisTable {
	    return "serengeti-platadmin.platform.chassis.chassisTable.chassisEntry.sunSmTreeProp"
	}
	slotTable {
	    return "serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry.sunSmTreeProp"
	}
	cpuBoardTable {
	    return "serengeti-platadmin.platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.sunSmTreeProp"
	}
	ioBoardTable {
	    return "serengeti-platadmin.platform.slots.ioBoards.ioBrdTable.ioBoardEntry.sunSmTreeProp"
	}
	l2BoardTable {
	    return "serengeti-platadmin.platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.sunSmTreeProp"
	}
	cpuModTable {
	    return "serengeti-platadmin.platform.components.cpuMod.cpuModTable.cpuModEntry.sunSmTreeProp"
	}
	dimmTable {
	    return "serengeti-platadmin.platform.components.dimm.dimmTable.dimmEntry.sunSmTreeProp"
	}
	ecacheTable {
	    return "serengeti-platadmin.platform.components.ecache.ecacheTable.ecacheEntry.sunSmTreeProp"
	}
	fanTable {
	    return "serengeti-platadmin.platform.slots.fanTrays.fanTrayTable.fanEntry.sunSmTreeProp"
	}
	psTable {
	    return "serengeti-platadmin.platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.sunSmTreeProp"
	}
	scTable {
	    return "serengeti-platadmin.platform.slots.systemController.systemControllerTable.systemControllerEntry.sunSmTreeProp"
	}
	wciModTable {
	    return "serengeti-platadmin.platform.components.wci.wciModTable.wciModEntry.sunSmTreeProp"
	}
	wciPortTable {
	    return "serengeti-platadmin.platform.components.wciPort.wciPortTable.wciPortEntry.sunSmTreeProp"
	}
	domainTable {
	    return "serengeti-platadmin.platform.domains.domainTable.domainEntry.sunSmTreeProp"
	}
	default {
	    return $name
	}
    } 
}

#
#Function to handle the chassis related management operations. This function
#is the setAction of CmdNode for all chassis related management operations.
#

proc chassisOperation { value index rowname } {
    #
    #If either SC is down or SC SNMP agent is down then
    #operation will fail.
    #

    set scagentstatus [ toe_send [locate serengeti-platadmin.scagentstatus ] lookup -d 0 data 0 ]
    dprint debug "inside chassisOperation, scagentstatus=$scagentstatus"
    if { $scagentstatus != 2 } {
        if { $scagentstatus == 0 } {
	    set message "Operation Failed : System Controller is down."
        } else {
	    set message "Operation Failed : System Controller Agent is not responding."
        }
	dprint debug "message = $message"

	#Set the Command Node and send a refresh trap on that    

	set cmdstatusnode [locate CmdStatusNode]
	toe_send $cmdstatusnode setValue $index "{$message}"
	toe_send $cmdstatusnode setTrapInfo refreshOID
        return
    }

    #
    #SC SNMP agent is up so do the set.
    #

    #
    # It seems split is not required here. If we try to access 
    # a string like a list, then string is automaticaly converted
    # into list with default separator.
    #
    dprint debug "index=$index, rowname=$rowname"
    set listvalue [split $value , ]
    set cmd [lindex $listvalue 0]
    set version  [toe_send [getModuleRoot] "lookup param snmpVersion"]
    set community  [valueOf serengeti-platadmin.communitystrings.platformwritecommunity ]
    set port [toe_send [getModuleRoot] "lookup param targetPort"]
    set host [valueOf serengeti-platadmin.remoteIPAddress ]
    set level [toe_send [getModuleRoot] "lookup param securityLevel"]
    set cb [list [toe_self] "chassisOperationCallback %result $index $rowname"] 
    dprint debug "cmd=$cmd, version=$version, community=$community, port=$port, host=$host, level=$level, cb=$cb"

    set loghostoid ""
    set traphostoid ""

    switch -exact -- $cmd {
       setupLogTrapHost {
            set loghost [lindex $listvalue 1]
            set traphost [lindex $listvalue 2]
            if { [llength $loghost] == 0 && [llength $traphost] == 0 } {
                set cmdstatusnode [locate CmdStatusNode]
                toe_send $cmdstatusnode setValue $index "{Empty Values For These Properties Are Not Allowed}"
                toe_send $cmdstatusnode setTrapInfo refreshOID
                return
            }
	    dprint debug "something is there to setup"
            if { [llength $loghost] != 0 } {
                set loghostoid "{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.chassis.chassisTable.chassisEntry.chassisLogHost#$rowname {OCTET STRING} \"$loghost\" }"
            }
            if { [llength $traphost] != 0 } {

                #set traphost "add:$traphost"
                #Console should tell whether to add or delete or clear or replace.
                #for adding a node into trap host list, the value should be add:nodename
                #for removing a node from the list of trap hosts, the value should be rem:nodename
                #for replacing a node from the list of trap hosts, the value should be rep:nodenamelist
                #for clearing the list of trap hosts, the value should be clr:

                set traphostoid "{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.chassis.chassisTable.chassisEntry.chassisTrapHosts#$rowname {OCTET STRING} \"$traphost\" }"
            }
            set targetoid "{$loghostoid $traphostoid}"
	    dprint debug "targetoid=$targetoid"
       }
    }

    set cmdstatusnode [locate CmdStatusNode]
    toe_send $cmdstatusnode setValue $index "{Command $cmd is in progress}"

    dprint debug "evaluateCommand lsnmp \"\" \"set $host $port -1 $targetoid -version $version -community $community -securityLevel $level\" $cb"

    evaluateCommand lsnmp "" "set $host $port -1 $targetoid -version $version -community $community -securityLevel $level" $cb
    return
}

#
#The callback function to handle the result of set command issued by 
#chassisOperation function. chassisOperation function issues an asyncronous
#set on SC snmp mib for different management operations and then returns
#immediately. When the reply of snmp set is received then this callback is called.
#This callback determines whether the operation was success or failure and takes
#proper actions.
#

proc chassisOperationCallback { result index rowname} {
    dprint debug "inside chassisOperationCallback, result = $result, index = $index, rowname = $rowname"
    set retcode [lindex $result 0]
    set tid     [lindex $result 1]
    set data    [lindex $result 2]
    dprint debug "retcode = $retcode, tid = $tid, data = $data"
    switch -exact -- $retcode {
        error {
            set message "Operation Failed : $data"
            dprint debug "message = $message"
        }
        data {
            set message "Operation Successful"
            dprint debug "message = $message"
            #refresh The Table
            toe_send [locate serengeti-platadmin.platform.chassis.chassisTable] refreshValueAndTrap
        }
        wait {
            dprint debug "wait case, doing nothing"
            return
        }
    }
    dprint debug "outside the switch statement"
    #Set the Command Node and send a refresh trap on that    
    set cmdstatusnode [locate CmdStatusNode]
    dprint debug "cmdstatusnode = $cmdstatusnode"
    toe_send $cmdstatusnode setValue $index "{$message}"
    toe_send $cmdstatusnode setTrapInfo refreshOID
    dprint debug "finished this operation"
    return
}


#
#Function to handle the slot related management operations. This function
#is the setAction of CmdNode for all slot related management operations.
#

proc slotOperation { value index rowname viewname } {
    #
    #If either SC is down or SC SNMP agent is down then
    #operation will fail.
    #

    set scagentstatus [ toe_send [locate serengeti-platadmin.scagentstatus ] lookup -d 0 data 0 ]
    dprint debug "inside slotOperation, scagentstatus=$scagentstatus"
    if { $scagentstatus != 2 } {
        if { $scagentstatus == 0 } {
	    set message "Operation Failed : System Controller is down."
        } else {
	    set message "Operation Failed : System Controller Agent is not responding."
        }
	dprint debug "message = $message"

	#Set the Command Node and send a refresh trap on that    

	set cmdstatusnode [locate CmdStatusNode]
	toe_send $cmdstatusnode setValue $index "{$message}"
	toe_send $cmdstatusnode setTrapInfo refreshOID
        return
    }

    #
    #SC SNMP agent is up so do the set.
    #

    set version  [toe_send [getModuleRoot] "lookup param snmpVersion"]
    #set community  [valueOf serengeti-platadmin.communitystrings.platformwritecommunity ]
    switch -exact -- $viewname {
        P {
	    set community  [valueOf serengeti-platadmin.communitystrings.platformwritecommunity ]
        }
        A {
	    set community  [valueOf serengeti-platadmin.communitystrings.domainAwritecommunity ]
        }
        B {
	    set community  [valueOf serengeti-platadmin.communitystrings.domainBwritecommunity ]
        }
        C {
	    set community  [valueOf serengeti-platadmin.communitystrings.domainCwritecommunity ]
        }
        D {
	    set community  [valueOf serengeti-platadmin.communitystrings.domainDwritecommunity ]
        }
    }

    set port [toe_send [getModuleRoot] "lookup param targetPort"]
    set host [valueOf serengeti-platadmin.remoteIPAddress ]
    set level [toe_send [getModuleRoot] "lookup param securityLevel"]
    set cb [list [toe_self] "slotOperationCallback %result $index $rowname $viewname"] 

    #
    # Build the indices here from rowname. rowname contains indices separated
    # by ','. We have to replace ',' by '.'.
    #
    set list_of_indices [ split $rowname , ]
    set indices [ join $list_of_indices . ]

    set listvalue [split $value , ]
    set cmd [lindex $listvalue 0]
    switch -exact -- $cmd {
       testBoard {
	   set targetvalue 6
           #set targetoid "{{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.slot.slotTable.slotEntry.slotTestStatus#$rowname Integer32 $targetvalue}}"
           set targetoid "{{oid//1.3.6.1.4.1.42.2.70.2.1.1.6.$indices Integer32 $targetvalue}}"
       }
       powerOn {
	   set targetvalue 2
           #set targetoid "{{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.slot.slotTable.slotEntry.slotPowerStatus#$rowname Integer32 $targetvalue}}"
           set targetoid "{{oid//1.3.6.1.4.1.42.2.70.2.1.1.7.$indices Integer32 $targetvalue}}"
       }
       powerOff {
	   set targetvalue 3
           #set targetoid "{{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.slot.slotTable.slotEntry.slotPowerStatus#$rowname Integer32 $targetvalue}}"
           set targetoid "{{oid//1.3.6.1.4.1.42.2.70.2.1.1.7.$indices Integer32 $targetvalue}}"
       }
       addBoard {
	   set targetdomain [lindex $listvalue 1]
           switch -exact -- $targetdomain {
               DomainA {
                   set targetvalue 2
               }
               DomainB {
                   set targetvalue 3
               }
               DomainC {
                   set targetvalue 4
               }
               DomainD {
                   set targetvalue 5
               }
               Unknown {
                   set targetvalue 1
               }
           }
           
           #set targetoid "{{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.slot.slotTable.slotEntry.slotDomain#$rowname Integer32 $targetvalue}}"
           set targetoid "{{oid//1.3.6.1.4.1.42.2.70.2.1.1.8.$indices Integer32 $targetvalue}}"
       }
       deleteBoard {
	   set targetvalue 1
           #set targetoid "{{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.slot.slotTable.slotEntry.slotDomain#$rowname Integer32 $targetvalue}}"
           set targetoid "{{oid//1.3.6.1.4.1.42.2.70.2.1.1.8.$indices Integer32 $targetvalue}}"
       }
       setupNetwork {
	    set timezone [lindex $listvalue 1]
	    set ipaddress [lindex $listvalue 2]
	    set netmask [lindex $listvalue 3]

	#
	#HERE WE NEED TO FIND OUT THE FORMAT OF SPECIFYING THE LIST OF ROUTERS OR DNS SERVERS ON RESOLVERS
	#
	    set defaultrouters [lindex $listvalue 4]
	    set dnsdomains [lindex $listvalue 5]
	    set dnsresolvers [lindex $listvalue 6]

            dprint debug "timezone=$timezone,ipaddress=$ipaddress,netmask=$netmask,defaultrouters=$defaultrouters,dnsdomains=$dnsdomains,dnsresolvers=$dnsresolvers"

	    set timezoneoid ""
	    set ipaddressoid ""
	    set netmaskoid ""
	    set defaultroutersoid ""
	    set dnsdomainsoid ""
	    set dnsresolversoid ""
            set novalue  ""


	    if { [llength $timezone] != 0 } {
                #set timezoneoid "{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.systemController.scTable.scEntry.scTimeZone#$rowname {OCTET STRING} \"$timezone\" }" 
                set timezoneoid "{oid//1.3.6.1.4.1.42.2.70.15.1.1.7.$indices {OCTET STRING} \"$timezone\" }" 
                set novalue "false"
	    }

	    if { [llength $ipaddress] != 0 } {
                #set ipaddressoid "{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.systemController.scTable.scEntry.scIP#$rowname IpAddress \"$ipaddress\"}" 
                set ipaddressoid "{oid//1.3.6.1.4.1.42.2.70.15.1.1.11.$indices IpAddress \"$ipaddress\"}" 
                set novalue "false"
	    }

	    if { [llength $netmask] != 0 } {
                #set netmaskoid "{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.systemController.scTable.scEntry.scNetmask#$rowname IpAddress \"$netmask\" }" 
                set netmaskoid "{oid//1.3.6.1.4.1.42.2.70.15.1.1.12.$indices IpAddress \"$netmask\" }" 
                set novalue "false"
	    }

	    if { [llength $defaultrouters] != 0 } {
                #set defaultroutersoid "{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.systemController.scTable.scEntry.scDefaultRouters#$rowname {OCTET STRING} \"$defaultrouters\" }" 
                set defaultroutersoid "{oid//1.3.6.1.4.1.42.2.70.15.1.1.13.$indices {OCTET STRING} \"$defaultrouters\" }" 
                set novalue "false"
	    }

	    if { [llength $dnsdomains] != 0 } {
                #set dnsdomainsoid "{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.systemController.scTable.scEntry.scDNSDomain#$rowname {OCTET STRING} \"$dnsdomains\" }" 
                set dnsdomainsoid "{oid//1.3.6.1.4.1.42.2.70.15.1.1.14.$indices {OCTET STRING} \"$dnsdomains\" }" 
                set novalue "false"
	    }

	    if { [llength $dnsresolvers] != 0 } {
                #set dnsresolversoid "{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.systemController.scTable.scEntry.scDNSResolvers#$rowname {OCTET STRING} \"$dnsresolvers\" }" 
                set dnsresolversoid "{oid//1.3.6.1.4.1.42.2.70.15.1.1.15.$indices {OCTET STRING} \"$dnsresolvers\" }" 
                set novalue "false"
	    }

            
	    if { [llength $novalue] == 0 } {
		set cmdstatusnode [locate CmdStatusNode]
		toe_send $cmdstatusnode setValue $index "{Empty Values For These Properties Are Not Allowed}"
		toe_send $cmdstatusnode setTrapInfo refreshOID
		return
	    }

	    set targetoid "{$timezoneoid $ipaddressoid $netmaskoid $defaultroutersoid $dnsdomainsoid $dnsresolversoid}"

            #evaluateCommand lsnmp "" "set $host $port -1 $targetoid -version $version -community $community -securityLevel $level" $cb
       }
    }

    set cmdstatusnode [locate CmdStatusNode]
    toe_send $cmdstatusnode setValue $index "{Command $cmd is in progress}"

    dprint debug "evaluateCommand lsnmp \"\" \"set $host $port -1 $targetoid -version $version -community $community -securityLevel $level\" $cb"
    evaluateCommand lsnmp "" "set $host $port -1 $targetoid -version $version -community $community -securityLevel $level" $cb
    return
}

#
#The callback function to handle the result of set command issued by 
#slotOperation function. slotOperation function issues an asyncronous
#set on SC snmp mib for different management operations and then returns
#immediately. When the reply of snmp set is received then this callback is called.
#This callback determines whether the operation was success or failure and takes
#proper actions.
#

proc slotOperationCallback { result index rowname viewname } {
    dprint debug "inside slotOperationCallback, result = $result, index = $index, rowname = $rowname, viewname = $viewname"
    set retcode [lindex $result 0]
    set tid     [lindex $result 1]
    set data    [lindex $result 2]
    dprint debug "retcode = $retcode, tid = $tid, data = $data"

    switch -exact -- $retcode {
        error {
            set message "Operation Failed : $data"
            dprint debug "message = $message"
        }
        data {
            set message "Operation Successful"
            dprint debug "message = $message"
            #refresh The Table
	    refreshSlotTablesInAllViews
#	    switch -exact -- $viewname {
#		P {
#		    set slottabletoeid  [locate serengeti-platadmin.platform.slots.originalTables.slotTable]
#		}
#		A {
#		    set slottabletoeid  [locate serengeti-platadmin.domainA.slots.originalTables.slotTableA]
#		}
#		B {
#		    set slottabletoeid  [locate serengeti-platadmin.domainB.slots.originalTables.slotTableB]
#		}
#		C {
#		    set slottabletoeid  [locate serengeti-platadmin.domainC.slots.originalTables.slotTableC]
#		}
#		D {
#		    set slottabletoeid  [locate serengeti-platadmin.domainD.slots.originalTables.slotTableD]
#		}
#	    }
#            toe_send $slottabletoeid refreshValueAndTrap
        }
        wait {
            dprint debug "wait case, doing nothing"
            return
        }
    }
    dprint debug "outside the switch statement"
    #Set the Command Node and send a refresh trap on that    
    #set cmdstatusnode [locate serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry.slotCmdStatusNode]
    set cmdstatusnode [locate CmdStatusNode]
    dprint debug "cmdstatusnode = $cmdstatusnode"
    toe_send $cmdstatusnode setValue $index "{$message}"
    toe_send $cmdstatusnode setTrapInfo refreshOID
    dprint debug "finished this operation"
    return
}


#
#Function to handle the domain related management operations. This function
#is the setAction of CmdNode for all domain related management operations.
#

proc domainOperation { value index rowname viewname } {
    #
    #If either SC is down or SC SNMP agent is down then
    #operation will fail.
    #

    set scagentstatus [ toe_send [locate serengeti-platadmin.scagentstatus ] lookup -d 0 data 0 ]
    dprint debug "inside domainOperation, scagentstatus=$scagentstatus"
    if { $scagentstatus != 2 } {
        if { $scagentstatus == 0 } {
	    set message "Operation Failed : System Controller is down."
        } else {
	    set message "Operation Failed : System Controller Agent is not responding."
        }
	dprint debug "message = $message"

	#Set the Command Node and send a refresh trap on that    

	set cmdstatusnode [locate CmdStatusNode]
	toe_send $cmdstatusnode setValue $index "{$message}"
	toe_send $cmdstatusnode setTrapInfo refreshOID
        return
    }

    #
    #SC SNMP agent is up so do the set.
    #

    set version  [toe_send [getModuleRoot] "lookup param snmpVersion"]
    #set community  [valueOf serengeti-platadmin.communitystrings.platformwritecommunity ]
    switch -exact -- $viewname {
        P {
	    set community  [valueOf serengeti-platadmin.communitystrings.platformwritecommunity ]
        }
        A {
	    set community  [valueOf serengeti-platadmin.communitystrings.domainAwritecommunity ]
        }
        B {
	    set community  [valueOf serengeti-platadmin.communitystrings.domainBwritecommunity ]
        }
        C {
	    set community  [valueOf serengeti-platadmin.communitystrings.domainCwritecommunity ]
        }
        D {
	    set community  [valueOf serengeti-platadmin.communitystrings.domainDwritecommunity ]
        }
    }
    set port [toe_send [getModuleRoot] "lookup param targetPort"]
    set host [valueOf serengeti-platadmin.remoteIPAddress ]
    set level [toe_send [getModuleRoot] "lookup param securityLevel"]
    set cb [list [toe_self] "domainOperationCallback %result $index $rowname $viewname"] 

    set listvalue [split $value , ]
    set cmd [lindex $listvalue 0]

    switch -exact -- $cmd {
       setupLogTrapHost {
            set loghost [lindex $listvalue 1]
            set traphost [lindex $listvalue 2]
	    set loghostoid ""
	    set traphostoid ""
	    if { [llength $loghost] == 0 && [llength $traphost] == 0 } {
		set cmdstatusnode [locate CmdStatusNode]
		toe_send $cmdstatusnode setValue $index "{Empty Values For These Properties Are Not Allowed}"
		toe_send $cmdstatusnode setTrapInfo refreshOID
		return
	    }

	    if { [llength $loghost] != 0 } {
                set loghostoid "{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.domain.domainTable.domainEntry.domainLogHost#$rowname {OCTET STRING} \"$loghost\" }"
	    }
	    if { [llength $traphost] != 0 } {
		#Console should tell whether to add or delete or clear.
		#for adding a node into trap host list, the value should be add:nodename
		#for removing a mode from the list of trpa hosts, the value should be rem:nodename
		#for clearing the list of trap hosts, the value should be clr:

                set traphostoid "{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.domain.domainTable.domainEntry.domainTrapHosts#$rowname {OCTET STRING} \"$traphost\" }"
	    }

	    set targetoid "{$loghostoid $traphostoid}"

            #evaluateCommand lsnmp "" "set $host $port -1 $targetoid -version $version -community $community -securityLevel $level" $cb
       }
       setDomainACL {
	    #Console should tell whether to add or delete or clear.
	    #for adding into ACL, the value should be add:value
	    #for removing from the ACL, the value should be rem:value
	    #for clearing the ACL, the value should be clr:
            #This operation is permitted only from platform view.

	   set targetvalue [lindex $listvalue 1]
           set targetoid "{{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.domain.domainTable.domainEntry.domainACLDescr#$rowname {OCTET STRING} \"$targetvalue\" }}"
           #evaluateCommand lsnmp "" "set $host $port -1 $targetoid -version $version -community $community -securityLevel $level" $cb
       }
       setDomainKeySwitch {
	   set tmptargetvalue [lindex $listvalue 1]

           switch -exact -- $tmptargetvalue {
	      Unknown { 
                      set targetvalue 1 
              } 
	      Off { 
                      set targetvalue 2 
              } 
	      Standby { 
                      set targetvalue 3 
              } 
	      On { 
                      set targetvalue 4 
              } 
	      Diagnostic { 
                      set targetvalue 5 
              } 
	      Secure { 
                      set targetvalue 6 
              } 
	      default { 
                      set targetvalue 1 
              } 
	   }

           set targetoid "{{sym//iso.org.dod.internet.private.enterprises.sun.products.serengeti.domain.domainTable.domainEntry.domainKeySwitch#$rowname Integer32 $targetvalue}}"
       }
    }

    set cmdstatusnode [locate CmdStatusNode]
    toe_send $cmdstatusnode setValue $index "{Command $cmd is in progress}"

    dprint debug "evaluateCommand lsnmp \"\" \"set $host $port -1 $targetoid -version $version -community $community -securityLevel $level\" $cb"
    evaluateCommand lsnmp "" "set $host $port -1 $targetoid -version $version -community $community -securityLevel $level" $cb
    return
}


#
#The callback function to handle the result of set command issued by 
#domainOperation function. domainOperation function issues an asyncronous
#set on SC snmp mib for different management operations and then returns
#immediately. When the reply of snmp set is received then this callback is called.
#This callback determines whether the operation was success or failure and takes
#proper actions.
#

proc domainOperationCallback { result index rowname viewname } {
    dprint debug "inside domainOperationCallback, result = $result, index = $index, rowname = $rowname, viewname = $viewname"
    set retcode [lindex $result 0]
    set tid     [lindex $result 1]
    set data    [lindex $result 2]
    dprint debug "retcode = $retcode, tid = $tid, data = $data"

    switch -exact -- $retcode {
        error {
            set message "Operation Failed : $data"
            dprint debug "message = $message"
        }
        data {
            set message "Operation Successful"
            dprint debug "message = $message"
            #refresh The Table
	    switch -exact -- $viewname {
		P {
		    set domaintabletoeid  [locate serengeti-platadmin.platform.domains.domainTable]
		}
		A {
		    set domaintabletoeid  [locate serengeti-platadmin.domainA.domains.domainTableA]
		}
		B {
		    set domaintabletoeid  [locate serengeti-platadmin.domainB.domains.domainTableB]
		}
		C {
		    set domaintabletoeid  [locate serengeti-platadmin.domainC.domains.domainTableC]
		}
		D {
		    set domaintabletoeid  [locate serengeti-platadmin.domainD.domains.domainTableD]
		}
	    }
            toe_send $domaintabletoeid refreshValueAndTrap
        }
        wait {
            dprint debug "wait case, doing nothing"
            return
        }
    }
    dprint debug "outside the switch statement"
    #Set the Command Node and send a refresh trap on that    
    #set cmdstatusnode [locate serengeti-platadmin.platform.domains.domainTable.domainEntry.domainCmdStatusNode]
    set cmdstatusnode [locate CmdStatusNode]
    dprint debug "cmdstatusnode = $cmdstatusnode"
    toe_send $cmdstatusnode setValue $index "{$message}"
    toe_send $cmdstatusnode setTrapInfo refreshOID
    dprint debug "finished this operation"
    return
}

#-----------------------------------------------------------------------------------------

#
#This function is used in PV/LV Support
#

proc getImageNamePdiStrEtc { name index objectid } {

    #
    #name is the table name. index is the row index into the table.
    #objectid is the toeid for treeNodeInfo node inside the table name.
    #

    switch -exact -- $name {
	chassisTable {
	    return "chassis:null:front rear:null:null:null"
	}
	slotTable {
	    return "-:null:null:null:null:null"
	}
	cpuBoardTable {
            set slotnumber [ toe_send [ locate serengeti-platadmin.platform.slots.originalTables.cpuBoardTable.cpuBoardEntry.cpuBoardIndex ] getValue $index ]
            if { $slotnumber < 400 } {
                dprint error "slotNumber for cpuBoardTable does not start with 400"
                return "cpu-board:null:null:null:null:null"
            }
            set slotindex [expr $slotnumber - 400]
			return "cpu-board:slot-$slotindex:top:null:null:null"
	}
	ioBoardTable {
            #
            #get the type of the io board, pci or cpci.
            #
            
            set boardtype [toe_send [ locate serengeti-platadmin.platform.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardType ] lookup -d "Unknown" data $index]
            switch -exact -- $boardtype {
                Unknown {
                    dprint debug "BoardType is Unknown so defaulting it to pci"
                    set btype "pci"
                }
                PCI {
                    set btype "pci"
                }
                CPCI {
                    set btype "cpci"
                }
                FIRE_LINK_CPCI {
                    set btype "cpci"
                }
                FIRE_LINK_SP_CPCI {
                    set btype "cpci"
                }
		PCI+ {
		    # tempory set to the pci boards for PV/LV
                    set btype "pci"
                }
            }
            #
            #Find out the chassis model here
            #
            if { [toe_csend cmodel [locate serengeti-platadmin.platform.chassis.chassisTable.chassisEntry.chassisModel] lookup data 1 ] } {
                dprint error "Could not find chassis model"
            }
            if { "$cmodel" == "F3800" } {
                set btype "sp-$btype"
            } 
            set slotnumber [ toe_send [ locate serengeti-platadmin.platform.slots.originalTables.ioBoardTable.ioBoardEntry.ioBoardIndex ] getValue $index ]
            if { $slotnumber < 500 } {
                dprint error "slotNumber for ioBoardTable does not start with 500"
                return "$btype-bay:null:null:null:null:null"
            }
            set slotindex [expr $slotnumber - 500]
			return "$btype-bay:slot-$slotindex:null:null:null:null"
	}
	l2RepeaterTable {
            set slotnumber [ toe_send [ locate serengeti-platadmin.platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.l2RepeaterIndex ] getValue $index ]
            if { $slotnumber < 600 } {
                dprint error "slotNumber for l2BoardTable does not start with 600"
                return "l2-repeater:null:null:null:null:null"
            }
            set slotindex [expr $slotnumber - 600]
			return "l2-repeater:l2-repeater-$slotindex:top:null:null:null"
	}
	cpuModTable {
            set cpumodindexvalue [ toe_send [ locate serengeti-platadmin.platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModIndex ] getValue $index ] 
	    return "cpu-unit:cpu-unit-P$cpumodindexvalue:null:null:null:null"
	}
	dimmTable {
            set dimmcpumodindexvalue [ toe_send [ locate serengeti-platadmin.platform.components.dimm.dimmTable.dimmEntry.dimmCpuModIndex ] getValue $index ]
            set dimmindexvalue [ toe_send [ locate serengeti-platadmin.platform.components.dimm.dimmTable.dimmEntry.dimmIndex ] getValue $index ]
	    switch -exact -- $dimmindexvalue {
                1 {
                    set dimmindexvalue 2
                }
                2 {
                    set dimmindexvalue 4
                }
                3 {
                    set dimmindexvalue 6
                }
                4 {
                    set dimmindexvalue 1
                }
                5 {
                    set dimmindexvalue 3
                }
                6 {
                    set dimmindexvalue 5
                }
            }
	    return "dimm:dimm-$dimmcpumodindexvalue-$dimmindexvalue:null:null:null:null"
	}
	ecacheTable {
            set ecachecpumodindexvalue [ toe_send [ locate serengeti-platadmin.platform.components.ecache.ecacheTable.ecacheEntry.ecacheCpuModIndex ] getValue $index ]
            set ecacheindexvalue [ toe_send [ locate serengeti-platadmin.platform.components.ecache.ecacheTable.ecacheEntry.ecacheIndex ] getValue $index ]
	    return "ecache:ecache-$ecachecpumodindexvalue-$ecacheindexvalue:null:null:null:null"
	}
	fanTrayTable {
            set slotnumber [ toe_send [ locate serengeti-platadmin.platform.slots.fanTrays.fanTrayTable.fanEntry.fanIndex ] getValue $index ]
            if { $slotnumber < 200 } {
                dprint error "slotNumber for fanTable does not start with 200"
                return "fan-tray:null:null:null:null:null"
            }
            set slotindex [expr $slotnumber - 200]
            #
            # Find out the image name 
            #
            set fantype [ toe_send [ locate serengeti-platadmin.platform.slots.originalTables.fanTable.fanEntry.fanType ] lookup -d "Unknown" data $index ] 
            switch -exact -- $fantype {
                Unknown { 
                     set imagename "fan-tray"  
                }
                r24IoFanTray { 
                     set imagename "r24-io-four-fan-tray"
                }
                r24CpuFanTray { 
                     set imagename "r24-cpu-six-fan-tray"
                }
                rackFanTray { 
                     set imagename "fan-tray"  
                }
                r12FanTray { 
                     set imagename "r12-three-fan-tray"
                }
                k12IoFanTray { 
                     set imagename "fan-tray"  
                }
                k12CpuFanTray { 
                     set imagename "k12-cpu-three-fan-tray"
                }
                mdTopFanTray { 
                     set imagename "md-top-io-fan-tray"
                }
                spFanTray { 
                     set imagename "sp-fan-tray"
                }
                mdBotFanTray { 
                     set imagename "md-bottom-io-fan-tray"
                }
                mdTopHiVolFanTray { 
                     set imagename "md-top-hi-vol-io-fan-tray"
                }
                mdBotLeftHiVolFanTray { 
                     set imagename "md-bottom-left-hi-vol-io-fan-tray"
                }
                mdBotRightHiVolFanTray { 
                     set imagename "md-bottom-right-hi-vol-io-fan-tray"
                }
            }
	    return "$imagename:fan-slot-$slotindex:null:null:null:null"
	}
	powerSupplyTable {

            set slotnumber [ toe_send [ locate serengeti-platadmin.platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyIndex ] getValue $index ]
            if { $slotnumber < 300 } {
                dprint error "slotNumber for psTable does not start with 300"
                return "power-supply:null:null:null:null:null"
            }
            set slotindex [expr $slotnumber - 300]
            #
            # Get the image name here
            #
            set pstype [ toe_send [ locate serengeti-platadmin.platform.slots.originalTables.psTable.psEntry.psType ] lookup -d "Unknown" data $index ] 
            switch -exact -- $pstype {
                Unknown { 
                     set imagename "power-supply"
                }
                a123 { 
                     set imagename "power-supply"
                }
                a138 { 
                     set imagename "power-supply"
                }
                a145 { 
                     set imagename "power-supply-a145"
                }
                a152 { 
                     set imagename "power-supply-a152"
                }
                a153 { 
                     set imagename "power-supply-a153"
                }
                a184 { 
                     set imagename "power-supply-a184"
                }
                a185 { 
                     set imagename "power-supply-a185"
                }
            }
	    return "$imagename:power-supply-slot-$slotindex:null:null:null:null"
	}
	systemControllerTable {
            set slotnumber [ toe_send [ locate serengeti-platadmin.platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerIndex ] getValue $index ]
            if { $slotnumber < 100 } {
                dprint error "slotNumber for scTable does not start with 100"
                return "sc:null:null:null:null:null"
            }
            set slotindex [expr $slotnumber - 100 ]
	    return "sc:sc-$slotindex:null:null:null:null"
	}
    } 
}

#
#This function is used to get the node name in PV/LV Support
#

proc getNodeNameByTableName { name } {
    switch -exact -- $name {
	chassisTable {
	    return "chassis"
	}
	slotTable {
	    return "slot"
	}
	cpuBoardTable {
	    return "cpuBoard"
	}
	ioBoardTable {
	    return "ioBoard"
	}
	l2BoardTable {
	    return "l2Board"
	}
	cpuModTable {
	    return "cpuMod"
	}
	dimmTable {
	    return "dimm"
	}
	ecacheTable {
	    return "ecache"
	}
	fanTable {
	    return "fan"
	}
	psTable {
	    return "PowerSupply"
	}
	scTable {
	    return "SystemController"
	}
	wciModTable {
	    return "wciMod"
	}
	wciPortTable {
	    return "wciPort"
	}
	domainTable {
	    return "domain"
	}
    } 
}
proc getNodeNameToeID { name } {
    switch -exact -- $name {
	cpuBoardTable {
	    return [locate serengeti-platadmin.platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardName]
	}
	ioBoardTable {
	    return [locate serengeti-platadmin.platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardName]
	}
    } 
}

#-----------------------------------------------------------------------------------------

#
#Trap Handling Functions
#



proc refreshSlotTablesInAllViews { } {

    set tabletoeid [locate .iso*modules.serengeti-platadmin.daq.slots ]
    toe_send $tabletoeid refreshValueAndTrap

    return
}

proc refreshDomainTablesInAllViews { } {

    set tabletoeid [locate .iso*modules.serengeti-platadmin.daq.domain ]
    toe_send $tabletoeid refreshValueAndTrap
    
    return
}
proc refreshWciModTablesInAllViews { } {

    set tabletoeid [locate .iso*modules.serengeti-platadmin.daq.wci ]
    toe_send $tabletoeid refreshValueAndTrap

    return
}
proc refreshWciPortTablesInAllViews { } {

    set tabletoeid [locate .iso*modules.serengeti-platadmin.daq.wciPort ]
    toe_send $tabletoeid refreshValueAndTrap

    return
}

#
#Trap handler for boardPresenceChanged trap
#
#HOT SWAP fixes added.  When a trap comes in that a board presence has changed 
#(ie a board is physically inserted or removed)
#it will now also find and increment *serengeti-platadmin.system.total_config_changes.
#Then the console will see this changed value every couple of minutes and refresh
#PV/LV.
#

proc insRemBoard { } {
 
    dprint debug "Recvd trap boardPresenceChanged"
	
	#
	#Kick off a refresh of the chassis table, which will force several 
	#other tables to also refresh.
	#
	if { [ toe_csend x [ locate .iso*serengeti-platadmin.daq.chassis ] {refreshValue} ] } {
		dprint error "insRemBoard{}, toe_csend serengeti-platadmin.daq.chassis failed. $x"
	}

	#
	#Grab the toeID,and then grab the current value of total_config_changes
	#The Console looks for changes in total_config_changes to determine when a
	#refresh should be done.
	#
	set total_config_changesID [locate *serengeti-platadmin.system.total_config_changes] 
	if { [ set current_total_configvalue [toe_send $total_config_changesID getValue 0] ] } {
		dprint debug "insRemBoard{}, could NOT get current_total_configvalue"
	}
	dprint debug "---- Current total_configvalue is $current_total_configvalue ----"

	#
	#Now set total_config_changes data index 0 (first field) to current_total_configvalue +1
	#
	if { [ toe_send $total_config_changesID setValue 0 [expr $current_total_configvalue + 1] ] } {
		dprint debug "insRemBoard{}, failed to set total_config_changes"
	}
	dprint debug "---- Incremented value is $current_total_configvalue ----"

    return
}

#
#Trap handler for slotAssignmentChanged trap
#

proc addDelBoard { } {
 
    dprint debug "Recvd trap slotAssignmentChanged"
    if { [ toe_csend x [ locate .iso*serengeti-platadmin.daq.slots ] {refreshValue} ] } {
	dprint error "addDelBoard{}, toe_csend failed. $x"
    }
    return
}

#
#Trap handler for aclChanged trap
#

proc aclChanged { } {
    dprint debug "Recvd trap aclChanged"
    if { [ toe_csend x [ locate .iso*serengeti-platadmin.daq.slots ] {refreshValue} ] } {
	dprint error "addDelBoard{}, toe_csend failed. $x"
    }
    return
}

#
#Trap handler for boardStatusChanged trap
#

proc boardStatusChanged {slotchassisindex slotindex slotteststatus slotpowerstatus } {
    #
    #This trap is equivalent to 3 traps.
    #1. Board Self Test has completed
    #2. Board Power On
    #3. Board Power Off
    #In case of Self Test Completed, this function will have to set the value of
    #proper node and send a refresh trap on that. This is used for board test
    #operation.

    dprint debug "Recvd trap boardStatusChanged, slotchassisindex=$slotchassisindex, slotindex=$slotindex, slotteststatus=$slotteststatus, slotpowerstatus=$slotpowerstatus"

    set originalslottableentrytoeid [locate .iso*modules.serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry ]
    set originalslottablerownumber [toe_send $originalslottableentrytoeid getRowIndex "$slotchassisindex,$slotindex" ] 
    set slotboardtype   [ toe_send [locate .iso*modules.serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry.slotBoardType] lookup -d "null" data $originalslottablerownumber ]
    dprint debug "slotboardtype is $slotboardtype"
    switch -exact $slotboardtype {
	IO {
	    #IO Board
	    set viewPcmdstatusnode [locate .iso*modules.serengeti-platadmin.platform.slots.ioBoards.ioBrdTable.ioBoardEntry.CmdStatusNode ]
	    set viewAcmdstatusnode [locate .iso*modules.serengeti-platadmin.domainA.slots.ioBoards.ioBrdTableA.ioBoardEntry.CmdStatusNode ]
	    set viewBcmdstatusnode [locate .iso*modules.serengeti-platadmin.domainB.slots.ioBoards.ioBrdTableB.ioBoardEntry.CmdStatusNode ]
	    set viewCcmdstatusnode [locate .iso*modules.serengeti-platadmin.domainC.slots.ioBoards.ioBrdTableC.ioBoardEntry.CmdStatusNode ]
	    set viewDcmdstatusnode [locate .iso*modules.serengeti-platadmin.domainD.slots.ioBoards.ioBrdTableD.ioBoardEntry.CmdStatusNode ]
	    foreach toeid "$viewPcmdstatusnode $viewAcmdstatusnode $viewBcmdstatusnode $viewCcmdstatusnode $viewDcmdstatusnode" {


		set res [ toe_csend rownumber $toeid getRowIndex "$slotchassisindex,$slotindex" ]
		if { $res == 1 } {
		    continue
		}
		switch -exact -- $slotteststatus {
		    1 {
		       toe_send $toeid setValue $rownumber "Passed"
		       toe_send $toeid setTrapInfo refreshOID
		    }
		    2 {
		       toe_send $toeid setValue $rownumber "Failed"
		       toe_send $toeid setTrapInfo refreshOID
		    }
		}

	    }

	}
	CPU {
	    #CPU Board
	    set viewPcmdstatusnode [locate .iso*modules.serengeti-platadmin.platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.CmdStatusNode]
	    set viewAcmdstatusnode [locate .iso*modules.serengeti-platadmin.domainA.slots.cpuBoards.cpuBrdTableA.cpuBoardEntry.CmdStatusNode]
	    set viewBcmdstatusnode [locate .iso*modules.serengeti-platadmin.domainB.slots.cpuBoards.cpuBrdTableB.cpuBoardEntry.CmdStatusNode]
	    set viewCcmdstatusnode [locate .iso*modules.serengeti-platadmin.domainC.slots.cpuBoards.cpuBrdTableC.cpuBoardEntry.CmdStatusNode]
	    set viewDcmdstatusnode [locate .iso*modules.serengeti-platadmin.domainD.slots.cpuBoards.cpuBrdTableD.cpuBoardEntry.CmdStatusNode]
	    foreach toeid "$viewPcmdstatusnode $viewAcmdstatusnode $viewBcmdstatusnode $viewCcmdstatusnode $viewDcmdstatusnode" {

		set res [ toe_csend rownumber $toeid getRowIndex "$slotchassisindex,$slotindex" ]
		if { $res == 1 } {
		    continue
		}
		switch -exact -- $slotteststatus {
		    Passed {
		       toe_send $toeid setValue $rownumber "Passed"
		       toe_send $toeid setTrapInfo refreshOID
		    }
		    Failed {
		       toe_send $toeid setValue $rownumber "Failed"
		       toe_send $toeid setTrapInfo refreshOID
		    }
		}
	    }
	}
    }
    dprint debug " Refreshing slot tables in all views"
    refreshSlotTablesInAllViews
    return

}

#
#Trap handler for overTemp trap
#

proc overTemp { } {

    dprint debug "Recvd trap overTemp"
    refreshSlotTablesInAllViews
    return

}

#
#Trap handler for fruFailure trap
#

proc fruFailure { } {
    dprint debug "Recvd trap fruFailure"
    refreshSlotTablesInAllViews
    return
}

#
#Trap handler for wciLinkFailure trap
#

proc wciLinkFailure { } {
    dprint debug "Recvd trap wciLinkFailure"
    refreshWciModTablesInAllViews 
    refreshWciPortTablesInAllViews
    return
}

#
#Trap handler for domainStateChange trap
#

proc domainStateChange { } {
    dprint debug "Recvd trap domainStateChange"
    refreshCompleteSystem

    return
}


#
#Trap handler for platformLoghostChange trap
#

proc platformLoghostChange { } {
    dprint debug "Recvd trap platformLoghostChange"
    set tabletoeid [locate .iso*modules.serengeti-platadmin.daq.chassis ]
    toe_send $tabletoeid refreshValueAndTrap
    return
}

#
#Trap handler for scAlive trap
#

proc scAlive {sourceaddress scindex scstate fruSerialnumber} {

    #
    #This trap indicates either SC UP or IP change. If SC UP then
    #scstate will be 1 and if IP change then scstate will be 2
    #In case of SC UP we need to refresh the node scnetworked. In 
    #case of IP cahnge, we need to modify the node remoteIPAddress.
    #Here we will update the ip address in configuration file too to
    #reflect the same at next start time.
    #
    set sourceaddress [lindex [split $sourceaddress :] 0]
    dprint debug "Recvd trap scAlive, sourceaddress=$sourceaddress, scindex=$scindex, scstate=$scstate, fruSerialnumber=$fruSerialnumber"
   

    #set sourceIP [resolveHostName $sourceaddress]

    set rulenode [locate .iso*modules.serengeti-platadmin.rules.rspa1005 ]
    toe_send $rulenode define scstate 0 $scstate
    toe_send $rulenode refreshValue

    switch -exact -- $scstate {
        1 {
            #toe_send [locate .iso*modules.serengeti-platadmin.scnetworked] refreshValue
            toe_send [locate .iso*modules.serengeti-platadmin.scagentstatus] refreshValue
        }
        2 {
            toe_send [locate .iso*modules.serengeti-platadmin.remoteIPAddress ] setValue 0 $sourceaddress
            updateConfigFile SCIPAddress $sourceaddress
        }
    }
    return
}

#
#Trap handler for chassisCommunityChange trap
#

proc chassisCommunityChange { } {
    # Not supported because it is not implemented, and fundamentally incsecure
    dprint debug "NOOP - Recvd trap chassisCommunityChange"
    return
}

#
#Trap handler for domainCommunityChange trap
#

proc domainCommunityChange {} {
    # Not supported because it is not implemented, and fundamentally incsecure
    dprint debug "NOOP - Recvd trap domainCommunityChange"
    return
}

#
#Trap handler for scFailover trap
#

proc scFailover { } {
    dprint debug "Recvd trap scFailover"

    #
    # fixed from Quinton for scfailover
    #    toe_send [locate .iso*modules.serengeti-platadmin.rules.rspa1004 ] refreshValue
    #
    if { [ toe_csend x [ locate .iso*serengeti-platadmin.daq.chassis ] { refreshValueAndTrap } ] } {
 	dprint error "scFailover, toe_csend chassis failed. $x"
    }
    if { [ toe_csend x [ locate .iso*serengeti-platadmin.rules.rspa1004 ] { refreshValue } ] } {
	dprint error "scFailover, toe_csend rspa1004 failed. $x"
    }     
    return
}

#
#Trap handler for clockFailover trap
#

proc clockFailover { } {
    dprint debug "Recvd trap clockFailover"
    toe_send [locate .iso*modules.serengeti-platadmin.rules.rspa1001 ] refreshValue
    return
}

#
#Trap Handler For chassisTrapHostChange trap
#

proc chassisTrapHostChange { } {
    dprint debug "Recvd trap chassisTrapHostChange"
    set tabletoeid [locate .iso*serengeti-platadmin.daq.chassis]
    toe_send $tabletoeid refreshValueAndTrap
    return
}

#
#Trap Handler For domainLogHostChange and domainTrapHostChange trap
#

proc domainLogTrapHostChange { } {
    dprint debug "Recvd trap domainLogHostChange"
    refreshDomainTablesInAllViews 
    return
}

#
#End Of Trap Handlers
#
#-----------------------------------------------------------------------------------------

#
#This fucntion is used to update the configuration file. If the variable
#is already present in the file then it updtaes the value of it otherwise
#it creates the variable:value pair in the configuration file.
#

proc updateConfigFile { name value } {
    global env
    set found 0
    set componentname [ lookup value component ]
    set configfile "$env(ESDIR)/cfg/serengeti-platadmincfg-$componentname-d.dat"
    if [ catch { open $configfile r } fileId ] {
        dprint error "Could not open file $configfile for reading"
        return
    } else {
        set lines [read $fileId]
        close $fileId
    }
    if [ catch { open $configfile w+ } fileId ] {
        dprint error "Could not open file $configfile for writing"
        return
    } else {
        set lineslist [split $lines \n ]
        set lineslistlength [expr [llength $lineslist] - 1]
        for {set i 0} {$i < $lineslistlength} {incr i 1} {
            set line [lindex $lineslist $i]
            set varname  [lindex [split $line :] 0]
            set varvalue [lindex [split $line :] 1]
            if { $varname == $name } {
                set varvalue $value
                puts $fileId "$varname:$varvalue"
                set found 1
            } else {
                puts $fileId $line
            }
        }
        if { $found == 0 } {
            puts $fileId "$name:$value"
        }
        close $fileId
        return
    }
    return
}

#
#This function handles the treeNodeInfo of tables in the platform view.
#This function is called once for every table having column treeNodeInfo.
#The list of data which will refresh the table is passed to this function.
#It takes out all the treeNodeInfo data from the list. The for each treeNodeInfo
#data it does the following..
# -- Puts the child and brother table name into the list of tables to be refreshed.
# -- It removes its own table name from the list of tables to be refreshed.
# -- issues the refresh command on its child and brother tables.
# -- If the list of tables to be refreshed has this table name then it issues
#    a refresh command on its own table after 100 ms.
# -- If the list of table to be refreshed is empty then issues a refresh command
#    on node serengeti-platadmin.sunSmTreePropRefreshNode.
#

proc handleTreeNodeInfo { listtoreturn  numofcolumns numberofrows} {

    set tablename [getNodeName 0]
    dprint debug "Starting handling of treenodeinfo for table $tablename"
    set entrylist [toe_send [locate [ls]] ls]
    set treenodeinfoindex [ lsearch -regexp $entrylist TreeNodeInfo]
    set treenodename [lindex $entrylist $treenodeinfoindex]
    set treenodeinfocolumn [expr $treenodeinfoindex + 1]
    #set firsttime [exists private refreshed]
    #set tablestoberefreshed [valueOf serengeti-platadmin.tableListTorefresh]
    set tablestoberefreshed [toe_send [locate serengeti-platadmin.tableListTorefresh] lookup -d "" data 0]
    dprint debug "Table to be refreshed = $tablestoberefreshed # Length = [llength $tablestoberefreshed]"
    set tablelist [list]

    #puts stdout "$tablename $entrylist $treenodeinfoindex $treenodename $treenodeinfocolumn $tablestoberefreshed"

    #
    #Build a list of unique tables which are either brother or child of this table.
    #Exclude the same table name as the current one. Then refresh all of them.
    #

    for {set i 0} {$i < $numberofrows} {incr i 1} {
        set index [expr $treenodeinfoindex + $numofcolumns * $i]
        #lappend listoftreenodeinfo [lindex $listtoreturn $index]
        set treenodeinfo [lindex $listtoreturn $index]
        dprint debug "Row = [expr $i + 1] # treenodeinfo = $treenodeinfo"
        if { [llength $treenodeinfo] == 0 } {
             dprint debug "Tree Node info is not well populated in SC agent"
             continue
        }

	set listvalue [ split $treenodeinfo : ]
	set name     [lindex $listvalue 0 ]  
	set child    [lindex $listvalue 1 ]  
	set brother  [lindex $listvalue 2 ]  
        dprint debug "name = $name # child = $child # brother = $brother"
        if { $name == "null" } {
            dprint debug "Table name must never be null, there is some problem in SC mib"
            continue
        }
        if { $child != "null" && [ lsearch -exact $tablelist $child ] == -1 } {
            if { $child != $tablename } {
		lappend tablelist $child
                dprint debug "tablelist = $tablelist"
		set childtreenodeinfosymoid [ getSymOidByName $child ]                
		set childtabletoeid [toe_send [locate $childtreenodeinfosymoid] locate $child]
                toe_send $childtabletoeid refreshValue
            }
        }
        if { $brother != "null" && [ lsearch -exact $tablelist $brother ]  == -1 } {
            if { $brother != $tablename } {
		lappend tablelist $brother
                dprint debug "tablelist = $tablelist"
		set brothertreenodeinfosymoid [ getSymOidByName $brother ]                
		set brothertabletoeid [toe_send [locate $brothertreenodeinfosymoid] locate $brother]
                toe_send $brothertabletoeid refreshValue
            }
        }
    }

    #
    #Remove the current table name from the list of tables to be refreshed if present.
    #Add the table list into the list of tables to be refreshed. If the current table
    #name is still there in the list then refresh the current table too. If the list
    #of tables to be refreshed is empty then refresh the node sunSmTreePropRefreshNode.
    #
   
    set tablenameindex [lsearch -exact $tablestoberefreshed $tablename ]
    if { $tablenameindex >= 0 } {
        set firstpartlist [lrange $tablestoberefreshed 0 [expr $tablenameindex - 1]]
        set secondpartlist [lrange $tablestoberefreshed [expr $tablenameindex + 1] [expr [llength $tablestoberefreshed] - 1]]
        set newlist [concat $firstpartlist $secondpartlist]
        dprint debug "New table list to be refreshed after removing table name $tablename = $newlist"
    } else {
        set newlist $tablestoberefreshed
        dprint debug "Table name $tablename is not in list of tables to be refreshed, the new list = $newlist"
    }

    set newlist [concat $newlist $tablelist]
    dprint debug "The final list of tables to be refreshed after handling table $tablename = $newlist # Length = [llength $newlist]"
    #
    #Some times because of some unexpected value in treenodeinfo, the newlist variable
    #contains some null list members like {}. So clean them all before seting to the node.
    #
    set clean_newlist [list]
    for {set i 0} {$i < [llength $newlist] } {incr i 1} {
	if { [lindex $newlist $i] != "" } {
	    lappend clean_newlist [lindex $newlist $i]
	}
    }
    if { [llength $clean_newlist] == 0 } {
	toe_send [locate serengeti-platadmin.tableListTorefresh] setValue 0 "" 
    } else {
	toe_send [locate serengeti-platadmin.tableListTorefresh] setValue 0 "{$clean_newlist}" 
    }
    dprint debug "#####The value of serengeti-platadmin.tableListTorefresh node after set = [valueOf serengeti-platadmin.tableListTorefresh] #####"

    if { [llength $clean_newlist] == 0 } {
        dprint debug "The list of tables to be refreshed is empty, refreshing the sunSmTreeProp"
        toe_send [locate serengeti-platadmin.sunSmTreePropRefreshNode] refreshValue
        return
    }
    set tablenameindex [lsearch -exact $clean_newlist $tablename ]
    if { $tablenameindex >= 0 } {
        dprint debug "Refreshing the same table after 100 milliseconds"
        after 100 toe_send [toe_self] refreshValue
    }
    return    
}

#
#This function builds the PV tree. This functions will be called only
#after the list of tables to be refreshed goes empty.
#For chassisTable, emptySlots and all tables under components, it build the 
#sunSmTreeProp and sunSmNodeName in the same table. For all other slot related
#tables, it takes treeNodeInfo from the tables under originalTable node but
#build the sunSmTreeProp in table under slots node.
#

#proc refreshAllSunSmTreeProp { } {
#
#    set listoftables [list chassisTable slotTable cpuBoardTable ioBoardTable l2BoardTable cpuModTable dimmTable ecacheTable fanTable psTable scTable wciModTable wciPortTable domainTable]
#
#    global env
#    set componentname [ lookup value component ]
#    set treefile "$env(ESDIR)/cfg/serengeti-platadmin-$componentname.tree"
#    if [ catch { open $treefile w+ } fileId ] {
#        dprint error "Could not open file $treefile for writing."
#        return 
#    } 
#    puts $fileId "system:1:0:system:platform.chassis.chassisTable:null:1:0:-:null:null:null:null:null"
#    flush $fileId
#
#    foreach tablename $listoftables {
#        dprint debug "Starting refresh of sunSmTreeProp for table $tablename"
#	set objectSymName [getSymOidByName $tablename]
#	set objecttoeid [locate $objectSymName]
#	#set sunsmtreproptoeid [ toe_send $objecttoeid locate sunSmTreeProp ]
#	set sunsmtreproptoeid [ locate [ getSmTreePropOidByName $tablename] ]
#	#set sunsmnodenametoeid [ toe_send $objecttoeid locate sunSmNodeName ]
#	set sunsmnodenametoeid [ toe_send $sunsmtreproptoeid locate sunSmNodeName ]
#        
#	set indices [toe_send $objecttoeid getIndices]
#	set numberofindex [llength $indices]
#	if { $numberofindex == 0 } {
#	    dprint debug "Data not yet populated in table $tablename"
#            continue
#	}
#	for {set i 0} {$i < $numberofindex} {incr i 1} {
#	    set rowindex [lindex $indices $i]
#
#
#	    set value [toe_send $objecttoeid lookup -d "" data $rowindex]
#	    if { [llength $value] == 0 } {
#		dprint debug "There is nothing in treeNodeInfo of row $rowindex"
#		toe_send $sunsmtreproptoeid setValue $rowindex "$tablename:null:null:0:0:null:null:null:null:null:null"
#		toe_send $sunsmnodenametoeid setValue $rowindex "$tablename"
#                continue
#	    }
#            dprint debug "Tree node info for row $rowindex is = $value"
#	    set listvalue [ split $value : ]
#	    set name     [lindex $listvalue 0 ]  
#	    set child    [lindex $listvalue 1 ]  
#	    set brother  [lindex $listvalue 2 ]  
#
#            if { [llength $name] == 0 || [llength $child] == 0 || [llength $brother] == 0 } {
#		toe_send $sunsmtreproptoeid setValue $rowindex "$tablename:null:null:0:0:null:null:null:null:null:null"
#		toe_send $sunsmnodenametoeid setValue $rowindex "$tablename"
#                continue
#            }
#	    #set nodeName [ getNodeNameByTableName $name ]
#	    set nodeName [ getNodeNameByTableName $tablename ]
#	    set nodeName $nodeName\($rowindex\)
#
#	    set index 3
#	    if { $child != "null" } {
#		set numberofchildindex [lindex $listvalue $index]
#		set index [expr $index + 1]
#		set childindices [lindex $listvalue $index]
#		set childtoeid [locate [getSymOidByName $child]]
#                if { [toe_csend childindex $childtoeid getRowIndex $childindices] } {
#                    dprint debug "Could not find child row index for table $child and index $childindices"
#                    set child "null"
#                    set childindex 0
#                }
#		set index [expr $index + 1]
#	    } else {
#		set childindex 0
#		set index [expr $index + 2]
#	    }
#	    if { $brother != "null" } {
#		set numberofbrotherindex [lindex $listvalue $index]
#                if { $numberofbrotherindex == "null" || [llength $numberofbrotherindex] == 0 } {
#                    dprint debug "Number of brother index is either null or nothing"
#                    set brother "null"
#                    set brotherindex 0
#                } else {
#		    set index [expr $index + 1]
#		    set brotherindices [lindex $listvalue $index]
#		    set brothertoeid [locate [getSymOidByName $brother]]
#		    #set brotherindex [toe_send $brothertoeid "getRowIndex $brotherindices"]
#		    if { [toe_csend brotherindex $brothertoeid getRowIndex $brotherindices] } {
#			dprint debug "Could not find brother row index for table $brother and index $brotherindices"
#			set brother "null"
#			set brotherindex 0
#		    }
#                }
#		set index [expr $index + 1]
#	    } else {
#		set brotherindex 0
#		set index [expr $index + 1]
#	    }
#
#            #
#            #Get the path of the table name of child table  which will host the sunSmTreeProp
#            #
#
#            set child [getPVMoName $child]
#            set brother [getPVMoName $brother]
#
#            dprint debug "list to return before pdistr = $nodeName:$child:$brother:$childindex:$brotherindex"
#	    set pdistretc [getImageNamePdiStrEtc $tablename $rowindex $objecttoeid]
#	    dprint debug "value to be set afetr pdistr = $nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
#	    toe_send $sunsmtreproptoeid setValue $rowindex "{$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc}"
#	    toe_send $sunsmnodenametoeid setValue $rowindex "$nodeName"
#
#            #
#            #Code To Dump the sunSmTreeProp into tree file.
#            #
#   
#            set moname [getPVMoName $tablename]
#            set instance "$rowindex"
#            set snmpindex [toe_send $sunsmtreproptoeid getRowName $rowindex]
#            dprint debug "string to put into tree file is = $moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc" 
#            puts $fileId "$moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
#	    flush $fileId
#
#	}
#        #toe_end
#        dprint debug "table $tablename completed"
#    }
#    close $fileId
#    return 
#}

#
#This is used to get the MO name while building the tree file.
#

proc getPVMoName { name } {
        if { $name == "null" } {
            return $name
        }
        set fullname [getSmTreePropOidByName $name]
        set fullnamelist [split $fullname . ]
        set listlength [llength $fullnamelist]
        set pathlist [lrange $fullnamelist 0 [expr $listlength - 3]]
        set finalpath ""
        for { set i 1 } { $i < [llength $pathlist] } { incr i 1 } {
	    if { $finalpath == "" } {
		set finalpath "[lindex $pathlist $i]"
	    } else {
		set finalpath "$finalpath.[lindex $pathlist $i]"
	    }
        }
        return $finalpath
}

#
#Used to refresh the CmdNode in all the tables.
#

proc refreshCmdNode { } {
    set tableentryname [getNodeName 1]
    set nodename [getNodeName 0]
    set numberofrows [toe_send [locate $tableentryname] getTableDepth]
    if { $numberofrows == 0 } {
        return 
    }
    if { [catch { getValues } currentvalue ] } {
        set listtoreturn ""
        for {set i 0} { $i < $numberofrows } { incr i 1} {
            lappend listtoreturn ""
        }
        return $listtoreturn
    } else {
        set currentlength [llength $currentvalue]
        if { $numberofrows <= $currentlength } {
            return $currentvalue
        } else {
            for {set i $currentlength} { $i < $numberofrows } { incr i 1} {
                lappend currentvalue ""
            }
            return $currentvalue
        }
    }
}

#proc refreshEmptySlots { viewname } {
#    set slottableentrytoeid [locate originalTables.slotTable.slotEntry]
#    if { [toe_send $slottableentrytoeid getTableDepth] == 0 } {
#        dprint debug "One of the required tables has no data in it. originalTables.slotTable"
#        return
#    }
#    set slottype [toe_send [locate originalTables.slotTable.slotEntry.slotBoardType] getValues]  
#    if { [llength $slottype ] == 0 } {
#        return
#    }
#    set i 0
#    set emptyslotindexlist ""
#    foreach entry $slottype {
#        incr i
#        if { $entry == "Empty" } {
#            lappend emptyslotindexlist $i
#        }
#    }
#    if { [llength $emptyslotindexlist ] == 0 } {
#        return
#    }
#    foreach rowindex $emptyslotindexlist {
#        set rowdata [ lindex [toe_send $slottableentrytoeid getRowData -useDefaults $rowindex] 1 ] 
#        lappend listtoreturn [lindex $rowdata 0]
#        lappend listtoreturn [lindex $rowdata 1]
#        lappend listtoreturn [lindex $rowdata 9]
#        lappend listtoreturn [lindex $rowdata 6]
#        set listtoreturn [concat $listtoreturn [lrange $rowdata 3 5]]
#        lappend listtoreturn [lindex $rowdata 7]
#        lappend listtoreturn [lindex $rowdata 8]
#    }
#    return $listtoreturn
#}
proc refreshEmptySlots { viewname } {
    dprint debug "started refreshEmptySlots, viewname=$viewname"
    if { $viewname != "P" } {
        set tablename "slotTable$viewname"
    } else {
        set tablename "slotTable"
    }
    set slottableentrytoeid [locate originalTables.$tablename.slotEntry]
    if { [toe_send $slottableentrytoeid getTableDepth] == 0 } {
        dprint debug "One of the required tables has no data in it. originalTables.$tablename"
    dprint debug "ended refreshEmptySlots, viewname=$viewname"
        return
    }
    set slottype [toe_send [locate originalTables.$tablename.slotEntry.slotBoardType] getValues]  
    if { [llength $slottype ] == 0 } {
    dprint debug "ended refreshEmptySlots, viewname=$viewname"
        return
    }
    set i 0
    set emptyslotindexlist ""
    foreach entry $slottype {
        incr i
        if { $entry == "Empty" } {
            lappend emptyslotindexlist $i
        }
    }
    if { [llength $emptyslotindexlist ] == 0 } {
    dprint debug "ended refreshEmptySlots, viewname=$viewname"
        return
    }
    foreach rowindex $emptyslotindexlist {
        set rowdata [ lindex [toe_send $slottableentrytoeid getRowData -useDefaults $rowindex] 1 ] 
        lappend listtoreturn [lindex $rowdata 0]
        lappend listtoreturn [lindex $rowdata 1]
        lappend listtoreturn [lindex $rowdata 9]
        lappend listtoreturn [lindex $rowdata 6]
        set listtoreturn [concat $listtoreturn [lrange $rowdata 3 5]]
        lappend listtoreturn [lindex $rowdata 7]
        lappend listtoreturn [lindex $rowdata 8]
    }
    setTrapInfo refreshOID
    dprint debug "ended refreshEmptySlots, viewname=$viewname"
    return $listtoreturn
}

# Procedure called to refresh data for CPU Board Table.  It draws from two
# "hidden" tables.  The slotTable, and cpuBoardTable both of which are defined
# in models-d.x file.  

proc refreshCPUBoards { viewname } {
    dprint debug "started refreshCPUBoards, viewname=$viewname"
    if { $viewname != "P" } {
        set dom $viewname
    } else {
        set dom ""
    }
    set slottableentrytoeid [locate .iso*originalTables.slotTable$dom.slotEntry]
    set cpuboardtableentrytoeid [locate .iso*originalTables.cpuBoardTable$dom.cpuBoardEntry]
    if { [toe_send $slottableentrytoeid getTableDepth] == 0 } {
        dprint debug "One of the required tables has no data in it. originalTables.slotTable$dom"
        dprint debug "ended refreshCPUBoards, viewname=$viewname"
        return
    }
    if { [toe_send $cpuboardtableentrytoeid getTableDepth] == 0} {
        dprint debug "One of the required tables has no data in it. originalTables.cpuBoardTable$dom"
        dprint debug "ended refreshCPUBoards, viewname=$viewname"
        return
    }
    set slottype [toe_send [locate .iso*originalTables.slotTable$dom.slotEntry.slotBoardType] getValues]  
    if { [llength $slottype ] == 0 } {
        dprint debug "ended refreshCPUBoards, viewname=$viewname"
        return
    }
    set i 0
    set slotindexlist ""
    foreach entry $slottype {
        incr i
        if { $entry == "CPU" } {
            lappend slotindexlist $i
        }
    }
    if { [llength $slotindexlist ] == 0 } {
        dprint debug "ended refreshCPUBoards, viewname=$viewname"
        return
    }

    foreach rowindex $slotindexlist {
        #
        #Fill data from slot table
        #

        set rowdata [ lindex [toe_send $slottableentrytoeid getRowData -useDefaults $rowindex] 1 ]
        set index "[lindex $rowdata 0],[lindex $rowdata 1]"
	
        #Changes made for Jaguar Support. Instead of appending all the values
        #from the hidden table serengeti-platadmin-models-d.x cpuBoardTable
	#to listtoreturn and then barfing it out to the
        #console, we will take each entry and assign it to a variable so we can
        #better manipulate the presentation.

        set SlotChassisIndex [lindex $rowdata 0]
        set SlotIndex [lindex $rowdata 1]
        set SlotName [lindex $rowdata 9]
        set SlotPowerStatus [lindex $rowdata 6]
        set SlotBoardType [lindex $rowdata 3]
        set SlotState [lindex $rowdata 4]
        set SlotTestStatus [lindex $rowdata 5]
        set SlotDomain [lindex $rowdata 7]
        set SlotStatus [lindex $rowdata 8]

	#Here is where we gather the information from the cpuBoardTable.
        #
        #Bugfix 4660269 4/17/02
        #Fill data from cpu board table. First check to make sure the lookup
        #is successful. If not, fill in default values.
        #
        if { [toe_csend errMsg $cpuboardtableentrytoeid getRowIndex $index ] } {
	    set cpuBoardType "Unknown"
	    lappend listtoreturn $SlotChassisIndex $SlotIndex $SlotName $SlotPowerStatus $cpuBoardType $SlotState $SlotTestStatus $SlotDomain $SlotStatus

            foreach i { 1 2 3 4 5 } { lappend listtoreturn 0 }
            lappend listtoreturn "0|"
	    lappend listtoreturn "Unknown"
            dprint warning "Error while gathering CPU Board information: $errMsg"
            set boardName [lindex $rowdata 9] 
            dprint warning "Using default values for: $boardName."
        } else {

	    set cpuboardtablerowindex [ toe_send $cpuboardtableentrytoeid getRowIndex $index ]
 	    set cpuboardtablerowdata [lindex [ toe_send $cpuboardtableentrytoeid getRowData -useDefaults $cpuboardtablerowindex ] 1 ]

	    #Now that we have the cpuboardtablerowdata available we can pick out that
	    #entry for cpuBoardType and so that 
	    #we can put it in the right place in the console.
	    #Note: listtoreturn will be appended to each time it is run through this proceedure
	    #for each board. 

	    #
	    # CPU board type is got from cpu board table which may not be available.
	    #
	    set cpuBoardType [lindex $cpuboardtablerowdata 10]
	
	    lappend listtoreturn $SlotChassisIndex $SlotIndex $SlotName $SlotPowerStatus $cpuBoardType $SlotState $SlotTestStatus $SlotDomain $SlotStatus

	    set listtoreturn [concat $listtoreturn [lrange $cpuboardtablerowdata 3 9]]
        }
    }


    setTrapInfo refreshOID
    dprint debug "ended refreshCPUBoards, viewname=$viewname"
    return $listtoreturn
}

proc refreshIOBoards { viewname } {
    dprint debug "started refreshIOBoards, viewname=$viewname"
    if { $viewname != "P" } {
        set dom $viewname
    } else {
        set dom ""
    }
    set slottableentrytoeid [locate .iso*originalTables.slotTable$dom.slotEntry]
    set ioboardtableentrytoeid [locate .iso*originalTables.ioBoardTable$dom.ioBoardEntry]
    if { [toe_send $slottableentrytoeid getTableDepth] == 0 } {
        dprint debug "One of the required tables has no data in it. originalTables.slotTable$dom"
    dprint debug "ended refreshIOBoards, viewname=$viewname"
        return
    }
    if { [toe_send $ioboardtableentrytoeid getTableDepth] == 0} {
        dprint debug "One of the required tables has no data in it. originalTables.ioBoardTable$dom"
    dprint debug "ended refreshIOBoards, viewname=$viewname"
        return
    }
    set slottype [toe_send [locate .iso*originalTables.slotTable$dom.slotEntry.slotBoardType] getValues]  
    if { [llength $slottype ] == 0 } {
    dprint debug "ended refreshIOBoards, viewname=$viewname"
        return
    }
    set i 0
    set slotindexlist ""
    foreach entry $slottype {
        incr i
        if { $entry == "IO" } {
            lappend slotindexlist $i
        }
    }
    if { [llength $slotindexlist ] == 0 } {
    dprint debug "ended refreshIOBoards, viewname=$viewname"
        return
    }
    foreach rowindex $slotindexlist {
        #
        #Fill data from slot table
        #

        set rowdata [ lindex [toe_send $slottableentrytoeid getRowData -useDefaults $rowindex] 1 ]
        set index "[lindex $rowdata 0],[lindex $rowdata 1]"

	set slotChassisIndex [lindex $rowdata 0]
	set slotIndex [lindex $rowdata 1]
	set slotName [lindex $rowdata 9]
	set slotPowerStatus [lindex $rowdata 6]
	set slotState [lindex $rowdata 4]
	set slotTestStatus [lindex $rowdata 5]
	set slotDomain [lindex $rowdata 7]
	set slotStatus [lindex $rowdata 8]

        #
        # Fill data from io board table
        #
        
        #
        # Bugfix 4984246 1/27/04: Added check for non-existant io board data.
        # Fill data from io board table. First check to make sure the lookup
        # is successful. If not, fill in default values.
        #
        if { [toe_csend errMsg $ioboardtableentrytoeid getRowIndex $index ] } {
	    # construct the data from slot table but the io board type is set to unknown
	    set ioBoardType "Unknown"
	    set ioBoardFruIndex "0"
	    lappend listtoreturn $slotChassisIndex $slotIndex $slotName $slotPowerStatus $ioBoardType $slotState $slotTestStatus $slotDomain $slotStatus $ioBoardFruIndex

	    # construct the data from dummy data to replace info from ioboardtable.
            lappend listtoreturn "0"
            lappend listtoreturn "0"
            lappend listtoreturn "null"
            dprint warning "Error while gathering IO Board information: $errMsg"
            set boardName [lindex $rowdata 9]
            dprint warning "Using default values for: $boardName."
        } else {
	    set ioboardtablerowindex [ toe_send $ioboardtableentrytoeid getRowIndex $index ]
            set ioboardtablerowdata [lindex [ toe_send $ioboardtableentrytoeid getRowData -useDefaults $ioboardtablerowindex ] 1 ]

           #lappend listtoreturn [lrange $ioboardtablerowdata 3 7]
	   #Changes made to bring IO Board Table into conformity with the new CPU Board Table. 
	   #Old columns IO Board Type and IO Sub-Board Type have been merged.
	   #To do that we set some variables equal to values from the "hidden table"
	   #and then we manipluate the order that they are sent back to the console,
	   #by lappend'ing to listtoreturn.

	   set ioBoardType [lindex $ioboardtablerowdata 4]
	   set ioBoardFruIndex [lindex $ioboardtablerowdata 3]

	   lappend listtoreturn $slotChassisIndex $slotIndex $slotName $slotPowerStatus $ioBoardType $slotState $slotTestStatus $slotDomain $slotStatus $ioBoardFruIndex

           set listtoreturn [concat $listtoreturn [lrange $ioboardtablerowdata 5 7]]
    	}
    }
    setTrapInfo refreshOID
    dprint debug "ended refreshIOBoards, viewname=$viewname"
    return $listtoreturn
}
proc refreshL2Repeaters { viewname } {
    dprint debug "started refreshL2Repeaters, viewname=$viewname"
    if { $viewname != "P" } {
        set dom $viewname
    } else {
        set dom ""
    }
    set slottableentrytoeid [locate originalTables.slotTable$dom.slotEntry]
    set l2boardtableentrytoeid [locate originalTables.l2BoardTable$dom.l2BoardEntry]
    if { [toe_send $slottableentrytoeid getTableDepth] == 0 } {
        dprint debug "One of the required tables has no data in it. originalTables.slotTable$dom"
    dprint debug "ended refreshL2Repeaters, viewname=$viewname"
        return
    }
    if { [toe_send $l2boardtableentrytoeid getTableDepth] == 0} {
        dprint debug "One of the required tables has no data in it. originalTables.l2BoardTable$dom"
    dprint debug "ended refreshL2Repeaters, viewname=$viewname"
        return
    }
    set slottype [toe_send [locate originalTables.slotTable$dom.slotEntry.slotBoardType] getValues]  
    if { [llength $slottype ] == 0 } {
    dprint debug "ended refreshL2Repeaters, viewname=$viewname"
        return
    }
    set i 0
    set slotindexlist ""
    foreach entry $slottype {
        incr i
        if { $entry == "L2" } {
            lappend slotindexlist $i
        }
    }
    if { [llength $slotindexlist ] == 0 } {
    dprint debug "ended refreshL2Repeaters, viewname=$viewname"
        return
    }
    foreach rowindex $slotindexlist {
        #
        #Fill data from slot table
        #

        set rowdata [ lindex [toe_send $slottableentrytoeid getRowData -useDefaults $rowindex] 1 ]
        set index [lindex $rowdata 1]
        lappend listtoreturn [lindex $rowdata 0]
        lappend listtoreturn [lindex $rowdata 1]
        lappend listtoreturn [lindex $rowdata 9]
        lappend listtoreturn [lindex $rowdata 6]
        set listtoreturn [concat $listtoreturn [lrange $rowdata 3 5]]
        lappend listtoreturn [lindex $rowdata 7]
        lappend listtoreturn [lindex $rowdata 8]

        #
        # Fill data from io board table
        #
        if { [catch { toe_send $l2boardtableentrytoeid getRowIndex $index } values] } {
           set l2boardtablerowindex -1
        } else {
           set l2boardtablerowindex [ toe_send $l2boardtableentrytoeid getRowIndex $index ]
        }

	if { [catch { toe_send $l2boardtableentrytoeid getRowData -useDefaults $l2boardtablerowindex } values] } {
           lappend listtoreturn "0"
           lappend listtoreturn "Unknown"
           lappend listtoreturn "Unknown"
        } else {
           set l2boardtablerowdata [lindex [ toe_send $l2boardtableentrytoeid getRowData -useDefaults $l2boardtablerowindex ] 1 ]
           set listtoreturn [concat $listtoreturn [lrange $l2boardtablerowdata 2 4]]
        }
    }
    setTrapInfo refreshOID
    dprint debug "ended refreshL2Repeaters, viewname=$viewname"
    return $listtoreturn
}
proc refreshFanTrays { viewname } {
    dprint debug "started refreshFanTrays, viewname=$viewname"
    set slottableentrytoeid [locate originalTables.slotTable.slotEntry]
    set fantableentrytoeid [locate originalTables.fanTable.fanEntry]
    if { [toe_send $slottableentrytoeid getTableDepth] == 0 } {
        dprint debug "One of the required tables has no data in it. originalTables.slotTable"
    dprint debug "ended refreshFanTrays, viewname=$viewname"
        return
    }
    if { [toe_send $fantableentrytoeid getTableDepth] == 0} {
        dprint debug "One of the required tables has no data in it. originalTables.fanTable"
    dprint debug "ended refreshFanTrays, viewname=$viewname"
        return
    }
    set slottype [toe_send [locate originalTables.slotTable.slotEntry.slotBoardType] getValues]  
    if { [llength $slottype ] == 0 } {
    dprint debug "ended refreshFanTrays, viewname=$viewname"
        return
    }
    set i 0
    set slotindexlist ""
    foreach entry $slottype {
        incr i
        if { $entry == "Fan" } {
            lappend slotindexlist $i
        }
    }
    if { [llength $slotindexlist ] == 0 } {
    dprint debug "ended refreshFanTrays, viewname=$viewname"
        return
    }
    foreach rowindex $slotindexlist {
        #
        #Fill data from slot table
        #

        set rowdata [ lindex [toe_send $slottableentrytoeid getRowData -useDefaults $rowindex] 1 ]
        set index [lindex $rowdata 1]
        lappend listtoreturn [lindex $rowdata 0]
        lappend listtoreturn [lindex $rowdata 1]
        lappend listtoreturn [lindex $rowdata 9]
        lappend listtoreturn [lindex $rowdata 6]
        set listtoreturn [concat $listtoreturn [lrange $rowdata 3 5]]
        lappend listtoreturn [lindex $rowdata 7]
        lappend listtoreturn [lindex $rowdata 8]

        #
        # Fill data from io board table
        #
        
	if { [catch { toe_send $fantableentrytoeid getRowIndex $index } values] } {
           set fantablerowindex -1
        } else {
           set fantablerowindex [ toe_send $fantableentrytoeid getRowIndex $index ]
        }

	if { [catch { toe_send $fantableentrytoeid getRowData -useDefaults $fantablerowindex } values] } {
           lappend listtoreturn "0"
           lappend listtoreturn "Unknown"
        } else {
           set fantablerowdata [lindex [ toe_send $fantableentrytoeid getRowData -useDefaults $fantablerowindex ] 1 ]
           set listtoreturn [concat $listtoreturn [lrange $fantablerowdata 2 3]]
        }
    }
    setTrapInfo refreshOID
    dprint debug "ended refreshFanTrays, viewname=$viewname"
    return $listtoreturn
}
proc refreshPowerSupply { viewname } {
    dprint debug "started refreshPowerSupply, viewname=$viewname"
    set slottableentrytoeid [locate originalTables.slotTable.slotEntry]
    set pstableentrytoeid [locate originalTables.psTable.psEntry]
    if { [toe_send $slottableentrytoeid getTableDepth] == 0 } {
        dprint debug "One of the required tables has no data in it. originalTables.slotTable"
        dprint debug "ended refreshPowerSupply, viewname=$viewname"
        return
    }
    if { [toe_send $pstableentrytoeid getTableDepth] == 0} {
        dprint debug "One of the required tables has no data in it. originalTables.psTable"
        dprint debug "ended refreshPowerSupply, viewname=$viewname"
        return
    }
    set slottype [toe_send [locate originalTables.slotTable.slotEntry.slotBoardType] getValues]  
    if { [llength $slottype ] == 0 } {
        dprint debug "ended refreshPowerSupply, viewname=$viewname"
        return
    }
    set i 0
    set slotindexlist ""
    foreach entry $slottype {
        incr i
        if { $entry == "PowerSupply" } {
            lappend slotindexlist $i
        }
    }
    if { [llength $slotindexlist ] == 0 } {
        dprint debug "ended refreshPowerSupply, viewname=$viewname"
        return
    }
    foreach rowindex $slotindexlist {
        #
        #Fill data from slot table
        #

        set rowdata [ lindex [toe_send $slottableentrytoeid getRowData -useDefaults $rowindex] 1 ]
        set index [lindex $rowdata 1]
        lappend listtoreturn [lindex $rowdata 0]
        lappend listtoreturn [lindex $rowdata 1]
        lappend listtoreturn [lindex $rowdata 9]
        lappend listtoreturn [lindex $rowdata 6]
        set listtoreturn [concat $listtoreturn [lrange $rowdata 3 5]]
        lappend listtoreturn [lindex $rowdata 7]
        lappend listtoreturn [lindex $rowdata 8]

        #
        # Fill data from power supply table
        #

        set pstablerowindex [ toe_send $pstableentrytoeid getRowIndex $index ]

        #
        # Fix for bug 4844612: If data is missing we return default values
        # rather than skip entry. We need to do this to open an alarm.
        #
        if { [catch { toe_send $pstableentrytoeid getRowData -useDefaults $pstablerowindex } values] } {
            dprint debug "refreshPowerSupply: no power supply data available"
            lappend listtoreturn "-1"
            lappend listtoreturn "0|0|0"
            lappend listtoreturn "0"
            lappend listtoreturn "0"
            lappend listtoreturn "0|0:0:0:unknown|"
        } else {
            set pstablerowdata [lindex [ toe_send $pstableentrytoeid getRowData -useDefaults $pstablerowindex ] 1 ]
            set listtoreturn [concat $listtoreturn [lrange $pstablerowdata 2 6]]
        }
    }
    setTrapInfo refreshOID
    dprint debug "ended refreshPowerSupply, viewname=$viewname"
    return $listtoreturn
}
proc refreshSystemController { viewname } {
    dprint debug "started refreshSystemController, viewname=$viewname"
    set slottableentrytoeid [locate originalTables.slotTable.slotEntry]
    set sctableentrytoeid [locate originalTables.scTable.scEntry]
    if { [toe_send $slottableentrytoeid getTableDepth] == 0 } {
        dprint debug "One of the required tables has no data in it. originalTables.slotTable"
        dprint debug "ended refreshSystemController, viewname=$viewname"
        return
    }
    if { [toe_send $sctableentrytoeid getTableDepth] == 0} {
        dprint debug "One of the required tables has no data in it. originalTables.scTable"
        dprint debug "ended refreshSystemController, viewname=$viewname"
        return
    }
    set slottype [toe_send [locate originalTables.slotTable.slotEntry.slotBoardType] getValues]  
    if { [llength $slottype ] == 0 } {
    dprint debug "ended refreshSystemController, viewname=$viewname"
        return
    }
    set i 0
    set slotindexlist ""
    foreach entry $slottype {
        incr i
        if { $entry == "SC" } {
            lappend slotindexlist $i
        }
    }
    if { [llength $slotindexlist ] == 0 } {
    dprint debug "ended refreshSystemController, viewname=$viewname"
        return
    }
    foreach rowindex $slotindexlist {
        #
        #Fill data from slot table
        #

        set rowdata [ lindex [toe_send $slottableentrytoeid getRowData -useDefaults $rowindex] 1 ]

        set index "[lindex $rowdata 0],[lindex $rowdata 1]"
        lappend listtoreturn [lindex $rowdata 0]
        lappend listtoreturn [lindex $rowdata 1]
        lappend listtoreturn [lindex $rowdata 9]
        lappend listtoreturn [lindex $rowdata 6]
        set listtoreturn [concat $listtoreturn [lrange $rowdata 3 5]]
        lappend listtoreturn [lindex $rowdata 7]
        lappend listtoreturn [lindex $rowdata 8]

        #
        # Fill data from sc table
        #
	if { [catch { toe_send $sctableentrytoeid getRowIndex $index } values] } {
	   set sctablerowindex -1
        } else {
           set sctablerowindex [ toe_send $sctableentrytoeid getRowIndex $index ]
	}

	if { [catch { toe_send $sctableentrytoeid getRowData -useDefaults $sctablerowindex } values] } {
            dprint debug "refreshPowerSupply: no System Controller data available in scTable"
            lappend listtoreturn "0"
            lappend listtoreturn "0"
            lappend listtoreturn "Unknown"
            lappend listtoreturn "Unknown"
            lappend listtoreturn "Unknown"
            lappend listtoreturn "0"
            lappend listtoreturn "Unknown"
            lappend listtoreturn "0.0.0.0"
            lappend listtoreturn "0.0.0.0"
            lappend listtoreturn "0.0.0.0"
            lappend listtoreturn "0.0.0.0"
            lappend listtoreturn "0.0.0.0"
            lappend listtoreturn "0"
	} else {
            set sctablerowdata [lindex [ toe_send $sctableentrytoeid getRowData -useDefaults $sctablerowindex ] 1 ]
            lappend listtoreturn [lindex $sctablerowdata 2]
            set listtoreturn [concat $listtoreturn [lrange $sctablerowdata 4 15]]
        }
    }
    setTrapInfo refreshOID
    dprint debug "ended refreshSystemController, viewname=$viewname"
    return $listtoreturn
}

proc refreshUnknownBoards { viewname } {
    dprint debug "started refreshUnknownBoards, viewname=$viewname"
    if { $viewname != "P" } {
        set dom $viewname
    } else {
        set dom ""
    }

    #
    # look for the slot table
    #
    set slottableentrytoeid [locate originalTables.slotTable$dom.slotEntry]
    if { [toe_send $slottableentrytoeid getTableDepth] == 0 } {
        dprint debug "One of the required tables has no data in it. originalTables.slotTable$dom"
    	dprint debug "ended refreshCPUBoards, viewname=$viewname"
        return
    }

    #
    # get the slot types if the table is found
    # extract the boards with type unknown
    #
    set slottype [toe_send [locate originalTables.slotTable$dom.slotEntry.slotBoardType] getValues]  
    if { [llength $slottype ] == 0 } {
    	dprint debug "ended refreshUnknownBoards, viewname=$viewname"
        return
    }
    set i 0
    set slotindexlist ""
    foreach entry $slottype {
        incr i
        if { $entry == "Unknown" } {
            lappend slotindexlist $i
        }
    }
    if { [llength $slotindexlist ] == 0 } {
    	dprint debug "ended refreshCPUBoards, viewname=$viewname"
        return
    }
    foreach rowindex $slotindexlist {
        #
        #Fill data from slot table
        #

        set rowdata [ lindex [toe_send $slottableentrytoeid getRowData -useDefaults $rowindex] 1 ]
        set index "[lindex $rowdata 0],[lindex $rowdata 1]"
        lappend listtoreturn [lindex $rowdata 0]
        lappend listtoreturn [lindex $rowdata 1]
        lappend listtoreturn [lindex $rowdata 9]
        lappend listtoreturn [lindex $rowdata 6]
        set listtoreturn [concat $listtoreturn [lrange $rowdata 3 5]]
        lappend listtoreturn [lindex $rowdata 7]
        lappend listtoreturn [lindex $rowdata 8]

    }
    setTrapInfo refreshOID
    dprint debug "ended refreshUnknownBoards, viewname=$viewname"
    return $listtoreturn
}


#
#This is the check command for most of the tables. This function
#is called first time after the checkinterval but then it sets the 
#checkinterval to the value given in secondarycheckinterval (in 
#agent file) if the SC agent is not responding. If the SC agent is 
#responding then it sets the checkInterval to checkFinalInterval. 
#If the SC is not networked or agent is not respondingat the first 
#time then it returns nothing to prevent the refreh of the table. 
#After that it rturns the same value as previous return if the SC 
#is not networked or agent is not responding else it returns the 
#different value then the previous return to trigger the refresh of 
#the table.
#

proc isSCNetworked { } {

    #
    #Try to implement the initCheckInterval, primaryCheckInterval and secondaryCheckInterval
    #

    dprint debug "checkcommand called for node [getNodeName 0]"
    set primaryinterval [ lookup -d 0 value checkInterval ]
    set secondaryinterval [ lookup -d $primaryinterval value checkSecondaryInterval]
    set finalinterval [ lookup -d $primaryinterval value checkFinalInterval]
    dprint debug "primaryinterval=$primaryinterval, secondaryinterval=$secondaryinterval, finalinterval = $finalinterval"

    set scagentstatus [ toe_send [locate serengeti-platadmin.scagentstatus ] lookup -d 0 data 0 ]
    dprint debug "inside isSCNetworked scagentstatus=$scagentstatus"
    set firsttime [exists private checkvalue]
    if { $firsttime == 0 } {
        if { $scagentstatus == 2 } {
            define private checkvalue 1
            if { $primaryinterval != $finalinterval } {
		checkValueUpdate $finalinterval
            }
            dprint debug "returning 1"
            return 1
        } else {
            if { $primaryinterval != $secondaryinterval } {
		checkValueUpdate $secondaryinterval
            }
            dprint debug "returning nothing"
            return 
        }
    }
    dprint debug "This is not the first time check"

    set prevret [lookup private checkvalue]
    dprint debug "Previous return was $prevret"
    if { $scagentstatus == 2 } {
	if { $prevret == 1 } {
	    define private checkvalue 0
            if { $primaryinterval != $finalinterval } {
		checkValueUpdate $finalinterval
            }
            dprint debug "Previous return was 1 so returning 0, sc agent is up"
	    return 0
	} else {
	    define private checkvalue 1
            if { $primaryinterval != $finalinterval } {
		checkValueUpdate $finalinterval
            }
            dprint debug "Previous return was 0 so returning 1, sc agent is up"
	    return 1
	}
    } else {
        dprint debug "sc agent is not up so returning the previous value $prevret"
        return $prevret
    }
}


proc refreshDiscoveryObjectTable { } {
    dprint debug "Starting refresh of discovery object table"
    set index 0
    set ip_address [resolveHostName [info hostname]]
    set componentname [ lookup value component ]
    set port  [toe_send [locate ._config.$componentname ] "lookup value snmpPort"]
    set scport [toe_send [getModuleRoot] lookup -d 161 param targetPort ]
    set scip  [valueOf serengeti-platadmin.remoteIPAddress]
    #set localfamilytype [toe_send [locate .iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.base.info.system.familytype ] lookup -d "generic-host" data 0 ]
    set localfamilytype [toe_send [locate ._config.$componentname ] lookup -d "generic-host" value family_name ]

    #
    #Get the chassis model to form the family type.
    #
 
    set chassismodel [ toe_send [ locate serengeti-platadmin.platform.chassis.chassisTable.chassisEntry.chassisModel ] lookup -d "Unknown" data 1 ]
    if { $chassismodel == "Unknown" } {
        return ""
    } 
    #set cmodel [ lindex [split $chassismodel -] 0 ]
    switch -exact -- $chassismodel {
        "Sun Fire 3800" { set cmodel 3800 }
        "Sun Fire 4800" { set cmodel 4800 }
        "Sun Fire 4810" { set cmodel 4810 }
        "Sun Fire E4900" { set cmodel E4900 }
        "Sun Fire 6800" { set cmodel 6800 }
        "Sun Fire E6900" { set cmodel E6900 }
    }
    dprint debug "chassis model is $cmodel"


    set domainport -1

    set firstrow [list [incr index ] "Sun-Fire_Platform_${cmodel}_Group_${componentname}" "" 2 $ip_address $port "sun-Sun-Fire-${cmodel}-group" "Sun-Fire_Platform_Group" "Object For Sun Fire Platform Group" ]
    set secondrow [list [incr index ] "Sun-Fire_Proxy_Platform_${componentname}" "Sun-Fire_Platform_${cmodel}_Group_${componentname}" 3 $ip_address $port "$localfamilytype" "Sun-Fire_Proxy_Platform" "Object For Sun Fire Platform" ]
    set thirdrow [list [incr index ] "Sun-Fire_Platform_SC_${componentname}" "Sun-Fire_Platform_${cmodel}_Group_${componentname}" 3 $scip $scport "sun-Sun-Fire-${cmodel}-platform" "Sun-Fire_Platform_SC" "Object For Sun Fire SC" ]
    set listtoreturn "$firstrow $secondrow $thirdrow"

    dprint debug "formed the first three row and they are $listtoreturn"
    set scnetworked [ toe_send [locate serengeti-platadmin.scagentstatus ] lookup -d 0 data 0 ]
    #set scnetworked [ valueOf serengeti-platadmin.scnetworked ]
    
    if { $scnetworked != 2 } {

        dprint debug "SC is not networked or SC Agent is not responding, so refreshing the DOT from configuration file"
        #
        #SC is not networked, so refresh the dot from configuration file
        #
        set domaip [getValueFromCfgFile domainAIP]
        set dombip [getValueFromCfgFile domainBIP]
        set domcip [getValueFromCfgFile domainCIP]
        set domdip [getValueFromCfgFile domainDIP]
        set dominiplist [list $domaip $dombip $domcip $domdip]
    
        set domaport [getValueFromCfgFile domainAPort] 
        set dombport [getValueFromCfgFile domainBPort] 
        set domcport [getValueFromCfgFile domainCPort] 
        set domdport [getValueFromCfgFile domainDPort] 
        set domainportlist [list $domaport $dombport $domcport $domdport]
        dprint debug "list of domain ips = $dominiplist and list of domain ports = $domainportlist"
        for { set i 0 } { $i < [llength $dominiplist] } { incr i 1 } {
            set domainip [lindex $dominiplist $i]
            dprint debug "making entries for domain $domainip"
            if { $domainip != "null" } {
                set domainport [lindex $domainportlist $i]
                if { $domainport != "null" } {
                    if { [isIpAddress $domainip ] } {
			set domain_ip $domainip
                        if { [catch {ip2host $domainip} domainnodename ] } {
                            set domainnodename $domainip
                        }
                    } else {
			if { [catch {resolveHostName $domainip } domain_ip] } {
			    dprint debug "Could not convert the hostname $domainip to IP address"
			    continue
			} 
			#set domain_ip [resolveHostName $domainip]
                        set domainnodename $domainip
                    }
                    #set domain_ip [resolveHostName $domainip]
                    switch -exact -- $i {
                        0 {
                            set domainlabelfordot "$domainnodename\(DomainA\)"
                        } 
                        1 {
                            set domainlabelfordot "$domainnodename\(DomainB\)"
                        } 
                        2 {
                            set domainlabelfordot "$domainnodename\(DomainC\)"
                        } 
                        3 {
                            set domainlabelfordot "$domainnodename\(DomainD\)"
                        } 
                        default {
                            set domainlabelfordot "$domainnodename"
                        } 
                    }
		    set domain_list [list [incr index] "Domain_${domain_ip}_${componentname}" "Sun-Fire_Platform_${cmodel}_Group_${componentname}" 1 $domain_ip $domainport "sun4u-Sun-Sun-Fire-${cmodel}" "$domainlabelfordot" "Object For Sun fire Domain" ] 
		    set listtoreturn "$listtoreturn $domain_list"
                } else {
                    dprint debug "The port for domain $domainip is null so ignoring it"
                }
            } else {
                dprint debug "The ipaddress for domain is null so ignoring it"
            }
        }
        dprint debug "final list to return = $listtoreturn"
        return $listtoreturn

    } else {
        dprint debug "SC Agent is responding so refreshing from domain table"
	#set domaintabletoeid [locate serengeti-platadmin.platform.domains.domainTable]
        set domainnodenametoeid [locate serengeti-platadmin.platform.domains.domainTable.domainEntry.domainNodeName ]
        set domaindomaintoeid [locate serengeti-platadmin.platform.domains.domainTable.domainEntry.domainDomain ]
        set domainstatustoeid [locate serengeti-platadmin.platform.domains.domainTable.domainEntry.domainStatus ]
	#set domain_names [ toe_send [locate serengeti-platadmin.platform.domains.domainTable.domainEntry.domainNodeName ] getValues ]
        if { [toe_csend domain_names $domainnodenametoeid getValues ] } {
            dprint debug "Domain Table not yet refreshed, Could not get the list of domain node names."
	    define private refreshed 1
	    dprint debug "final list to return = $listtoreturn"
	    return $listtoreturn
        } 
	dprint debug "domain names found in domain table are $domain_names"
	set domainrownumber 0
	foreach domain $domain_names {
	    incr domainrownumber
	    if { [isIpAddress $domain ] } {
		set domain_ip $domain
	    } else {
		if { [catch {resolveHostName $domain } domain_ip] } {
		    dprint debug "Could not convert the hostname $domain to IP address"
		    continue
		} 
	    }
	    set domaindomain [ toe_send $domaindomaintoeid lookup -d Unknown data $domainrownumber ]
	    switch -exact -- $domaindomain {
	        DomainA {
		    set domainport [getValueFromCfgFile domainAPort ]
		    if { $domainport == "null" } {
			set domainport -1
		    }
		    
		    updateConfigFile domainAIP $domain_ip
		}
		DomainB {
		    set domainport [getValueFromCfgFile domainBPort ]
		    if { $domainport == "null" } {
			set domainport -1
		    }
		    updateConfigFile domainBIP $domain_ip
		}
		DomainC {
		    set domainport [getValueFromCfgFile domainCPort ]
		    if { $domainport == "null" } {
			set domainport -1
		    }
		    updateConfigFile domainCIP $domain_ip
		}
		DomainD {
		    set domainport [getValueFromCfgFile domainDPort ]
		    if { $domainport == "null" } {
			set domainport -1
		    }
		    updateConfigFile domainDIP $domain_ip
		}
		default {
		    continue
		}
	    }
	    set domainstat [ toe_send $domainstatustoeid lookup -d Unknown data $domainrownumber ]
            dprint debug "status for rownumber $domainrownumber = $domainstat"
	    switch -exact -- $domainstat {
		Active {
		    set domainlabel "$domain\($domaindomain\)"
                    dprint debug "Label for Active  = $domainlabel"
		}
		default {
		    set domainlabel "$domain"
                    dprint debug "Default Label = $domainlabel"
		}
	    }
	    set domain_list [list [incr index] "Domain_${domain_ip}_${componentname}" "Sun-Fire_Platform_${cmodel}_Group_${componentname}" 1 $domain_ip $domainport "sun4u-Sun-Sun-Fire-${cmodel}" "$domainlabel" "Object For Sun Fire Domain" ] 
	    set listtoreturn "$listtoreturn $domain_list"
	}
	define private refreshed 1
	dprint debug "final list to return = $listtoreturn"
	return $listtoreturn
    }
}
	
#
#Function to get value from the configuration file. If the 
#variable is not found in the file then it return 'null'
#

proc getValueFromCfgFile { variable } {
    global env
    set retval "null"
    set componentname [ lookup value component ]
    set configfile "$env(ESDIR)/cfg/serengeti-platadmincfg-$componentname-d.dat"
    if [ catch { open $configfile r } fileId ] {
        dprint error "Could not open file $configfile for reading"
        return $retval
    } else {
        foreach line [ split [read $fileId] \n ] {
            set varname  [lindex [split $line :] 0]
            set varvalue [lindex [split $line :] 1]
            if { $variable == $varname } {
		set retval $varvalue
		break
            } 
        }
        close $fileId
        return $retval
    }
        
}

#
#Function to refresh the column in domainTable. This column
#cotains the port on which the sunMC agent is setup to work
#on the related domain. The port information is read from
#the configuration file.
#

proc refreshsnmpAgentPort { } {
    set tableentryname [getNodeName 1]
    set nodename [getNodeName 0]
    set numberofrows [toe_send [locate $tableentryname] getTableDepth]
    if { $numberofrows == 0 } {
        return 
    }
    for { set i 1} { $i <= $numberofrows } { incr i 1} {
        set domain [toe_send [locate domainDomain ] lookup -d Unknown data $i] 
        switch -exact -- $domain {
            DomainA {
                set snmpport [getValueFromCfgFile domainAPort]
            }
            DomainB {
                set snmpport [getValueFromCfgFile domainBPort]
            }
            DomainC {
                set snmpport [getValueFromCfgFile domainCPort]
            }
            DomainD {
                set snmpport [getValueFromCfgFile domainDPort]
            }
            default {
                set snmpport 161
            }
        } 
        lappend listtoreturn $snmpport
    }
    return $listtoreturn
}

proc refreshCompleteSystem { } {
    refreshSlotTablesInAllViews
    return
}

proc refreshSystemPlatform { } {
    refreshSlotTablesInAllViews
    set nodetoeid [ locate serengeti-platadmin.platform.chassis.chassisTable.chassisEntry.chassisModel ]
    if { [ toe_csend retnvalue $nodetoeid getValues ] } {
        dprint debug "Could not get the chassis model type, PV/LV will be affected"
        return [list "unknown"]
    } else {
	set retvalue [ lindex $retnvalue 0 ]
	switch -exact -- $retvalue {
            Unknown {
                return [list "unknown"]
            }
            "Sun Fire 3800" {
                return [list "Sun-Fire-3800"]
            }
            "Sun Fire 4800" {
                return [list "Sun-Fire-4800"]
            }
            "Sun Fire 4810" {
                return [list "Sun-Fire-4810"]
            }
            "Sun Fire E4900" {
                return [list "Sun-Fire-E4900"]
            }
            "Sun Fire 6800" {
                return [list "Sun-Fire-6800"]
            }
            "Sun Fire E6900" {
                return [list "Sun-Fire-E6900"]
            }
            default {
                return [list "unknown"]
            }
        }
    }
}

proc refresh_total_config_changes { } {
    set currentvalue [lookup -d 0 data 0]
    return [expr $currentvalue + 1]
    setTrapInfo refreshOID
}

proc refreshSCAgentStatus { ecm command } {
    #puts "sampleCommand [ list [ list $ecm $command ] ]"
    regsub -all {%} $ecm {%%} ecm
    return [ evaluateCommand snmp "" $command [ list [ list refreshSCAgentStatusCallback %result $ecm ]]]

}

proc refreshSCAgentStatusCallback { result ecm } {
    if { [lindex $result 0] == "wait" } {
        #setParameters result $result
        pushParameters result $result
    } else {
        if { [lindex $result 2] == "Agent Not Responding" } {
            pushParameters result [list data [lindex $result 1] 1 ]
            #setParameters result [list data [lindex $result 1] 1 ]
        } else {
            if { [lindex $result 2] == "Host Not Responding" } {
		pushParameters result [list data [lindex $result 1] 0 ]
		#setParameters result [list data [lindex $result 1] 0 ]
            } else {
		pushParameters result [list data [lindex $result 1] 2 ]
		#setParameters result [list data [lindex $result 1] 2 ]
            }
        }
    }
    evalECM $ecm
    #clearParameters result
    popParameters result

    #refresh if status changes
    checkAgentStatus
}

#
# insure that daq.chassis drives a refresh, if the SC SNMP agent status changes to 2
#
# slice/key checkAgentStatus/status, the previous value for scagentstatus
#

proc checkAgentStatus { } {

    # get current SC SNMP agent status
    if { [ catch { valueOf scagentstatus } status ] } {
	dprint error "checkAgentStatus, valueOf failed. $status"
	return
    }

    if { "$status" == "2" } {

	# get the old SC SNMP agent status from slice/key checkAgentStatus/status
	catch { ilookup -d 0 checkAgentStatus status } oldstatus
    
	if { "$status" != "$oldstatus" } {
	    if { [ toe_csend x [ locate .iso*serengeti-platadmin.daq.chassis ] { refreshValueAndTrap } ] } {
		dprint error "checkAgentStatus, toe_csend failed. $x"
		return
	    }
	    dprint debug "checkAgentStatus, SC SNMP agent status up."
	}
    }

    # save the current status
    define checkAgentStatus status $status
}



proc refreshslotsNotInACL { } {
    set acllist [toe_send [locate domainACLDescr] getValues ]
    set completeacllist [toe_send [locate serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry.slotName ] getValues ]
    if { [llength $acllist] == 0 } {
        return [list ""]
    }
    if { [llength $completeacllist] == 0 } {
        dprint debug "It seems there is nothing in the slotTable of originalTables. acllist != empty but completeacllist = empty"
        return [list ""]
    }
    
    #Get the index of the boards in all the slots
    set slotindextoeid [locate  serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry.slotIndex ]
    if { [catch { toe_send $slotindextoeid getValues } values ] } {
	#caught exception
	dprint debug "could not find the values of slotIndex from slotTable"
	return [list ""]
    } 

     #The acllist is a list of elements eg: { ab c} {a c}, so 2 for loops are needed
     foreach acl $acllist {
         set entry ""
	 set typeindex 0
         foreach name $completeacllist {

	     set brdindex ""
	     #Using the index get the type for this slot
	     set brdindex [ lindex  $values $typeindex ]
	     set typeindex [ expr $typeindex + 1 ]

	     #Check if this slot contains/can contain a system board
	     if { $brdindex >= 400 && $brdindex < 600 } {

		#slotName have /N../<slot> while domainACLDescr are just slot
		#So get the slot from slotName
		set name [ split $name / ]
		set name [ lindex $name [ expr [ llength $name ] -1 ]]
		#Check if it is in the ACL
		if { [lsearch -exact $acl $name ] == -1 } {
			#Not in the ACL list so add to the notInACLList
			if { [string length $entry] == 0 } {
				append entry "$name"
			} else {
				append entry " $name"
			}
		}
	     }

	}
	lappend listtoreturn "$entry"
    }
    return $listtoreturn
}

proc registertohdregmodule { } {
    dprint debug "Registering to hardware registry module"
    set rtn [ catch { locate hdreg.hdreg-table } obj ]
    if { $rtn == "1" } {
	dprint error "Hardware registry module has not been loaded"
	return
    }
    toe_send $obj regModule serengeti-platadmin "{platform}" S "platform.chassis.chassisTable"
}

proc unregisterfromhdregmodule { } {
    dprint debug "Unregistering to hardware registry module"
    set rtn [ catch { locate hdreg.hdreg-table } obj ]
    if { $rtn == "1" } {
	dprint error "Hardware registry module has not been loaded"
	return
    }
    toe_send $obj unregModule serengeti-platadmin
}

#
#New code to refresh all sunSmTreeProp
#

proc refreshAllSunSmTreeProp { } {
    dprint debug "============== Starting the refresh of all sunSmTreeProp ===================="

    global env
    set componentname [ lookup value component ]
    set treefile "$env(ESDIR)/cfg/serengeti-platadmin-$componentname.tree"
    if [ catch { open $treefile w+ } fileId ] {
        dprint error "Could not open file $treefile for writing."
        return 
    } 

    #
    #put system node tree info into tree file
    #

    #puts $fileId "system:1:0:system:platform.chassis.chassisTable:null:1:0:-:null:null:null:null:null"
    #flush $fileId

    #
    #refresh the sunSmTreeProp for chassisTable
    #
    
    dprint debug "-------------- Starting the refresh of ChassisTable ----------------"
    refreshSunSmTreePropOfChassisTable $fileId
    dprint debug "-------------- Ending the refresh of ChassisTable ----------------"

    #
    #refresh the sunSmTreeProp for systemControllerTable
    #
    
    dprint debug "-------------- Starting the refresh of systemControllerTable ----------------"
    refreshSunSmTreePropOfsystemControllerTable $fileId
    dprint debug "-------------- Ending the refresh of systemControllerTable ----------------"

    #
    #refresh the sunSmTreeProp for fanTrayTable
    #
    
    dprint debug "-------------- Starting the refresh of fanTrayTable ----------------"
    refreshSunSmTreePropOffanTrayTable $fileId
    dprint debug "-------------- Ending the refresh of fanTrayTable ----------------"

    #
    #refresh the sunSmTreeProp for powerSupplyTable
    #
    
    dprint debug "-------------- Starting the refresh of powerSupplyTable ----------------"
    refreshSunSmTreePropOfpowerSupplyTable $fileId
    dprint debug "-------------- Ending the refresh of powerSupplyTable ----------------"

    #
    #refresh the sunSmTreeProp for slotTable
    #
    
    dprint debug "-------------- Starting the refresh of slotTable ----------------"
    refreshSunSmTreePropOfslotTable $fileId
    dprint debug "-------------- Ending the refresh of slotTable ----------------"

    #
    #refresh the sunSmTreeProp for CPU and IO related tables
    #
    
    dprint debug "-------------- Starting the refresh of otherTables ----------------"
    refreshSunSmTreePropOfotherTables $fileId
    dprint debug "-------------- Ending the refresh of otherTables ----------------"

    #
    #refresh the sunSmTreeProp for cpuMod table
    #

    dprint debug "-------------- Starting the refresh of cpuModTable ----------------"
    refreshSunSmTreePropOfcpuModTable $fileId
    dprint debug "-------------- Ending the refresh of cpuModTable ----------------"

    #
    #refresh the sunSmTreeProp for dimm table
    #

    dprint debug "-------------- Starting the refresh of dimmTable ----------------"
    refreshSunSmTreePropOfdimmTable $fileId
    dprint debug "-------------- Ending the refresh of dimmTable ----------------"

    #
    #refresh the sunSmTreeProp for ecacheTable table
    #

    dprint debug "-------------- Starting the refresh of ecacheTable ----------------"
    refreshSunSmTreePropOfecacheTable $fileId
    dprint debug "-------------- Ending the refresh of ecacheTable ----------------"

    #
    #refresh the sunSmTreeProp for wciModTable table
    #

    dprint debug "-------------- Starting the refresh of wciModTable ----------------"
    refreshSunSmTreePropOfwciModTable $fileId
    dprint debug "-------------- Ending the refresh of wciModTable ----------------"

    #
    #refresh the sunSmTreeProp for wciPortTable table
    #

    dprint debug "-------------- Starting the refresh of wciPortTable ----------------"
    refreshSunSmTreePropOfwciPortTable $fileId
    dprint debug "-------------- Ending the refresh of wciPortTable ----------------"

    #
    #refresh the sunSmTreeProp for l2RepeaterTable
    #
    
    dprint debug "-------------- Starting the refresh of l2RepeaterTable ----------------"
    refreshSunSmTreePropOfl2RepeaterTable $fileId
    dprint debug "-------------- Ending the refresh of l2RepeaterTable ----------------"

    close $fileId
    dprint debug "============== Ending the refresh of all sunSmTreeProp ===================="
    return 
}


proc refreshSunSmTreePropOfChassisTable { treefileid } {
    dprint debug "Starting refresh of sunSmTreeProp for table chassisTable"

    set entryindextoeid [locate  serengeti-platadmin.platform.chassis.chassisTable.chassisEntry.chassisIndex ]
    set sunsmtreproptoeid [ locate serengeti-platadmin.platform.chassis.chassisTable.chassisEntry.sunSmTreeProp ]
    set sunsmnodenametoeid [ toe_send $sunsmtreproptoeid locate sunSmNodeName ]

    set indices [toe_send $entryindextoeid getIndices]
    set numberofindex [llength $indices]
    if { $numberofindex == 0 } {
        dprint debug "Data not yet populated in table chassisTable"
        return
    }
    
    # 
    #Reset the previous values
    #

    toe_send $sunsmtreproptoeid refreshValue
    toe_send $sunsmnodenametoeid refreshValue

    dprint debug "list to return before pdistr = chassis(1):platform.slots.systemController.systemControllerTable:null:1:0"
    set pdistretc [getImageNamePdiStrEtc chassisTable 1 "null" ]
    dprint debug "pdistr = $pdistretc"
    toe_send $sunsmtreproptoeid setValue 1 "{chassis:platform.slots.systemController.systemControllerTable:null:1:0:$pdistretc}"
    toe_send $sunsmnodenametoeid setValue 1 "chassis"

    #
    #Code To Dump the sunSmTreeProp into tree file.
    #

    set moname "platform.chassis.chassisTable"
    set instance "1"
    set snmpindex [toe_send $sunsmtreproptoeid getRowName 1]
    dprint debug "string to put into tree file is = $moname:$instance:$snmpindex:chassis:platform.slots.systemController.systemControllerTable:null:1:0:$pdistretc"
    puts $treefileid "$moname:$instance:$snmpindex:chassis:platform.slots.systemController.systemControllerTable:null:1:0:$pdistretc"
    flush $treefileid

    #
    # fixed from Quinton for scfailover
    #
    if { [ toe_csend x [ locate .iso*serengeti-platadmin.platform.chassis.chassisTable ] { setTrapInfo refreshOID } ] } {
	dprint error "refreshSunSmTreePropOfChassisTable, toe_csend failed, $x"
    }

    return
}



proc refreshSunSmTreePropOfsystemControllerTable { treefileid } {
    dprint debug "Starting refresh of sunSmTreeProp for table systemControllerTable"

    set entryindextoeid [locate  serengeti-platadmin.platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerChassisIndex ]
    set namenodetoeid [locate  serengeti-platadmin.platform.slots.systemController.systemControllerTable.systemControllerEntry.systemControllerName ]
    set sunsmtreproptoeid [ locate serengeti-platadmin.platform.slots.systemController.systemControllerTable.systemControllerEntry.sunSmTreeProp ]
    set sunsmnodenametoeid [ toe_send $sunsmtreproptoeid locate sunSmNodeName ]

    set indices [toe_send $entryindextoeid getIndices]
    set numberofindex [llength $indices]
    if { $numberofindex == 0 } {
        dprint debug "Data not yet populated in table systemControllerTable"
        return
    }
    
    # 
    #Reset the previous values
    #

    toe_send $sunsmtreproptoeid refreshValue
    toe_send $sunsmnodenametoeid refreshValue

    for {set i 0} {$i < $numberofindex} {incr i 1} {
        set rowindex [lindex $indices $i]
        set lastindex [ expr $numberofindex - 1 ]
        if { $i == $lastindex } {
            set brother "platform.slots.fanTrays.fanTrayTable"
            set brotherindex 1
        } else {
	    set brother "platform.slots.systemController.systemControllerTable"
            set brotherindex [ lindex $indices [ expr $i + 1 ] ]
        }
        #set nodeName "SystemController($rowindex)"
        set nodeName [toe_send $namenodetoeid lookup -d "SystemController\($i\)" data $rowindex ]
	set pdistretc [getImageNamePdiStrEtc systemControllerTable $rowindex "null" ]
	toe_send $sunsmtreproptoeid setValue $rowindex "{$nodeName:null:$brother:0:$brotherindex:$pdistretc}"
	toe_send $sunsmnodenametoeid setValue $rowindex "$nodeName"

	#
	#Code To Dump the sunSmTreeProp into tree file.
	#

	set moname "platform.slots.systemController.systemControllerTable"
	set instance "$rowindex"
	set snmpindex [toe_send $sunsmtreproptoeid getRowName $rowindex]
	puts $treefileid "$moname:$instance:$snmpindex:$nodeName:null:$brother:0:$brotherindex:$pdistretc"
	flush $treefileid
    }
    return
}

proc refreshSunSmTreePropOffanTrayTable { treefileid } {
    dprint debug "Starting refresh of sunSmTreeProp for table fanTrayTable"

    set entryindextoeid [locate  serengeti-platadmin.platform.slots.fanTrays.fanTrayTable.fanEntry.fanChassisIndex ]
    set namenodetoeid [locate  serengeti-platadmin.platform.slots.fanTrays.fanTrayTable.fanEntry.fanName ]
    set sunsmtreproptoeid [ locate serengeti-platadmin.platform.slots.fanTrays.fanTrayTable.fanEntry.sunSmTreeProp ]
    set sunsmnodenametoeid [ toe_send $sunsmtreproptoeid locate sunSmNodeName ]

    set indices [toe_send $entryindextoeid getIndices]
    set numberofindex [llength $indices]
    if { $numberofindex == 0 } {
        dprint debug "Data not yet populated in table fanTrayTable"
        return
    }
    
    # 
    #Reset the previous values
    #

    toe_send $sunsmtreproptoeid refreshValue
    toe_send $sunsmnodenametoeid refreshValue

    for {set i 0} {$i < $numberofindex} {incr i 1} {
        set rowindex [lindex $indices $i]
        set lastindex [ expr $numberofindex - 1 ]
        if { $i == $lastindex } {
            set brother "platform.slots.powerSupply.powerSupplyTable"
            set brotherindex 1
        } else {
	    set brother "platform.slots.fanTrays.fanTrayTable"
            set brotherindex [ lindex $indices [ expr $i + 1 ] ]
        }
        #set nodeName "FanTray($rowindex)"
        set nodeName [toe_send $namenodetoeid lookup -d "FanTray\($i\)" data $rowindex ]
	set pdistretc [getImageNamePdiStrEtc fanTrayTable $rowindex "null" ]
	toe_send $sunsmtreproptoeid setValue $rowindex "{$nodeName:null:$brother:0:$brotherindex:$pdistretc}"
	toe_send $sunsmnodenametoeid setValue $rowindex "$nodeName"

	#
	#Code To Dump the sunSmTreeProp into tree file.
	#

	set moname "platform.slots.fanTrays.fanTrayTable"
	set instance "$rowindex"
	set snmpindex [toe_send $sunsmtreproptoeid getRowName $rowindex]
	puts $treefileid "$moname:$instance:$snmpindex:$nodeName:null:$brother:0:$brotherindex:$pdistretc"
	flush $treefileid
    }
    return
}

proc refreshSunSmTreePropOfpowerSupplyTable { treefileid } {
    dprint debug "Starting refresh of sunSmTreeProp for table powerSupplyTable"

    set entryindextoeid [locate  serengeti-platadmin.platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyChassisIndex ]
    set namenodetoeid [locate  serengeti-platadmin.platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.powerSupplyName ]
    set sunsmtreproptoeid [ locate serengeti-platadmin.platform.slots.powerSupply.powerSupplyTable.powerSupplyEntry.sunSmTreeProp ]
    set sunsmnodenametoeid [ toe_send $sunsmtreproptoeid locate sunSmNodeName ]

    set indices [toe_send $entryindextoeid getIndices]
    set numberofindex [llength $indices]
    if { $numberofindex == 0 } {
        dprint debug "Data not yet populated in table powerSupplyTable"
        return
    }
    
    # 
    #Reset the previous values
    #

    toe_send $sunsmtreproptoeid refreshValue
    toe_send $sunsmnodenametoeid refreshValue
    dprint debug "Data has been populated in table powerSupplyTable, numberof rows = $numberofindex"

    for {set i 0} {$i < $numberofindex} {incr i 1} {
        set rowindex [lindex $indices $i]
        set lastindex [ expr $numberofindex - 1 ]
        if { $i == $lastindex } {
            set brother "platform.slots.originalTables.slotTable"
            #
            #Calculate the index in slotTable for first cpuSlot entry
            #
            set brotherindex 0
            set slottableentrytoeid [locate serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry]
            set slotboardtypetoeid [ locate serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry.slotBoardType ]


            #set values [ toe_send $slotboardtypetoeid getValues ]
	    if { [catch { toe_send $slotboardtypetoeid getValues } values ] } {
		#caught exception
                dprint debug "could not find the values of slotBoardType from slotTable"
	    } else { 

		set numberofvalues [llength $values ]
		for { set j 1 } { $j <= $numberofvalues } { incr j 1 } {
		    #set type [ toe_send $slotboardtypetoeid getValue $j ]
                    if { [catch { toe_send $slotboardtypetoeid getValue $j } type ] } {
                        dprint debug "could not find the values of slotBoardType for index $j from slotTable"
                        continue
                    }
		    if { "$type" == "CPU" } {
			set brotherindex $j
			break
		    }
		}
            }
        } else {
	    set brother "platform.slots.powerSupply.powerSupplyTable"
            set brotherindex [ lindex $indices [ expr $i + 1 ] ]
        }
        #set nodeName "PowerSupply($rowindex)"
        set nodeName [toe_send $namenodetoeid lookup -d "PowerSupply\($i\)" data $rowindex ]
	set pdistretc [getImageNamePdiStrEtc powerSupplyTable $rowindex "null" ]
	toe_send $sunsmtreproptoeid setValue $rowindex "{$nodeName:null:$brother:0:$brotherindex:$pdistretc}"
	toe_send $sunsmnodenametoeid setValue $rowindex "$nodeName"

	#
	#Code To Dump the sunSmTreeProp into tree file.
	#

	set moname "platform.slots.powerSupply.powerSupplyTable"
	set instance "$rowindex"
	set snmpindex [toe_send $sunsmtreproptoeid getRowName $rowindex]
	puts $treefileid "$moname:$instance:$snmpindex:$nodeName:null:$brother:0:$brotherindex:$pdistretc"
	flush $treefileid
    }
    return
}

proc refreshSunSmTreePropOfl2RepeaterTable { treefileid } {
    dprint debug "Starting refresh of sunSmTreeProp for table l2RepeaterTable"

    set entryindextoeid [locate  serengeti-platadmin.platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.l2RepeaterChassisIndex ]
    set namenodetoeid [locate  serengeti-platadmin.platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.l2RepeaterName ]
    set sunsmtreproptoeid [ locate serengeti-platadmin.platform.slots.l2Repeaters.l2RepeaterTable.l2RepeaterEntry.sunSmTreeProp ]
    set sunsmnodenametoeid [ toe_send $sunsmtreproptoeid locate sunSmNodeName ]

    set indices [toe_send $entryindextoeid getIndices]
    set numberofindex [llength $indices]
    if { $numberofindex == 0 } {
        dprint debug "Data not yet populated in table l2RepeaterTable"
        return
    }
    
    # 
    #Reset the previous values
    #

    toe_send $sunsmtreproptoeid refreshValue
    toe_send $sunsmnodenametoeid refreshValue

    for {set i 0} {$i < $numberofindex} {incr i 1} {
        set rowindex [lindex $indices $i]
        set lastindex [ expr $numberofindex - 1 ]
        if { $i == $lastindex } {
            set brother "null"
            set brotherindex 0
        } else {
	    set brother "platform.slots.l2Repeaters.l2RepeaterTable"
            set brotherindex [ lindex $indices [ expr $i + 1 ] ]
        }
        #set nodeName "L2Repeater($rowindex)"
        set nodeName [toe_send $namenodetoeid lookup -d "L2Repeater\($i\)" data $rowindex ]
	set pdistretc [getImageNamePdiStrEtc l2RepeaterTable $rowindex "null" ]
	toe_send $sunsmtreproptoeid setValue $rowindex "{$nodeName:null:$brother:0:$brotherindex:$pdistretc}"
	toe_send $sunsmnodenametoeid setValue $rowindex "$nodeName"

	#
	#Code To Dump the sunSmTreeProp into tree file.
	#

	set moname "platform.slots.l2Repeaters.l2RepeaterTable"
	set instance "$rowindex"
	set snmpindex [toe_send $sunsmtreproptoeid getRowName $rowindex]
	puts $treefileid "$moname:$instance:$snmpindex:$nodeName:null:$brother:0:$brotherindex:$pdistretc"
	flush $treefileid
    }
    return
}


proc refreshSunSmTreePropOfslotTable { treefileid } {
    dprint debug "Starting refresh of sunSmTreeProp for table slotTable"

    #set entrytoeid [locate  serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry ]
    set slotindextoeid [locate  serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry.slotIndex ]
    set sunsmtreproptoeid [ locate serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry.sunSmTreeProp ]
    set sunsmnodenametoeid [ toe_send $sunsmtreproptoeid locate sunSmNodeName ]
    set treenodeinfotoeid [ locate serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry.slotTreeNodeInfo ]

    if { [catch { toe_send $slotindextoeid getValues } values ] } {
	#caught exception
	dprint debug "could not find the values of slotIndex from slotTable"
	return
    } 
    
    # 
    #Reset the previous values
    #

    toe_send $sunsmtreproptoeid refreshValue
    toe_send $sunsmnodenametoeid refreshValue
    dprint debug "slotindex values = $values"
    set numberofvalues [llength $values]

    set firstcpuindex 0
    set lastcpuindex 0
    set firstioindex 0
    set lastioindex 0

    for {set i 0} {$i < $numberofvalues} {incr i 1} {
        set brdindex [ lindex $values $i]
        if { $brdindex >= 400 && $brdindex < 500 && $firstcpuindex == 0 } {
            set firstcpuindex [expr $i + 1 ]
        }
        if { $brdindex >= 500 && $brdindex < 600 } {
            if { $firstcpuindex != 0 && $lastcpuindex == 0 } {
                set lastcpuindex $i
            }
            if { $firstioindex == 0 } {
                set firstioindex [expr $i + 1 ]
            }
        }
        if { $brdindex >= 600 } {
            if { $firstioindex != 0 && $lastioindex == 0 } {
                set lastioindex $i
            }
        }
    }
    if { $firstcpuindex != 0 && $lastcpuindex == 0 } {
        set lastcpuindex $numberofvalues
    }
    if { $firstioindex != 0 && $lastioindex == 0 } {
        set lastioindex $numberofvalues
    }

    dprint debug "firstcpuindex=$firstcpuindex, lastcpuindex=$lastcpuindex, firstioindex=$firstioindex, lastioindex=$lastioindex"
    #
    #From here we know the first and the last rownumber for CPU and IO slots.
    #
    for {set i $firstcpuindex} {$i <= $lastcpuindex} {incr i 1} {
        if { $i == 0 } {
            continue
        }

        set value [toe_send $treenodeinfotoeid lookup -d "" data $i]
	if { [llength $value] == 0 } {
	    dprint debug "There is nothing in treeNodeInfo of row $i"
	    toe_send $sunsmtreproptoeid setValue $i "slotTable:null:null:0:0:null:null:null:null:null:null
"
	    toe_send $sunsmnodenametoeid setValue $i "slotTable"
	    continue
	}
        dprint debug "Tree node info for row $i is = $value"
        set listvalue [ split $value : ]
	set name     [lindex $listvalue 0 ]
	set child    [lindex $listvalue 1 ]
	set brother  [lindex $listvalue 2 ]

	if { [llength $name] == 0 || [llength $child] == 0 || [llength $brother] == 0 } {
            dprint debug "either name, child or brother length is 0 in treenodeinfo"
	    toe_send $sunsmtreproptoeid setValue $i "slotTable:null:null:0:0:null:null:null:null:null:null"
	    toe_send $sunsmnodenametoeid setValue $i "slotTable"
	    continue
	}
        dprint debug "name=$name, child=$child, brother=$brother"
	set index 3
	if { $child != "null" } {
	    set numberofchildindex [lindex $listvalue $index]
	    set index [expr $index + 1]
	    set childindices [lindex $listvalue $index]
	    set childtoeid [locate platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry]
	    if { [toe_csend childindex $childtoeid getRowIndex $childindices] } {
		dprint debug "Could not find child row index for table $child and index $childindices"
		set child "null"
		set childindex 0
	    }
            dprint debug "child index = $childindex"
	    set index [expr $index + 1]
	} else {
	    set childindex 0
	    set index [expr $index + 2]
	}
        dprint debug "child = $child, childindex=$childindex"
	if { $brother != "null" } {
	    set numberofbrotherindex [lindex $listvalue $index]
	    if { $numberofbrotherindex == "null" || [llength $numberofbrotherindex] == 0 } {
		dprint debug "Number of brother index is either null or nothing"
		set brother "null"
		set brotherindex 0
	    } else {
		set index [expr $index + 1]
		set brotherindices [lindex $listvalue $index]
		set brothertoeid [locate platform.slots.originalTables.slotTable.slotEntry ]
		if { [toe_csend brotherindex $brothertoeid getRowIndex $brotherindices] } {
		    dprint debug "Could not find brother row index for table $brother and index $brotherindices"
		    set brother "null"
		    set brotherindex 0
		}
	    }
	    set index [expr $index + 1]
	} else {
	    set brotherindex 0
	    set index [expr $index + 1]
	}
        dprint debug "brother = $brother, brotherindex=$brotherindex"

	set child [getPVMoName $child]
	set brother [getPVMoName $brother]

        dprint debug "Final child = $child, brother = $brother"
        #
        #Find out the node name here.
        #
        set slotindexvalue [ toe_send [ locate serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry.slotIndex] getValue $i]
        set slotoffset [ expr $slotindexvalue - 400 ]
        set nodeName "slot($slotoffset)"
	set pdistretc [getImageNamePdiStrEtc slotTable $i "null"]
        dprint debug "pdistretc = $pdistretc"
	toe_send $sunsmtreproptoeid setValue $i "{$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc}"
	toe_send $sunsmnodenametoeid setValue $i "$nodeName"
        dprint debug "final node value = $nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"

	#
	#Code To Dump the sunSmTreeProp into tree file.
	#

	set moname "platform.slots.originalTables.slotTable"
	set instance "$i"
	set snmpindex [toe_send $sunsmtreproptoeid getRowName $i]
	dprint debug "string to put into tree file is = $moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	puts $treefileid "$moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	flush $treefileid

    }

    for {set i $firstioindex} {$i <= $lastioindex} {incr i 1} {
        dprint debug "starting to handle io slots from slot table"
        if { $i == 0 } {
            continue
        }

        set value [toe_send $treenodeinfotoeid lookup -d "" data $i]
	if { [llength $value] == 0 } {
	    dprint debug "There is nothing in treeNodeInfo of row $i"
	    toe_send $sunsmtreproptoeid setValue $i "slotTable:null:null:0:0:null:null:null:null:null:null
"
	    toe_send $sunsmnodenametoeid setValue $i "slotTable"
	    continue
	}
        dprint debug "Tree node info for row $i is = $value"
        set listvalue [ split $value : ]
	set name     [lindex $listvalue 0 ]
	set child    [lindex $listvalue 1 ]
	set brother  [lindex $listvalue 2 ]
        dprint debug "name=$name, child=$child, brother=$brother"
	if { [llength $name] == 0 || [llength $child] == 0 || [llength $brother] == 0 } {
            dprint debug "Either name, child or brother length is 0"
	    toe_send $sunsmtreproptoeid setValue $i "slotTable:null:null:0:0:null:null:null:null:null:null"
	    toe_send $sunsmnodenametoeid setValue $i "slotTable"
	    continue
	}
	set index 3
	if { $child != "null" } {
	    set numberofchildindex [lindex $listvalue $index]
	    set index [expr $index + 1]
	    set childindices [lindex $listvalue $index]
	    set childtoeid [locate platform.slots.ioBoards.ioBrdTable.ioBoardEntry]
	    if { [toe_csend childindex $childtoeid getRowIndex $childindices] } {
		dprint debug "Could not find child row index for table $child and index $childindices"
		set child "null"
		set childindex 0
	    }
	    set index [expr $index + 1]
	} else {
	    set childindex 0
	    set index [expr $index + 2]
	}
        dprint debug "child = $child, childindex = $childindex"
	if { $brother != "null" } {
            #
            #If brother of last io slot is not null then there is a l2 board
            #So if it is the last io index then make brother as l2Repeater table.
            #
	    if { $i == $lastioindex } {
                set brotherindex 1
                set brother  "platform.slots.l2Repeaters.l2RepeaterTable"
            } else {
		set numberofbrotherindex [lindex $listvalue $index]
		if { $numberofbrotherindex == "null" || [llength $numberofbrotherindex] == 0 } {
		    dprint debug "Number of brother index is either null or nothing"
		    set brother "null"
		    set brotherindex 0
		} else {
		    set index [expr $index + 1]
		    set brotherindices [lindex $listvalue $index]
		    set brothertoeid [locate platform.slots.originalTables.slotTable.slotEntry ]
		    if { [toe_csend brotherindex $brothertoeid getRowIndex $brotherindices] } {
			dprint debug "Could not find brother row index for table $brother and index $brotherindices"
			set brother "null"
			set brotherindex 0
		    }
		}
		set index [expr $index + 1]
            }
	    set index [expr $index + 1]
	} else {
	    set brotherindex 0
	    set index [expr $index + 1]
	}
        dprint debug "brother = $brother, brotherindex = $brotherindex"
	set child [getPVMoName $child]
	if { $i != $lastioindex } {
	    set brother [getPVMoName $brother]
        }
        dprint debug "final child = $child, brother = $brother"
        #
        #Find out the node name here.
        #
        set slotindexvalue [ toe_send [ locate serengeti-platadmin.platform.slots.originalTables.slotTable.slotEntry.slotIndex] getValue $i]
        set slotoffset [ expr $slotindexvalue - 500 ]
        set nodeName "slot($slotoffset)"
	set pdistretc [getImageNamePdiStrEtc slotTable $i "null"]
	toe_send $sunsmtreproptoeid setValue $i "{$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc}"
	toe_send $sunsmnodenametoeid setValue $i "$nodeName"

	#
	#Code To Dump the sunSmTreeProp into tree file.
	#

	set moname "platform.slots.originalTables.slotTable"
	set instance "$i"
	set snmpindex [toe_send $sunsmtreproptoeid getRowName $i]
	dprint debug "string to put into tree file is = $moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	puts $treefileid "$moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	flush $treefileid

    }

}

proc refreshSunSmTreePropOfotherTables { treefileid } {
    #set listoftables [list  cpuBoardTable ioBoardTable cpuModTable dimmTable ecacheTable ]
    set listoftables [list  cpuBoardTable ioBoardTable ]

    foreach tablename $listoftables {
        dprint debug "Starting refresh of sunSmTreeProp for table $tablename"
        set objectSymName [getSymOidByName $tablename]
        set objecttoeid [locate $objectSymName]
        set sunsmtreproptoeid [ locate [ getSmTreePropOidByName $tablename] ]
        set sunsmnodenametoeid [ toe_send $sunsmtreproptoeid locate sunSmNodeName ]

        set indices [toe_send $objecttoeid getIndices]
        set numberofindex [llength $indices]
        if { $numberofindex == 0 } {
            dprint debug "Data not yet populated in table $tablename"
            continue
        }
	    
	    # 
	    #Reset the previous values
	    #

	    toe_send $sunsmtreproptoeid refreshValue
	    toe_send $sunsmnodenametoeid refreshValue

        for {set i 0} {$i < $numberofindex} {incr i 1} {
            set rowindex [lindex $indices $i]


            set value [toe_send $objecttoeid lookup -d "" data $rowindex]
            if { [llength $value] == 0 } {
                dprint debug "There is nothing in treeNodeInfo of row $rowindex"
                toe_send $sunsmtreproptoeid setValue $rowindex "$tablename:null:null:0:0:null:null:null:null:null:null"
                toe_send $sunsmnodenametoeid setValue $rowindex "$tablename"
                continue
            }
            dprint debug "Tree node info for row $rowindex is = $value"
            set listvalue [ split $value : ]
            set name     [lindex $listvalue 0 ]
            set child    [lindex $listvalue 1 ]
            set brother  [lindex $listvalue 2 ]

            if { [llength $name] == 0 || [llength $child] == 0 || [llength $brother] == 0 } {
                toe_send $sunsmtreproptoeid setValue $rowindex "$tablename:null:null:0:0:null:null:null:null:null:null"

                toe_send $sunsmnodenametoeid setValue $rowindex "$tablename"
                continue
            }
            set defaultNodeName [ getNodeNameByTableName $tablename ]
            set nodenametoeid [ getNodeNameToeID $tablename ]
            set defaultNodeName $defaultNodeName\($rowindex\)
	    set nodeName [toe_send $nodenametoeid lookup -d "$defaultNodeName" data $rowindex ]

            set index 3
            if { $child != "null" } {
                set numberofchildindex [lindex $listvalue $index]
                set index [expr $index + 1]
                set childindices [lindex $listvalue $index]
                set childtoeid [locate [getSymOidByName $child]]
                if { [toe_csend childindex $childtoeid getRowIndex $childindices] } {
                    dprint debug "Could not find child row index for table $child and index $childindices"
                    set child "null"
                    set childindex 0
                }
                set index [expr $index + 1]
            } else {
                set childindex 0
                set index [expr $index + 2]
            }
            if { $brother != "null" } {
                set numberofbrotherindex [lindex $listvalue $index]
                if { $numberofbrotherindex == "null" || [llength $numberofbrotherindex] == 0 } {
                    dprint debug "Number of brother index is either null or nothing"
                    set brother "null"
                    set brotherindex 0
                } else {
                    set index [expr $index + 1]
                    set brotherindices [lindex $listvalue $index]
                    set brothertoeid [locate [getSymOidByName $brother]]
                    #set brotherindex [toe_send $brothertoeid "getRowIndex $brotherindices"]
                    if { [toe_csend brotherindex $brothertoeid getRowIndex $brotherindices] } {
                        dprint debug "Could not find brother row index for table $brother and index $brotherindices"
                        set brother "null"
                        set brotherindex 0
                    }
                }
                set index [expr $index + 1]
            } else {
                set brotherindex 0
                set index [expr $index + 1]
            }

            #

            #
            #Get the path of the table name of child table  which will host the sunSmTreeProp
            #

            set child [getPVMoName $child]
            set brother [getPVMoName $brother]

            dprint debug "list to return before pdistr = $nodeName:$child:$brother:$childindex:$brotherindex"
            set pdistretc [getImageNamePdiStrEtc $tablename $rowindex $objecttoeid]
            dprint debug "value to be set afetr pdistr = $nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
            toe_send $sunsmtreproptoeid setValue $rowindex "{$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc}"
            toe_send $sunsmnodenametoeid setValue $rowindex "$nodeName"

            #
            #Code To Dump the sunSmTreeProp into tree file.
            #

            set moname [getPVMoName $tablename]
            set instance "$rowindex"
            set snmpindex [toe_send $sunsmtreproptoeid getRowName $rowindex]
            dprint debug "string to put into tree file is = $moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
            puts $treefileid "$moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
            flush $treefileid

        }
        dprint debug "table $tablename completed"
    }
    return
}

proc getCPUBoardsmNodeName { currentcpuboardindex } {

    set cpuboardindextoeid [locate platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardIndex ]
    set datavalues [toe_send $cpuboardindextoeid getValues ]
    dprint debug "datavalues=$datavalues"
    if { [llength $datavalues ] == 0 } {
        dprint debug "platform.slots.cpuBoards.cpuBrdTable.cpuBoardEntry.cpuBoardIndex not populated"
        return ""
    }
    set brdindex [lsearch -exact $datavalues $currentcpuboardindex]
    dprint debug "brdindex=$brdindex"
    if { $brdindex != -1 } {
        set brdindex [expr $brdindex + 1 ]
        #set chassisindextoeid [ toe_send $cpuboardindextoeid locate cpuBoardChassisIndex ]
        #set chassisindex [ toe_send $chassisindextoeid getValue $brdindex ]
        set smnodenametoeid [toe_send $cpuboardindextoeid locate sunSmNodeName ]
        set smNodeName [ toe_send $smnodenametoeid lookup -d ""  data $brdindex ]
        dprint debug "smNodeName=$smNodeName"
        return $smNodeName
    } 

}

proc refreshSunSmTreePropOfcpuModTable { treefileid } {

    set tablename "cpuModTable"
    dprint debug "Starting refresh of sunSmTreeProp for table $tablename"
    set objectSymName [getSymOidByName $tablename]
    set objecttoeid [locate $objectSymName]
    set sunsmtreproptoeid [ locate [ getSmTreePropOidByName $tablename] ]
    set sunsmnodenametoeid [ toe_send $sunsmtreproptoeid locate sunSmNodeName ]
    set cpubrdindextoeid [ locate serengeti-platadmin.platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModBoardIndex ]
    set cpumodeindextoeid [ locate serengeti-platadmin.platform.components.cpuMod.cpuModTable.cpuModEntry.cpuModIndex ]

    set indices [toe_send $objecttoeid getIndices]
    set numberofindex [llength $indices]
    if { $numberofindex == 0 } {
	dprint debug "Data not yet populated in table $tablename"
	return
    }
    
    # 
    #Reset the previous values
    #

    toe_send $sunsmtreproptoeid refreshValue
    toe_send $sunsmnodenametoeid refreshValue
    set lastrowindex 0
    for {set i 0} {$i < $numberofindex} {incr i 1} {
	set rowindex [lindex $indices $i]
        set nextrowindex [ lindex $indices [expr $i + 1] ]
        if { [llength $nextrowindex ] == 0 } {
            set lastrowindex 1
        } 

        set child "null"
        set childindex 0
        set smNodeName ""
       
        set currentcpuboardindex [toe_send $cpubrdindextoeid lookup data $rowindex ]
        dprint debug "currentcpuboardindex=$currentcpuboardindex"
        set smNodeName [getCPUBoardsmNodeName $currentcpuboardindex]

        if { $lastrowindex == 0 } {
	    set nextcpuboardindex [toe_send $cpubrdindextoeid lookup data $nextrowindex ]
        } else {
	    set nextcpuboardindex $currentcpuboardindex
        }
        if { $lastrowindex == 0 && $currentcpuboardindex == $nextcpuboardindex } {
	    set brother [ getPVMoName "cpuModTable" ]
            set brotherindex $nextrowindex
        } else {
            set dimmcpubrdindex [locate serengeti-platadmin.platform.components.dimm.dimmTable.dimmEntry.dimmCpuBoardIndex ]
            set dimmtablecpubrdindices [toe_send $dimmcpubrdindex getValues ]
            set firstmatchedindex [lsearch $dimmtablecpubrdindices $currentcpuboardindex]
            if { $firstmatchedindex != -1 } {
                set dimmtableindices [ toe_send $dimmcpubrdindex getIndices ] 
                set brother [ getPVMoName "dimmTable" ]
                set brotherindex [lindex $dimmtableindices $firstmatchedindex]
            } else {
                set ecachecpubrdindex [locate serengeti-platadmin.platform.components.ecache.ecacheTable.ecacheEntry.ecacheCpuBoardIndex]
                set ecachetablecpubrdindices [ toe_send $ecachecpubrdindex getValues ]
                set firstmatchedindex [lsearch $ecachetablecpubrdindices $currentcpuboardindex]
                if { $firstmatchedindex != -1 } {
		    set ecachetableindices [ toe_send $ecachecpubrdindex getIndices ] 
		    set brother [ getPVMoName "ecacheTable" ]
		    set brotherindex [lindex $ecachetableindices $firstmatchedindex]
                } else {
                    set brother "null"
                    set brotherindex 0
                }
            }
        }

	#
	#Get the path of the table name of child table  which will host the sunSmTreeProp
	#

	#set child [getPVMoName $child]
	#set brother [getPVMoName $brother]

	#set nodeName [ getNodeNameByTableName $tablename ]
	#set nodeName $nodeName\($rowindex\)

        set nodeName "$smNodeName.P[toe_send $cpumodeindextoeid lookup -d "$i" data $rowindex ]"

	dprint debug "list to return before pdistr = $nodeName:$child:$brother:$childindex:$brotherindex"
	set pdistretc [getImageNamePdiStrEtc $tablename $rowindex $objecttoeid]
	dprint debug "value to be set afetr pdistr = $nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	toe_send $sunsmtreproptoeid setValue $rowindex "{$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc}"
	toe_send $sunsmnodenametoeid setValue $rowindex "$nodeName"

	#
	#Code To Dump the sunSmTreeProp into tree file.
	#

	set moname [getPVMoName $tablename]
	set instance "$rowindex"
	set snmpindex [toe_send $sunsmtreproptoeid getRowName $rowindex]
	dprint debug "string to put into tree file is = $moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	puts $treefileid "$moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	flush $treefileid

    }
    dprint debug "table $tablename completed"
    return
}
proc refreshSunSmTreePropOfdimmTable { treefileid } {

    set tablename "dimmTable"
    dprint debug "Starting refresh of sunSmTreeProp for table $tablename"
    set objectSymName [getSymOidByName $tablename]
    set objecttoeid [locate $objectSymName]
    set sunsmtreproptoeid [ locate [ getSmTreePropOidByName $tablename] ]
    set sunsmnodenametoeid [ toe_send $sunsmtreproptoeid locate sunSmNodeName ]
    set cpubrdindextoeid [ locate serengeti-platadmin.platform.components.dimm.dimmTable.dimmEntry.dimmCpuBoardIndex ]
    set dimmindextoeid [ locate serengeti-platadmin.platform.components.dimm.dimmTable.dimmEntry.dimmIndex ]

    set indices [toe_send $objecttoeid getIndices]
    set numberofindex [llength $indices]
    if { $numberofindex == 0 } {
	dprint debug "Data not yet populated in table $tablename"
	return
    }
    
    # 
    #Reset the previous values
    #

    toe_send $sunsmtreproptoeid refreshValue
    toe_send $sunsmnodenametoeid refreshValue

    set lastrowindex 0
    for {set i 0} {$i < $numberofindex} {incr i 1} {
	set rowindex [lindex $indices $i]
        set nextrowindex [ lindex $indices [expr $i + 1] ]
        if { [llength $nextrowindex ] == 0 } {
            set lastrowindex 1
        } 

        set child "null"
        set childindex 0

        set currentcpuboardindex [toe_send $cpubrdindextoeid lookup data $rowindex ]
        if { $lastrowindex == 0 } {
	    set nextcpuboardindex [toe_send $cpubrdindextoeid lookup data $nextrowindex ]
        } else {
	    set nextcpuboardindex $currentcpuboardindex
        }
        if { $lastrowindex == 0 && $currentcpuboardindex == $nextcpuboardindex } {
	    set brother [ getPVMoName "dimmTable" ]
            set brotherindex $nextrowindex
        } else {
	    set ecachecpubrdindex [locate serengeti-platadmin.platform.components.ecache.ecacheTable.ecacheEntry.ecacheCpuBoardIndex]
	    set ecachetablecpubrdindices [ toe_send $ecachecpubrdindex getValues ]
	    set firstmatchedindex [lsearch $ecachetablecpubrdindices $currentcpuboardindex]
	    if { $firstmatchedindex != -1 } {
		set ecachetableindices [ toe_send $ecachecpubrdindex getIndices ] 
		set brother [ getPVMoName "ecacheTable" ]
		set brotherindex [lindex $ecachetableindices $firstmatchedindex]
	    } else {
		set brother "null"
		set brotherindex 0
	    }
        }

	#
	#Get the path of the table name of child table  which will host the sunSmTreeProp
	#

	#set child [getPVMoName $child]
	#set brother [getPVMoName $brother]
	#set nodeName [ getNodeNameByTableName $tablename ]
	#set nodeName $nodeName\($rowindex\)

        set nodeName "dimm[toe_send $dimmindextoeid lookup -d "$i" data $rowindex ]"

	dprint debug "list to return before pdistr = $nodeName:$child:$brother:$childindex:$brotherindex"
	set pdistretc [getImageNamePdiStrEtc $tablename $rowindex $objecttoeid]
	dprint debug "value to be set afetr pdistr = $nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	toe_send $sunsmtreproptoeid setValue $rowindex "{$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc}"
	toe_send $sunsmnodenametoeid setValue $rowindex "$nodeName"

	#
	#Code To Dump the sunSmTreeProp into tree file.
	#

	set moname [getPVMoName $tablename]
	set instance "$rowindex"
	set snmpindex [toe_send $sunsmtreproptoeid getRowName $rowindex]
	dprint debug "string to put into tree file is = $moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	puts $treefileid "$moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	flush $treefileid

    }
    dprint debug "table $tablename completed"
    return
}
proc refreshSunSmTreePropOfecacheTable { treefileid } {

    set tablename "ecacheTable"
    dprint debug "Starting refresh of sunSmTreeProp for table $tablename"
    set objectSymName [getSymOidByName $tablename]
    set objecttoeid [locate $objectSymName]
    set sunsmtreproptoeid [ locate [ getSmTreePropOidByName $tablename] ]
    set sunsmnodenametoeid [ toe_send $sunsmtreproptoeid locate sunSmNodeName ]
    set cpubrdindextoeid [ locate serengeti-platadmin.platform.components.ecache.ecacheTable.ecacheEntry.ecacheCpuBoardIndex ]
    set ecacheindextoeid [ locate serengeti-platadmin.platform.components.ecache.ecacheTable.ecacheEntry.ecacheIndex ]

    set indices [toe_send $objecttoeid getIndices]
    set numberofindex [llength $indices]
    if { $numberofindex == 0 } {
	dprint debug "Data not yet populated in table $tablename"
	return
    }
    
    # 
    #Reset the previous values
    #

    toe_send $sunsmtreproptoeid refreshValue
    toe_send $sunsmnodenametoeid refreshValue

    set lastrowindex 0
    for {set i 0} {$i < $numberofindex} {incr i 1} {
	set rowindex [lindex $indices $i]
        set nextrowindex [ lindex $indices [expr $i + 1] ]
        if { [llength $nextrowindex ] == 0 } {
            set lastrowindex 1
        } 

        set child "null"
        set childindex 0

        set currentcpuboardindex [toe_send $cpubrdindextoeid lookup data $rowindex ]
        if { $lastrowindex == 0 } {
	    set nextcpuboardindex [toe_send $cpubrdindextoeid lookup data $nextrowindex ]
        } else {
	    set nextcpuboardindex $currentcpuboardindex
        }
        if { $lastrowindex == 0 && $currentcpuboardindex == $nextcpuboardindex } {
	    set brother [ getPVMoName "ecacheTable" ]
            set brotherindex $nextrowindex
        } else {
	    set brother "null"
	    set brotherindex 0
        }

	#
	#Get the path of the table name of child table  which will host the sunSmTreeProp
	#

	#set child [getPVMoName $child]
	#set brother [getPVMoName $brother]
	#set nodeName [ getNodeNameByTableName $tablename ]
	#set nodeName $nodeName\($rowindex\)

        set nodeName "ecache[toe_send $ecacheindextoeid lookup -d "$i" data $rowindex ]"

	dprint debug "list to return before pdistr = $nodeName:$child:$brother:$childindex:$brotherindex"
	set pdistretc [getImageNamePdiStrEtc $tablename $rowindex $objecttoeid]
	dprint debug "value to be set afetr pdistr = $nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	toe_send $sunsmtreproptoeid setValue $rowindex "{$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc}"
	toe_send $sunsmnodenametoeid setValue $rowindex "$nodeName"

	#
	#Code To Dump the sunSmTreeProp into tree file.
	#

	set moname [getPVMoName $tablename]
	set instance "$rowindex"
	set snmpindex [toe_send $sunsmtreproptoeid getRowName $rowindex]
	dprint debug "string to put into tree file is = $moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	puts $treefileid "$moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	flush $treefileid

    }
    dprint debug "table $tablename completed"
    return
}

proc getWCIBoardsmNodeName { currentioboardindex } {

    set ioboardindextoeid [locate platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardIndex ]
    set datavalues [toe_send $ioboardindextoeid getValues ]
    dprint debug "datavalues=$datavalues"
    if { [llength $datavalues ] == 0 } {
        dprint debug "platform.slots.ioBoards.ioBrdTable.ioBoardEntry.ioBoardIndex not populated"
        return ""
    }
    set brdindex [lsearch -exact $datavalues $currentioboardindex]
    dprint debug "brdindex=$brdindex"
    if { $brdindex != -1 } {
        set brdindex [expr $brdindex + 1 ]
        set smnodenametoeid [toe_send $ioboardindextoeid locate sunSmNodeName ]
        set smNodeName [ toe_send $smnodenametoeid lookup -d ""  data $brdindex ]
        dprint debug "smNodeName=$smNodeName"
        return $smNodeName
    } 
}

proc refreshSunSmTreePropOfwciModTable { treefileid } {

    set tablename "wciModTable"
    dprint debug "Starting refresh of sunSmTreeProp for table $tablename"
    set objectSymName [getSymOidByName $tablename]
    set objecttoeid [locate $objectSymName]
    set sunsmtreproptoeid [ locate [ getSmTreePropOidByName $tablename] ]
    set sunsmnodenametoeid [ toe_send $sunsmtreproptoeid locate sunSmNodeName ]
    set iobrdindextoeid [ locate serengeti-platadmin.platform.components.wci.wciModTable.wciModEntry.wciModBoardIndex ]
    set wcimodindextoeid [ locate serengeti-platadmin.platform.components.wci.wciModTable.wciModEntry.wciModIndex ]

    set indices [toe_send $objecttoeid getIndices]
    set numberofindex [llength $indices]
    if { $numberofindex == 0 } {
	dprint debug "Data not yet populated in table $tablename"
	return
    }

    # 
    #Reset the previous values
    #

    toe_send $sunsmtreproptoeid refreshValue
    toe_send $sunsmnodenametoeid refreshValue

    set lastrowindex 0
    for {set i 0} {$i < $numberofindex} {incr i 1} {
	set rowindex [lindex $indices $i]
        set nextrowindex [ lindex $indices [expr $i + 1] ]
        if { [llength $nextrowindex ] == 0 } {
            set lastrowindex 1
        } 

        set child "null"
        set childindex 0

        set currentioboardindex [toe_send $iobrdindextoeid lookup data $rowindex ]
        set smNodeName [getWCIBoardsmNodeName $currentioboardindex]

        if { $lastrowindex == 0 } {
	    set nextioboardindex [toe_send $iobrdindextoeid lookup data $nextrowindex ]
        } else {
	    set nextioboardindex $currentioboardindex
        }
        if { $lastrowindex == 0 && $currentioboardindex == $nextioboardindex } {
	    set brother [ getPVMoName "wciModTable" ]
            set brotherindex $nextrowindex
        } else {
	    set brother "null"
	    set brotherindex 0
        }

	#
	#Get the path of the table name of child table  which will host the sunSmTreeProp
	#

	#set child [getPVMoName $child]
	#set brother [getPVMoName $brother]
	#set nodeName [ getNodeNameByTableName $tablename ]
	#set nodeName $nodeName\($rowindex\)

        set nodeName "$smNodeName/WCI[toe_send $wcimodindextoeid lookup -d "$i" data $rowindex ]"

	dprint debug "list to return before pdistr = $nodeName:$child:$brother:$childindex:$brotherindex"
	set pdistretc [getImageNamePdiStrEtc $tablename $rowindex $objecttoeid]
	dprint debug "value to be set afetr pdistr = $nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	toe_send $sunsmtreproptoeid setValue $rowindex "{$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc}"
	toe_send $sunsmnodenametoeid setValue $rowindex "$nodeName"

	#
	#Code To Dump the sunSmTreeProp into tree file.
	#

	set moname [getPVMoName $tablename]
	set instance "$rowindex"
	set snmpindex [toe_send $sunsmtreproptoeid getRowName $rowindex]
	dprint debug "string to put into tree file is = $moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	puts $treefileid "$moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	flush $treefileid

    }
    dprint debug "table $tablename completed"
    return
}

proc getWCIModsmNodeName { currentwcimodindex } {

    set wcimodindextoeid [locate platform.components.wci.wciModTable.wciModEntry.wciModBoardIndex ]
    set datavalues [toe_send $wcimodindextoeid getValues ]
    dprint debug "datavalues=$datavalues"
    if { [llength $datavalues ] == 0 } {
        dprint debug "platform.components.wci.wciModTable.wciModEntry.wciModBoardIndex not populated"
        return ""
    }
    set brdindex [lsearch -exact $datavalues $currentwcimodindex]
    dprint debug "brdindex=$brdindex"
    if { $brdindex != -1 } {
        set brdindex [expr $brdindex + 1 ]
        set smnodenametoeid [toe_send $wcimodindextoeid locate sunSmNodeName ]
        set smNodeName [ toe_send $smnodenametoeid lookup -d ""  data $brdindex ]
        dprint debug "smNodeName=$smNodeName"
        return $smNodeName
    } 
}

proc refreshSunSmTreePropOfwciPortTable { treefileid } {

    set tablename "wciPortTable"
    dprint debug "Starting refresh of sunSmTreeProp for table $tablename"
    set objectSymName [getSymOidByName $tablename]
    set objecttoeid [locate $objectSymName]
    set sunsmtreproptoeid [ locate [ getSmTreePropOidByName $tablename] ]
    set sunsmnodenametoeid [ toe_send $sunsmtreproptoeid locate sunSmNodeName ]
    set wcimodindextoeid [ locate serengeti-platadmin.platform.components.wciPort.wciPortTable.wciPortEntry.wciPortBoardIndex ]
    set wciportindextoeid [ locate serengeti-platadmin.platform.components.wciPort.wciPortTable.wciPortEntry.wciPortIndex ]

    set indices [toe_send $objecttoeid getIndices]
    set numberofindex [llength $indices]
    if { $numberofindex == 0 } {
	dprint debug "Data not yet populated in table $tablename"
	return
    }

    # 
    #Reset the previous values
    #

    toe_send $sunsmtreproptoeid refreshValue
    toe_send $sunsmnodenametoeid refreshValue

    set lastrowindex 0
    for {set i 0} {$i < $numberofindex} {incr i 1} {
	set rowindex [lindex $indices $i]
        set nextrowindex [ lindex $indices [expr $i + 1] ]
        if { [llength $nextrowindex ] == 0 } {
            set lastrowindex 1
        } 

        set child "null"
        set childindex 0

        set currentwcimodindex [toe_send $wcimodindextoeid lookup data $rowindex ]
        set smNodeName [getWCIModsmNodeName $currentwcimodindex]

        if { $lastrowindex == 0 } {
	    set nextwcimodindex [toe_send $wcimodindextoeid lookup data $nextrowindex ]
        } else {
	    set nextwcimodindex $currentwcimodindex
        }
        if { $lastrowindex == 0 && $currentwcimodindex == $nextwcimodindex } {
	    set brother [ getPVMoName "wciPortTable" ]
            set brotherindex $nextrowindex
        } else {
	    set brother "null"
	    set brotherindex 0
        }

	#
	#Get the path of the table name of child table  which will host the sunSmTreeProp
	#

	#set child [getPVMoName $child]
	#set brother [getPVMoName $brother]
	#set nodeName [ getNodeNameByTableName $tablename ]
	#set nodeName $nodeName\($rowindex\)

        set nodeName "$smNodeName/PAR[toe_send $wciportindextoeid lookup -d "$i" data $rowindex ]"

	dprint debug "list to return before pdistr = $nodeName:$child:$brother:$childindex:$brotherindex"
	set pdistretc [getImageNamePdiStrEtc $tablename $rowindex $objecttoeid]
	dprint debug "value to be set afetr pdistr = $nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	toe_send $sunsmtreproptoeid setValue $rowindex "{$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc}"
	toe_send $sunsmnodenametoeid setValue $rowindex "$nodeName"

	#
	#Code To Dump the sunSmTreeProp into tree file.
	#

	set moname [getPVMoName $tablename]
	set instance "$rowindex"
	set snmpindex [toe_send $sunsmtreproptoeid getRowName $rowindex]
	dprint debug "string to put into tree file is = $moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	puts $treefileid "$moname:$instance:$snmpindex:$nodeName:$child:$brother:$childindex:$brotherindex:$pdistretc"
	flush $treefileid

    }
    dprint debug "table $tablename completed"
    return
}

proc refreshrspa1007 { } {
    set scagentstatnode [locate serengeti-platadmin.scagentstatus]
    set value [toe_send $scagentstatnode lookup -d 0 data 0]
    return $value
}

proc scnetworkedFilter { value } {
    set scagentstatustoeid [locate serengeti-platadmin.scagentstatus]
    if { $value == "up" } {
        set scagentstaus [toe_send $scagentstatustoeid lookup -d 0 data 0 ]
        if { $scagentstaus == "0" } {
            toe_send $scagentstatustoeid setValue 0 1
            toe_send $scagentstatustoeid refreshValue
        }
        return 1
    } else {
        toe_send $scagentstatustoeid setValue 0 0
        return 0
    }
}

#
# This is awkward, basically we need to get the target SC IP address
# and the appropriate SC community strings before we start, so we
# call this from a startup service....
#
# While it seems like these things would be good candidates for
# module parameters, they contain sensitive information so should
# not be exposed to the general SunMC console.
#
proc setparams { } {
    set code ok
    dprint info "setparams"

    # set/get remoteIPAddress
    if { [ toe_csend x [ locate .iso*serengeti-platadmin.remoteIPAddress] { refreshValue} ] } {
	dprint error "setparams, remoteIPAddress refreshValue failed. $x"
	set code error
    } elseif { [ catch { valueOf serengeti-platadmin.remoteIPAddress } ip ] } {
	dprint error "setparams, remoteIPAddress valueOf failed. $ip"
	set code error
    }

    # set communitystrings
    if { [ toe_csend x [ locate .iso*serengeti-platadmin.communitystrings ] { refreshValue} ] } {
	dprint error "setparams, remoteIPAddress communitystrings failed. $x"
	set code error
    }

    # get platformreadcommunity
    if { [ catch { valueOf serengeti-platadmin.communitystrings.platformreadcommunity } community ] } {
	dprint error "setparams, platformreadcommunity valueOf failed. $community"
	set code error
    }

    # set the ip and community parameters for each of the daq nodes
    foreach i { chassis slots cpuBoard ioBoard l2Board  cpuMod dimm ecache wci wciPort domain fan powerSupply systemController fru} {
	if { [ toe_csend x [ locate .iso*serengeti-platadmin.daq.$i ] { setParameters targetAddress $ip securityName $community retries 1 timeout 60 } ] } {
	    dprint error "setparams, $i setParameters failed. $x"
	    set code error
	}
    }
    return -code $code
}


#
# pvlvMarkProc stores a timestamp in seconds in the slice\key pvlvMark time
#
proc pvlvMarkProc { } {

    if { ! [ catch { ilookup pvlvMark time } x ] } {
	return "OK: timestamp already set"
    }

    if { [ catch { define pvlvMark time [ getTime ] } x ] } {
	dprint error "pvlvMarkProc, define pvlvMark time [ getTime ]. $x"
	return "ERROR: define pvlvMark time [ getTime ]. $x"
    }
    return "OK: timestamp set"
}


proc pvlvRefreshProc { } {

    if { [ catch { ilookup pvlvMark time } oldtime ] } {
	# slice not present, so no pvlv refresh pending
	return "no refresh pending"
    }

    dprint debug "pvlvRefreshProc, refreshing the pvlv gui properties"
    if { [ toe_csend x [ locate .iso*serengeti-platadmin.sunSmTreePropRefreshNode ] { refreshValue } ] } {
	dprint error "pvlvRefreshProc, pvlv gui refresh failed, toe_csend failed. $x"
	return "ERROR: pvlv gui refresh failed, toe_csend failed. $x"
    }

    if { [ catch { undefine pvlvMark time } x ] } {
	dprint error "pvlvRefreshProc, undefine pvlvMark time. $x"
	return "ERROR: undefine pvlvMark time. $x"
    }
    return "refreshValue sent"
}
