#!/usr/bin/perl

use File::Copy;
use File::Basename;
use File::Spec;
use File::Path;

$BUILD_NUMBER = "2005.230.0410";
$DS_PACKAGE = "directory-5.2_Patch_4-us.powerpc-ibm-aix5.1.0.0.tar.gz";
$IS_WINDOWS = 0;
$USE_NATIVE_ZIP = 0;


sub change_dir {
  my $dir = shift;
  print "Change dir to $dir\n";
  return chdir $dir;
}

sub cmd {
  $c = shift;
  print "$c\n";
  system("$c");
  if( $? ) {
    print "Error: $!, exiting\n";
    exit 1;
  }
}

sub cmd_silent {
  $c = shift;
  system("$c");
  if( $? ) {
    print "Error: $!, exiting\n";
    exit 1;
  }
}

sub cmd_noerr {
  $c = shift;
  print "$c\n";
  system("$c");
  if( $? ) {
    return 1;
  }
  return 0;
}

sub cp {
  my $c1 = shift; my $c2 = shift;
  print "cp $c1 $c2\n";
  my $res = copy $c1, $c2;
  if( ! $res ) {
    print "Error, $!\n";
  }
  return $res;
}

sub mv {
  my $c1 = shift; my $c2 = shift;
#  print "mv $c1 $c2\n";
  my $res = move "$c1", "$c2";
  if( ! $res ) {
    print "Error, $!\n";
  }
  return $res;
}

sub unzip {
  my $pkg = shift;
  if( $USE_NATIVE_ZIP ) {
    cmd "unzip -q -o $pkg";
  }
  else {
    my $unzip_cmd = File::Spec->catdir("$CUR_DIR", "unzip");
    chmod 0755, "$unzip_cmd";
    cmd "$unzip_cmd -q -o $pkg";
  }
}

sub sav_tmp {
  my $SAV = shift;
  my $time_ext = shift;
    if( -f "$SAV" ) {
      print "saving $SAV\n";
      mv "$SAV", "$SAV-$time_ext.ref";
  }
}


sub rest_tmp {
  my $SAV = shift;
  my $time_ext = shift;
    if( -f "$SAV-$time_ext.ref" ) {
     print "restoring $SAV\n";
     unlink "$SAV";
     mv "$SAV-$time_ext.ref", "$SAV";
  }
}

sub upgrade_startjvm {

  $start_jvm = File::Spec->catfile("$SERVER_ROOT", "bin", "https", "bin", "start-jvm");
  $new_start_jvm = File::Spec->catfile("$SERVER_ROOT", "bin", "https", "bin", "start-jvm.tmp");

  open(SJVM,"< $start_jvm") || return 1;
  open(SNEWJVM,"> $new_start_jvm") || return 1;

  while (defined($line=<SJVM>)) {

     if ($line =~ /jss311/) {
	 $line =~ s/jss311/jss4/g;
	}

    if ($line =~ /\$\{NSES_JRE\}\/lib\/sparc\/server/) {
	$line =~ s/\$\{NSES_JRE\}\/lib\/sparc\/server:\$\{NSES_JRE\}\/lib\/sparc:/\$\{NSES_JRE\}\/lib\/sparc:\$\{NSES_JRE\}\/lib\/sparc\/server:/g;
    }

     	print SNEWJVM $line;
  }

  close SNEWJVM;
  close SJVM;

  mv $new_start_jvm, $start_jvm;

  return 0;
}

sub upgrade_startadmin {

  $start_admin = File::Spec->catfile("$SERVER_ROOT", "start-admin");
  $new_start_admin = File::Spec->catfile("$SERVER_ROOT", "start-admin.tmp");

  open(SADM,"< $start_admin") or return 1;
  open(SNEWADM,"> $new_start_admin") or return 1;

  while (defined($line=<SADM>)) {

	if ($line =~ /^SERVER_ROOT/) {
	 print SNEWADM "LANG=C; export LANG\n";
	 print SNEWADM "LC_ALL=C; export LC_ALL\n";
	}

     print SNEWADM $line;
  }

  close SADM;
  close SNEWADM;

  mv $new_start_admin, $start_admin;
  chmod 0755, "$start_admin";

  # Chown start-admin after the script is all finished before start up for perms.
  if($DS_SPEC_USER) {
	print "Non-Root Installation, executing start_admin chown\n";
	`chown $DS_USER:$DS_GROUP $start_admin`;
  }

 return 0;


}


sub upgrade_dseldif {

 my $dseldif_file = shift;

 if ("$PLATFORM" eq "SunOS" ) {
    my $version = `uname -r`; chomp $version;
    if ("$version" eq "5.10") {
	if  ( -f $dseldif_file ) {
	  $saslpath = File::Spec->catfile("$SERVER_ROOT","lib","sasl");
	  $new_dseldif_file = $dseldif_file.".tmp";

	  open(SDSE,"< $dseldif_file") or return 1;
	  open(SNEWDSE,"> $new_dseldif_file") or return 1;

	  while (defined($line=<SDSE>)) {

	     if ($line =~ /\/usr\/lib\/sasl2/) {
	        print SNEWDSE "dsSaslPluginsPath: $saslpath\n";
	     } else {
	      print SNEWDSE $line;
	     }
	  }

	  close SDSE;
	  close SNEWDSE;

	  mv $new_dseldif_file, $dseldif_file;
	  chmod 0600, "$dseldif_file";
	}
    }
 }
 return 0;
}



sub test_user {
  my $dir=shift;

  if ( ! -O $dir ) {
    return 0;
  }

 return 1;
}

my $return_code = 0;
my $devnul = "";
my $interactive = 0;

$SERVER_ROOT = $ARGV[0];
$DS_USER = $ARGV[3];
$DS_GROUP = $ARGV[4];
$DS_SPEC_USER = 0 ;

if ($DS_USER && $DS_GROUP && ( $IS_WINDOWS == 0) ) {

#Specific User Installation - root patching
$DS_SPEC_USER = 1 ;
  }


if ( $#ARGV == 0 ) {
  $interactive=1;
}

if ( ! -d $SERVER_ROOT ) {
  print "$SERVER_ROOT directory does not exist\n";
  exit 1;
}

if ($DS_SPEC_USER == 0 ) {
test_user("$SERVER_ROOT") || die "User must be the same than serverroot owner";
}
umask 0022;

$DIR64BITS = 0;

if($IS_WINDOWS) {
  $CUR_DIR = `chdir`; chomp $CUR_DIR;
}
else {
  $CUR_DIR = `pwd`; chomp $CUR_DIR;
  $PLATFORM = `uname`; chomp $PLATFORM;
  if( "$PLATFORM" eq "SunOS" ) {
    $BINDIR_64 = File::Spec->catfile("$SERVER_ROOT", "bin", "slapd", "server", "64");
    $LIBDIR_64 = File::Spec->catfile("$SERVER_ROOT", "lib","64");
    $NSSLAPD_64 = File::Spec->catfile("$BINDIR_64","ns-slapd");
    # check if we are in 32 or 64 bits
    if(-x $NSSLAPD_64) {
      $DIR64BITS = 1;
    }
  }
  elsif ("$PLATFORM" eq "HP-UX") {
    $BINDIR_64 = File::Spec->catfile("$SERVER_ROOT", "bin", "slapd", "server", "pa20_64");
    $LIBDIR_64 = File::Spec->catfile("$SERVER_ROOT", "lib","pa20_64");
    $NSSLAPD_64 = File::Spec->catfile("$BINDIR_64","ns-slapd");
    # check if we are in 32 or 64 bits
    if(-x $NSSLAPD_64) {
      $DIR64BITS = 1;
    }
  }
  else {
    $NSSLAPD_64 = "";
  }    
}

my @upgrade_time = localtime(time);
my $time_ext = sprintf("%d%02d%02d%02d%02d", 
		       $upgrade_time[5]+1900, $upgrade_time[4], $upgrade_time[3],
		       $upgrade_time[2], $upgrade_time[1]);


my $CREDS_FILE,$cred_option;

if (! $interactive) {

   if ($IS_WINDOWS) {
      $log_file = File::Spec->catfile("$SERVER_ROOT","sync-log");
   } else {
      $log_file = "/var/tmp/sync-log";
   }

   open(LOG, ">$log_file") or die "Can't create logfile: $!";
   close LOG; 
   $devnul = " >> \"$log_file\" 2>&1 ";

   $CREDS_FILE = File::Spec->catfile("$CUR_DIR", "creds");
   if (!$IS_WINDOWS) {
       $CREDS_FILE = File::Spec->catfile("","tmp","creds.$$");
   }

   if ( "$ARGV[1]" eq "-f" ) {
     if ( ! -f "$ARGV[2]" ) {
        print "Error: $ARGV[2] does not exist\n";
        exit 1;
     }
    cp "$ARGV[2]" , $CREDS_FILE;
    chmod 0700, $CREDS_FILE;
   }
   else
   {
    open(CREDS, ">$CREDS_FILE") || die "Could not create : creds, $!";
    chmod 0700, $CREDS_FILE;
    print CREDS "Admin Id: $ARGV[1]\n";
    print CREDS "Admin Password: $ARGV[2]\n";
    close CREDS;
   }
 $cred_option=" -f $CREDS_FILE ";
} else {
 $cred_option="";
}


# Keep trace of presence of a slap- directory
# (which means there's at least one DS installed in 
# the server root.
my $DS_installed = 0;

# We need first to stop all instances of the server
opendir(SERVERDIR, "$SERVER_ROOT") || die "Could not open directory : $SERVER_ROOT, $!";
@instance_dirs = grep { /^slapd-/ } readdir SERVERDIR;
for (@instance_dirs) {
  my $stop_slapd_dir = File::Spec->catfile("$SERVER_ROOT", $_);
  my $dseldiffile = File::Spec->catfile($stop_slapd_dir,"config","dse.ldif");
  if( -d $stop_slapd_dir) {
    $DS_installed = 1;
    change_dir $stop_slapd_dir || die "Could not change dir to $stop_slapd_dir";
    print "Stopping instance : $_\n";
    my $stop_slapd = File::Spec->catfile(File::Spec->curdir(), "stop-slapd");
    $res = cmd_noerr "$stop_slapd";
    if ( $res )	 {
	$return_code += 1;
    } else {
	$return_code += upgrade_dseldif($dseldiffile);
    }

  }
}

# And to stop the admin server
#my $stop_admin = File::Spec->catfile("$SERVER_ROOT", "stop-admin");
#print "Stopping the admin server...\n";
#$stop_admin = "\"" . $stop_admin . "\"" if $IS_WINDOWS;
change_dir $SERVER_ROOT;
$stop_admin = File::Spec->catfile(File::Spec->curdir(), "stop-admin");
$return_code += cmd_noerr "$stop_admin";

change_dir $CUR_DIR;

if($DS_installed) {

  ($dspkg_file, $dspkg_path, $d_suf) = fileparse("$DS_PACKAGE", ".gz", ".zip");

  if( "$d_suf" eq ".gz" ) {
    # Might have already been gunzip'ed
    if( -f "$DS_PACKAGE" ) {
      cmd "gunzip $DS_PACKAGE";
    }
    cp "$dspkg_file", "$SERVER_ROOT";
    change_dir $SERVER_ROOT;

    open( TAR, "tar tf $dspkg_file |") || die "tar tf $dspkg_file : $!";
    while( <TAR> ) {
      chomp;
      if( -f "$_" ) {
	mv "$_", "$_-$time_ext.ref";
      }
    }
    close TAR;
    cmd "tar xf $dspkg_file";
    unlink File::Spec->catfile("$SERVER_ROOT", "$dspkg_file");
  }
  elsif ( "$d_suf" eq ".zip" ) {
    cp "$DS_PACKAGE", "$SERVER_ROOT";
    change_dir $SERVER_ROOT;
    unzip "$DS_PACKAGE";
    unlink File::Spec->catfile("$SERVER_ROOT", "$DS_PACKAGE");
  }
  else {
    print "Don't know how to handle this type of file : $DS_PACKAGE\n";
    exit 1;
  }
}

# Remove 64 bits if the install was initially 32 bits
if( (!$IS_WINDOWS) && (! $DIR64BITS) ) {
  if( -d $BINDIR_64 ) {
    print "Removing 64 bits support\n";
    rmtree $BINDIR_64;
    rmtree $LIBDIR_64;
  }
}

change_dir $CUR_DIR;

cp "nsbase.zip", "$SERVER_ROOT";
cp "nsclient.zip", "$SERVER_ROOT";
cp "nsjre.zip", "$SERVER_ROOT";
cp "nsadmin.zip", "$SERVER_ROOT";
cp "nsadminclient.zip", "$SERVER_ROOT";

if($IS_WINDOWS) {
  $SYSTEM_DIR = $ENV{SystemRoot};
  $nss_d = File::Spec->catfile("$SERVER_ROOT",bin,https,bin);

  $SYSTEM_DIR = File::Spec->catfile($SYSTEM_DIR, "SYSTEM32");
  cp "nsbasesys.zip", "$SYSTEM_DIR";
  if( -d $nss_d ) {
  cp "nsbasesys.zip", "$nss_d";
  }
}

change_dir $SERVER_ROOT;

my $shared = File::Spec->catfile("$SERVER_ROOT","shared");
my $config = File::Spec->catfile("$shared","config");
my $certmap = File::Spec->catfile("$config","certmap.conf");
sav_tmp "$certmap", "$time_ext";

my $userdb = File::Spec->catfile("$SERVER_ROOT","userdb");
my $ucertmap = File::Spec->catfile("$userdb","certmap.conf");
sav_tmp "$ucertmap","$time_ext";

unzip "nsbase.zip";
unzip "nsclient.zip";
unzip "nsjre.zip";
unzip "nsadmin.zip";
unzip "nsadminclient.zip";
unlink "nsbase.zip";
unlink "nsclient.zip";
unlink "nsjre.zip";
unlink "nsadmin.zip";
unlink "nsadminclient.zip";

rest_tmp "$certmap", "$time_ext";
rest_tmp "$ucertmap", "$time_ext";

if($IS_WINDOWS) {
  change_dir $SYSTEM_DIR;
  unzip "nsbasesys.zip";
  unlink "nsbasesys.zip";
# 5.2rtm has delivered nss on 2 places on windows, so we have to replace it in the 2 places
  if ( -d $nss_d ) {
    change_dir $nss_d;
    unzip "nsbasesys.zip";
    unlink "nsbasesys.zip";
  }
}

sleep(5);

# Now restart the servers
# Do this befor sync'ing since the
# CDS might be one of the(se) servers.




if($DS_SPEC_USER) {
# Used for non root installations where the server is running under privileged 
# port 1024.
  `chown -R $DS_USER:$DS_GROUP $SERVER_ROOT/*`;
}

if($DS_installed) {
  for (@instance_dirs) {
    my $start_dir = File::Spec->catfile("$SERVER_ROOT","$_");
    if( -d $start_dir) {
      print "cd $start_dir\n";
      change_dir $start_dir;
      my $start_slapd = File::Spec->catfile(File::Spec->curdir(), "start-slapd");
      print "Starting instance : $_\n";
      cmd "$start_slapd";
    }
  }
  
  print "Please wait 20 seconds...\n";
  sleep(20);
}


my $new_dir = File::Spec->catdir("$SERVER_ROOT", "bin", "admin");
change_dir $new_dir;

my $sync_admin = File::Spec->catfile(File::Spec->curdir(), "sync-admin");
$sync_admin = $sync_admin . " upgrade -r \"$SERVER_ROOT\"".$devnul;
print "Upgrading the Administration Server...\n";
my $res = cmd_noerr $sync_admin;
if( $res ) {
  print "Warning, sync-admin upgrade returned with error, the upgrade might have already been done ?\n";
  $return_code += 1;
}

my $sync_admin_cds = File::Spec->catfile(File::Spec->curdir(), "sync-admin-cds");
$sync_admin_cds_cmd = $sync_admin_cds . " -r \"$SERVER_ROOT\"".$cred_option.$devnul;
print "Updating the Configuration Directory Server for the Admin Server...\n";
$res = cmd_noerr $sync_admin_cds_cmd;
if( $res ) {
  print "Warning, sync-admin-cds returned with error\n";
  print "Verify user and password are the right ones and that CDS is up and running\n";
  print "You could run the following commands once upgrade is finished:\n";
  print "--------------------------\n";
  print "cd $new_dir\n";
  print "$sync_admin_cds -r \"$SERVER_ROOT\"\n";
  print "--------------------------\n";
  $return_code += 1;
}

# Sync the DS.
# Need to do this only if there's at least one
# Directory server configured in SERVER ROOT.
if($DS_installed) {
  $new_dir = File::Spec->catdir("$SERVER_ROOT", "shared", "bin");
  change_dir $new_dir;
  my $sync_product_cds_file = File::Spec->catfile(File::Spec->curdir(), "sync-product-cds");
  my $isie_file = File::Spec->catfile("$SERVER_ROOT","admin-serv", "config", "adm.conf");
  open(ISIE, "$isie_file") || die "$isie_file: $!";
  my ($isie) = grep { /^isie:/i } <ISIE>;
  chop $isie;
  $isie1 = $isie;
  $isie1 =~ s/^[^,]+,(.+)/cn=Sun ONE Directory Server,$1/;

  $sync_product_cds = $sync_product_cds_file . 
    " -r \"$SERVER_ROOT\" -i \"$isie1\" -j ds524.jar -g ds524.jar -v 5.2_Patch_4 -n \"Sun Java(TM) System Directory Server\" -b $BUILD_NUMBER".$cred_option.$devnul;
  print "Updating the Configuration Directory Server for the directory server instances\n";
  $res = cmd_noerr $sync_product_cds;
  if( $res ) {
    print "Warning, sync-product-cds returned with error\n";
    print "Verify user and password are the right ones and that CDS is up and running\n";
    print "You could run the following commands once upgrade is finished:\n";
    print "--------------------------\n";
    print "cd $new_dir\n";
    print "$sync_product_cds_file -r \"$SERVER_ROOT\" -i \"$isie1\" -j ds524.jar -g ds524.jar -v 5.2_Patch_4 -n \"Sun Java(TM) System Directory Server\" -b $BUILD_NUMBER\n";
    print "--------------------------\n";
    $return_code += 1;
  }

  if ($IS_WINDOWS) {
     $isie =~ s/^[^,]+,(.+)/cn=Sun Java(TM) System Directory Server,$1/;
     $sync_product_cds = $sync_product_cds_file . 
       " -r \"$SERVER_ROOT\" -i \"$isie\" -j ds524.jar -g ds524.jar -v 5.2_Patch_4 -n \"Sun Java(TM) System Directory Server\" -b $BUILD_NUMBER".$cred_option.$devnul;
     system($sync_product_cds);
     $isie =~ s/^[^,]+,(.+)/cn=Sun ONE System Directory Server,$1/;
     $sync_product_cds = $sync_product_cds_file . 
       " -r \"$SERVER_ROOT\" -i \"$isie\" -j ds524.jar -g ds524.jar -v 5.2_Patch_4 -n \"Sun Java(TM) System Directory Server\" -b $BUILD_NUMBER".$cred_option.$devnul;
     system($sync_product_cds);
  }

}


if (!$IS_WINDOWS) {

#  # upgrade start-jvm
#  $res = upgrade_startjvm;
#  if ( $res ) {
#    print "Warning, start-jvm not upgraded\n";
#  }

  # upgrade start-admin
  $res = upgrade_startadmin;
  if ( $res ) { 
    print "Warning, start-admin not upgraded\n";
  }
}

# And start the admin server
#my $start_admin = File::Spec->catfile("$SERVER_ROOT", "start-admin");
#$start_admin = "\"" . $start_admin . "\"" if $IS_WINDOWS;
#cmd $start_admin;

print "Starting the admin server...\n";
change_dir $SERVER_ROOT;
my $start_admin = File::Spec->catfile(File::Spec->curdir(), "start-admin");
$return_code += cmd_noerr "$start_admin";

if (! $interactive) {
 unlink "$CREDS_FILE";
}

print "\n\nDone\n\n";

if ($return_code == 0) {
  unlink "$log_file";
}

exit $return_code;
