# The contents of this file are subject to the Netscape Public License
# Version 1.1 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at
# http://www.mozilla.org/NPL/
#
# Software distributed under the License is distributed on an "AS IS"
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
# the License for the specific language governing rights and limitations
# under the License.
#
# The Original Code was released August, 1999.  The Initial Developer
# of the Original Code is Netscape Communications Corporation.  Portions
# created by Netscape are Copyright (C) 1999 Netscape Communications
# Corporation.  All Rights Reserved.
#
# Contributor(s): John M. Kristian <kristian@netscape.com>
# --------------------------------------------------------------------

# Reconfigure Perl for its current location in the filesystem.
# This is a Perl script, but don't run it as a shell command; instead,
# run the `perl` program with the name of this script as a parameter.

use strict;

use Config;
use Cwd qw(cwd);
use File::Basename qw(dirname);
use File::Spec;
use FileHandle;

my $prefixexp = (@ARGV && $ARGV[0] && ($ARGV[0] ne File::Spec->curdir()))
		? $ARGV[0] : cwd;

sub _fully_qualify # filename
{
    my ($p) = @_;
    return File::Spec->file_name_is_absolute ($p) ? $p
	 : File::Spec->catfile ($prefixexp, $p);
}

my $perl = $^X;
my $perlpath = _fully_qualify $perl;

my $reconfigure_pl = File::Spec->catfile (dirname ($0), 'reconfigure.pl');
system ("$perl $reconfigure_pl \"prefixexp=$prefixexp\" \"perlpath=$perlpath\"")
    and die ($! ? "$perl: $!" : "$perl $reconfigure_pl: $?");

my $reconfigure = File::Spec->catfile (File::Spec->curdir(), 'reconfigure');
$reconfigure_pl = _fully_qualify ($reconfigure_pl);
$reconfigure_pl = "\"$reconfigure_pl\"" if ($reconfigure_pl =~ /\s/);
print {new FileHandle "> $reconfigure"} ("#!/bin/sh\n",
	"exec $reconfigure_pl ", '"$@"', "\n")
    or die;
chmod (0755, $reconfigure);

print ("You might want to reconfigure these parameters:\n");
foreach my $key (qw(myhostname mydomain perladmin cf_email cf_by)) {
    print ("$reconfigure \"$key=$Config{$key}\"\n");
}

my $test = File::Spec->catfile (dirname ($0), 'test.pl');
system ("$perl $test")
    and die ($! ? "$perl: $!" : "$perl $test: $?");
