#
# This file is auto-generated. ***ANY*** changes here will be lost
#

package Errno;
use vars qw(@EXPORT_OK %EXPORT_TAGS @ISA $VERSION %errno $AUTOLOAD);
use Exporter ();
use Config;
use strict;

$Config{'myarchname'} eq "00600181C000-aix" or
	die "Errno architecture (00600181C000-aix) does not match executable architecture ($Config{'myarchname'})";

$VERSION = "1.111";
@ISA = qw(Exporter);

@EXPORT_OK = qw(EFAULT ENOSYS ENETDOWN EAFNOSUPPORT ENOEXEC EALREADY
	EMSGSIZE ECLONEME ENOENT ECHILD EDEADLK EL2HLT EL2NSYNC ENOTSUP
	ENOTBLK EISCONN ENOLINK EIDRM EEXIST ERANGE EBADMSG ECONNABORTED
	ECANCELED ECHRNG EUSERS EMULTIHOP EDESTADDRREQ EDIST EOVERFLOW EXDEV
	ESTALE ELOOP EISDIR ENODEV ENOCSI ESHUTDOWN ECONNREFUSED ESOFT ENOTTY
	ESOCKTNOSUPPORT EADDRINUSE ENOTRUST ENOTEMPTY ESPIPE EUNATCH ENOMSG
	E2BIG ENOPROTOOPT ENOCONNECT EFORMAT EREMOTE ENETUNREACH EPIPE ENOTDIR
	ECONNRESET EPROCLIM ENODATA EFBIG EIO EADDRNOTAVAIL EROFS EINVAL
	EILSEQ EACCES ENOTCONN EAGAIN EMEDIA EDESTADDREQ ENOSPC ENAMETOOLONG
	EHOSTUNREACH ENOTREADY EWRPROTECT EMFILE EBADF ENOBUFS ETXTBSY ENFILE
	ETIME EPFNOSUPPORT EWOULDBLOCK ENOSTR ENOLCK EL3RST ESAD EMLINK ENOMEM
	EINTR ENXIO EDOM ENOTSOCK ELNRNG ENOSR EBUSY ERESTART EL3HLT ENETRESET
	ETIMEDOUT EINPROGRESS EDQUOT EPROTONOSUPPORT ESRCH EPERM EPROTO
	EPROTOTYPE EHOSTDOWN ETOOMANYREFS EOPNOTSUPP ENOATTR);
	
%EXPORT_TAGS = (
    POSIX => [qw(
	E2BIG EACCES EADDRINUSE EADDRNOTAVAIL EAFNOSUPPORT EAGAIN EALREADY
	EBADF EBUSY ECHILD ECONNABORTED ECONNREFUSED ECONNRESET EDEADLK
	EDESTADDRREQ EDOM EDQUOT EEXIST EFAULT EFBIG EHOSTDOWN EHOSTUNREACH
	EINPROGRESS EINTR EINVAL EIO EISCONN EISDIR ELOOP EMFILE EMLINK
	EMSGSIZE ENAMETOOLONG ENETDOWN ENETRESET ENETUNREACH ENFILE ENOBUFS
	ENODEV ENOENT ENOEXEC ENOLCK ENOMEM ENOPROTOOPT ENOSPC ENOSYS ENOTBLK
	ENOTCONN ENOTDIR ENOTEMPTY ENOTSOCK ENOTTY ENXIO EOPNOTSUPP EPERM
	EPFNOSUPPORT EPIPE EPROCLIM EPROTONOSUPPORT EPROTOTYPE ERANGE EREMOTE
	ERESTART EROFS ESHUTDOWN ESOCKTNOSUPPORT ESPIPE ESRCH ESTALE ETIMEDOUT
	ETOOMANYREFS ETXTBSY EUSERS EWOULDBLOCK EXDEV
    )]
);

sub EPERM () { 1 }
sub ENOENT () { 2 }
sub ESRCH () { 3 }
sub EINTR () { 4 }
sub EIO () { 5 }
sub ENXIO () { 6 }
sub E2BIG () { 7 }
sub ENOEXEC () { 8 }
sub EBADF () { 9 }
sub ECHILD () { 10 }
sub EAGAIN () { 11 }
sub EWOULDBLOCK () { 11 }
sub ENOMEM () { 12 }
sub EACCES () { 13 }
sub EFAULT () { 14 }
sub ENOTBLK () { 15 }
sub EBUSY () { 16 }
sub EEXIST () { 17 }
sub ENOTEMPTY () { 17 }
sub EXDEV () { 18 }
sub ENODEV () { 19 }
sub ENOTDIR () { 20 }
sub EISDIR () { 21 }
sub EINVAL () { 22 }
sub ENFILE () { 23 }
sub EMFILE () { 24 }
sub ENOTTY () { 25 }
sub ETXTBSY () { 26 }
sub EFBIG () { 27 }
sub ENOSPC () { 28 }
sub ESPIPE () { 29 }
sub EROFS () { 30 }
sub EMLINK () { 31 }
sub EPIPE () { 32 }
sub EDOM () { 33 }
sub ERANGE () { 34 }
sub ENOMSG () { 35 }
sub EIDRM () { 36 }
sub ECHRNG () { 37 }
sub EL2NSYNC () { 38 }
sub EL3HLT () { 39 }
sub EL3RST () { 40 }
sub ELNRNG () { 41 }
sub EUNATCH () { 42 }
sub ENOCSI () { 43 }
sub EL2HLT () { 44 }
sub EDEADLK () { 45 }
sub ENOTREADY () { 46 }
sub EWRPROTECT () { 47 }
sub EFORMAT () { 48 }
sub ENOLCK () { 49 }
sub ENOCONNECT () { 50 }
sub ESTALE () { 52 }
sub EDIST () { 53 }
sub EINPROGRESS () { 55 }
sub EALREADY () { 56 }
sub ENOTSOCK () { 57 }
sub EDESTADDRREQ () { 58 }
sub EDESTADDREQ () { 58 }
sub EMSGSIZE () { 59 }
sub EPROTOTYPE () { 60 }
sub ENOPROTOOPT () { 61 }
sub EPROTONOSUPPORT () { 62 }
sub ESOCKTNOSUPPORT () { 63 }
sub EOPNOTSUPP () { 64 }
sub EPFNOSUPPORT () { 65 }
sub EAFNOSUPPORT () { 66 }
sub EADDRINUSE () { 67 }
sub EADDRNOTAVAIL () { 68 }
sub ENETDOWN () { 69 }
sub ENETUNREACH () { 70 }
sub ENETRESET () { 71 }
sub ECONNABORTED () { 72 }
sub ECONNRESET () { 73 }
sub ENOBUFS () { 74 }
sub EISCONN () { 75 }
sub ENOTCONN () { 76 }
sub ESHUTDOWN () { 77 }
sub ETIMEDOUT () { 78 }
sub ECONNREFUSED () { 79 }
sub EHOSTDOWN () { 80 }
sub EHOSTUNREACH () { 81 }
sub ERESTART () { 82 }
sub ECLONEME () { 82 }
sub EPROCLIM () { 83 }
sub EUSERS () { 84 }
sub ELOOP () { 85 }
sub ENAMETOOLONG () { 86 }
sub EDQUOT () { 88 }
sub EREMOTE () { 93 }
sub ENOSYS () { 109 }
sub EMEDIA () { 110 }
sub ESOFT () { 111 }
sub ENOATTR () { 112 }
sub ESAD () { 113 }
sub ENOTRUST () { 114 }
sub ETOOMANYREFS () { 115 }
sub EILSEQ () { 116 }
sub ECANCELED () { 117 }
sub ENOSR () { 118 }
sub ETIME () { 119 }
sub EBADMSG () { 120 }
sub EPROTO () { 121 }
sub ENODATA () { 122 }
sub ENOSTR () { 123 }
sub ENOTSUP () { 124 }
sub EMULTIHOP () { 125 }
sub ENOLINK () { 126 }
sub EOVERFLOW () { 127 }

sub TIEHASH { bless [] }

sub FETCH {
    my ($self, $errname) = @_;
    my $proto = prototype("Errno::$errname");
    if (defined($proto) && $proto eq "") {
	no strict 'refs';
        return $! == &$errname;
    }
    require Carp;
    Carp::confess("No errno $errname");
} 

sub STORE {
    require Carp;
    Carp::confess("ERRNO hash is read only!");
}

*CLEAR = \&STORE;
*DELETE = \&STORE;

sub NEXTKEY {
    my($k,$v);
    while(($k,$v) = each %Errno::) {
	my $proto = prototype("Errno::$k");
	last if (defined($proto) && $proto eq "");
	
    }
    $k
}

sub FIRSTKEY {
    my $s = scalar keys %Errno::;
    goto &NEXTKEY;
}

sub EXISTS {
    my ($self, $errname) = @_;
    my $proto = prototype($errname);
    defined($proto) && $proto eq "";
}

tie %!, __PACKAGE__;

1;
__END__

=head1 NAME

Errno - System errno constants

=head1 SYNOPSIS

    use Errno qw(EINTR EIO :POSIX);

=head1 DESCRIPTION

C<Errno> defines and conditionally exports all the error constants
defined in your system C<errno.h> include file. It has a single export
tag, C<:POSIX>, which will export all POSIX defined error numbers.

C<Errno> also makes C<%!> magic such that each element of C<%!> has a non-zero
value only if C<$!> is set to that value, eg

    use Errno;
    
    unless (open(FH, "/fangorn/spouse")) {
        if ($!{ENOENT}) {
            warn "Get a wife!\n";
        } else {
            warn "This path is barred: $!";
        } 
    } 

=head1 AUTHOR

Graham Barr <gbarr@pobox.com>

=head1 COPYRIGHT

Copyright (c) 1997-8 Graham Barr. All rights reserved.
This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

