#
# This file is auto-generated. ***ANY*** changes here will be lost
#

package Errno;
use vars qw(@EXPORT_OK %EXPORT_TAGS @ISA $VERSION %errno $AUTOLOAD);
use Exporter ();
use Config;
use strict;

$Config{'myarchname'} eq "9000/780-hpux" or
	die "Errno architecture (9000/780-hpux) does not match executable architecture ($Config{'myarchname'})";

$VERSION = "1.111";
@ISA = qw(Exporter);

@EXPORT_OK = qw(EFAULT ENOSYS ENOUNREG ENETDOWN EAFNOSUPPORT ENOEXEC
	EMSGSIZE EALREADY ENOENT ECHILD EDEADLK EL2HLT ENOTSUP EL2NSYNC
	ENOTBLK EISCONN ENOLINK EIDRM ERANGE EEXIST EBADMSG EREFUSED ECANCELED
	ECONNABORTED EMULTIHOP ECHRNG EUSERS EDESTADDRREQ EOVERFLOW EBADVER
	ERELOC EXDEV ESTALE ELOOP EISDIR ENOREG ENODEV ECONNREFUSED ENOCSI
	ESHUTDOWN ENOTTY ESOCKTNOSUPPORT EADDRINUSE ENOTEMPTY ESPIPE EUNATCH
	E2BIG ENOMSG ENOPROTOOPT ENONET EREMOTE ENETUNREACH EREMOTERELEASE
	EPIPE EDOTDOT ENOTDIR ECONNRESET ESRMNT ENODATA EFBIG EIO
	EADDRNOTAVAIL EROFS EINVAL EADV EILSEQ ENOTCONN EACCES EAGAIN
	ENAMETOOLONG ENOSPC EHOSTUNREACH ENOMATCH ENOBUFS EMFILE EBADF ETXTBSY
	ENFILE ETIME EPFNOSUPPORT EWOULDBLOCK ENOSTR ENOLCK EL3RST EMLINK
	ENOMEM EINTR ENOLOAD ENXIO ENOPKG EDOM ENOTSOCK ELNRNG ENOSR EBUSY
	EL3HLT ENETRESET ETIMEDOUT EINPROGRESS ECOMM EDQUOT EPROTONOSUPPORT
	ESRCH ENOUNLD EPERM EPROTO EPROTOTYPE ENOSYM EHOSTDOWN ECONFIG
	ETOOMANYREFS EOPNOTSUPP);

%EXPORT_TAGS = (
    POSIX => [qw(
	E2BIG EACCES EADDRINUSE EADDRNOTAVAIL EAFNOSUPPORT EAGAIN EALREADY
	EBADF EBUSY ECHILD ECONNABORTED ECONNREFUSED ECONNRESET EDEADLK
	EDESTADDRREQ EDOM EDQUOT EEXIST EFAULT EFBIG EHOSTDOWN EHOSTUNREACH
	EINPROGRESS EINTR EINVAL EIO EISCONN EISDIR ELOOP EMFILE EMLINK
	EMSGSIZE ENAMETOOLONG ENETDOWN ENETRESET ENETUNREACH ENFILE ENOBUFS
	ENODEV ENOENT ENOEXEC ENOLCK ENOMEM ENOPROTOOPT ENOSPC ENOSYS ENOTBLK
	ENOTCONN ENOTDIR ENOTEMPTY ENOTSOCK ENOTTY ENXIO EOPNOTSUPP EPERM
	EPFNOSUPPORT EPIPE EPROTONOSUPPORT EPROTOTYPE ERANGE EREMOTE EROFS
	ESHUTDOWN ESOCKTNOSUPPORT ESPIPE ESRCH ESTALE ETIMEDOUT ETOOMANYREFS
	ETXTBSY EUSERS EWOULDBLOCK EXDEV
    )]
);

sub EPERM () { 1 }
sub ENOENT () { 2 }
sub ESRCH () { 3 }
sub EINTR () { 4 }
sub EIO () { 5 }
sub ENXIO () { 6 }
sub E2BIG () { 7 }
sub ENOEXEC () { 8 }
sub EBADF () { 9 }
sub ECHILD () { 10 }
sub EAGAIN () { 11 }
sub ENOMEM () { 12 }
sub EACCES () { 13 }
sub EFAULT () { 14 }
sub ENOTBLK () { 15 }
sub EBUSY () { 16 }
sub EEXIST () { 17 }
sub EXDEV () { 18 }
sub ENODEV () { 19 }
sub ENOTDIR () { 20 }
sub EISDIR () { 21 }
sub EINVAL () { 22 }
sub ENFILE () { 23 }
sub EMFILE () { 24 }
sub ENOTTY () { 25 }
sub ETXTBSY () { 26 }
sub EFBIG () { 27 }
sub ENOSPC () { 28 }
sub ESPIPE () { 29 }
sub EROFS () { 30 }
sub EMLINK () { 31 }
sub EPIPE () { 32 }
sub EDOM () { 33 }
sub ERANGE () { 34 }
sub ENOMSG () { 35 }
sub EIDRM () { 36 }
sub ECHRNG () { 37 }
sub EL2NSYNC () { 38 }
sub EL3HLT () { 39 }
sub EL3RST () { 40 }
sub ELNRNG () { 41 }
sub EUNATCH () { 42 }
sub ENOCSI () { 43 }
sub EL2HLT () { 44 }
sub EDEADLK () { 45 }
sub ENOLCK () { 46 }
sub EILSEQ () { 47 }
sub ENONET () { 50 }
sub ENODATA () { 51 }
sub ETIME () { 52 }
sub ENOSR () { 53 }
sub ENOSTR () { 54 }
sub ENOPKG () { 55 }
sub ENOLINK () { 57 }
sub EADV () { 58 }
sub ESRMNT () { 59 }
sub ECOMM () { 60 }
sub EPROTO () { 61 }
sub EMULTIHOP () { 64 }
sub EDOTDOT () { 66 }
sub EBADMSG () { 67 }
sub EUSERS () { 68 }
sub EDQUOT () { 69 }
sub ESTALE () { 70 }
sub EREMOTE () { 71 }
sub EOVERFLOW () { 72 }
sub ENOLOAD () { 152 }
sub ERELOC () { 153 }
sub ENOMATCH () { 154 }
sub ENOUNLD () { 155 }
sub EBADVER () { 156 }
sub ECONFIG () { 157 }
sub ENOREG () { 158 }
sub ENOUNREG () { 159 }
sub ENOSYM () { 215 }
sub ENOTSOCK () { 216 }
sub EDESTADDRREQ () { 217 }
sub EMSGSIZE () { 218 }
sub EPROTOTYPE () { 219 }
sub ENOPROTOOPT () { 220 }
sub EPROTONOSUPPORT () { 221 }
sub ESOCKTNOSUPPORT () { 222 }
sub EOPNOTSUPP () { 223 }
sub EPFNOSUPPORT () { 224 }
sub EAFNOSUPPORT () { 225 }
sub EADDRINUSE () { 226 }
sub EADDRNOTAVAIL () { 227 }
sub ENETDOWN () { 228 }
sub ENETUNREACH () { 229 }
sub ENETRESET () { 230 }
sub ECONNABORTED () { 231 }
sub ECONNRESET () { 232 }
sub ENOBUFS () { 233 }
sub EISCONN () { 234 }
sub ENOTCONN () { 235 }
sub ESHUTDOWN () { 236 }
sub ETOOMANYREFS () { 237 }
sub ETIMEDOUT () { 238 }
sub ECONNREFUSED () { 239 }
sub EREFUSED () { 239 }
sub EREMOTERELEASE () { 240 }
sub EHOSTDOWN () { 241 }
sub EHOSTUNREACH () { 242 }
sub EALREADY () { 244 }
sub EINPROGRESS () { 245 }
sub EWOULDBLOCK () { 246 }
sub ENOTEMPTY () { 247 }
sub ENAMETOOLONG () { 248 }
sub ELOOP () { 249 }
sub ENOSYS () { 251 }
sub ENOTSUP () { 252 }
sub ECANCELED () { 253 }

sub TIEHASH { bless [] }

sub FETCH {
    my ($self, $errname) = @_;
    my $proto = prototype("Errno::$errname");
    if (defined($proto) && $proto eq "") {
	no strict 'refs';
        return $! == &$errname;
    }
    require Carp;
    Carp::confess("No errno $errname");
} 

sub STORE {
    require Carp;
    Carp::confess("ERRNO hash is read only!");
}

*CLEAR = \&STORE;
*DELETE = \&STORE;

sub NEXTKEY {
    my($k,$v);
    while(($k,$v) = each %Errno::) {
	my $proto = prototype("Errno::$k");
	last if (defined($proto) && $proto eq "");
	
    }
    $k
}

sub FIRSTKEY {
    my $s = scalar keys %Errno::;
    goto &NEXTKEY;
}

sub EXISTS {
    my ($self, $errname) = @_;
    my $proto = prototype($errname);
    defined($proto) && $proto eq "";
}

tie %!, __PACKAGE__;

1;
__END__

=head1 NAME

Errno - System errno constants

=head1 SYNOPSIS

    use Errno qw(EINTR EIO :POSIX);

=head1 DESCRIPTION

C<Errno> defines and conditionally exports all the error constants
defined in your system C<errno.h> include file. It has a single export
tag, C<:POSIX>, which will export all POSIX defined error numbers.

C<Errno> also makes C<%!> magic such that each element of C<%!> has a non-zero
value only if C<$!> is set to that value, eg

    use Errno;
    
    unless (open(FH, "/fangorn/spouse")) {
        if ($!{ENOENT}) {
            warn "Get a wife!\n";
        } else {
            warn "This path is barred: $!";
        } 
    } 

=head1 AUTHOR

Graham Barr <gbarr@pobox.com>

=head1 COPYRIGHT

Copyright (c) 1997-8 Graham Barr. All rights reserved.
This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

